/*
 * Decompiled with CFR 0.152.
 */
package hades.models;

import java.awt.Color;
import java.io.Serializable;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class StdLogic1164
implements Serializable {
    private int value = 0;
    public static final int _U = 0;
    public static final int _X = 1;
    public static final int _0 = 2;
    public static final int _1 = 3;
    public static final int _Z = 4;
    public static final int _W = 5;
    public static final int _L = 6;
    public static final int _H = 7;
    public static final int _D = 8;
    public static final char[] chars = new char[]{'U', 'X', '0', '1', 'Z', 'W', 'L', 'H', 'D'};
    public static Color[] colors = new Color[]{Color.cyan, Color.magenta, new Color(220, 220, 220), Color.red, Color.orange, Color.orange, new Color(64, 64, 64), new Color(200, 0, 0), Color.gray};
    static final int[] BUF_TABLE;
    static final int[] NOT_TABLE;
    static final int[][] AND_TABLE;
    static final int[][] OR_TABLE;
    static final int[][] XOR_TABLE;
    static final int[][] RESOLUTION_TABLE;
    static final boolean[] UXZ_TABLE;

    public StdLogic1164() {
    }

    public StdLogic1164(Integer I) {
        this();
        this.value = I >= 0 && I <= 8 ? I : 0;
    }

    public StdLogic1164(int v) {
        this();
        this.value = this.value >= 0 && this.value <= 8 ? v : 0;
    }

    public StdLogic1164(char c) {
        this();
        this.setValue(c);
    }

    public void setValue(char c) {
        switch (c) {
            case 'u': {
                this.value = 0;
                break;
            }
            case 'U': {
                this.value = 0;
                break;
            }
            case 'x': {
                this.value = 1;
                break;
            }
            case 'X': {
                this.value = 1;
                break;
            }
            case '0': {
                this.value = 2;
                break;
            }
            case '1': {
                this.value = 3;
                break;
            }
            case 'z': {
                this.value = 4;
                break;
            }
            case 'Z': {
                this.value = 4;
                break;
            }
            case 'w': {
                this.value = 5;
                break;
            }
            case 'W': {
                this.value = 5;
                break;
            }
            case 'l': {
                this.value = 6;
                break;
            }
            case 'L': {
                this.value = 6;
                break;
            }
            case 'h': {
                this.value = 7;
                break;
            }
            case 'H': {
                this.value = 7;
                break;
            }
            case 'd': {
                this.value = 8;
                break;
            }
            case 'D': {
                this.value = 8;
                break;
            }
            case '-': {
                this.value = 8;
                break;
            }
        }
    }

    public static StdLogic1164 get_U() {
        return new StdLogic1164();
    }

    public StdLogic1164 copy() {
        return new StdLogic1164(this.intValue());
    }

    public final Object getValue() {
        return new Integer(this.value);
    }

    public final int intValue() {
        return this.value;
    }

    public final void setValue(Object o) {
        if (o instanceof Integer) {
            this.value = (Integer)o;
        } else if (o instanceof String) {
            try {
                this.setValue(((String)o).charAt(0));
            }
            catch (Exception e) {
                ExceptionTracer.message("-W- StdLogic1164.setValue: invalid string: " + e);
            }
        } else {
            ExceptionTracer.message("-W- Illegal type in StdLogic1164.setValue(), offending object is: " + o.toString());
        }
    }

    public void setIntValue(int v) {
        this.value = v;
    }

    public boolean equals(StdLogic1164 o) {
        return this.intValue() == o.intValue();
    }

    public boolean equals(Object o) {
        if (o instanceof StdLogic1164) {
            return this.intValue() == ((StdLogic1164)o).intValue();
        }
        return super.equals(o);
    }

    public static final StdLogic1164 not(StdLogic1164 a) {
        return new StdLogic1164(NOT_TABLE[a.intValue()]);
    }

    public static final StdLogic1164 or(StdLogic1164 a, StdLogic1164 b) {
        return new StdLogic1164(OR_TABLE[a.intValue()][b.intValue()]);
    }

    public static final StdLogic1164 and(StdLogic1164 a, StdLogic1164 b) {
        int ia = a.intValue();
        int ib = b.intValue();
        int iy = AND_TABLE[ia][ib];
        return new StdLogic1164(iy);
    }

    public static final StdLogic1164 xor(StdLogic1164 a, StdLogic1164 b) {
        return new StdLogic1164(XOR_TABLE[a.intValue()][b.intValue()]);
    }

    public static final StdLogic1164 resolve(StdLogic1164[] inputs) {
        int tmp = 4;
        int i = 0;
        while (i < inputs.length) {
            tmp = RESOLUTION_TABLE[tmp][inputs[i].intValue()];
            ++i;
        }
        return new StdLogic1164(tmp);
    }

    public static final StdLogic1164[] not(StdLogic1164[] A) {
        StdLogic1164[] tmp = new StdLogic1164[A.length];
        int i = 0;
        while (i < A.length) {
            tmp[i] = StdLogic1164.not(A[i]);
            ++i;
        }
        return tmp;
    }

    public static final StdLogic1164[] and(StdLogic1164[] A, StdLogic1164[] B) {
        if (A.length != B.length) {
            return null;
        }
        StdLogic1164[] tmp = new StdLogic1164[A.length];
        int i = 0;
        while (i < A.length) {
            tmp[i] = StdLogic1164.and(A[i], B[i]);
            ++i;
        }
        return tmp;
    }

    public static final StdLogic1164[] or(StdLogic1164[] A, StdLogic1164[] B) {
        if (A.length != B.length) {
            return null;
        }
        StdLogic1164[] tmp = new StdLogic1164[A.length];
        int i = 0;
        while (i < A.length) {
            tmp[i] = StdLogic1164.or(A[i], B[i]);
            ++i;
        }
        return tmp;
    }

    public static final StdLogic1164[] xor(StdLogic1164[] A, StdLogic1164[] B) {
        if (A.length != B.length) {
            return null;
        }
        StdLogic1164[] tmp = new StdLogic1164[A.length];
        int i = 0;
        while (i < A.length) {
            tmp[i] = StdLogic1164.xor(A[i], B[i]);
            ++i;
        }
        return tmp;
    }

    public StdLogic1164 setToCopy(StdLogic1164 a) {
        this.setIntValue(a.intValue());
        return this;
    }

    public StdLogic1164 setToBuffered(StdLogic1164 a) {
        this.setIntValue(BUF_TABLE[a.intValue()]);
        return this;
    }

    public StdLogic1164 setToInvert(StdLogic1164 a) {
        this.setIntValue(NOT_TABLE[a.intValue()]);
        return this;
    }

    public StdLogic1164 setToAnd(StdLogic1164 a, StdLogic1164 b) {
        this.setIntValue(AND_TABLE[a.intValue()][b.intValue()]);
        return this;
    }

    public StdLogic1164 setToAnd(StdLogic1164 a, StdLogic1164 b, StdLogic1164 c) {
        int tmp = AND_TABLE[a.intValue()][b.intValue()];
        this.setIntValue(AND_TABLE[tmp][c.intValue()]);
        return this;
    }

    public StdLogic1164 setToAnd(StdLogic1164 a, StdLogic1164 b, StdLogic1164 c, StdLogic1164 d) {
        int tmp1 = AND_TABLE[a.intValue()][b.intValue()];
        int tmp2 = AND_TABLE[c.intValue()][d.intValue()];
        this.setIntValue(AND_TABLE[tmp1][tmp2]);
        return this;
    }

    public StdLogic1164 setToNand(StdLogic1164 a, StdLogic1164 b) {
        int tmp = AND_TABLE[a.intValue()][b.intValue()];
        this.setIntValue(NOT_TABLE[tmp]);
        return this;
    }

    public StdLogic1164 setToNand(StdLogic1164 a, StdLogic1164 b, StdLogic1164 c) {
        int tmp = AND_TABLE[a.intValue()][b.intValue()];
        tmp = AND_TABLE[tmp][c.intValue()];
        this.setIntValue(NOT_TABLE[tmp]);
        return this;
    }

    public StdLogic1164 setToNand(StdLogic1164 a, StdLogic1164 b, StdLogic1164 c, StdLogic1164 d) {
        int tmp1 = AND_TABLE[a.intValue()][b.intValue()];
        int tmp2 = AND_TABLE[c.intValue()][d.intValue()];
        this.setIntValue(NOT_TABLE[AND_TABLE[tmp1][tmp2]]);
        return this;
    }

    public StdLogic1164 setToOr(StdLogic1164 a, StdLogic1164 b) {
        this.setIntValue(OR_TABLE[a.intValue()][b.intValue()]);
        return this;
    }

    public StdLogic1164 setToOr(StdLogic1164 a, StdLogic1164 b, StdLogic1164 c) {
        int tmp = OR_TABLE[a.intValue()][b.intValue()];
        this.setIntValue(OR_TABLE[tmp][c.intValue()]);
        return this;
    }

    public StdLogic1164 setToOr(StdLogic1164 a, StdLogic1164 b, StdLogic1164 c, StdLogic1164 d) {
        int tmp1 = OR_TABLE[a.intValue()][b.intValue()];
        int tmp2 = OR_TABLE[c.intValue()][d.intValue()];
        this.setIntValue(OR_TABLE[tmp1][tmp2]);
        return this;
    }

    public StdLogic1164 setToNor(StdLogic1164 a, StdLogic1164 b) {
        int tmp = OR_TABLE[a.intValue()][b.intValue()];
        this.setIntValue(NOT_TABLE[tmp]);
        return this;
    }

    public StdLogic1164 setToNor(StdLogic1164 a, StdLogic1164 b, StdLogic1164 c) {
        int tmp = OR_TABLE[a.intValue()][b.intValue()];
        tmp = OR_TABLE[tmp][c.intValue()];
        this.setIntValue(NOT_TABLE[tmp]);
        return this;
    }

    public StdLogic1164 setToNor(StdLogic1164 a, StdLogic1164 b, StdLogic1164 c, StdLogic1164 d) {
        int tmp1 = OR_TABLE[a.intValue()][b.intValue()];
        int tmp2 = OR_TABLE[c.intValue()][d.intValue()];
        this.setIntValue(NOT_TABLE[OR_TABLE[tmp1][tmp2]]);
        return this;
    }

    public StdLogic1164 setToXnor(StdLogic1164 a, StdLogic1164 b) {
        this.setIntValue(NOT_TABLE[XOR_TABLE[a.intValue()][b.intValue()]]);
        return this;
    }

    public StdLogic1164 setToXor(StdLogic1164 a, StdLogic1164 b) {
        this.setIntValue(XOR_TABLE[a.intValue()][b.intValue()]);
        return this;
    }

    public StdLogic1164 setToResolve(StdLogic1164[] inputs) {
        this.setIntValue(4);
        int i = 0;
        while (i < inputs.length) {
            this.setIntValue(RESOLUTION_TABLE[this.intValue()][inputs[i].intValue()]);
            ++i;
        }
        return this;
    }

    public boolean isLow_0L() {
        return this.value == 6 || this.value == 2;
    }

    public boolean isHigh_1H() {
        return this.value == 7 || this.value == 3;
    }

    public boolean is_1H() {
        return this.value == 7 || this.value == 3;
    }

    public boolean is_0L() {
        return this.value == 6 || this.value == 2;
    }

    public boolean is_U() {
        return this.value == 0;
    }

    public boolean is_X() {
        return this.value == 1;
    }

    public boolean is_0() {
        return this.value == 2;
    }

    public boolean is_1() {
        return this.value == 3;
    }

    public boolean is_Z() {
        return this.value == 4;
    }

    public boolean is_W() {
        return this.value == 5;
    }

    public boolean is_L() {
        return this.value == 6;
    }

    public boolean is_H() {
        return this.value == 7;
    }

    public boolean is_D() {
        return this.value == 8;
    }

    public boolean is_01() {
        return this.value == 2 || this.value == 3;
    }

    public boolean is_UXZ() {
        return UXZ_TABLE[this.value];
    }

    public final Color getColor() {
        return colors[this.value];
    }

    public static final Color getColorFromIntValue(int i) {
        return colors[i];
    }

    public static void setColor(int i, Color c) {
        if (i >= 0 && i <= 8) {
            StdLogic1164.colors[i] = c;
        }
    }

    public final char getChar() {
        return chars[this.value];
    }

    public String getValueString() {
        switch (this.value) {
            case 0: {
                return "U";
            }
            case 1: {
                return "X";
            }
            case 2: {
                return "0";
            }
            case 3: {
                return "1";
            }
            case 4: {
                return "Z";
            }
            case 5: {
                return "W";
            }
            case 6: {
                return "L";
            }
            case 7: {
                return "H";
            }
            case 8: {
                return "D";
            }
        }
        return "";
    }

    public String toString() {
        String s = "StdLogic1164<" + chars[this.value] + ">";
        return s;
    }

    static {
        StdLogic1164.colors[0] = SetupManager.getColor("Hades.StdLogic1164.Color._U", Color.cyan);
        StdLogic1164.colors[1] = SetupManager.getColor("Hades.StdLogic1164.Color._X", Color.magenta);
        StdLogic1164.colors[2] = SetupManager.getColor("Hades.StdLogic1164.Color._0", new Color(220, 220, 200));
        StdLogic1164.colors[3] = SetupManager.getColor("Hades.StdLogic1164.Color._1", Color.red);
        StdLogic1164.colors[4] = SetupManager.getColor("Hades.StdLogic1164.Color._Z", Color.orange);
        StdLogic1164.colors[5] = SetupManager.getColor("Hades.StdLogic1164.Color._W", Color.orange);
        StdLogic1164.colors[6] = SetupManager.getColor("Hades.StdLogic1164.Color._L", new Color(64, 64, 64));
        StdLogic1164.colors[7] = SetupManager.getColor("Hades.StdLogic1164.Color._H", new Color(200, 0, 0));
        StdLogic1164.colors[8] = SetupManager.getColor("Hades.StdLogic1164.Color._D", Color.gray);
        BUF_TABLE = new int[]{0, 1, 2, 3, 1, 1, 2, 3, 1};
        NOT_TABLE = new int[]{0, 1, 3, 2, 1, 1, 3, 2, 1};
        AND_TABLE = new int[][]{{0, 0, 2, 0, 0, 0, 2, 0, 0}, {0, 1, 2, 1, 1, 1, 2, 1, 1}, {2, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 1, 2, 3, 1, 1, 2, 3, 1}, {0, 1, 2, 1, 1, 1, 2, 1, 1}, {0, 1, 2, 1, 1, 1, 2, 1, 1}, {2, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 1, 2, 3, 1, 1, 2, 3, 1}, {0, 1, 2, 1, 1, 1, 2, 1, 1}};
        OR_TABLE = new int[][]{{0, 0, 0, 3, 0, 0, 0, 3, 0}, {0, 1, 1, 3, 1, 1, 1, 3, 1}, {0, 1, 2, 3, 1, 1, 2, 3, 1}, {3, 3, 3, 3, 3, 3, 3, 3, 3}, {0, 1, 1, 3, 1, 1, 1, 3, 1}, {0, 1, 1, 3, 1, 1, 1, 3, 1}, {0, 1, 2, 3, 1, 1, 2, 3, 1}, {3, 3, 3, 3, 3, 3, 3, 3, 3}, {0, 1, 1, 3, 1, 1, 1, 3, 1}};
        XOR_TABLE = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 2, 3, 1, 1, 2, 3, 1}, {0, 1, 3, 2, 1, 1, 3, 2, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 2, 3, 1, 1, 2, 3, 1}, {0, 1, 3, 2, 1, 1, 3, 2, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1}};
        RESOLUTION_TABLE = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 2, 1, 2, 2, 2, 2, 1}, {0, 1, 1, 3, 3, 3, 3, 3, 1}, {0, 1, 2, 3, 4, 5, 6, 7, 1}, {0, 1, 2, 3, 5, 5, 5, 5, 1}, {0, 1, 2, 3, 6, 5, 6, 5, 1}, {0, 1, 2, 3, 7, 5, 5, 7, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1}};
        UXZ_TABLE = new boolean[]{true, true, false, false, true, true, false, false, true};
    }
}

