/*
 * Decompiled with CFR 0.152.
 */
package hades.manager;

import hades.manager.Colibri;
import hades.manager.TreeManager;
import hades.manager.tree.AssemblerFileTreeNode;
import hades.manager.tree.DesignFileTreeNode;
import hades.manager.tree.DirectoryTreeNode;
import hades.manager.tree.FileRootTreeNode;
import hades.manager.tree.PythonFileTreeNode;
import hades.manager.tree.SimObjectTreeNode;
import hades.manager.tree.SortedTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreePopupMenu
implements ActionListener,
MouseListener {
    private static boolean debug = false;
    Colibri browser;
    JTree tree;
    SortedTreeNode popupNode;
    JPopupMenu dirPopup;
    JMenuItem dirSubfolderMI;
    JMenuItem dirRenameMI;
    JMenuItem dirRefreshMI;
    JPopupMenu hdsPopup;
    JMenuItem hdsOpenMI;
    JMenuItem hdsOpenNewEditorMI;
    JMenuItem hdsOpenViewModeMI;
    JMenuItem hdsAsSubdesignMI;
    JMenuItem hdsSaveAsMI;
    JMenuItem hdsDeleteMI;
    JMenuItem hdsRenameMI;
    JMenuItem hdsCreateSymbolMI;
    JPopupMenu objPopup;
    JMenuItem objCreateMI;
    JMenuItem objThumbnailMI;
    JPopupMenu asmPopup;
    JMenuItem asmEditMI;
    JMenuItem asmSaveAsMI;
    JMenuItem asmRenameMI;
    JMenuItem asmDeleteMI;
    JMenuItem asmPicAssembleMI;
    JMenuItem asmMipsAssembleMI;
    JMenuItem asmMCS4AssembleMI;
    JPopupMenu pytPopup;
    JMenuItem pytEditMI;
    JMenuItem pytSaveAsMI;
    JMenuItem pytRenameMI;
    JMenuItem pytDeleteMI;
    JMenuItem pytExecMI;

    public void createDirPopup() {
        JPopupMenu p = new JPopupMenu();
        this.dirSubfolderMI = this._cmi("add subdirectory...", false);
        p.add(this.dirSubfolderMI);
        this.dirRenameMI = this._cmi("rename", false);
        p.add(this.dirRenameMI);
        this.dirRefreshMI = this._cmi("refresh", false);
        p.add(this.dirRefreshMI);
        this.dirPopup = p;
        this.tree.add(this.dirPopup);
    }

    public void createHdsPopup() {
        JPopupMenu p = new JPopupMenu();
        this.hdsOpenMI = this._cmi("open design", true);
        p.add(this.hdsOpenMI);
        this.hdsOpenNewEditorMI = this._cmi("open design (new editor)", true);
        p.add(this.hdsOpenNewEditorMI);
        this.hdsOpenViewModeMI = this._cmi("open design (view mode)", true);
        p.add(this.hdsOpenViewModeMI);
        p.addSeparator();
        this.hdsAsSubdesignMI = this._cmi("add as subdesign", true);
        p.add(this.hdsAsSubdesignMI);
        p.addSeparator();
        this.hdsSaveAsMI = this._cmi("save as...", false);
        p.add(this.hdsSaveAsMI);
        this.hdsRenameMI = this._cmi("rename...", false);
        p.add(this.hdsRenameMI);
        this.hdsDeleteMI = this._cmi("delete", false);
        p.add(this.hdsDeleteMI);
        this.hdsCreateSymbolMI = this._cmi("create symbol", false);
        p.add(this.hdsCreateSymbolMI);
        this.hdsPopup = p;
        this.tree.add(this.hdsPopup);
    }

    public void createObjPopup() {
        JPopupMenu p = new JPopupMenu();
        this.objCreateMI = this._cmi("add to current design", true);
        p.add(this.objCreateMI);
        p.addSeparator();
        this.objThumbnailMI = this._cmi("create thumbnail", false);
        p.add(this.objThumbnailMI);
        this.objPopup = p;
        this.tree.add(this.objPopup);
    }

    public void createAsmPopup() {
        JPopupMenu p = new JPopupMenu();
        this.asmEditMI = this._cmi("edit", false);
        p.add(this.asmEditMI);
        p.addSeparator();
        this.asmPicAssembleMI = this._cmi("assemble (PIC16)", false);
        p.add(this.asmPicAssembleMI);
        this.asmMipsAssembleMI = this._cmi("assemble (MIPS32)", false);
        p.add(this.asmMipsAssembleMI);
        this.asmMCS4AssembleMI = this._cmi("assemble (MCS4)", false);
        p.add(this.asmMCS4AssembleMI);
        p.addSeparator();
        this.asmSaveAsMI = this._cmi("save as...", false);
        p.add(this.asmSaveAsMI);
        this.asmRenameMI = this._cmi("rename", false);
        p.add(this.asmRenameMI);
        this.asmDeleteMI = this._cmi("delete", false);
        p.add(this.asmDeleteMI);
        this.asmPopup = p;
        this.tree.add(this.asmPopup);
    }

    public void createPythonPopup() {
        JPopupMenu p = new JPopupMenu();
        this.pytEditMI = this._cmi("edit", false);
        p.add(this.pytEditMI);
        this.pytExecMI = this._cmi("execute script", false);
        p.add(this.pytExecMI);
        p.addSeparator();
        this.pytSaveAsMI = this._cmi("save as...", false);
        p.add(this.pytSaveAsMI);
        this.pytRenameMI = this._cmi("rename", false);
        p.add(this.pytRenameMI);
        this.pytDeleteMI = this._cmi("delete", false);
        p.add(this.pytDeleteMI);
        this.pytPopup = p;
        this.tree.add(this.pytPopup);
    }

    private final JMenuItem _cmi(String label, boolean enabled) {
        JMenuItem mi = new JMenuItem(label);
        mi.setEnabled(enabled);
        mi.addActionListener(this);
        return mi;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        SortedTreeNode node = this.popupNode;
        if (this.popupNode == null) {
            this.msg("-E- TreePopupMenu.actionPerformed: internal: popupNode is null.");
            return;
        }
        try {
            if (src == this.dirSubfolderMI) {
                this.doCreateSubfolder(node);
            } else if (src == this.dirRenameMI) {
                this.doRenameSubfolder(node);
            } else if (src == this.dirRefreshMI) {
                this.doRefreshSubfolder(node);
            } else if (src == this.hdsOpenMI) {
                this.doOpenDesign(node);
            } else if (src == this.hdsOpenNewEditorMI) {
                this.doOpenDesignInNewEditor(node);
            } else if (src == this.hdsOpenViewModeMI) {
                this.doOpenDesignViewMode(node);
            } else if (src == this.hdsAsSubdesignMI) {
                this.doCreateSubdesign(node);
            } else if (src == this.hdsSaveAsMI) {
                this.doDesignSaveAs(node);
            } else if (src == this.hdsDeleteMI) {
                this.doDeleteDesign(node);
            } else if (src == this.hdsRenameMI) {
                this.doRenameDesign(node);
            } else if (src == this.hdsCreateSymbolMI) {
                this.doCreateSymbol(node);
            } else if (src == this.objCreateMI) {
                this.doCreateComponent(node);
            } else if (src == this.objThumbnailMI) {
                this.doCreateThumbnail(node);
            } else if (src == this.asmEditMI) {
                this.doEditAsmFile(node);
            } else if (src == this.asmSaveAsMI) {
                this.doSaveAsAsmFile(node);
            } else if (src == this.asmRenameMI) {
                this.doRenameAsmFile(node);
            } else if (src == this.asmDeleteMI) {
                this.doDeleteAsmFile(node);
            } else if (src == this.asmPicAssembleMI) {
                this.doAssemblePic16(node);
            } else if (src == this.asmMCS4AssembleMI) {
                this.doAssembleMCS4(node);
            } else if (src == this.asmMipsAssembleMI) {
                this.doAssembleMips(node);
            } else if (src == this.pytEditMI) {
                this.doEditPythonFile(node);
            } else if (src == this.pytExecMI) {
                this.doExecPythonFile(node);
            } else if (src == this.pytSaveAsMI) {
                this.doSaveAsPythonFile(node);
            } else if (src == this.pytDeleteMI) {
                this.doDeletePythonFile(node);
            } else if (src == this.pytRenameMI) {
                this.doRenamePythonFile(node);
            } else {
                this.msg("-W- TreePopupMenu.actionPerformed unknown event: " + e);
            }
        }
        catch (Throwable t) {
            this.msg("-E- internal error: " + t);
            t.printStackTrace();
        }
    }

    public void doCreateSubfolder(SortedTreeNode node) {
        this.msg("-#- doCreateSubfolder: " + node);
        SortedTreeNode parent = TreeManager.getFirstLevelNode(node);
        if (!(parent instanceof FileRootTreeNode)) {
            JOptionPane.showMessageDialog(this.browser.getFrame(), "Cannot create a subfolder there (read-only tree node)!", "Error", 0);
            return;
        }
        try {
            String rawname = JOptionPane.showInputDialog(this.browser.getFrame(), "Create subfolder: enter folder name", "NewFolder");
            if (rawname == null) {
                return;
            }
            String dirname = TreeManager.getFullPathname(node);
            File newdir = new File(dirname, rawname);
            newdir.mkdir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doRenameSubfolder(SortedTreeNode node) {
        throw new UnsupportedOperationException("doRenameSubfolder not yet");
    }

    public void doRefreshSubfolder(SortedTreeNode node) {
        this.msg("-#- doRefreshSubfolder... doing a full tree refresh.");
        this.browser.doRefresh();
    }

    public void doOpenDesign(SortedTreeNode node) {
        this.msg("-#- doOpenDesign " + node);
        DesignFileTreeNode hdsNode = (DesignFileTreeNode)node;
        hdsNode.openDesign(false, false);
    }

    public void doOpenDesignInNewEditor(SortedTreeNode node) {
        this.msg("-#- doOpenDesignInNewEditor " + node);
        DesignFileTreeNode hdsNode = (DesignFileTreeNode)node;
        hdsNode.openDesign(true, false);
    }

    public void doOpenDesignViewMode(SortedTreeNode node) {
        this.msg("-#- doOpenDesignViewMode " + node);
        DesignFileTreeNode hdsNode = (DesignFileTreeNode)node;
        hdsNode.openDesign(false, true);
    }

    public void doCreateSubdesign(SortedTreeNode node) {
        this.msg("-#- doCreateSubdesign " + node);
        DesignFileTreeNode hdsNode = (DesignFileTreeNode)node;
        hdsNode.createAsSubdesign();
    }

    public void doDesignSaveAs(SortedTreeNode node) {
        throw new UnsupportedOperationException("doDesignSaveAs");
    }

    public void doDeleteDesign(SortedTreeNode node) {
        throw new UnsupportedOperationException("doDeleteDesign");
    }

    public void doRenameDesign(SortedTreeNode node) {
        throw new UnsupportedOperationException("doRenameDesign");
    }

    public void doCreateSymbol(SortedTreeNode node) {
        throw new UnsupportedOperationException("doCreateSymbol");
    }

    public void doCreateComponent(SortedTreeNode node) {
        this.msg("-#- doCreateComponent " + node);
        SimObjectTreeNode simobjNode = (SimObjectTreeNode)node;
        simobjNode.addAsComponentToCurrentDesign();
    }

    public void doCreateThumbnail(SortedTreeNode node) {
        throw new UnsupportedOperationException("doCreateThumbnail");
    }

    public void doEditAsmFile(SortedTreeNode node) {
        throw new UnsupportedOperationException("doEditAsmFile");
    }

    public void doSaveAsAsmFile(SortedTreeNode node) {
        throw new UnsupportedOperationException("doSaveAsAsmFile");
    }

    public void doRenameAsmFile(SortedTreeNode node) {
        throw new UnsupportedOperationException("doRenameAsmFile");
    }

    public void doDeleteAsmFile(SortedTreeNode node) {
        throw new UnsupportedOperationException("doDeleteAsmFile");
    }

    public void doAssemblePic16(SortedTreeNode node) {
        throw new UnsupportedOperationException("doAssemblePic16");
    }

    public void doAssembleMCS4(SortedTreeNode node) {
        throw new UnsupportedOperationException("doAssembleMCS4");
    }

    public void doAssembleMips(SortedTreeNode node) {
        throw new UnsupportedOperationException("doAssembleMips");
    }

    public void doEditPythonFile(SortedTreeNode node) {
        throw new UnsupportedOperationException("doEditPythonFile");
    }

    public void doExecPythonFile(SortedTreeNode node) {
        throw new UnsupportedOperationException("doExecPythonFile");
    }

    public void doSaveAsPythonFile(SortedTreeNode node) {
        throw new UnsupportedOperationException("doSaveAsPythonFile");
    }

    public void doDeletePythonFile(SortedTreeNode node) {
        throw new UnsupportedOperationException("doDeletePythonFile");
    }

    public void doRenamePythonFile(SortedTreeNode node) {
        throw new UnsupportedOperationException("doRenamePythonFile");
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            TreePath tmp = this.tree.getPathForLocation(e.getX(), e.getY());
            if (tmp == null) {
                return;
            }
            SortedTreeNode node = null;
            try {
                node = (SortedTreeNode)tmp.getLastPathComponent();
                node.handleDoubleClick(null);
            }
            catch (Throwable t) {
                this.msg("-F- TreePopupMenu.mouseClicked internal: " + t);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    private final void showPopup(MouseEvent e) {
        TreePath tmp = this.tree.getPathForLocation(e.getX(), e.getY());
        if (tmp == null) {
            this.popupNode = null;
            return;
        }
        SortedTreeNode node = null;
        try {
            this.popupNode = node = (SortedTreeNode)tmp.getLastPathComponent();
            if (node instanceof DirectoryTreeNode) {
                this.dirPopup.show((Component)e.getSource(), e.getX(), e.getY());
            } else if (node instanceof SimObjectTreeNode) {
                this.objPopup.show((Component)e.getSource(), e.getX(), e.getY());
            } else if (node instanceof DesignFileTreeNode) {
                this.hdsPopup.show((Component)e.getSource(), e.getX(), e.getY());
            } else if (node instanceof AssemblerFileTreeNode) {
                this.asmPopup.show((Component)e.getSource(), e.getX(), e.getY());
            } else if (node instanceof PythonFileTreeNode) {
                this.pytPopup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
        catch (Exception ee) {
            this.msg("-E- internal: " + ee);
            ee.printStackTrace();
        }
    }

    private final void msg(String s) {
        if (!debug && s.startsWith("-#-")) {
            return;
        }
        System.out.println(s);
    }

    public TreePopupMenu(Colibri browser) {
        this.browser = browser;
        this.tree = browser.getTree();
        this.createDirPopup();
        this.createHdsPopup();
        this.createObjPopup();
        this.createAsmPopup();
        this.createPythonPopup();
        this.tree.addMouseListener(this);
    }
}

