/*
 * Decompiled with CFR 0.152.
 */
package hades.manager;

import hades.gui.Editor;
import hades.gui.GUIFactory;
import hades.gui.SelectURLDialog;
import hades.manager.ExtensionFileFilter;
import hades.manager.SimObjectNotFoundException;
import hades.manager.SimObjectVersionNotFoundException;
import hades.models.Design;
import hades.simulator.SimObject;
import hades.utils.EndsWithFilter;
import hades.utils.NameMangler;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DesignManager {
    private static DesignManager _designManager = null;
    private static boolean debug = false;
    private static String appletServerName = null;
    private static String appletBaseDirName = null;
    private SelectURLDialog selectDialog;
    private FileDialog fileDialog;
    private Frame frame;
    private String _lastFileDialogDirectory;
    private SwingFileChooser swingFileChooser;
    private Hashtable _zipfileTable;
    private Hashtable thumbnailTable;
    private String[] matlabPath;
    private Hashtable virtualFiles;

    public static synchronized DesignManager getDesignManager() {
        if (_designManager == null) {
            _designManager = new DesignManager();
        }
        return _designManager;
    }

    public void setMatlabPath(String s) {
        if (debug) {
            DesignManager.msg("-#- DesignManager.setMatlabPath: " + s);
        }
        try {
            if (s == null || s.length() == 0) {
                this.matlabPath = null;
                return;
            }
            StringTokenizer st = new StringTokenizer(s, File.pathSeparator);
            int N = st.countTokens();
            this.matlabPath = new String[N];
            int i = 0;
            while (i < N) {
                this.matlabPath[i] = st.nextToken();
                ++i;
            }
        }
        catch (Throwable t) {
            DesignManager.msg("-E- DM.setMatlabPath: " + t);
            t.printStackTrace();
        }
    }

    public String[] getMatlabPath() {
        return this.matlabPath;
    }

    public SimObject getSimObject(String classname) throws SimObjectNotFoundException {
        if (debug) {
            DesignManager.msg("-I- DM.getSimObject(" + classname + ')');
        }
        SimObject tmp = null;
        try {
            Class<?> cl = Class.forName(classname);
            tmp = (SimObject)cl.newInstance();
        }
        catch (Exception e) {
            DesignManager.msg("-E- DesignManager: SimObject not found: " + classname);
            ExceptionTracer.trace(e);
            throw new SimObjectNotFoundException(classname);
        }
        return tmp;
    }

    public SimObject getSimObject(String classname, long version, Editor editor) throws SimObjectNotFoundException, SimObjectVersionNotFoundException {
        DesignManager.msg("-W- DM.getSimObject(): ignoring requested version: " + version);
        return this.getSimObject(classname);
    }

    public SimObject getCopy(SimObject source, Editor editor) {
        if (debug) {
            DesignManager.msg("-I- DesignManager.getCopy()...");
        }
        SimObject copy = source.copy();
        copy.setEditor(editor);
        return copy;
    }

    public Design getNewDesign(Editor editor) {
        Design tmp = new Design();
        tmp.setEditor(editor);
        tmp.setVisible(true);
        return tmp;
    }

    public Design getDesign(Editor editor, String resourcename, boolean toplevel) throws SimObjectNotFoundException {
        if (resourcename == null) {
            throw new SimObjectNotFoundException("-E- Empty Design resourcename!");
        }
        Design tmp = new Design();
        try {
            tmp.setEditor(editor);
            tmp.setVisible(toplevel);
            tmp.initialize(NameMangler.encodeWithUnicodeEscapes(resourcename));
        }
        catch (Exception e) {
            DesignManager.msg("-E- DesignManager.getDesign(): " + e);
            throw new SimObjectNotFoundException();
        }
        return tmp;
    }

    public boolean checkExistsMakeBackup(String pathname) {
        File orig = null;
        File tmpfile = null;
        String tmpname = null;
        try {
            orig = new File(pathname);
            tmpfile = new File(pathname);
            if (!orig.exists()) {
                return false;
            }
            int i = 0;
            while (tmpfile.exists()) {
                tmpname = pathname + '_' + i;
                tmpfile = new File(tmpname);
                ++i;
            }
            orig.renameTo(tmpfile);
            if (debug) {
                DesignManager.msg("-I- DM.checkExistsMakeBackup: renaming to " + tmpname);
            }
        }
        catch (Exception e) {
            DesignManager.msg("-E- internal error in DesignManager.checkExistsMakeBackup: ");
            DesignManager.msg("    pathname: `" + pathname + "' tmpname: `" + tmpname + '\'');
            DesignManager.msg(e.toString());
            e.printStackTrace();
        }
        return true;
    }

    public InputStream getResourceAsStream(String resourceName) {
        if (debug) {
            this.traceResourceAccess(resourceName);
        }
        InputStream IS = null;
        if (appletServerName != null) {
            String fullName = null;
            try {
                DesignManager.msg("-I- DesignManager.AppletWorkaround: loading " + appletServerName + ' ' + appletBaseDirName + ' ' + resourceName + " ...");
                fullName = appletServerName + appletBaseDirName + resourceName;
                URL url = new URL(fullName);
                IS = url.openStream();
                if (IS != null) {
                    return IS;
                }
            }
            catch (Exception e) {
                ExceptionTracer.trace(e);
            }
            System.err.println("-E- DesignManager.applet workaround failed for '" + fullName + '\'');
        }
        try {
            IS = this.getClass().getResourceAsStream(resourceName);
            if (IS != null) {
                return IS;
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
        }
        DesignManager.msg("-W- DesignManager: could not find resource '" + resourceName + "', checking for a file now...");
        try {
            if (new File(resourceName).exists()) {
                IS = new FileInputStream(resourceName);
            }
            if (IS != null) {
                return IS;
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
        }
        DesignManager.msg("-W- DesignManager: could not find file '" + resourceName + "', checking for an URL now...");
        try {
            IS = new URL(resourceName).openStream();
            if (IS != null) {
                return IS;
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
        }
        DesignManager.msg("-E- DesignManager: could not find URL '" + resourceName + '\'');
        DesignManager.msg("-E- Please check the resource/file/URL name and your CLASSPATH settings!");
        return null;
    }

    void traceResourceAccess(String resourceName) {
        System.err.println("-#- DesignManager.getResourceAsStream: " + resourceName);
    }

    public static String getAppletServerName() {
        return appletServerName;
    }

    public static void setAppletServerName(String servername) {
        System.out.println("-#- DM.setAppletServerName: " + servername);
        appletServerName = servername;
    }

    public static String getAppletBaseDir() {
        return appletBaseDirName;
    }

    public static void setAppletBaseDir(String name) {
        appletBaseDirName = name;
    }

    private final synchronized void checkCreateSelectURLDialog() {
        if (this.selectDialog == null) {
            this.checkCreateDummyFrame();
            this.selectDialog = GUIFactory.getGUIFactory().createSelectURLDialog(this.frame, "Select an URL:", "http://tams-www.informatik.uni-hamburg.de/applets/hades/webdemos/20-arithmetic/60-mult/mult4x4.hds");
        }
    }

    private final synchronized void checkCreateFileDialog() {
        if (this.fileDialog == null) {
            this.checkCreateDummyFrame();
        }
        this.fileDialog = new FileDialog(this.frame, "AWT is broken");
    }

    private final synchronized void checkCreateDummyFrame() {
        if (this.frame == null) {
            this.frame = new Frame("dummy");
            this.frame.setSize(100, 100);
            this.frame.setVisible(true);
        }
    }

    public void setDialogWindowsParentFrame(Frame frame) {
        this.frame = frame;
    }

    public String selectFileOrURLName(String dialogTitle, String defaultName, Object _extensions, int mode) {
        String name = null;
        String extension = null;
        if (_extensions instanceof String) {
            extension = (String)_extensions;
        }
        if (SetupManager.getBoolean("Hades.DesignManager.UseSelectDialog", false)) {
            this.checkCreateSelectURLDialog();
            if (dialogTitle != null) {
                this.selectDialog.getDialog().setTitle(dialogTitle);
            }
            if (defaultName != null) {
                this.selectDialog.setUrlName(defaultName);
            }
            this.selectDialog.setSelectFileEnabled(false);
            this.selectDialog.setVisible(true);
            int status = this.selectDialog.getStatus();
            if (status == 13) {
                name = this.selectDialog.getUrlName();
            } else if (status == 11) {
                name = null;
            } else if (status == 15) {
                DesignManager.msg("-E- internal: NOT YET IMPLEMENTED!");
                Thread.dumpStack();
            }
        } else if (SetupManager.getBoolean("Hades.UseSwingGUI", true)) {
            if (this.swingFileChooser == null) {
                this.swingFileChooser = new SwingFileChooser();
            }
            if (dialogTitle != null) {
                this.swingFileChooser.setTitle(dialogTitle);
            }
            if (_extensions != null) {
                this.swingFileChooser.setExtension(_extensions);
            }
            if (defaultName != null) {
                this.swingFileChooser.setDefaultName(defaultName);
            }
            this.swingFileChooser.setMode(mode);
            String result = this.swingFileChooser.select();
            if (result != null) {
                name = result;
                this._lastFileDialogDirectory = this.swingFileChooser.getDirectory();
            }
        } else {
            this.checkCreateFileDialog();
            if (dialogTitle != null) {
                this.fileDialog.setTitle(dialogTitle);
            }
            if (extension != null) {
                this.fileDialog.setFilenameFilter(new EndsWithFilter(extension));
            }
            if (defaultName != null) {
                this.setFileDialogDirectoryAndFilename(this.fileDialog, defaultName);
            }
            this.fileDialog.setMode(mode);
            this.fileDialog.setVisible(true);
            AntiDeadlock.sleep(100L);
            if (this.fileDialog.getFile() != null) {
                name = this.fileDialog.getDirectory() + this.fileDialog.getFile();
                this._lastFileDialogDirectory = this.fileDialog.getDirectory();
            }
        }
        if (name != null) {
            name = name.replace(File.separatorChar, '/');
        }
        DesignManager.dbg("-#- DM.selectFileOrURLName: " + name);
        return name;
    }

    public String selectURLName(String dialogTitle, String defaultName) {
        this.checkCreateSelectURLDialog();
        if (dialogTitle != null) {
            this.selectDialog.getDialog().setTitle(dialogTitle);
        }
        if (defaultName != null) {
            this.selectDialog.setUrlName(defaultName);
        }
        this.selectDialog.setSelectFileEnabled(false);
        this.selectDialog.setVisible(true);
        int status = this.selectDialog.getStatus();
        if (status == 13) {
            return this.selectDialog.getUrlName();
        }
        if (status == 11) {
            return null;
        }
        DesignManager.msg("-E- NOT YET IMPLEMENTED!");
        Thread.dumpStack();
        return null;
    }

    public void setFileDialogDirectoryAndFilename(FileDialog fileDialog, String resourceName) {
        String dirName = null;
        String fileName = null;
        DesignManager.dbg("-#- sFDDAF: '" + resourceName + '\'');
        if (fileDialog == null) {
            return;
        }
        if (this._lastFileDialogDirectory != null) {
            fileDialog.setDirectory(this._lastFileDialogDirectory);
        }
        DesignManager.dbg("*** " + fileDialog.getDirectory());
        try {
            int lastSlash = resourceName.lastIndexOf(47);
            if (lastSlash >= 0) {
                dirName = resourceName.substring(0, lastSlash);
                fileName = resourceName.substring(lastSlash + 1);
            } else {
                fileName = resourceName;
            }
        }
        catch (Exception e) {
            DesignManager.msg("-#- Internal error in sFDDAF: " + e);
            e.printStackTrace();
        }
        if (dirName != null) {
            dirName = dirName.replace('/', File.separatorChar);
            File dir = null;
            dir = new File(dirName);
            if (dir != null && dir.exists()) {
                fileDialog.setDirectory(dirName);
            }
        }
        if (fileName != null) {
            fileDialog.setFile(fileName);
        }
        DesignManager.dbg("-#- dirName  = '" + dirName + '\'');
        DesignManager.dbg("-#- fileName = '" + fileName + '\'');
    }

    public String checkAndAddFilenameExtension(String name, String extension) {
        boolean extensionHasDot;
        boolean nameHasDot;
        if (!SetupManager.getBoolean("Hades.DesignManager.AutoAddExtension", true)) {
            return name;
        }
        boolean bl = false;
        if (name.indexOf(46) >= 0) {
            bl = true;
        }
        if (nameHasDot = bl) {
            return name;
        }
        if (extension == null) {
            return name;
        }
        boolean bl2 = false;
        if (extension.indexOf(46) >= 0) {
            bl2 = true;
        }
        if (extensionHasDot = bl2) {
            return name + extension;
        }
        return name + '.' + extension;
    }

    public void LOG(String protocol, String name, Object result) {
    }

    public InputStream getInputStream(Object parent, String pathname) {
        if (debug) {
            DesignManager.msg("\n\n-#- DM.getInputStream: raw name '" + pathname + '\'');
        }
        InputStream raw = null;
        raw = this.getInputStreamFromURL(pathname);
        if (raw != null) {
            return raw;
        }
        raw = this.getInputStreamFromResource(pathname);
        if (raw != null) {
            return raw;
        }
        raw = this.getInputStreamForAppletMode(pathname);
        if (raw != null) {
            return raw;
        }
        raw = this.getInputStreamForMatlabMode(pathname);
        if (raw != null) {
            return raw;
        }
        raw = this.getParentRelativeInputStream(parent, pathname);
        if (raw != null) {
            return raw;
        }
        raw = this.getInputStreamFromAbsoluteFilename(pathname);
        if (raw != null) {
            return raw;
        }
        raw = this.getInputStreamFromRelativeFilename(pathname);
        if (raw != null) {
            return raw;
        }
        DesignManager.msg("-E- DM.getInputStream: no stream found for '" + pathname + '\'');
        return null;
    }

    public InputStream getInputStreamFromURL(String pathname) {
        InputStream raw = null;
        String tmpname = null;
        try {
            if (pathname.startsWith("virtual://")) {
                tmpname = pathname.substring(10).replace('/', File.separatorChar);
                raw = this.getVirtualFile(tmpname);
                this.LOG("-1- virtual://", tmpname, raw);
            } else if (pathname.startsWith("file://")) {
                tmpname = pathname.substring(7).replace('/', File.separatorChar);
                raw = new FileInputStream(tmpname);
                this.LOG("-1- file://", tmpname, raw);
            } else if (pathname.startsWith("file:")) {
                tmpname = pathname.substring(5).replace('/', File.separatorChar);
                raw = new FileInputStream(tmpname);
                this.LOG("-1- file://", tmpname, raw);
            } else if (pathname.startsWith("zip://")) {
                raw = this.getZipEntryInputStream(pathname);
                this.LOG("-1- zip://", tmpname, raw);
            } else if (pathname.startsWith("resource://")) {
                tmpname = pathname.substring(11);
                raw = this.getClass().getResourceAsStream(tmpname);
                this.LOG("-1- resource://", tmpname, raw);
            } else if (pathname.indexOf("://") > 0) {
                tmpname = pathname;
                URL rawURL = new URL(tmpname);
                URLConnection conn = rawURL.openConnection();
                raw = conn.getInputStream();
                this.LOG("-1- unkown URL protocol:", tmpname, raw);
            } else {
                if (debug) {
                    DesignManager.msg("-1- no explicit protocol '" + pathname + '\'');
                }
                return null;
            }
            if (raw != null && debug) {
                DesignManager.msg("-1- found: '" + tmpname + '\'');
            }
        }
        catch (Throwable e) {
            DesignManager.msg("-1- exception while opening '" + tmpname + "': " + e);
            if (debug) {
                e.printStackTrace();
            }
            this.LOG("error phase 1", pathname, raw);
        }
        return raw;
    }

    /*
     * Unable to fully structure code
     */
    public InputStream getInputStreamFromAbsoluteFilename(String pathname) {
        block7: {
            if (File.separatorChar != '/' || pathname.length() <= 1 || pathname.charAt(0) != '/') ** GOTO lbl9
            unixfile = new File(pathname);
            if (unixfile.exists() && unixfile.canRead()) {
                this.LOG("-5- absolute unix file: ", pathname, unixfile);
                return new FileInputStream(unixfile);
            }
            break block7;
lbl9:
            // 1 sources

            if (File.separatorChar != '\\' || pathname.length() <= 2 || pathname.charAt(1) != ':') ** GOTO lbl16
            winfile = new File(pathname = pathname.replace('/', File.separatorChar));
            if (winfile.exists() && winfile.canRead()) {
                this.LOG("-5- absolute windows file: ", pathname, winfile);
                return new FileInputStream(winfile);
            }
            try {
                break block7;
lbl16:
                // 1 sources

                file = new File(pathname = pathname.replace('/', File.separatorChar));
                if (file.exists() && file.canRead()) {
                    this.LOG("-5- absolute file: ", pathname, file);
                    return new FileInputStream(file);
                }
            }
            catch (Exception e) {
                DesignManager.msg("-5- exception (absolute file mode) '" + pathname + "': " + e);
                if (!DesignManager.debug) break block7;
                e.printStackTrace();
            }
        }
        return null;
    }

    public InputStream getInputStreamFromRelativeFilename(String pathname) {
        block3: {
            String tmpname = null;
            try {
                tmpname = pathname.replace('/', File.separatorChar);
                File file = new File(tmpname);
                if (file.exists() && file.canRead()) {
                    this.LOG("-6- arbitrary file: ", tmpname, file);
                    return new FileInputStream(file);
                }
            }
            catch (Exception e) {
                DesignManager.msg("-6- exception (file mode) for '" + tmpname + "': " + e);
                if (!debug) break block3;
                e.printStackTrace();
            }
        }
        return null;
    }

    public InputStream getInputStreamForMatlabMode(String pathname) {
        if (this.matlabPath == null) {
            return null;
        }
        try {
            int N = this.matlabPath.length;
            int i = 0;
            while (i < N) {
                String mname = this.matlabPath[i] + File.separator + pathname;
                File mfile = new File(mname);
                if (mfile.exists()) {
                    this.LOG("-3- Matlab mode: found '" + mname + '\'', pathname, mfile);
                    return new FileInputStream(mfile);
                }
                ++i;
            }
            return null;
        }
        catch (Throwable e) {
            DesignManager.msg("-3- exception (Matlab mode) for '" + pathname + "': " + e);
            if (debug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public InputStream getInputStreamForAppletMode(String pathname) {
        if (appletServerName == null) {
            return null;
        }
        String fullName = null;
        InputStream stream = null;
        try {
            URL url;
            fullName = appletServerName + appletBaseDirName + pathname;
            if (debug) {
                DesignManager.msg("-4- applet URL '" + fullName + '\'');
            }
            if ((stream = (url = new URL(fullName)).openStream()) != null) {
                this.LOG("-4- applet mode: found '" + fullName + '\'', pathname, stream);
            }
            return stream;
        }
        catch (Exception e) {
            e.printStackTrace();
            DesignManager.msg("-4- exception (applet mode) for '" + fullName + '\'');
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getInputStreamFromResource(String pathname) {
        String tmpname = pathname;
        try {
            void e;
            tmpname = pathname.startsWith("/") ? pathname : "/" + pathname;
            InputStream raw = this.getClass().getResourceAsStream(tmpname);
            this.LOG("-7- resource://", tmpname, raw);
            return e;
        }
        catch (Exception e) {
            DesignManager.msg("-7- exception (resource mode) for '" + tmpname + "': " + e);
            if (debug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public InputStream getParentRelativeInputStream(Object parent, String pathname) {
        if (parent == null) {
            return null;
        }
        DesignManager.dbg("-#- getParentRelativeInputStream: ");
        DesignManager.dbg("    parent object='" + parent + '\'');
        DesignManager.dbg("    pathname='" + pathname + '\'');
        Design design = null;
        try {
            SimObject tmp = (SimObject)parent;
            design = (Design)tmp.getParent();
        }
        catch (Exception e) {
            return this.getInputStream(null, pathname);
        }
        while (design != null) {
            InputStream raw;
            String designResourceName = design.getResourceName();
            DesignManager.dbg("    in parent Design '" + designResourceName + '\'');
            String dirName = DesignManager.getDirectoryName(designResourceName);
            String qualifiedName = pathname;
            if (dirName.length() > 0 && (raw = this.getInputStream(null, qualifiedName = DesignManager.concatenateUnixPathnames(dirName, pathname))) != null) {
                return raw;
            }
            design = (Design)design.getParent();
        }
        return null;
    }

    private static final String concatenateUnixPathnames(String dirname, String filename) {
        String dtmp = dirname;
        String ftmp = filename;
        if (dirname == null) {
            return filename;
        }
        if (dtmp.endsWith("/")) {
            dtmp = dtmp.substring(0, dtmp.length() - 1);
        }
        try {
            while (ftmp.startsWith("../")) {
                ftmp = ftmp.substring(3);
                int ix = dtmp.lastIndexOf("/");
                if (ix > 0) {
                    dtmp = dtmp.substring(0, ix);
                    continue;
                }
                DesignManager.msg("-E- concatenateUnixPathnames: '" + dirname + "' + '" + filename + '\'');
                DesignManager.msg("-E- not enough parent dirs...");
                return filename;
            }
            return dtmp + '/' + ftmp;
        }
        catch (Exception e) {
            DesignManager.msg("-E- concatenateUnixPathnames: " + e);
            e.printStackTrace();
            return dtmp + '/' + ftmp;
        }
    }

    public static void dumpStringArray(String[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            System.out.print(" '" + tokens[i] + "' ");
            ++i;
        }
        System.out.println();
    }

    public OutputStream getOutputStream(Object o, String pathname) {
        try {
            pathname = pathname.replace('/', File.separatorChar);
            DesignManager.dbg("-#- DM.getOutputStream: '" + pathname + '\'');
            return new FileOutputStream(pathname);
        }
        catch (Exception e) {
            return System.out;
        }
    }

    public Image getThumbnail(String pathname) {
        String gifName;
        Image thumbnail;
        if (debug) {
            DesignManager.msg("-#- DM.getThumbnail: " + pathname);
        }
        if ((thumbnail = (Image)this.thumbnailTable.get(gifName = pathname)) != null) {
            return thumbnail;
        }
        thumbnail = this.getImage(null, gifName);
        if (thumbnail != null) {
            this.thumbnailTable.put(gifName, thumbnail);
        } else {
            thumbnail = this.getImage(null, "/hades/manager/icons/null.gif");
        }
        return thumbnail;
    }

    public Image getImage(Object parent, String pathname) {
        if (debug) {
            DesignManager.msg("-#- DM.getThumbnail: " + pathname);
        }
        Image image = null;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            InputStream inputStream = this.getInputStream(parent, pathname);
            if (inputStream == null) {
                throw new FileNotFoundException("Image not found: " + pathname);
            }
            ByteArrayOutputStream baos = this.readStreamIntoBuffer(inputStream);
            image = toolkit.createImage(baos.toByteArray());
            Frame observer = this.frame;
            toolkit.prepareImage(image, -1, -1, observer);
            int iter = 0;
            while (iter < 1000) {
                int status = toolkit.checkImage(image, -1, -1, observer);
                if ((status & 0x40) != 0) {
                    DesignManager.msg("-E- DM.getImage: got an error during image decoding.");
                } else if ((status & 0x20) == 0) {
                    Thread.sleep(10L);
                    ++iter;
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            DesignManager.msg("-E- DM.getImage: not found from " + pathname);
        }
        return image;
    }

    public String readStreamIntoString(String pathname) {
        ByteArrayOutputStream baos = this.readStreamIntoBuffer(pathname);
        if (baos != null) {
            return baos.toString();
        }
        return null;
    }

    public ByteArrayOutputStream readStreamIntoBuffer(String pathname) {
        return this.readStreamIntoBuffer(this.getInputStream(null, pathname));
    }

    public ByteArrayOutputStream readStreamIntoBuffer(InputStream input) {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            if (input != null) {
                byte[] buffer = new byte[4096];
                int length = 0;
                int count = 0;
                while ((length = input.read(buffer, 0, buffer.length)) >= 0) {
                    baos.write(buffer, 0, length);
                    count += length;
                }
            }
            baos.close();
            return baos;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public Hashtable getVirtualFiles() {
        return this.virtualFiles;
    }

    public void saveAsVirtualFile(String key, InputStream is) {
        ByteArrayOutputStream baos = this.readStreamIntoBuffer(is);
        if (baos != null) {
            this.virtualFiles.put(key, baos.toString());
        }
    }

    public void saveAsVirtualFile(String key, String data) {
        this.virtualFiles.put(key, data);
    }

    public InputStream getVirtualFile(String key) {
        String raw = (String)this.virtualFiles.get(key);
        if (raw == null) {
            return null;
        }
        byte[] bytes = raw.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public void registerZipFile(ZipFile zipfile) {
        this._zipfileTable.put(zipfile.getName(), zipfile);
        DesignManager.msg("-I- registerZipFile: " + zipfile.getName());
    }

    public InputStream getZipEntryInputStream(String pathname) {
        try {
            int index = pathname.indexOf(63);
            String zipname = pathname.substring(6, index);
            String filename = pathname.substring(index + 2);
            if (debug) {
                DesignManager.msg("-#- DM.getZEIS: zip='" + zipname + "' file='" + filename + '\'');
            }
            ZipFile zipfile = (ZipFile)this._zipfileTable.get(zipname);
            InputStream input = zipfile.getInputStream(zipfile.getEntry(filename));
            return input;
        }
        catch (Exception e) {
            DesignManager.msg("-E- getZipEntryInputStream failed for pathname: " + pathname);
            return null;
        }
    }

    public static String convertToUnixFileSeparator(String pathname) {
        String tmp1 = pathname.replace('\\', '/');
        String tmp2 = tmp1.replace('|', '/');
        return tmp2;
    }

    public static String getAbsoluteFilename(String pathname) {
        return new File(pathname).getAbsolutePath();
    }

    public static String getDirectoryOLD(String pathname) {
        if (pathname == null) {
            return null;
        }
        if (pathname.indexOf("://") > 0) {
            int slash = pathname.lastIndexOf(47);
            String tmp = pathname.substring(0, slash);
            System.out.println("-#- getDirectory: '" + pathname + "' >>> '" + tmp + '\'');
            return tmp;
        }
        String tmp = pathname.replace('/', File.separatorChar);
        String parentname = new File(tmp).getParent();
        if (parentname == null) {
            return null;
        }
        return new File(parentname).getAbsolutePath();
    }

    public static String getDirectoryName(String pathname) {
        try {
            int ix;
            if (pathname == null) {
                return "";
            }
            if (pathname.endsWith("/")) {
                pathname = pathname.substring(0, pathname.length() - 1);
            }
            if ((ix = pathname.lastIndexOf("/")) > 0) {
                return pathname.substring(0, ix);
            }
            return "";
        }
        catch (Exception e) {
            DesignManager.msg("-E- getDirectoryName: " + e);
            e.printStackTrace();
            return "";
        }
    }

    public static String getName(String pathname) {
        File f = new File(pathname);
        return f.getName();
    }

    public static String getExtension(String pathname) {
        int index = pathname.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return pathname.substring(index);
    }

    public static String changeExtension(String source, String newExtension) {
        int index = source.lastIndexOf(".");
        if (index < 0) {
            return source + newExtension;
        }
        return source.substring(0, index) + newExtension;
    }

    public static String getProtocol(String pathname) {
        int ix = pathname.indexOf("://");
        if (ix > 0) {
            return pathname.substring(0, ix + 3);
        }
        if (pathname.startsWith("file:")) {
            DesignManager.msg("-W- getProtocol: truncated 'file:' URL detected: '" + pathname + '\'');
            return "file:";
        }
        return null;
    }

    public static String[] splitIntoProtocolAndDirectoryAndFilename(String pathname) {
        int ix;
        String protocol = DesignManager.getProtocol(pathname);
        String remainder = pathname;
        String directory = null;
        String filename = null;
        if (protocol != null) {
            remainder = pathname.substring(protocol.length());
        }
        if ((ix = remainder.lastIndexOf("/")) >= 0) {
            directory = remainder.substring(0, ix);
            filename = remainder.substring(ix + 1);
        } else {
            directory = "";
            filename = remainder;
        }
        return new String[]{protocol, directory, filename};
    }

    public static void setDebug(boolean b) {
        debug = b;
        Thread.dumpStack();
    }

    public boolean getDebug() {
        return debug;
    }

    public static void dbg(String msg) {
        if (SetupManager.getBoolean("Hades.DesignManager.VerboseMessages", false)) {
            System.out.println(msg);
        }
    }

    public static void msg(String msg) {
        System.out.println(msg);
    }

    public String toString() {
        return "HADES DesignManager 0.2";
    }

    public static void main(String[] args) {
        DesignManager.msg("-#- DesignManager selftest... ");
        String[] tests = new String[]{"http://tams-www/applets/hades/webdemos/intro/welcome/welcome.hds", "file://c:/temp/incoming/stalakdrama.mp3", "file:///home/hugo/hades/hello.hds", "file:///home/hugo/hades/no/filename/", "file://just/an/unusual/relative/path.rom", "file:/tmp/broken.hds", "virtual://testbench.hds", "zip://iDontRemember/The/Format/Of/Hades/Zip/URLs.txt", "resource:/hades/models/gates/And3.sym", "adder1.hds", "../mult4x4/add.hds", "/tmp/jetty/webdemos/docs.txt", "c:\\temp\\incoming\\SN74590.hds"};
        int i = 0;
        while (i < tests.length) {
            DesignManager.msg("\n-#- splitting: '" + tests[i] + '\'');
            DesignManager.dumpStringArray(DesignManager.splitIntoProtocolAndDirectoryAndFilename(DesignManager.convertToUnixFileSeparator(tests[i])));
            ++i;
        }
        String s = "../../hugo.rom";
        int i2 = 0;
        while (i2 < tests.length) {
            DesignManager.msg("\n-#- dirnames: '" + tests[i2] + '\'');
            String t = DesignManager.convertToUnixFileSeparator(tests[i2]);
            DesignManager.msg(" '" + DesignManager.getDirectoryName(t) + '\'');
            DesignManager.msg(" '" + DesignManager.concatenateUnixPathnames(DesignManager.getDirectoryName(t), s));
            ++i2;
        }
    }

    private final /* synthetic */ void this() {
        this._zipfileTable = new Hashtable();
        this.thumbnailTable = new Hashtable();
        this.virtualFiles = new Hashtable();
    }

    private DesignManager() {
        this.this();
        if (debug) {
            DesignManager.msg("-I- DesignManager() constructed...");
        }
        debug = SetupManager.getBoolean("Hades.DesignManager.Debug", false);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SwingFileChooser {
        JFileChooser fileChooser = new JFileChooser();
        File selectedFile;
        int mode;

        public void setTitle(String title) {
            this.fileChooser.setDialogTitle(title);
        }

        public void setExtension(Object _extensions) {
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.setFileFilter(new ExtensionFileFilter(_extensions));
        }

        public void setDefaultDirectory() {
            try {
                if (DesignManager.this._lastFileDialogDirectory == null) {
                    String tmp = System.getProperty("user.dir");
                    File cwd = new File(tmp);
                    DesignManager.this._lastFileDialogDirectory = cwd.getAbsolutePath();
                }
                this.fileChooser.setCurrentDirectory(new File(DesignManager.this._lastFileDialogDirectory));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void setDefaultName(String defaultName) {
            DesignManager.dbg("-#- DM.SFC.setDefaultName: '" + defaultName + '\'');
            if (defaultName == null || defaultName == "") {
                this.setDefaultDirectory();
                this.selectedFile = null;
                return;
            }
            String name = DesignManager.getName(defaultName);
            String dir = DesignManager.getDirectoryName(defaultName);
            if (dir == null) {
                this.setDefaultDirectory();
                dir = DesignManager.this._lastFileDialogDirectory;
                DesignManager.dbg("-#- DM.SFC.setDefaultName: dir='" + dir + "' name='" + name + '\'');
                this.selectedFile = new File(name);
            } else {
                this.fileChooser.setCurrentDirectory(new File(dir));
                this.selectedFile = new File(defaultName);
            }
        }

        public void setMode(int _mode) {
            this.mode = _mode;
        }

        public String select() {
            if (this.selectedFile != null) {
                try {
                    DesignManager.dbg("-#- DM.SFC.select: preselect= '" + this.selectedFile + '\'');
                    this.fileChooser.setSelectedFile(this.selectedFile);
                }
                catch (Throwable t) {
                    DesignManager.msg("-E- internal: " + t);
                }
            }
            if (this.mode == 0) {
                int status = this.fileChooser.showOpenDialog(DesignManager.this.frame);
                if (status == 0) {
                    this.selectedFile = this.fileChooser.getSelectedFile();
                    DesignManager.dbg("-#- DM.SFC.select.LOAD: '" + this.selectedFile + '\'');
                    return this.getFile();
                }
                return null;
            }
            if (this.mode == 1) {
                int status = this.fileChooser.showSaveDialog(DesignManager.this.frame);
                if (status == 0) {
                    this.selectedFile = this.fileChooser.getSelectedFile();
                    DesignManager.dbg("-#- DM.SFC.select.SAVE: '" + this.selectedFile + '\'');
                    return this.getFile();
                }
                return null;
            }
            DesignManager.msg("-E- internal error: unknown mode for FileChooser...");
            return null;
        }

        public String getDirectory() {
            if (this.selectedFile == null) {
                return null;
            }
            return this.selectedFile.getParent();
        }

        public String getFile() {
            return this.selectedFile.getPath();
        }

        public SwingFileChooser() {
            this.setDefaultDirectory();
            this.selectedFile = null;
            this.mode = 0;
        }
    }
}

