/*
 * Decompiled with CFR 0.152.
 */
package hades.manager;

import hades.gui.Console;
import hades.gui.Editor;
import hades.gui.JPropertiesViewer;
import hades.manager.Browser;
import hades.manager.HadesTreeCellRenderer;
import hades.manager.InfoPanel;
import hades.manager.TreeManager;
import hades.manager.TreePopupMenu;
import hades.manager.tree.DirectoryTreeNode;
import hades.manager.tree.ResourceRootTreeNode;
import hades.manager.tree.RootTreeNode;
import hades.manager.tree.SortedTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Colibri
implements ActionListener,
Browser {
    public static boolean debug = false;
    public static boolean standalone = false;
    public static String versionString = "Colibri 0.54 (15.07.2005)";
    private static Object lock = new Object();
    private static Browser singleton;
    private TreeManager treeManager;
    private SetupDialog setupDialog;
    private JFrame frame;
    private JSplitPane splitPane;
    private JTree tree;
    private JScrollPane treeScroller;
    private JSplitPane rightPanel;
    private JScrollPane imageScroller;
    private JLabel imageCanvas;
    private InfoPanel infoPanel;
    JMenuBar mb;
    JMenu mFile;
    JMenu mEdit;
    JMenu mBookmark;
    JMenu mSearch;
    JMenu mExtra;
    JMenu mHelp;
    JMenuItem miSetup;
    JMenuItem miClose;
    JMenuItem miExit;
    JMenuItem miCopy;
    JMenuItem miCut;
    JMenuItem miPaste;
    JMenuItem miRefresh;
    JMenuItem miMessages;
    JMenuItem miSearch;
    JMenuItem miThumb;
    JMenuItem miAbout;
    JMenuItem miHelp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Browser getBrowser() {
        Object object = lock;
        synchronized (object) {
            if (singleton == null) {
                TreeManager tb = new TreeManager();
                tb.setRootNode(new RootTreeNode());
                singleton = new Colibri(tb);
                singleton.getTree().setModel(new DefaultTreeModel(tb.getRootNode()));
                ((DefaultTreeModel)singleton.getTree().getModel()).reload();
            }
            return singleton;
        }
    }

    public void setTreeManager(TreeManager manager) {
        this.treeManager = manager;
    }

    public TreeManager getTreeManager() {
        return this.treeManager;
    }

    public void buildOrRefreshTree() {
        this.treeManager.getRootNode().removeAllChildren();
        this.checkIncludeSystemCLBs();
        this.checkIncludeClasspathJars();
        this.checkIncludeExtensionJars();
        this.checkScanUserDirectories();
    }

    public void createFrame() {
        this.frame = new JFrame("Colibri");
    }

    public void createMenus() {
        JMenu fileMenu = new JMenu("File");
        JMenu editMenu = new JMenu("Edit");
        JMenu optsMenu = new JMenu("Options");
        JMenu helpMenu = new JMenu("Help");
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(optsMenu);
        menuBar.add(helpMenu);
        this.frame.setJMenuBar(menuBar);
        this.miClose = this._cmi("Close", "control W");
        fileMenu.add(this.miClose);
        this.miExit = this._cmi("Exit", "control Q", standalone);
        fileMenu.add(this.miExit);
        this.miSetup = this._cmi("Browser setup...", null);
        editMenu.add(this.miSetup);
        editMenu.addSeparator();
        this.miCopy = this._cmi("Copy", null, false);
        editMenu.add(this.miCopy);
        this.miCut = this._cmi("Cut", null, false);
        editMenu.add(this.miCut);
        this.miPaste = this._cmi("Paste", null, false);
        editMenu.add(this.miPaste);
        editMenu.addSeparator();
        this.miRefresh = this._cmi("Refresh Tree", null);
        editMenu.add(this.miRefresh);
        this.miMessages = this._cmi("Show message window", "control M");
        optsMenu.add(this.miMessages);
        this.miSearch = this._cmi("Search...", null, false);
        optsMenu.add(this.miSearch);
        this.miThumb = this._cmi("Create thumbnail", null, false);
        optsMenu.add(this.miThumb);
        this.miAbout = this._cmi("About", "control A");
        helpMenu.add(this.miAbout);
        this.miHelp = this._cmi("Help", "control H");
        helpMenu.add(this.miHelp);
    }

    private final JMenuItem _cmi(String label, String shortcut) {
        return this._cmi(label, shortcut, true);
    }

    private final JMenuItem _cmi(String label, String shortcut, boolean enabled) {
        JMenuItem mi = new JMenuItem(label);
        mi.setEnabled(enabled);
        mi.addActionListener(this);
        try {
            if (shortcut != null) {
                mi.setAccelerator(KeyStroke.getKeyStroke(shortcut));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return mi;
    }

    public void createTree() {
        if (debug) {
            Colibri.msg("-#- createTree...");
        }
        this.tree = new JTree();
        this.tree.setModel(new DefaultTreeModel(new SortedTreeNode("empty")));
        this.tree.setRootVisible(false);
        this.tree.setLargeModel(true);
        this.tree.setCellRenderer(new HadesTreeCellRenderer());
        this.tree.setDragEnabled(true);
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel();
        dtsm.setSelectionMode(1);
        this.tree.setSelectionModel(dtsm);
        this.treeScroller = new JScrollPane(this.tree);
        this.treeScroller.setPreferredSize(new Dimension(250, 600));
    }

    public void createTreePopupMenu() {
        if (debug) {
            Colibri.msg("-#- createTreePopupMenu...");
        }
        new TreePopupMenu(this);
    }

    public void createImagePanel() {
        if (debug) {
            Colibri.msg("-#- createImagePanel...");
        }
        this.imageCanvas = new JLabel();
        this.imageCanvas.setIcon(new ImageIcon(this.getClass().getResource("/hades/manager/icons/unknown.gif")));
        this.imageCanvas.setBackground(Color.white);
        this.imageCanvas.setForeground(Color.orange);
        this.imageCanvas.setHorizontalAlignment(0);
        this.imageScroller = new JScrollPane(this.imageCanvas);
        this.imageScroller.setBackground(Color.white);
        this.imageScroller.setMinimumSize(new Dimension(225, 100));
        this.imageScroller.setPreferredSize(new Dimension(300, 225));
    }

    public void createInfoPanel() {
        if (debug) {
            Colibri.msg("-#- createInfoPanel...");
        }
        this.infoPanel = new InfoPanel();
    }

    public void createSplitPaneAndLayout() {
        if (debug) {
            Colibri.msg("-#- createSplitPaneAndLayout...");
        }
        this.rightPanel = new JSplitPane(0, false, this.imageScroller, this.infoPanel);
        this.rightPanel.setOneTouchExpandable(true);
        this.rightPanel.setMinimumSize(new Dimension(50, 200));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add("Center", this.treeScroller);
        this.splitPane = new JSplitPane(1, false, leftPanel, this.rightPanel);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setDoubleBuffered(true);
        this.frame.getContentPane().add("Center", this.splitPane);
    }

    public void createSetupDialog() {
        this.setupDialog = new SetupDialog();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public JTree getTree() {
        return this.tree;
    }

    public Editor getEditor() {
        Thread.dumpStack();
        return null;
    }

    public void setLookAndFeel() {
        try {
            String lnf = SetupManager.getProperty("Hades.LookAndFeelClassName");
            if (lnf != null) {
                Colibri.msg("-I- requesting custom look and feel '" + lnf + '\'');
                UIManager.setLookAndFeel(lnf);
            }
        }
        catch (Exception e) {
            Colibri.msg("-W- could not set requested look-and-feel: " + e);
        }
    }

    public InfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public void setInfoPanel(InfoPanel ip) {
        throw new RuntimeException("setInfoPanel NOT IMPLEMENTED");
    }

    public void setTree(JTree tree) {
        throw new RuntimeException("setTree NOT IMPLEMENTED");
    }

    public JLabel getImageCanvas() {
        return this.imageCanvas;
    }

    public Image getComponentThumbnail() {
        try {
            ImageIcon icon = (ImageIcon)this.imageCanvas.getIcon();
            return icon.getImage();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setComponentThumbnail(Image thumbnail) {
        ImageIcon icon = thumbnail != null ? new ImageIcon(thumbnail) : null;
        this.imageCanvas.setIcon(icon);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.miSetup) {
            this.doEditSetup();
        } else if (source == this.miClose) {
            this.doClose();
        } else if (source == this.miExit) {
            this.doExit();
        } else if (source == this.miCopy) {
            this.doClipboardCopy();
        } else if (source == this.miCut) {
            this.doClipboardCut();
        } else if (source == this.miPaste) {
            this.doClipboardPaste();
        } else if (source == this.miRefresh) {
            this.doRefresh();
        } else if (source == this.miMessages) {
            this.doShowMessages();
        } else if (source == this.miSearch) {
            this.doStartSearch();
        } else if (source == this.miThumb) {
            this.doCreateThumbnail();
        } else if (source == this.miAbout) {
            this.doShowAboutDialog();
        } else if (source == this.miHelp) {
            this.doShowHelp();
        } else {
            Colibri.msg("-W- unknown action event: " + e);
            Colibri.msg("... " + source);
            Colibri.msg("... " + this.miHelp);
            Colibri.msg("... " + this.miAbout);
        }
    }

    public void doShowAboutDialog() {
        JOptionPane.showMessageDialog(this.frame, "Colibri: the Hades component and library browser\n\n(C) 1998-2001 by Karola Kr\u00f6nert and Ulrich Dallmann\n(C) 2002-2005 by Norman Hendrich\n\n", "About Colibri", 1);
    }

    public void doShowHelp() {
        JOptionPane.showMessageDialog(this.frame, "Use the tree to browse the Hades component library\nand your own design directories. To add a component\nto your current design, just double-click a component\nor use the popup-menu in the tree.\n\nDouble-click a design file to open that design file,\nor use the popup-menu to instantiate a subdesign.\n\nUse menu->edit->browser setup to select up to four\ndesign directories.\n\nFor detailed help see the Hades website at\nhttp://tams-www.informatik.uni-hamburg.de/applets/hades/\n\n", "Colibri Help", 1);
    }

    public void doShowMessages() {
        Colibri.msg("-#- doShowMessages...");
        Console.getConsole().setVisible(true);
    }

    public void doStartSearch() {
        throw new UnsupportedOperationException("doStartSearch");
    }

    public void doCreateThumbnail() {
        throw new UnsupportedOperationException("doCreateThumbnail");
    }

    public void doExit() {
        if (standalone) {
            this.checkEditorChangesThenExit();
        } else {
            this.frame.setVisible(false);
        }
    }

    public void doClose() {
        if (standalone) {
            this.checkEditorChangesThenExit();
        } else {
            this.frame.setVisible(false);
        }
    }

    public void checkEditorChangesThenExit() {
        try {
            Editor editor = Editor.getActiveEditor();
            if (editor != null) {
                editor.doExit();
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            Colibri.msg("-E- internal error in checkEditorChangesThenExit: " + e);
            e.printStackTrace();
        }
    }

    public void doEditSetup() {
        Colibri.msg("-#- doEditSetup...");
        this.setupDialog.updateDirectories();
        this.setupDialog.setVisible(true);
    }

    public void doRefresh() {
        Colibri.msg("-I- doRefresh: rebuilding the tree now, this can take some time...");
        this.buildOrRefreshTree();
        ((DefaultTreeModel)this.getTree().getModel()).reload();
    }

    public void doClipboardCopy() {
        throw new UnsupportedOperationException("doClipboardCopy not yet!");
    }

    public void doClipboardCut() {
        throw new UnsupportedOperationException("doClipboardCut not yet!");
    }

    public void doClipboardPaste() {
        throw new UnsupportedOperationException("doClipboardPaste not yet!");
    }

    private final DirectoryTreeNode findDirectoryNode(SortedTreeNode rootNode, Hashtable dirTable, String fullDirectoryName) {
        Object val = dirTable.get(fullDirectoryName);
        if (val != null) {
            return (DirectoryTreeNode)val;
        }
        int lastSlash = fullDirectoryName.lastIndexOf(47);
        if (lastSlash > 1) {
            String parentName = fullDirectoryName.substring(0, lastSlash);
            String dirName = fullDirectoryName.substring(lastSlash + 1);
            DirectoryTreeNode parent = this.findDirectoryNode(rootNode, dirTable, parentName);
            DirectoryTreeNode dir = new DirectoryTreeNode();
            dir.setUserObject(dirName);
            parent.add(dir);
            dirTable.put(fullDirectoryName, dir);
            return dir;
        }
        DirectoryTreeNode dir = new DirectoryTreeNode();
        dir.setUserObject(fullDirectoryName);
        rootNode.add(dir);
        dirTable.put(fullDirectoryName, dir);
        return dir;
    }

    public void parseCLBListFile(InputStream is) {
        ResourceRootTreeNode tmpRoot = new ResourceRootTreeNode();
        Hashtable dirTable = new Hashtable();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                if (line.charAt(0) == '/') {
                    line = line.substring(1);
                }
                int lastSlash = line.lastIndexOf(47);
                String dirs = line.substring(0, lastSlash);
                String name = line.substring(lastSlash + 1);
                DirectoryTreeNode dtn = this.findDirectoryNode(tmpRoot, dirTable, dirs);
                SortedTreeNode sotn = this.treeManager.createLeafNode(name);
                dtn.add(sotn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.treeManager.getRootNode().add(tmpRoot);
    }

    public void checkIncludeSystemCLBs() {
        Colibri.msg("-#- checkIncludeSystemCLBs...");
        InputStream is = null;
        boolean fallback = false;
        try {
            String home = System.getProperty("user.home");
            File clbf = new File(home + File.separator + ".hades" + File.separator + "clblist.txt");
            Colibri.msg("-#- clbf: " + clbf);
            if (clbf.exists()) {
                is = new FileInputStream(clbf);
                this.parseCLBListFile(is);
                is.close();
            } else {
                Colibri.msg("-#- $HOME/.hades/clblist.txt file doesn't exist.");
                fallback = true;
            }
        }
        catch (SecurityException se) {
            Colibri.msg("-#- access to '$HOME/.hades/clblist.txt' denied.");
            fallback = true;
        }
        catch (Exception e) {
            Colibri.msg("-#- access to '$HOME/.hades/clblist.txt' failed...");
            fallback = true;
        }
        if (fallback) {
            is = this.getClass().getResourceAsStream("/hades/.clblist.txt");
            this.parseCLBListFile(is);
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void checkOneZipFile(String fname) {
        Colibri.msg("-#- checkOneZipFile: '" + fname + '\'');
        this.treeManager.registerZipFile(fname);
    }

    public void checkIncludeClasspathJars() {
        Colibri.msg("-#- checkIncludeClasspathJars...");
        if (!SetupManager.getBoolean("Hades.Browser.IncludeClasspathJars", false)) {
            return;
        }
        try {
            String cp = System.getProperty("java.class.path");
            if (cp == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
            Vector<String> tmp = new Vector<String>();
            while (st.hasMoreTokens()) {
                tmp.addElement(st.nextToken());
            }
            int i = 0;
            while (i < tmp.size()) {
                String fname = (String)tmp.elementAt(i);
                this.checkOneZipFile(fname);
                ++i;
            }
        }
        catch (SecurityException e) {
            Colibri.msg("-I- scanning classpath JARs denied by SecurityManager.");
        }
        catch (Exception e) {
            Colibri.msg("-E- internal in checkIncludeClasspathJars:");
            e.printStackTrace();
        }
    }

    public void checkIncludeExtensionJars() {
        Colibri.msg("-#- checkIncludeExtensionJars...");
        if (!SetupManager.getBoolean("Hades.Browser.IncludeExtensionJars", false)) {
            return;
        }
        try {
            String dirs = System.getProperty("java.ext.dirs");
            if (dirs == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(dirs, File.pathSeparator);
            Vector<String> tmp = new Vector<String>();
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                if (!dir.exists() || !dir.isDirectory()) continue;
                String[] fnames = dir.list();
                int i = 0;
                while (i < fnames.length) {
                    tmp.addElement(new File(dir, fnames[i]).getCanonicalPath());
                    ++i;
                }
            }
            int i = 0;
            while (i < tmp.size()) {
                String fname = (String)tmp.elementAt(i);
                Colibri.msg("-#- checking: '" + fname);
                this.checkOneZipFile(fname);
                ++i;
            }
        }
        catch (SecurityException e) {
            Colibri.msg("-I- scanning classpath JARs denied by SecurityManager.");
        }
        catch (Exception e) {
            Colibri.msg("-E- internal in checkIncludeClasspathJars:");
            e.printStackTrace();
        }
    }

    public void checkScanUserDirectories() {
        int n_user_dirs = SetupManager.getInteger("Hades.Browser.NumberOfUserDirectories", 4);
        Colibri.msg("-#- checkScanUserDirectories: " + n_user_dirs);
        int i = 0;
        while (i < n_user_dirs) {
            block5: {
                String key = "Hades.Browser.UserDirectory" + i;
                String val = SetupManager.getProperty(key, null);
                if (val != null) {
                    if (val.startsWith("$HOME")) {
                        try {
                            val = System.getProperty("user.home") + val.substring(5);
                        }
                        catch (SecurityException se) {
                            Colibri.msg("-W- access to directory '" + val + "' denied.");
                            break block5;
                        }
                    }
                    this.treeManager.registerDirectory(val);
                }
            }
            ++i;
        }
    }

    private final void getIcon() {
        Image icon = null;
        try {
            URL url = this.getClass().getResource("/hades/manager/icons/iconManager.gif");
            icon = Toolkit.getDefaultToolkit().getImage(url);
            this.frame.setIconImage(icon);
        }
        catch (Throwable e) {
            Colibri.msg("-E- Colibri.getIcon(): got Exception " + e);
            Colibri.msg("... you won't see the HADES manager icon.");
        }
    }

    public static void msg(String s) {
        if (s == null) {
            return;
        }
        if (!debug && s.startsWith("-#-")) {
            return;
        }
        System.out.println(s);
    }

    public String toString() {
        return versionString;
    }

    public static void main(String[] argv) throws Throwable {
        standalone = true;
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadUserProperties(".hadesrc");
        TreeManager tb = new TreeManager();
        tb.setRootNode(new RootTreeNode());
        Colibri colibri = new Colibri(tb);
        colibri.getTree().setModel(new DefaultTreeModel(tb.getRootNode()));
        singleton = colibri;
        JFrame frame = (JFrame)colibri.getFrame();
        frame.setSize(750, 600);
        frame.setVisible(true);
        ((DefaultTreeModel)colibri.getTree().getModel()).reload();
    }

    private final /* synthetic */ void this() {
        this.treeManager = null;
        this.setupDialog = null;
    }

    public Colibri() {
        this(new TreeManager());
    }

    public Colibri(TreeManager treeManager) {
        this.this();
        try {
            this.treeManager = treeManager;
            this.setLookAndFeel();
            this.createFrame();
            this.getIcon();
            this.createMenus();
            this.createTree();
            this.createTreePopupMenu();
            this.createImagePanel();
            this.createInfoPanel();
            this.createSplitPaneAndLayout();
            this.createSetupDialog();
            this.frame.addWindowListener(new WindowHandler());
            this.tree.addTreeSelectionListener(new TreeSelectionHandler());
            this.buildOrRefreshTree();
            this.frame.pack();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SetupDialog
    extends JDialog
    implements ActionListener {
        JButton applyButton;
        JButton saveButton;
        JButton closeButton;
        JTextField dir0TF;
        JTextField dir1TF;
        JTextField dir2TF;
        JTextField dir3TF;
        JCheckBox includeClasspathCB;
        JCheckBox includeExtensionCB;

        private final JTextField _tf(int i) {
            String key = "Hades.Browser.UserDirectory" + i;
            String value = SetupManager.getProperty(key, "");
            JTextField tf = new JTextField(value, 40);
            return tf;
        }

        private final JButton _button(String label) {
            JButton button = new JButton(label);
            button.addActionListener(this);
            return button;
        }

        private final void createGUI() {
            JPanel labelPanel = new JPanel(new GridLayout(0, 1));
            int right = 4;
            labelPanel.add(new JLabel(""));
            labelPanel.add(new JLabel(" user directory 0: ", right));
            labelPanel.add(new JLabel(" user directory 1: ", right));
            labelPanel.add(new JLabel(" user directory 2: ", right));
            labelPanel.add(new JLabel(" user directory 3: ", right));
            labelPanel.add(new JLabel(""));
            labelPanel.add(new JLabel(""));
            labelPanel.add(new JLabel(""));
            this.includeClasspathCB = new JCheckBox(" include CLASSPATH JARs ", SetupManager.getBoolean("Hades.Browser.IncludeClasspathJars", false));
            this.includeExtensionCB = new JCheckBox(" include extension directory JARs ", SetupManager.getBoolean("Hades.Browser.IncludeExtensionJars", false));
            JPanel tfPanel = new JPanel(new GridLayout(0, 1));
            tfPanel.add(new JLabel("Enter directory names:  /tmp/hades  C:\\temp\\hades  etc."));
            this.dir0TF = this._tf(0);
            tfPanel.add(this.dir0TF);
            this.dir1TF = this._tf(1);
            tfPanel.add(this.dir1TF);
            this.dir2TF = this._tf(2);
            tfPanel.add(this.dir2TF);
            this.dir3TF = this._tf(3);
            tfPanel.add(this.dir3TF);
            tfPanel.add(new JLabel(""));
            tfPanel.add(this.includeClasspathCB);
            tfPanel.add(this.includeExtensionCB);
            JPanel buttonPanel = new JPanel(new FlowLayout(1));
            this.applyButton = this._button("Apply");
            buttonPanel.add(this.applyButton);
            this.saveButton = this._button("Apply and Save");
            buttonPanel.add(this.saveButton);
            buttonPanel.add(new JLabel(" "));
            this.closeButton = this._button("Close");
            buttonPanel.add(this.closeButton);
            this.applyButton.setToolTipText("apply values (current session only)");
            this.saveButton.setToolTipText("apply values (and save permanently)");
            this.closeButton.setToolTipText("close window");
            this.includeClasspathCB.setToolTipText("search all JARs on CLASSPATH for Hades components?");
            this.includeExtensionCB.setToolTipText("search all JARs in extension directory for Hades components?");
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(new EmptyBorder(5, 5, 5, 5));
            panel.add("West", labelPanel);
            panel.add("Center", tfPanel);
            panel.add("South", buttonPanel);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", panel);
            this.pack();
        }

        public void updateDirectories() {
            JTextField[] tfs = new JTextField[]{this.dir0TF, this.dir1TF, this.dir2TF, this.dir3TF};
            int i = 0;
            while (i < tfs.length) {
                String key = "Hades.Browser.UserDirectory" + i;
                String val = SetupManager.getProperty(key);
                tfs[i].setText(val == null ? "" : val);
                ++i;
            }
        }

        public void actionPerformed(ActionEvent evt) {
            Object o = evt.getSource();
            if (o == this.applyButton) {
                this.doApply();
            } else if (o == this.saveButton) {
                this.doApply();
                this.doSave();
            } else if (o == this.closeButton) {
                this.setVisible(false);
            } else {
                Colibri.msg("-W- SetupDialog.actionPerformed: unknown event: " + evt);
            }
        }

        public void doApply() {
            Colibri.msg("-#- SetupDialog.doApply...");
            JTextField[] tfs = new JTextField[]{this.dir0TF, this.dir1TF, this.dir2TF, this.dir3TF};
            int i = 0;
            while (i < tfs.length) {
                String key = "Hades.Browser.UserDirectory" + i;
                String val = tfs[i].getText();
                if (val == null) {
                    val = "";
                }
                SetupManager.setProperty(key, val);
                ++i;
            }
            SetupManager.setProperty("Hades.Browser.IncludeClasspathJars", this.includeClasspathCB.isSelected() ? "true" : "false");
            SetupManager.setProperty("Hades.Browser.IncludeExtensionJars", this.includeExtensionCB.isSelected() ? "true" : "false");
            Colibri.this.doRefresh();
        }

        public void doSave() {
            Colibri.msg("-I- SetupDialog.doSave: saving using properties...");
            JPropertiesViewer hpv = new JPropertiesViewer(SetupManager.getProperties());
            hpv.showProperties();
            hpv.doSaveUserProperties();
            Colibri.msg("-I- save the properties to file '" + hpv.getDefaultPropertiesFileName() + '\'');
        }

        public SetupDialog() {
            super(Colibri.this.getFrame(), "Colibri Setup");
            this.createGUI();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WindowHandler
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            Colibri.this.doClose();
        }

        WindowHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            SortedTreeNode node = null;
            try {
                node = (SortedTreeNode)e.getPath().getLastPathComponent();
                node.handleTreeSelection(Colibri.this);
            }
            catch (Exception ee) {
                Colibri.msg("-E- internal: " + ee);
                ee.printStackTrace();
            }
        }

        TreeSelectionHandler() {
        }
    }
}

