/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class TrafficLight
extends Canvas {
    private int state = 0;
    public static final int STOPPED = 0;
    public static final int PAUSED = 1;
    public static final int RUNNING = 2;
    private int radius = 7;
    private int border = 1;
    private Color backgroundColor = Color.lightGray;
    private Color inactiveColor = Color.gray;

    public Dimension getPreferredSize() {
        return new Dimension(6 * this.radius + 4 * this.border, 2 * this.radius + 2 * this.border);
    }

    public Dimension getMinimumSize() {
        return new Dimension(6 * this.radius + 4 * this.border, 2 * this.radius + 2 * this.border);
    }

    public void setState(int i) {
        this.state = i;
        if (this.state > 2) {
            this.state = 0;
        }
        if (this.state < 0) {
            this.state = 0;
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.state == 0) {
            g.setColor(Color.red);
        } else {
            g.setColor(this.inactiveColor);
        }
        int x = this.border;
        int y = this.border;
        g.fillOval(x, y, 2 * this.radius, 2 * this.radius);
        if (this.state == 1) {
            g.setColor(Color.yellow);
        } else {
            g.setColor(this.inactiveColor);
        }
        x = this.border + 2 * this.radius + this.border;
        g.fillOval(x, y, 2 * this.radius, 2 * this.radius);
        if (this.state == 2) {
            g.setColor(Color.green);
        } else {
            g.setColor(this.inactiveColor);
        }
        x = this.border + 4 * this.radius + 2 * this.border;
        g.fillOval(x, y, 2 * this.radius, 2 * this.radius);
    }

    public String toString() {
        return "hades.gui.TrafficLight[" + this.state + "]";
    }
}

