/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.gui.StringDialog;
import hades.simulator.SimObject;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SetDesignNameCommand
extends Command
implements ActionListener {
    Point newPos;
    SimObject target;
    ObjectCanvas canvas;
    StringDialog stringDialog;
    boolean hasName;
    String newname = null;
    String oldname;

    public SetDesignNameCommand(Editor editor) {
        super(editor);
        this.oldname = editor.getDesign().getName();
        this.ready = false;
        this.newPos = null;
    }

    public void actionPerformed(ActionEvent evt) {
        if (Command.debug) {
            this.message("-W- CNC: actionPerformed: " + evt);
        }
        if (evt.getActionCommand().equals("Cancel")) {
            this.stringDialog.getDialog().setVisible(false);
            this.stringDialog.getDialog().dispose();
            this.ready = true;
            return;
        }
        if (evt.getActionCommand().equals("OK") || evt.getSource() == this.stringDialog.getTextComponent()) {
            if (Command.debug) {
                this.message("-W- CNC: actionPerformed[OK/TF]: " + evt);
            }
            this.newname = this.stringDialog.getText();
            if (this.newname.indexOf(32) > 0 || this.newname.indexOf(9) > 0) {
                this.newname = this.newname.replace(' ', '_');
                this.newname = this.newname.replace('\t', '_');
                this.message("-W- name contains spaces/tabs, changed to: " + this.newname);
            }
            this.stringDialog.getDialog().setVisible(false);
            this.stringDialog.getDialog().dispose();
            this.editor.getFrame().requestFocus();
            this.execute();
            this.ready = true;
        } else {
            this.message("-E- internal: unknown event source in SetDesignNameCommand: " + evt);
        }
    }

    public void execute() {
        this.editor.getDesign().setName(this.newname);
        this.editor.updateWindowTitle();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        this.editor.getDesign().setName(this.oldname);
        this.editor.updateWindowTitle();
        this.canvas.doFullRedraw();
    }

    public void setPosition(Point SP, Point WP) {
        this.stringDialog = StringDialog.createStringDialog(this.editor.getFrame(), "Enter the Design name:", "");
        this.stringDialog.addActionListener(this);
        this.stringDialog.setText(this.oldname);
        this.stringDialog.selectText(true);
        this.stringDialog.getDialog().setVisible(true);
        this.ready = false;
    }

    public String toString() {
        return "SetDesignNameCommand";
    }

    public String getDescription() {
        return "change design name";
    }

    static {
        Command.versionString = "HADES SetDesignNameCommand 0.1 (29.08.97)";
    }
}

