/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.symbols.SolderDot;
import hades.symbols.Symbol;
import hades.symbols.WireSegment;
import hades.utils.Selection;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;

public class SelectRegionCommand
extends Command {
    Point P1;
    Point P2;
    ObjectCanvas canvas;
    Hashtable candidates;
    Selection selection;

    public SelectRegionCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.P1 = null;
        this.P2 = null;
        this.statusMessage("Click on the first corner of the region to select");
        this.ready = false;
    }

    public void execute() {
        FigObject tmp;
        if (this.P1 == null || this.P2 == null) {
            return;
        }
        this.selection = this.editor.getSelection();
        FigBbox region = new FigBbox(this.P1, this.P2);
        this.candidates = new Hashtable();
        Enumeration E = this.editor.getObjectList().elements();
        while (E.hasMoreElements()) {
            tmp = (FigObject)E.nextElement();
            if (!tmp.getBbox().inside(region)) continue;
            this.candidates.put(tmp, "raw");
        }
        E = this.candidates.keys();
        while (E.hasMoreElements()) {
            boolean select;
            tmp = (FigObject)E.nextElement();
            boolean bl = select = !tmp.isSelected();
            if (tmp instanceof Symbol) {
                if (select) {
                    tmp.select();
                    this.selection.add(tmp);
                    continue;
                }
                tmp.deselect();
                this.selection.remove(tmp);
                continue;
            }
            if (tmp instanceof WireSegment) {
                if (this.candidates.get(tmp) != "raw") continue;
                Signal signal = ((WireSegment)tmp).getSignal();
                this.checkHandleSignalSelection(signal, select);
                continue;
            }
            if (tmp instanceof SolderDot) continue;
            if (select) {
                tmp.select();
                this.selection.add(tmp);
                continue;
            }
            tmp.deselect();
            this.selection.remove(tmp);
        }
        this.statusMessage("Select region ready. Please select a command.");
        this.canvas.doFullRedraw();
    }

    private void checkHandleSignalSelection(Signal signal, boolean select) {
        boolean covered = true;
        FigObject[] segments = signal.getSegments();
        int i = 0;
        while (i < segments.length) {
            Object result = this.candidates.get(segments[i]);
            if (result == null) {
                covered = false;
            } else {
                this.candidates.put(segments[i], "cooked");
            }
            ++i;
        }
        if (!covered) {
            return;
        }
        int i2 = 0;
        while (i2 < segments.length) {
            if (select) {
                segments[i2].select();
                this.selection.add(segments[i2]);
            } else {
                segments[i2].deselect();
                this.selection.remove(segments[i2]);
            }
            ++i2;
        }
        FigObject[] solders = signal.getSolderDots();
        int i3 = 0;
        while (i3 < solders.length) {
            if (select) {
                solders[i3].select();
                this.selection.add(solders[i3]);
            } else {
                solders[i3].deselect();
                this.selection.remove(solders[i3]);
            }
            ++i3;
        }
    }

    public void undo() {
        this.message("-E- Warning: Cannot undo a select region command,");
        this.message("    Workaround: Simply select the same region again.");
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        if (this.P1 == null) {
            this.P1 = new Point(WP);
            Point sc0 = new Point(0, 0);
            sc0 = this.canvas.getTrafo().wc_to_screen(WP, sc0);
            this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
            this.canvas.changeRubberbandMode(4);
            this.canvas.doSimpleRedraw();
            this.statusMessage("Click on the opposite corner of the region to select");
        } else {
            this.P2 = new Point(WP);
            this.canvas.changeRubberbandMode(1);
            this.execute();
            this.ready = true;
        }
    }

    public String toString() {
        return "SelectRegionCommand from: " + this.P1 + " to: " + this.P2;
    }

    public String getDescription() {
        return "select region";
    }

    static {
        Command.versionString = "HADES SelectRegionCommand 0.3 (24.03.98)";
    }
}

