/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.utils.Selection;
import java.awt.Point;
import java.util.Enumeration;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;

public class SelectAllCommand
extends Command {
    ObjectCanvas canvas;

    public SelectAllCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
    }

    public void execute() {
        Selection selection = this.editor.getSelection();
        Enumeration E = this.editor.getObjectList().elements();
        while (E.hasMoreElements()) {
            FigObject tmp = (FigObject)E.nextElement();
            tmp.select();
            selection.add(tmp);
        }
        this.canvas.doFullRedraw();
        this.statusMessage("Selected  all objects. Please select a command.");
    }

    public void undo() {
        this.message("-W- Cannot really undo a 'select all' command, because any ");
        this.message("    previous selection has been lost!");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "SelectAllCommand ";
    }

    public String getDescription() {
        return "select all";
    }
}

