/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.manager.DesignManager;
import hades.models.Design;
import hades.simulator.SimKernel;
import hades.utils.StringTokenizer;
import java.awt.Cursor;
import java.awt.Point;

public class OpenDesignCommand
extends Command {
    Point oldPos;
    Point newPos;
    Design newDesign;
    Design oldDesign;
    SimKernel oldSimulator;
    String resourcename;
    ObjectCanvas canvas;

    public OpenDesignCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.resourcename = "/hades/examples/dummy.hds";
        this.oldPos = null;
        this.newPos = null;
        this.ready = false;
    }

    public void execute() {
        this.oldDesign = this.editor.getDesign();
        this.oldSimulator = this.editor.getSimulator();
        this.oldSimulator.stopSimulation();
        this.editor.getFrame().setCursor(new Cursor(3));
        try {
            this.newDesign = DesignManager.getDesignManager().getDesign(this.editor, this.resourcename, true);
            this.newDesign.setVisible(true);
            this.editor.setDesign(this.newDesign);
            this.newDesign.setSimulator(this.editor.getSimulator());
            this.editor.getSimulator().setDesign(this.newDesign);
            this.editor.rebuildObjectList(this.newDesign);
            this.editor.getUndoStack().push(this);
        }
        catch (Exception e) {
            this.message("-E- OpenDesignCommand: exception " + e);
            this.message("-E- Cannot open Design named '" + this.resourcename + "'");
        }
        this.editor.getFrame().setCursor(new Cursor(0));
    }

    public void undo() {
        this.editor.setDesign(this.oldDesign);
        this.editor.rebuildObjectList(this.oldDesign);
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.resourcename = st.nextToken();
            this.execute();
            this.ready = true;
        }
        catch (Exception e) {
            this.message("-E- LoadDesignCommand: caught exception " + e);
            this.message("-E- offending String is: '" + s);
            this.ready = true;
            return true;
        }
        return true;
    }

    public String toString() {
        return "OpenDesignCommand from: " + this.oldPos + " to: " + this.newPos + " newDesign: " + this.newDesign;
    }

    public String getDescription() {
        return "load a new Design";
    }

    static {
        Command.versionString = "HADES OpenDesignCommand 0.01 (01.06.97)";
    }
}

