/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import java.awt.Point;
import java.util.Enumeration;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;

public class MoveToPositiveQuadrantCommand
extends Command {
    Point oldPos;
    Point newPos;
    ObjectCanvas canvas;
    int dx = 0;
    int dy = 0;

    public MoveToPositiveQuadrantCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
        this.oldPos = null;
        this.newPos = null;
    }

    public void execute() {
        FigBbox bbox = this.editor.getDesignBoundingBox();
        int xl = bbox.getXl();
        int yt = bbox.getYt();
        this.dx = xl <= 0 ? (-xl / 2400 + 1) * 2400 : (-xl / 2400 + 1) * 2400;
        this.dy = yt <= 0 ? (-yt / 2400 + 1) * 2400 : (-yt / 2400 + 1) * 2400;
        Enumeration e = this.editor.getObjectList().elements();
        while (e.hasMoreElements()) {
            ((FigObject)e.nextElement()).move(this.dx, this.dy);
        }
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
        this.ready = true;
    }

    public void undo() {
        Enumeration e = this.editor.getObjectList().elements();
        while (e.hasMoreElements()) {
            ((FigObject)e.nextElement()).move(-this.dx, -this.dy);
        }
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "MoveToPositiveQuadrantCommand dx= " + this.dx + " dy= " + this.dy;
    }

    public String getDescription() {
        return "move to positive quadrant";
    }

    static {
        Command.versionString = "HADES MoveToPositiveQuadrantCommand 0.1 (06.11.97)";
    }
}

