/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.SolderDot;
import hades.symbols.Symbol;
import hades.symbols.WireSegment;
import hades.utils.Selection;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.utils.BoundingBoxCalculator;

public class MoveSelectionCommand
extends Command {
    Point anchor;
    Point target;
    ObjectCanvas canvas;
    Hashtable syTable;
    Hashtable wsTable;

    public MoveSelectionCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
        this.anchor = null;
        this.target = null;
        this.statusMessage("Please click on the anchor (reference) point for the move command!");
    }

    public void execute() {
        this.syTable = new Hashtable();
        this.wsTable = new Hashtable();
        Selection selection = this.editor.getSelection();
        Enumeration e = selection.elements();
        while (e.hasMoreElements()) {
            Object tmp = e.nextElement();
            if (tmp instanceof Symbol) {
                this.syTable.put(tmp, tmp);
                continue;
            }
            if (tmp instanceof WireSegment) {
                this.wsTable.put(tmp, "both");
                continue;
            }
            if (tmp instanceof SolderDot) continue;
            if (tmp instanceof FigObject) {
                this.moveFigObject((FigObject)tmp);
                continue;
            }
            this.unknownObject(tmp);
        }
        int dx = this.target.x - this.anchor.x;
        int dy = this.target.y - this.anchor.y;
        Enumeration e2 = this.syTable.keys();
        while (e2.hasMoreElements()) {
            Symbol symbol = (Symbol)e2.nextElement();
            SimObject simobj = symbol.getParent();
            Port[] ports = simobj.getPorts();
            int i = 0;
            while (i < ports.length) {
                Signal signal = ports[i].getSignal();
                if (signal != null) {
                    this.markWireSegments(symbol, ports[i]);
                }
                ++i;
            }
            symbol.move(dx, dy);
        }
        Enumeration e3 = this.wsTable.keys();
        while (e3.hasMoreElements()) {
            WireSegment ws = (WireSegment)e3.nextElement();
            Signal signal = ws.getSignal();
            Point[] points = ws.getPoints();
            String status = (String)this.wsTable.get(ws);
            if ("first".equals(status)) {
                this.markWireSegments(signal, points[0]);
                continue;
            }
            if ("second".equals(status)) {
                this.markWireSegments(signal, points[1]);
                continue;
            }
            if (!"both".equals(status)) continue;
            this.markWireSegments(signal, points[0]);
            this.markWireSegments(signal, points[1]);
        }
        Enumeration e4 = this.wsTable.keys();
        while (e4.hasMoreElements()) {
            WireSegment ws = (WireSegment)e4.nextElement();
            String status = (String)this.wsTable.get(ws);
            if ("both".equals(status)) {
                ws.move(dx, dy);
                continue;
            }
            if ("none".equals(status)) continue;
            if ("first".equals(status)) {
                this.moveFirstPoint(ws, dx, dy);
                continue;
            }
            if ("second".equals(status)) {
                this.moveSecondPoint(ws, dx, dy);
                continue;
            }
            this.unknownObject(status);
        }
        Hashtable<Signal, String> siTable = new Hashtable<Signal, String>();
        Enumeration e5 = this.wsTable.keys();
        while (e5.hasMoreElements()) {
            WireSegment ws = (WireSegment)e5.nextElement();
            siTable.put(ws.getSignal(), "");
        }
        Enumeration e6 = siTable.keys();
        while (e6.hasMoreElements()) {
            Signal signal = (Signal)e6.nextElement();
            signal.rebuildSolderDots();
        }
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void markWireSegments(Symbol symbol, Port port) {
        Point WP = symbol.getPortPosition(port);
        Signal signal = port.getSignal();
        WireSegment[] segments = (WireSegment[])signal.getSegments();
        int i = 0;
        while (i < segments.length) {
            Point[] points = segments[i].getPoints();
            if (WP.equals(points[0])) {
                this.markFirstPoint(segments[i]);
            }
            if (WP.equals(points[1])) {
                this.markSecondPoint(segments[i]);
            }
            ++i;
        }
    }

    public void markWireSegments(Signal signal, Point WP) {
        WireSegment[] segments = (WireSegment[])signal.getSegments();
        int i = 0;
        while (i < segments.length) {
            Point[] points = segments[i].getPoints();
            if (WP.equals(points[0])) {
                this.markFirstPoint(segments[i]);
            }
            if (WP.equals(points[1])) {
                this.markSecondPoint(segments[i]);
            }
            ++i;
        }
    }

    public void markFirstPoint(WireSegment segment) {
        String value = (String)this.wsTable.get(segment);
        if (value == null) {
            this.wsTable.put(segment, "first");
        } else if ("none".equals(value)) {
            this.wsTable.put(segment, "first");
        } else if ("first".equals(value)) {
            this.wsTable.put(segment, "first");
        } else if ("second".equals(value)) {
            this.wsTable.put(segment, "both");
        } else if ("both".equals(value)) {
            this.wsTable.put(segment, "both");
        } else {
            this.unknownObject(value);
        }
    }

    public void markSecondPoint(WireSegment segment) {
        String value = (String)this.wsTable.get(segment);
        if (value == null) {
            this.wsTable.put(segment, "second");
        } else if ("none".equals(value)) {
            this.wsTable.put(segment, "second");
        } else if ("first".equals(value)) {
            this.wsTable.put(segment, "both");
        } else if ("second".equals(value)) {
            this.wsTable.put(segment, "second");
        } else if ("both".equals(value)) {
            this.wsTable.put(segment, "both");
        } else {
            this.unknownObject(value);
        }
    }

    public void moveFirstPoint(WireSegment segment, int dx, int dy) {
        Point[] points = segment.getPoints();
        Point tmp = new Point(points[0].x + dx, points[0].y + dy);
        segment.movePoint(points[0], tmp);
    }

    public void moveSecondPoint(WireSegment segment, int dx, int dy) {
        Point[] points = segment.getPoints();
        Point tmp = new Point(points[1].x + dx, points[1].y + dy);
        segment.movePoint(points[1], tmp);
    }

    public void moveFigObject(FigObject tmp) {
        tmp.move(this.target.x - this.anchor.x, this.target.y - this.anchor.y);
    }

    public void unknownObject(Object tmp) {
        this.msg("-E- internal error in MoveSelectionCommand.execute: ");
        this.msg("I don't know how to handle this object: " + tmp);
        try {
            throw new Exception("unknown object");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void undo() {
        System.out.println("-E- Cannot undo a MoveSelectionCommand (yet)!");
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.msg("-#- MoveSelectionCommand.setPosition: " + SP + " " + WP);
        if (this.anchor == null) {
            this.anchor = new Point(WP);
            this.canvas.setEnablePopup(false);
            FigBbox bbox = BoundingBoxCalculator.getBoundingBox(this.editor.getSelection().elements());
            this.canvas.setRubberbandBasePoint(this.canvas.getTrafo().wc_to_screen_x(bbox.getXl()), this.canvas.getTrafo().wc_to_screen_y(bbox.getYt()));
            this.canvas.changeRubberbandMode(5, this.canvas.getTrafo(), bbox);
            this.canvas.doSimpleRedraw();
            this.statusMessage("Click on the target position for the Selection!");
        } else {
            this.target = new Point(WP);
            this.canvas.changeRubberbandMode(1);
            this.editor.setTmpObject(null);
            this.execute();
            this.canvas.setEnablePopup(true);
            this.statusMessage("Move selection ready... select a command");
            this.ready = true;
        }
    }

    public String toString() {
        return "MoveSelectionCommand from: " + this.anchor + " to: " + this.target;
    }

    public String getDescription() {
        return "move selection";
    }

    public void msg(String s) {
        System.out.println(s);
    }

    static {
        Command.versionString = "HADES MoveSelectionCommand 0.2 (19.08.02)";
    }
}

