/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;

public class MirrorXCommand
extends Command {
    SimObject component;
    Symbol symbol;
    ObjectCanvas canvas;
    Point mirrorPos;

    public MirrorXCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.statusMessage("Click on the object to mirror!");
        this.component = null;
        this.symbol = null;
        this.mirrorPos = null;
        this.ready = false;
    }

    public void execute() {
        if (this.component == null || this.symbol == null) {
            this.message("-E- internal error in " + this.toString());
            this.message("   component or symbol is null.");
            return;
        }
        this.symbol.mirrorX(this.mirrorPos.x, this.mirrorPos.y);
        this.statusMessage("Ready. Please select a command.");
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        if (this.component == null || this.symbol == null) {
            this.message("-E- internal error in " + this.toString());
            this.message("   component or symbol is null.");
            return;
        }
        this.symbol.mirrorX(this.mirrorPos.x, this.mirrorPos.y);
        this.editor.rebuildObjectList(this.editor.getDesign());
        this.canvas.doFullRedraw();
    }

    public boolean isConnected(SimObject target) {
        Port[] ports = target.getPorts();
        int i = 0;
        while (i < ports.length) {
            if (ports[i].getSignal() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.mirrorPos = new Point(WP);
        this.component = this.editor.findSimObject(this.mirrorPos);
        if (this.component == null) {
            this.statusMessage("No object to mirror at that position.");
            this.ready = true;
            return;
        }
        if (this.isConnected(this.component)) {
            this.statusMessage("Cannot mirror connected objects, sorry!");
            this.ready = true;
            return;
        }
        this.symbol = this.component.getSymbol();
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "MirrorXCommand for: " + this.component + " at position: " + this.mirrorPos;
    }

    public String getDescription() {
        return "mirror-x symbol";
    }

    static {
        Command.versionString = "HADES MirrorXCommand 0.1 (24.02.98)";
    }
}

