/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.utils.HexFormat;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.gui.FontCache;
import jfig.gui.ImageHelper;
import jfig.utils.SetupManager;

public class MicroRomEditorCanvas
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    public static boolean debug = false;
    protected int n_words;
    protected int n_bits_per_word;
    protected long[] data;
    protected String[] addrCache;
    protected String[] dataCache;
    protected Hashtable actionListenerTable;
    protected Font textFont;
    protected Color backgroundColor;
    protected Color dataColor;
    protected Color addrColor;
    protected Color readHighlightColor;
    protected Color writeHighlightColor;
    protected Image offscreenBuffer;
    protected Graphics offscreenGraphics;
    protected Scrollbar scroller;
    protected int n_columns;
    protected int n_rows;
    protected int n_words_per_row;
    protected int n_chars_per_word;
    protected int n_chars_per_addr;
    protected int n_words_per_screen;
    protected int char_width;
    protected int char_height;
    protected int baseline;
    protected int x0_addr;
    protected int x0_data;
    protected int y0_addr;
    protected int y0_data;
    protected int dx_data;
    protected int border_width;
    protected int border_height;
    protected int width;
    protected int height;
    protected int start_address;
    protected int end_address;
    protected int cursor_x;
    protected int cursor_y;
    protected int n_cursor;
    protected int n_chars;
    protected int value;
    protected boolean shiftMode;
    protected int readHighlightAddress = -1;
    protected int writeHighlightAddress = -1;
    private static long[] digit_masks = new long[]{0L, 1L, 16L, 256L, 4096L, 65536L, 0x100000L, 0x1000000L, 0x10000000L, 0x100000000L, 0x1000000000L, 0x10000000000L, 0x100000000000L, 0x1000000000000L, 0x10000000000000L, 0x100000000000000L, 0x1000000000000000L};
    private static long[] bit_masks = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};

    public MicroRomEditorCanvas(long[] data, int n_words, int n_bits_per_word, int n_rows, int n_words_per_row) {
        MicroRomEditorCanvas.msg("-I- MicroRomEditorCanvas.<init>... ");
        this.n_words = n_words;
        this.n_bits_per_word = n_bits_per_word;
        this.n_rows = n_rows;
        this.n_words_per_row = n_words_per_row;
        this.data = data;
        this.start_address = 0;
        this.end_address = this.start_address + n_rows;
        this.n_chars_per_addr = this.getAddrFieldWidth(n_words);
        this.n_chars_per_word = this.getDataFieldWidth(n_bits_per_word);
        this.n_columns = this.n_chars_per_addr + 2 + this.n_chars_per_word * n_words_per_row + n_words_per_row - 1;
        this.n_words_per_screen = n_rows * n_words_per_row;
        this.prepareGUI();
        this.actionListenerTable = new Hashtable(7);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void setBackground(Color c) {
        this.backgroundColor = c;
        this.repaint();
    }

    public void setDataColor(Color c) {
        this.dataColor = c;
        this.repaint();
    }

    public void setAddrColor(Color c) {
        this.addrColor = c;
        this.repaint();
    }

    public void setReadHighlightColor(Color c) {
        this.readHighlightColor = c;
        this.repaint();
    }

    public void setWriteHighlightColor(Color c) {
        this.writeHighlightColor = c;
        this.repaint();
    }

    @Override
    public Color getBackground() {
        return this.backgroundColor;
    }

    public Color getDataColor() {
        return this.dataColor;
    }

    public Color getAddrColor() {
        return this.addrColor;
    }

    public Color getReadHightlightColor() {
        return this.readHighlightColor;
    }

    public Color getWriteHightlightColor() {
        return this.writeHighlightColor;
    }

    public void setReadHighlightAddress(int addr) {
        this.readHighlightAddress = addr;
    }

    public void setWriteHighlightAddress(int addr) {
        this.writeHighlightAddress = addr;
    }

    protected int getAddrFieldWidth(int n_words) {
        if (n_words > 0xFFFFFFF) {
            return 8;
        }
        if (n_words > 0xFFFFFF) {
            return 7;
        }
        if (n_words > 1048575) {
            return 6;
        }
        if (n_words > 65535) {
            return 5;
        }
        if (n_words > 4095) {
            return 4;
        }
        if (n_words > 255) {
            return 3;
        }
        if (n_words > 15) {
            return 2;
        }
        return 1;
    }

    protected int getDataFieldWidth(int n_bits_per_word) {
        return (int)Math.ceil((double)n_bits_per_word / 4.0);
    }

    protected long getData(int addr) {
        addr = this.clip(addr, 0, this.n_words - 1);
        return this.data[addr];
    }

    protected void setData(int addr, long value) {
        addr = this.clip(addr, 0, this.n_words - 1);
        this.data[addr] = value;
        this.notifyListeners(addr, value);
    }

    protected void notifyListeners(int addr, long value) {
        if (this.actionListenerTable == null) {
            return;
        }
        if (this.actionListenerTable.size() == 0) {
            return;
        }
        ActionEvent ie = new ActionEvent(this, 1001, "" + addr + " " + value);
        Enumeration E = this.actionListenerTable.keys();
        while (E.hasMoreElements()) {
            ((ActionListener)E.nextElement()).actionPerformed(ie);
        }
    }

    public void addActionListener(ActionListener AL) {
        if (AL == null) {
            return;
        }
        this.actionListenerTable.put(AL, AL);
    }

    public void removeActionListener(ActionListener AL) {
        if (AL == null) {
            return;
        }
        this.actionListenerTable.remove(AL);
    }

    protected void prepareGUI() {
        this.backgroundColor = SetupManager.getColor("Hades.MicroRomEditorCanvas.BackgroundColor", Color.white);
        this.dataColor = SetupManager.getColor("Hades.MicroRomEditorCanvas.DataColor", Color.blue);
        this.addrColor = SetupManager.getColor("Hades.MicroRomEditorCanvas.AddrColor", Color.black);
        this.readHighlightColor = SetupManager.getColor("Hades.MicroRomEditorCanvas.ReadHighlightColor", Color.green);
        this.writeHighlightColor = SetupManager.getColor("Hades.MicroRomEditorCanvas.WriteHighlightColor", Color.red);
        this.setBackground(this.backgroundColor);
        String fontname = SetupManager.getProperty("Hades.MicroRomEditorCanvas.FontName", "Monospaced");
        int fontsize = SetupManager.getInteger("Hades.MicroRomEditorCanvas.FontSize", 14);
        int fontstyle = SetupManager.getInteger("Hades.MicroRomEditorCanvas.FontStyle", 0);
        this.setTextFont(new Font(fontname, fontstyle, fontsize));
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font f) {
        this.textFont = f;
        FontMetrics fm = FontCache.getFontCache().getFontMetrics(this.textFont);
        this.char_width = fm.charWidth('M');
        this.char_height = fm.getMaxDescent() + fm.getMaxAscent();
        this.baseline = fm.getMaxAscent();
        this.border_width = 5;
        this.border_height = 5;
        this.width = this.n_columns * this.char_width + 2 * this.border_width;
        this.height = this.n_rows * this.char_height + 2 * this.border_height;
        this.x0_addr = this.border_width;
        this.x0_data = this.x0_addr + (this.getAddrFieldWidth(this.n_words) + 2) * this.char_width;
        this.y0_data = this.y0_addr = this.border_height + this.baseline;
        this.dx_data = (this.n_chars_per_word + 1) * this.char_width;
        this.repaint();
    }

    protected void createOffscreenBuffer() {
        this.offscreenBuffer = ImageHelper.createImage(this.width, this.height);
        if (this.offscreenBuffer != null) {
            this.offscreenGraphics = this.offscreenBuffer.getGraphics();
        }
    }

    public void blitOffscreenBuffer(Graphics g) {
        ImageObserver theObserver = null;
        g.drawImage(this.offscreenBuffer, 0, 0, theObserver);
    }

    public void paintBackgroundAndBorder(Graphics g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.gray);
        g.draw3DRect(0, 0, this.width - 1, this.height - 1, false);
        g.draw3DRect(1, 1, this.width - 3, this.height - 3, false);
    }

    public void paintAllAddresses(Graphics g) {
        int addr = this.start_address;
        int x = this.x0_addr;
        int y = this.y0_addr;
        g.setColor(this.addrColor);
        g.setFont(this.textFont);
        for (int i = 0; i < this.n_rows; ++i) {
            String s = HexFormat.getHexStringOrX(addr, this.n_chars_per_addr);
            g.drawString(s, x, y);
            addr += this.n_words_per_row;
            y += this.char_height;
        }
    }

    public void paintAllData(Graphics g) {
        int addr = this.start_address;
        int x = this.x0_data;
        int y = this.y0_data;
        g.setColor(this.dataColor);
        g.setFont(this.textFont);
        for (int i = 0; i < this.n_rows; ++i) {
            x = this.x0_data;
            for (int j = 0; j < this.n_words_per_row && addr < this.n_words; ++j) {
                String t = HexFormat.getHexStringOrX(this.getData(addr), this.n_chars_per_word);
                g.drawString(t, x, y);
                ++addr;
                x += this.dx_data;
            }
            y += this.char_height;
        }
    }

    public void paintStringAtAddr(Graphics g, int addr, String s) {
        int c_y = (addr - this.start_address) / this.n_words_per_row;
        int delta_addr = addr - this.start_address - c_y * this.n_words_per_row;
        int c_x = delta_addr * (this.n_chars_per_word + 1);
        g.drawString(s, this.x0_data + c_x * this.char_width, this.y0_data + c_y * this.char_height);
    }

    public void paintHighlighting(Graphics g) {
        String t;
        g.setFont(this.textFont);
        if (this.readHighlightAddress >= this.start_address && this.readHighlightAddress < this.start_address + this.n_words_per_screen) {
            t = HexFormat.getHexStringOrX(this.getData(this.readHighlightAddress), this.n_chars_per_word);
            g.setColor(this.readHighlightColor);
            this.paintStringAtAddr(g, this.readHighlightAddress, t);
        }
        if (this.writeHighlightAddress >= this.start_address && this.writeHighlightAddress < this.start_address + this.n_words_per_screen) {
            t = HexFormat.getHexStringOrX(this.getData(this.writeHighlightAddress), this.n_chars_per_word);
            g.setColor(this.writeHighlightColor);
            this.paintStringAtAddr(g, this.writeHighlightAddress, t);
        }
    }

    public void paintCursor(Graphics g) {
        int x0 = this.border_width;
        int y0 = this.border_height + this.baseline;
        g.setColor(this.dataColor);
        g.setFont(this.textFont);
        g.drawString("_", x0 + this.cursor_x * this.char_width, y0 + this.cursor_y * this.char_height);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics systemGraphics) {
        if (this.textFont == null) {
            this.prepareGUI();
        }
        if (this.offscreenGraphics == null) {
            this.createOffscreenBuffer();
        }
        Graphics g = this.offscreenGraphics != null ? this.offscreenGraphics : systemGraphics;
        this.paintBackgroundAndBorder(g);
        this.paintAllAddresses(g);
        this.paintAllData(g);
        this.paintHighlighting(g);
        this.paintCursor(g);
        if (this.offscreenGraphics != null) {
            this.blitOffscreenBuffer(systemGraphics);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void setCursorFromMousePosition(MouseEvent me) {
        this.cursor_x = (me.getX() - this.border_width) / this.char_width;
        this.cursor_y = (me.getY() - this.border_height) / this.char_height;
        this.cursor_x = this.clip(this.cursor_x, 0, this.n_columns - 1);
        this.cursor_y = this.clip(this.cursor_y, 0, this.n_rows - 1);
        this.shiftMode = false;
    }

    public boolean isCursorInDataArea() {
        return this.cursor_x >= this.n_chars_per_addr + 2;
    }

    public boolean isCursorInAddrArea() {
        return this.cursor_x < this.n_chars_per_addr;
    }

    public boolean isDataVisibleAtAddress(int addr) {
        return addr >= this.start_address && addr < this.start_address + this.n_words_per_screen;
    }

    public void makeDataVisibleAtAddress(int addr) {
        this.start_address = addr / this.n_words_per_screen * this.n_words_per_screen;
        this.start_address = this.clip(this.start_address, 0, this.n_words - 1);
        this.notifyScroller();
        MicroRomEditorCanvas.msg("makeDataVisibleAtAddress: " + addr + " new start: " + this.start_address);
    }

    public int getRelativeDataCursor() {
        if (!this.isCursorInDataArea()) {
            MicroRomEditorCanvas.msg("-E- Internal in getRelativeDataCursor: cursor is in addr!");
            return 0;
        }
        int tmp = (this.cursor_x - this.n_chars_per_addr - 2) % (this.n_chars_per_word + 1);
        return this.clip(tmp, 0, this.n_chars_per_word - 1);
    }

    public int getAddrFromCursorPosition() {
        if (!this.isCursorInDataArea()) {
            MicroRomEditorCanvas.msg("-E- Internal in getRelativeDataCursor: cursor is in addr!");
            return 0;
        }
        int tmp = (this.cursor_x - this.n_chars_per_addr - 2) / (this.n_chars_per_word + 1);
        tmp = this.clip(tmp, 0, this.n_words_per_row - 1);
        return this.start_address + this.cursor_y * this.n_words_per_row + tmp;
    }

    public int getCursorAddrIndex() {
        if (!this.isCursorInAddrArea()) {
            MicroRomEditorCanvas.msg("-E- Internal in getCursorAddrIndex: cursor isn't in addr!");
            return 0;
        }
        return this.start_address + this.cursor_y * this.n_words_per_row;
    }

    public int clip(int currentValue, int minValue, int maxValue) {
        if (currentValue < minValue) {
            return minValue;
        }
        if (currentValue > maxValue) {
            return maxValue;
        }
        return currentValue;
    }

    public void moveCursorTo(int x, int y) {
        this.cursor_x = x;
        this.cursor_y = y;
        this.shiftMode = false;
    }

    public void moveCursorRight() {
        ++this.cursor_x;
        this.cursor_x = this.clip(this.cursor_x, 0, this.n_columns - 1);
        this.shiftMode = false;
    }

    public void moveCursorLeft() {
        --this.cursor_x;
        this.cursor_x = this.clip(this.cursor_x, 0, this.n_columns - 1);
        this.shiftMode = false;
    }

    public void moveCursorUp() {
        --this.cursor_y;
        if (this.cursor_y < 0) {
            this.start_address -= this.n_words_per_row;
            this.start_address = this.clip(this.start_address, 0, this.n_words - this.n_rows * this.n_words_per_row);
            this.notifyScroller();
        }
        this.cursor_y = this.clip(this.cursor_y, 0, this.n_rows - 1);
        this.shiftMode = false;
    }

    public void moveCursorDown() {
        ++this.cursor_y;
        if (this.cursor_y >= this.n_rows) {
            this.start_address += this.n_words_per_row;
            this.start_address = this.clip(this.start_address, 0, this.n_words - this.n_rows * this.n_words_per_row);
            this.notifyScroller();
        }
        this.cursor_y = this.clip(this.cursor_y, 0, this.n_rows - 1);
        this.shiftMode = false;
    }

    public void movePageUp() {
        this.start_address -= this.n_rows * this.n_words_per_row;
        this.start_address = this.clip(this.start_address, 0, this.n_words - this.n_rows * this.n_words_per_row);
        this.notifyScroller();
    }

    public void movePageDown() {
        this.start_address += this.n_rows * this.n_words_per_row;
        this.start_address = this.clip(this.start_address, 0, this.n_words - this.n_rows * this.n_words_per_row);
        this.notifyScroller();
    }

    public void moveLineUp() {
        this.start_address -= this.n_words_per_row;
        this.start_address = this.clip(this.start_address, 0, this.n_words - this.n_rows * this.n_words_per_row);
        this.notifyScroller();
    }

    public void moveLineDown() {
        this.start_address += this.n_words_per_row;
        this.start_address = this.clip(this.start_address, 0, this.n_words - this.n_rows * this.n_words_per_row);
        this.notifyScroller();
    }

    public void moveHome() {
        this.start_address = 0;
        this.start_address = this.clip(this.start_address, 0, this.n_words - this.n_rows * this.n_words_per_row);
        this.notifyScroller();
    }

    public void moveEnd() {
        this.start_address = this.n_words - this.n_rows * this.n_words_per_row;
        this.start_address = this.clip(this.start_address, 0, this.n_words - this.n_rows * this.n_words_per_row);
        this.notifyScroller();
    }

    public void moveToAddress(int addr) {
        this.start_address = addr / this.n_words_per_row * this.n_words_per_row;
        this.start_address = this.clip(this.start_address, 0, this.n_words - this.n_words_per_screen);
        this.notifyScroller();
    }

    public void moveCursorToDataAtAddr(int addr) {
        if (!this.isDataVisibleAtAddress(addr)) {
            this.makeDataVisibleAtAddress(addr);
        }
        this.cursor_y = (addr - this.start_address) / this.n_words_per_row;
        int delta_addr = addr - this.start_address - this.cursor_y * this.n_words_per_row;
        this.cursor_x = this.n_chars_per_addr + 2 + delta_addr * (this.n_chars_per_word + 1);
    }

    public void moveTabNext() {
        int addr = this.getAddrFromCursorPosition();
        addr = this.clip(addr + 1, 0, this.n_words - 1);
        this.moveCursorToDataAtAddr(addr);
        this.shiftMode = false;
    }

    public void moveTabPrev() {
        int addr = this.getAddrFromCursorPosition();
        addr = this.clip(addr - 1, 0, this.n_words - 1);
        this.moveCursorToDataAtAddr(addr);
        this.shiftMode = false;
    }

    public void notifyScroller() {
        if (this.scroller == null) {
            return;
        }
        int pos = (int)(1.0 * (double)this.scroller.getMaximum() * (double)this.start_address / (double)this.n_words);
        this.scroller.setValue(pos);
    }

    public void setScroller(Scrollbar scroller) {
        this.scroller = scroller;
        this.notifyScroller();
    }

    public void incrementValue() {
        if (!this.isCursorInDataArea()) {
            MicroRomEditorCanvas.msg("-E- Internal in decrementValue: not in data area!");
            return;
        }
        int addr = this.getAddrFromCursorPosition();
        int offset = this.getRelativeDataCursor();
        long value = this.getData(addr) + digit_masks[this.n_chars_per_word - offset];
        MicroRomEditorCanvas.msg("-D- incremen: addr= " + addr + " offset= " + offset);
        this.setData(addr, value &= bit_masks[this.n_bits_per_word]);
    }

    public void decrementValue() {
        if (!this.isCursorInDataArea()) {
            MicroRomEditorCanvas.msg("-E- Internal in decrementValue: not in data area!");
            return;
        }
        int addr = this.getAddrFromCursorPosition();
        int offset = this.getRelativeDataCursor();
        long value = this.getData(addr) - digit_masks[this.n_chars_per_word - offset];
        MicroRomEditorCanvas.msg("-D- incremen: addr= " + addr + " offset= " + offset);
        this.setData(addr, value &= bit_masks[this.n_bits_per_word]);
    }

    public void setDigitAtMousePosition(char c) {
        if (!MicroRomEditorCanvas.isHexDigit(c)) {
            return;
        }
        if (!this.isCursorInDataArea()) {
            MicroRomEditorCanvas.msg("-E- Internal in decrementValue: not in data area!");
            return;
        }
        int addr = this.getAddrFromCursorPosition();
        long value = this.getData(addr);
        value &= bit_masks[this.n_bits_per_word];
    }

    public void editStartAddress(char c) {
        int old_address = this.start_address + this.cursor_y * this.n_words_per_row;
        int new_address = 0;
        StringBuffer buffer = new StringBuffer(HexFormat.getHexString(old_address, this.n_chars_per_addr));
        buffer.setCharAt(this.cursor_x, c);
        try {
            new_address = (int)Long.parseLong(buffer.toString(), 16);
            new_address = this.clip(new_address, 0, this.n_words - this.n_words_per_screen);
        }
        catch (Exception e) {
            return;
        }
        this.start_address = new_address;
        int tmp = this.cursor_x >= this.n_chars_per_addr - 1 ? 0 : this.cursor_x + 1;
        this.moveCursorTo(tmp, 0);
        this.notifyScroller();
    }

    public void insertDigitAtMousePosition(char c) {
        if (!MicroRomEditorCanvas.isHexDigit(c)) {
            return;
        }
        if (this.isCursorInAddrArea()) {
            this.editStartAddress(c);
            return;
        }
        if (!this.isCursorInDataArea()) {
            MicroRomEditorCanvas.msg("-E- Internal in insertDigitAtMousePosition: not in data area!");
            return;
        }
        int addr = this.getAddrFromCursorPosition();
        int offset = this.getRelativeDataCursor();
        long value = this.getData(addr);
        String source = HexFormat.getHexStringOrX(value, this.n_chars_per_word);
        StringBuffer buffer = new StringBuffer(source);
        if (!this.shiftMode) {
            buffer.setCharAt(offset, c);
            if (offset == this.n_chars_per_word - 1) {
                this.shiftMode = true;
            } else {
                this.moveCursorRight();
            }
        } else {
            for (int i = 0; i < offset; ++i) {
                buffer.setCharAt(i, source.charAt(i + 1));
            }
            buffer.setCharAt(offset, c);
        }
        try {
            value = Long.parseLong(buffer.toString(), 16);
        }
        catch (Exception e) {
            value = 0L;
        }
        this.setData(addr, value &= bit_masks[this.n_bits_per_word]);
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.requestFocus();
        this.setCursorFromMousePosition(me);
        if (me.isAltDown()) {
            this.incrementValue();
        } else if (me.isMetaDown()) {
            this.decrementValue();
        }
        if (this.isCursorInDataArea()) {
            int index = this.getAddrFromCursorPosition();
            int offset = this.getRelativeDataCursor();
            MicroRomEditorCanvas.msg("-D- in data area, addr= " + index + " offset= " + offset);
        } else {
            int addr = this.getCursorAddrIndex();
            MicroRomEditorCanvas.msg("-A- in addr area, addr= " + addr);
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.requestFocus();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.setCursorFromMousePosition(me);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        char c = ke.getKeyChar();
        int code = ke.getKeyCode();
        if (ke.isActionKey()) {
            if (code == 39) {
                this.moveCursorRight();
            } else if (code == 37) {
                this.moveCursorLeft();
            } else if (code == 38) {
                if (ke.isShiftDown()) {
                    this.incrementValue();
                } else {
                    this.moveCursorUp();
                }
            } else if (code == 40) {
                if (ke.isShiftDown()) {
                    this.decrementValue();
                } else {
                    this.moveCursorDown();
                }
            } else if (code == 33) {
                this.movePageUp();
            } else if (code == 34) {
                this.movePageDown();
            } else if (code == 36) {
                this.moveHome();
            } else if (code == 35) {
                this.moveEnd();
            } else if (code == 9) {
                if (ke.isShiftDown()) {
                    this.moveTabPrev();
                } else {
                    this.moveTabNext();
                }
            }
        } else if (c == '\t') {
            if (ke.isShiftDown()) {
                this.moveTabPrev();
            } else {
                this.moveTabNext();
            }
        } else if (c == ' ') {
            if (ke.isShiftDown()) {
                this.moveTabPrev();
            } else {
                this.moveTabNext();
            }
        } else {
            this.insertDigitAtMousePosition(c);
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    public static void msg(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public static void main(String[] argv) {
        MicroRomEditorCanvas.msg("MicroRomEditorCanvas selftest...");
        SetupManager.loadLocalProperties(".hadesrc");
        long[] data = new long[65536];
        for (int i = 0; i < data.length; ++i) {
            data[i] = i;
        }
        long[] data2 = new long[2048];
        for (int i = 0; i < data2.length; ++i) {
            data2[i] = i & 0xFF;
        }
        Frame f = new Frame("MicroRomEditorCanvas Demo");
        f.setSize(new Dimension(100, 100));
        f.setVisible(true);
        ImageHelper.setVisibleParent(f);
        MicroRomEditorCanvas htf = new MicroRomEditorCanvas(data, data.length, 16, 16, 8);
        MicroRomEditorCanvas mhe = new MicroRomEditorCanvas(data2, data2.length, 8, 16, 8);
        mhe.setBackground(Color.black);
        mhe.setDataColor(Color.yellow);
        mhe.setAddrColor(Color.green);
        mhe.setTextFont(new Font("SansSerif", 2, 17));
        mhe.setReadHighlightAddress(15);
        mhe.setWriteHighlightAddress(14);
        f.setLayout(new FlowLayout());
        f.add(new Label("DCache:"));
        f.add(htf);
        f.add(mhe);
        f.pack();
        htf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MicroRomEditorCanvas.msg("-I- action event: " + evt.getActionCommand());
            }
        });
    }
}

