/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.utils.NameMangler;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.utils.SetupManager;

public class LogManager {
    public static final String logdirname = ".hades";
    private boolean enabled = true;
    private PrintStream logStream = null;
    private Editor editor = null;

    public LogManager(Editor _editor) {
        this.editor = _editor;
        this.enabled = SetupManager.getBoolean("hades.gui.LogManager.enable", false);
    }

    public PrintStream getLogStream() {
        return this.logStream;
    }

    public void checkCreateLogStream() {
        try {
            if (!this.enabled) {
                return;
            }
            String home = System.getProperty("user.home");
            File logdir = new File(home + File.separator + logdirname);
            if (!logdir.exists()) {
                logdir.mkdirs();
                LogManager.msg("-W- LogManager: created directory " + logdir);
            }
            String hash = "" + new Date().hashCode();
            File logfile = new File(logdir, "log-" + hash + ".txt");
            this.logStream = new PrintStream(new FileOutputStream(logfile));
            this.writeLogMessage("# hades.gui.LogManager, starting on " + new Date());
            this.writeLogMessage("# ");
        }
        catch (SecurityException se) {
            this.enabled = false;
            LogManager.msg("-E- LogManager: logging disabled due to security restrictions!");
            LogManager.msg("    You might want to check your '.java.policy' settings.");
        }
        catch (Throwable t) {
            this.enabled = false;
            LogManager.msg("-E- LogManager: internal error in checkCreateLogStream: " + t);
            t.printStackTrace();
        }
    }

    public void closeLogStream() {
        try {
            if (this.logStream == null) {
                return;
            }
            this.logStream.flush();
            this.logStream.close();
        }
        catch (Throwable t) {
            LogManager.msg("-E- LogManager: internal error in checkCreateLogStream: " + t);
        }
    }

    public void writeLogMessage(String s) {
        if (!this.enabled) {
            return;
        }
        if (this.logStream == null) {
            this.checkCreateLogStream();
        }
        if (this.logStream != null) {
            this.logStream.println(s);
        }
    }

    public void writeLogComment(String s) {
        this.writeLogMessage("# " + s);
    }

    public void writeMethodCall(String methodname, Object arg) {
        String t = NameMangler.encodeWithUnicodeEscapes(arg.toString());
        this.writeLogMessage("F: " + methodname + " " + t);
    }

    public void writeSetCommand(Command c) {
        if (!this.enabled) {
            return;
        }
        if (c == null) {
            return;
        }
        this.writeLogMessage("\nC: " + c.getClass().getName() + " " + c.getLogExtraArguments());
    }

    public void writeSetPosition(Point sp, Point wp) {
        if (!this.enabled) {
            return;
        }
        this.writeLogMessage("s: " + sp.x + "," + sp.y + "  " + wp.x + "," + wp.y + "  ");
    }

    public void writeDoCancel() {
        if (!this.enabled) {
            return;
        }
        this.writeLogMessage("*: CANCEL");
    }

    public void writeDoCancelAndEnablePopupOnNextMouseRelease() {
        if (!this.enabled) {
            return;
        }
        this.writeLogMessage("*: CANCEL_AND_ENABLE_POPUP_ON_NEXT_MOUSE_RELEASE");
    }

    public void writeMousePressed(FigCanvasEvent fce) {
        if (!this.enabled) {
            return;
        }
        if (this.editor == null) {
            return;
        }
        FigTrafo2D trafo = this.editor.getObjectCanvas().getTrafo();
        Point sp = fce.getScreenCoordinatePoint();
        Point wp = fce.getWorldCoordinatePoint();
        Point anchor = trafo.getAnchor();
        double zoom = trafo.getZoom();
        String modifiers = (fce.isShiftDown() ? "s" : "-") + (fce.isAltDown() ? "a" : "-") + (fce.isControlDown() ? "c" : "-") + (fce.isMetaDown() ? "m" : "-");
        this.writeLogMessage("m: " + sp.x + "," + sp.y + "  " + wp.x + "," + wp.y + "  " + modifiers + "  " + anchor.x + "," + anchor.y + " " + zoom);
    }

    public void writeMouseMoved() {
        if (!this.enabled) {
            return;
        }
        if (this.editor == null) {
            return;
        }
        FigTrafo2D trafo = this.editor.getObjectCanvas().getTrafo();
        Point sp = this.editor.getObjectCanvas().getMousePosition();
        Point wp = trafo.getWorldCoordsSnapped(sp);
        Point anchor = trafo.getAnchor();
        double zoom = trafo.getZoom();
        String modifiers = "----";
        this.writeLogMessage("v: " + sp.x + "," + sp.y + "  " + wp.x + "," + wp.y + "  " + modifiers + "  " + anchor.x + "," + anchor.y + " " + zoom);
    }

    public void writeMouseReleased(MouseEvent me) {
        if (!this.enabled) {
            return;
        }
        if (this.editor == null) {
            return;
        }
        this.writeLogMessage("r: " + me.getX() + "," + me.getY());
    }

    public void writeShowPopupPosition(Point sp, Point wp) {
        if (!this.enabled) {
            return;
        }
        this.writeLogMessage("p: " + sp.x + "," + sp.y + "  " + sp.x + "," + sp.y + "  " + wp.x + "," + wp.y + "  ");
    }

    public void writeKeyPressed(KeyEvent evt) {
        if (!this.enabled) {
            return;
        }
        String key = NameMangler.encodeWithUnicodeEscapes("" + evt.getKeyChar());
        int code = evt.getKeyCode();
        String text = KeyEvent.getKeyText(code);
        String modifiers = (evt.isShiftDown() ? "s" : "-") + (evt.isAltDown() ? "a" : "-") + (evt.isControlDown() ? "c" : "-") + (evt.isMetaDown() ? "m" : "-");
        this.writeLogMessage("k: " + modifiers + "  " + code + " " + key + " " + text);
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        LogManager.msg("-#- LogManager.selftest...");
        Editor editor = null;
        LogManager manager = new LogManager(editor);
        manager.checkCreateLogStream();
        manager.writeLogMessage("Hello from the selftest on " + new Date());
        manager.closeLogStream();
    }
}

