/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Console;
import hades.gui.CreateCommand;
import hades.gui.CreateSignalCommand;
import hades.gui.Editor;
import hades.gui.SignalSetValueCommand;
import hades.simulator.SimObject;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import jfig.utils.ExceptionTracer;

public class KeyHandler {
    public boolean debug = false;
    Console console;
    Editor editor;

    public KeyHandler(Editor editor) {
        this.editor = editor;
        this.console = Console.getConsole();
    }

    public void keyTyped(KeyEvent evt) {
        char key = evt.getKeyChar();
        int keycode = evt.getKeyCode();
        if (this.debug) {
            System.out.println("\n\n-#- KeyHandler.keyTyped: " + evt);
            System.out.println("  " + key + " " + keycode);
        }
        if (this.debug) {
            this.message("KeyHandler.keyTyped(): " + evt + " " + key + " " + keycode);
        }
        if (keycode == 8 && this.debug) {
            System.out.println("-#- KeyHandler: backspace (control-H) ignored.");
        }
        if (keycode == 127) {
            if (!this.editor.isReady()) {
                return;
            }
            if (this.editor.isViewMode()) {
                return;
            }
            System.err.println("-#- KeyHandler: keycode=127, delete command...");
            this.createAndSetCommand("hades.gui.DeleteCommand");
            this.setMousePosition();
            return;
        }
        if (keycode == 27) {
            this.editor.doCancel();
            return;
        }
        if (this.isViewModeAndSimObjectBindkey(evt)) {
            return;
        }
        switch (key) {
            case '\b': {
                if (!this.debug) break;
                System.out.println("-#- KeyHandler: backspace (control-H) ignored.");
                break;
            }
            case '\u007f': {
                if (!this.editor.isReady()) {
                    return;
                }
                if (this.editor.isViewMode()) break;
                this.createAndSetCommand("hades.gui.DeleteCommand");
                this.setMousePosition();
                break;
            }
            case '\u001b': {
                if (this.editor.isViewMode()) {
                    this.editor.doClose();
                    break;
                }
                this.editor.doCancel();
                break;
            }
            case 'A': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.AutoconnectCommand");
                this.setMousePosition();
                break;
            }
            case 'c': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.CopyCommand");
                this.setMousePosition();
                break;
            }
            case 'D': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.DeselectAllCommand");
                this.setMousePosition();
                break;
            }
            case 'e': {
                if (!this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.EditCommand");
                this.setMousePosition();
                break;
            }
            case 'f': {
                System.err.println("-#- KeyHandler: 'f' doZoomFit... ");
                this.editor.doZoomFit();
                break;
            }
            case 'F': {
                this.editor.doZoom11();
                break;
            }
            case 'g': {
                this.editor.setGlowMode(!this.editor.getGlowMode());
                break;
            }
            case 'h': {
                this.editor.toggleGlowModeForOneSignal();
                break;
            }
            case 'I': {
                if (this.editor.isViewMode()) break;
                CreateCommand cri = new CreateCommand(this.editor, "hades.models.io.Ipin");
                this.editor.setCommand(cri);
                this.setMousePosition();
                break;
            }
            case 'm': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.MoveCommand");
                this.setMousePosition();
                break;
            }
            case 'M': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.SignalMovePointCommand");
                this.setMousePosition();
                break;
            }
            case 'n': {
                if (!this.editor.isReady()) break;
                evt.consume();
                this.createAndSetCommand("hades.gui.ChangeNameCommand");
                this.setMousePosition();
                break;
            }
            case 'N': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                evt.consume();
                this.createAndSetCommand("hades.gui.ChangeSignalNameCommand");
                this.setMousePosition();
                break;
            }
            case 'o': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.SignalMovePointCommand");
                this.setMousePosition();
                break;
            }
            case 'O': {
                if (this.editor.isViewMode()) break;
                CreateCommand cro = new CreateCommand(this.editor, "hades.models.io.Opin");
                this.editor.setCommand(cro);
                this.setMousePosition();
                break;
            }
            case 'p': {
                if (!this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.AddProbeToSignalCommand");
                this.setMousePosition();
                break;
            }
            case 'P': {
                if (!this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.DeleteProbeFromSignalCommand");
                this.setMousePosition();
                break;
            }
            case 'Q': {
                if (this.editor.isViewMode()) break;
                Console.getConsole().show();
                break;
            }
            case 'r': {
                this.editor.doRedraw();
                break;
            }
            case 'R': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.SelectRegionCommand");
                this.setMousePosition();
                break;
            }
            case 's': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.SelectObjectCommand");
                this.setMousePosition();
                break;
            }
            case 'U': {
                if (this.editor.isViewMode()) break;
                this.editor.doUndo();
                break;
            }
            case 'v': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.InsertVertexIntoSignalCommand");
                this.setMousePosition();
                break;
            }
            case 'V': {
                if (this.editor.isViewMode()) break;
                CreateCommand crv = new CreateCommand(this.editor, "hades.models.gates.InvSmall");
                this.editor.setCommand(crv);
                this.setMousePosition();
                break;
            }
            case 'w': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.AddSegmentToSignalCommand");
                this.setMousePosition();
                break;
            }
            case 'W': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                CreateSignalCommand csc = new CreateSignalCommand(this.editor);
                this.editor.setCommand(csc);
                csc.setShiftDown(true);
                this.setMousePosition();
                break;
            }
            case 'x': {
                if (this.editor.isViewMode() || !this.editor.isReady()) break;
                this.createAndSetCommand("hades.gui.DeleteSegmentFromSignalCommand");
                this.setMousePosition();
                break;
            }
            case 'y': {
                this.editor.doZoomOut07();
                break;
            }
            case 'Y': {
                this.editor.doZoomIn14();
                break;
            }
            case 'z': {
                this.editor.doZoomOut09();
                break;
            }
            case 'Z': {
                this.editor.doZoomIn11();
                break;
            }
            case '0': {
                SignalSetValueCommand sc0 = new SignalSetValueCommand(this.editor);
                this.editor.setCommand(sc0);
                sc0.setValue(2);
                this.setMousePosition();
                break;
            }
            case '1': {
                SignalSetValueCommand sc1 = new SignalSetValueCommand(this.editor);
                this.editor.setCommand(sc1);
                sc1.setValue(3);
                this.setMousePosition();
                break;
            }
            case '!': {
                boolean enable = !ExceptionTracer.getEnabled();
                ExceptionTracer.setEnabled(true);
                ExceptionTracer.message("debug messages/traces are now " + (enable ? "enabled" : "disabled"));
                ExceptionTracer.setEnabled(enable);
                break;
            }
            case '(': {
                if (this.editor.isViewMode()) break;
                this.createAndSetCommand("hades.gui.MirrorXCommand");
                this.setMousePosition();
                break;
            }
            case ')': {
                if (this.editor.isViewMode()) break;
                this.createAndSetCommand("hades.gui.MirrorYCommand");
                this.setMousePosition();
                break;
            }
            default: {
                if (!this.debug) break;
                this.message("-W- KeyHandler: no binding defined for key: '" + (char)key + "' code=" + keycode);
            }
        }
    }

    private boolean isViewModeAndSimObjectBindkey(KeyEvent evt) {
        if (!this.editor.isViewMode()) {
            return false;
        }
        if (this.debug) {
            this.msg("-#- KeyHandler.iVMASOB: " + evt);
        }
        if (evt.isControlDown()) {
            this.msg("-#- KeyHandler.IVMASOB: controlDown for event: " + evt);
            this.handleViewModeControlKeyEvent(evt);
        }
        String key = ("" + evt.getKeyChar()).toLowerCase();
        Enumeration simobjs = this.editor.getDesign().getComponents();
        while (simobjs.hasMoreElements()) {
            SimObject tmp = (SimObject)simobjs.nextElement();
            String bindkey = tmp.getBindkey();
            if (!key.equals(bindkey)) continue;
            if (this.debug) {
                this.msg("-#- KeyHandler: match is " + tmp);
            }
            tmp.keyPressed(evt);
            return true;
        }
        return false;
    }

    private void handleViewModeControlKeyEvent(KeyEvent evt) {
        this.msg("-#- KeyHandler.IVMASOB: controlDown for event: " + evt);
        char key = evt.getKeyChar();
        switch (key) {
            case '\u0001': 
            case 'a': {
                this.msg("-#- KeyHandler.hVMCKE.doToggleAntiAliasing...");
                this.editor.doToggleAntiAliasing();
                break;
            }
            case '\u0006': 
            case 'f': {
                this.msg("-#- KeyHandler.hVMCKE.doZoomFit...");
                this.editor.doZoomFit();
                break;
            }
            case '\u0007': 
            case 'g': {
                this.msg("-#- KeyHandler.hVMCKE.doToggleGlowMode...");
                this.editor.doToggleGlowMode();
                break;
            }
            case '\u0014': 
            case 't': {
                this.msg("-#- KeyHandler.hVMCKE.doToggleTooltips...");
                this.editor.doToggleToolTips();
                break;
            }
            case '\u0011': 
            case 'q': {
                this.msg("-#- KeyHandler.hVMCKE.doCloseWindow...");
                break;
            }
            case '\u0017': 
            case 'w': {
                this.msg("-#- KeyHandler.hVMCKE.doCloseWindow...");
            }
        }
    }

    private void createAndSetCommand(String classname) {
        if (this.editor == null) {
            return;
        }
        Command c = this.editor.createCommandByName(classname);
        this.editor.setCommand(c);
    }

    public void setMousePosition() {
        Point sp = this.editor.getObjectCanvas().getMousePosition();
        Point wp = new Point(0, 0);
        wp = this.editor.getObjectCanvas().getTrafo().screen_to_wc_snapped(sp, wp);
        this.editor.getCommand().setPosition(sp, wp);
    }

    public void msg(String s) {
        System.out.println(s);
    }

    public void message(String msg) {
        this.console.message(msg);
    }

    public String toString() {
        return "KeyHandler";
    }
}

