/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Editor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.python.util.PythonInterpreter;

public class JythonConsole
extends JFrame
implements WindowListener,
ActionListener,
KeyListener {
    protected boolean debug = false;
    protected PythonInterpreter interpreter;
    protected PythonRunner runner;
    protected History history;
    protected JMenuBar menuBar;
    protected JTabbedPane tabbedPane;
    protected JTextArea logPad;
    protected JTextArea scratchPad1;
    protected JTextArea scratchPad2;
    protected JTextArea scratchPad3;
    protected JTextField prompt;
    protected JScrollPane scroller0;
    protected JScrollPane scroller1;
    protected JScrollPane scroller2;
    protected JScrollPane scroller3;
    protected ConsoleStream logStream;
    protected Hashtable _callbackTable;
    protected JFileChooser chooser;
    protected Vector filesVector = new Vector();
    protected Editor editor;
    public static final String[][] _menuTable = new String[][]{{"File", null, null, null}, {null, "New", "control N", "doNewFile"}, {null, "Open", "control O", "doOpenFile"}, {null, "Save", "control S", "doSaveFile"}, {null, "Save as", "control shift S", "doSaveFileAs"}, {null, "separator", null, null}, {null, "Close", "control W", "doClose"}, {null, "Exit", "alt F4", "doExit"}, {"Edit", null, null, null}, {null, "Cut", "control X", "doCutSelection"}, {null, "Copy", "control C", "doCopySelection"}, {null, "Paste", "control V", "doPasteSelection"}, {null, "separator", null, null}, {null, "Execute selection", "F5", "doExecuteSelection"}, {null, "Execute buffer", "F6", "doExecuteBuffer"}, {null, "separator", null, null}, {null, "Undo", "control Z", "doUndo"}, {null, "Redo", "control R", "doRedo"}, {"Help", null, null, null}, {null, "About", null, "doShowAbout"}};

    public JythonConsole(Editor editor) {
        this();
        this.editor = editor;
        this.interpreter.set("editor", (Object)editor);
    }

    public JythonConsole() {
        super("Hades JythonConsole");
        this.history = new History();
        this.logStream = new ConsoleStream();
        this.interpreter = new PythonInterpreter();
        this.interpreter.set("printStream", (Object)this.logStream);
        this.interpreter.set("console", (Object)this);
        this.interpreter.setOut((OutputStream)this.logStream);
        this.interpreter.setErr((OutputStream)this.logStream);
        Color background = new Color(240, 240, 240);
        GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Font font = new Font("Courier", 0, 12);
        this.logPad = new JTextArea(40, 80);
        this.logPad.setBackground(background);
        this.logPad.setEditable(true);
        this.scratchPad1 = new JTextArea(40, 80);
        this.scratchPad1.setEditable(true);
        this.scratchPad2 = new JTextArea(40, 80);
        this.scratchPad2.setEditable(true);
        this.scratchPad3 = new JTextArea(40, 80);
        this.scratchPad3.setEditable(true);
        this.setEditorFont(font);
        int H = 32;
        int V = 22;
        this.scroller0 = new JScrollPane(this.logPad, V, H);
        this.scroller1 = new JScrollPane(this.scratchPad1, V, H);
        this.scroller2 = new JScrollPane(this.scratchPad2, V, H);
        this.scroller3 = new JScrollPane(this.scratchPad3, V, H);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addTab("Log", null, this.scroller0, "Jython interpreter output");
        this.tabbedPane.addTab("ScratchPad #1", null, this.scroller1, "text editor");
        this.tabbedPane.addTab("ScratchPad #2", null, this.scroller2, "text editor");
        this.tabbedPane.addTab("ScratchPad #3", null, this.scroller3, "text editor");
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            this.filesVector.add(i, "");
            ++i;
        }
        this.prompt = new JTextField("", 80);
        this.prompt.setFont(font);
        this.prompt.setBackground(Color.white);
        this.prompt.addKeyListener(this);
        this.prompt.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.runner = new PythonRunner();
        this.runner.start();
        this.menuBar = new JMenuBar();
        this.buildMenus();
        this.getContentPane().add("Center", this.tabbedPane);
        this.getContentPane().add("South", this.prompt);
        this.setJMenuBar(this.menuBar);
        this.setBackground(background);
        this.addWindowListener(this);
        this.pack();
    }

    public void setFont(Font font) {
        super.setFont(font);
    }

    public void setEditorFont(Font font) {
        this.logPad.setFont(font);
        this.scratchPad1.setFont(font);
        this.scratchPad2.setFont(font);
        this.scratchPad3.setFont(font);
    }

    public void buildMenus() {
        this._callbackTable = new Hashtable();
        JMenu tmp = null;
        int i = 0;
        while (i < _menuTable.length) {
            if (_menuTable[i][0] != null) {
                tmp = new JMenu(_menuTable[i][0]);
                this.menuBar.add(tmp);
            } else if ("separator".equals(_menuTable[i][1])) {
                tmp.addSeparator();
            } else {
                String name = _menuTable[i][1];
                String sc = _menuTable[i][2];
                String func = _menuTable[i][3];
                JMenuItem item = new JMenuItem(name);
                item.addActionListener(this);
                item.setAccelerator(KeyStroke.getKeyStroke(sc));
                tmp.add(item);
                this._callbackTable.put(item, func);
            }
            ++i;
        }
    }

    public JTextComponent getActiveTextComponent() {
        int index = this.tabbedPane.getSelectedIndex();
        System.out.println("-#- gATC: " + index);
        Component top = this.tabbedPane.getSelectedComponent();
        if (top == null) {
            return this.logPad;
        }
        if (top == this.scroller0) {
            return this.logPad;
        }
        if (top == this.scroller1) {
            return this.scratchPad1;
        }
        if (top == this.scroller2) {
            return this.scratchPad2;
        }
        if (top == this.scroller3) {
            return this.scratchPad3;
        }
        System.err.println("-E- unknown component in gATC: " + top);
        return this.logPad;
    }

    public String getDefaultTabTitle(int index) {
        if (index == 0) {
            return "Log";
        }
        return "ScratchPad#" + index;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        String func = (String)this._callbackTable.get(source);
        Method method = null;
        try {
            method = this.getClass().getMethod(func, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            this.print("-E- call: " + t.toString());
            t.printStackTrace(System.out);
        }
        catch (NoSuchMethodException e) {
            this.print("-E- no such method: '" + func + "'");
            e.printStackTrace(System.out);
        }
        catch (Exception e) {
            this.print("-E- call: " + e.toString());
            e.printStackTrace(System.out);
        }
    }

    public void doNewFile() {
        JTextComponent tmp = this.getActiveTextComponent();
        tmp.setText("");
        int index = this.tabbedPane.getSelectedIndex();
        this.tabbedPane.setTitleAt(index, this.getDefaultTabTitle(index));
    }

    public void doOpenFile() {
        block3: {
            this.checkCreateFileChooser();
            this.chooser.setDialogTitle("Load a Jython script: ");
            int index = this.tabbedPane.getSelectedIndex();
            if (index == 0) {
                System.out.println("-W- Cannot load into console Log window, sorry!");
                return;
            }
            int status = this.chooser.showOpenDialog(this);
            if (status != 0) break block3;
            File selectedFile = this.chooser.getSelectedFile();
            JTextComponent tmp = this.getActiveTextComponent();
            try {
                FileReader reader = new FileReader(selectedFile);
                tmp.read(reader, null);
                reader.close();
                this.tabbedPane.setTitleAt(index, selectedFile.getName());
                this.filesVector.setElementAt(selectedFile, index);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void doSaveFile() {
        int index = this.tabbedPane.getSelectedIndex();
        JTextComponent tmp = this.getActiveTextComponent();
        try {
            File file = (File)this.filesVector.elementAt(index);
            FileWriter writer = new FileWriter(file);
            tmp.write(writer);
            writer.close();
        }
        catch (Exception e) {
            this.doSaveFileAs();
        }
    }

    public void doSaveFileAs() {
        block2: {
            this.checkCreateFileChooser();
            this.chooser.setDialogTitle("Save text as: ");
            int status = this.chooser.showSaveDialog(this);
            if (status != 0) break block2;
            File selectedFile = this.chooser.getSelectedFile();
            JTextComponent tmp = this.getActiveTextComponent();
            try {
                FileWriter writer = new FileWriter(selectedFile);
                tmp.write(writer);
                writer.close();
                int index = this.tabbedPane.getSelectedIndex();
                this.tabbedPane.setTitleAt(index, selectedFile.getName());
                this.filesVector.setElementAt(selectedFile, index);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected void checkCreateFileChooser() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setFileFilter(new PyTxtFileFilter());
            this.chooser.setCurrentDirectory(new File("."));
        }
    }

    public void doCutSelection() {
        JTextComponent tmp = this.getActiveTextComponent();
        tmp.cut();
    }

    public void doCopySelection() {
        JTextComponent tmp = this.getActiveTextComponent();
        tmp.copy();
    }

    public void doPasteSelection() {
        JTextComponent tmp = this.getActiveTextComponent();
        tmp.paste();
    }

    public void doShowAbout() {
        JOptionPane.showMessageDialog(null, "Hades JythonConsole\n\n(C) 1999-2001 by\nMatthias Meyer\n", "About JythonConsole", 1);
    }

    public void doExit() {
        if (this.editor != null) {
            this.doClose();
            this.editor.doExit();
        } else {
            System.exit(0);
        }
    }

    public void doClose() {
        this.setVisible(false);
    }

    public void doExecuteBuffer() {
        JTextComponent tmp = this.getActiveTextComponent();
        String selection = tmp.getText();
        this.runner.addCommand(selection);
    }

    public void doExecuteSelection() {
        JTextComponent tmp = this.getActiveTextComponent();
        String selection = tmp.getSelectedText();
        this.runner.addCommand(selection);
    }

    public void execResource(String resourcefilename) {
        InputStream IS = this.getClass().getResourceAsStream(resourcefilename);
        this.interpreter.execfile(IS);
    }

    public void updatePythonPath() {
        this.interpreter.exec("import sys");
        this.interpreter.exec("sys.path.insert(0, './jpshell/module')");
        this.interpreter.exec("sys.path.insert(1, './jpshell/examples')");
        this.interpreter.exec("sys.path.insert(2, './jpshell/module/objects')");
    }

    public void print(String s) {
        this.interpreter.exec("print \"" + s + "\"");
    }

    protected void enter() {
        String s = this.prompt.getText();
        this.prompt.setText("");
        this.logPad.append(">>> " + s + "\n");
        if (s.length() > 0) {
            this.history.addCommand(s);
        }
        try {
            this.runner.addCommand(s);
        }
        catch (Exception e) {
            PrintStream ps = new PrintStream(this.logStream);
            e.printStackTrace(ps);
            ps.flush();
            this.logPad.append("### Exception: " + e);
        }
        this.logPad.setCaretPosition(this.logPad.getText().length());
    }

    protected void enterOLD() {
        String s = this.prompt.getText();
        this.prompt.setText("");
        this.logPad.append(">>> " + s + "\n");
        try {
            this.interpreter.exec(s);
        }
        catch (Exception e) {
            PrintStream ps = new PrintStream(this.logStream);
            e.printStackTrace(ps);
            ps.flush();
            this.logPad.append("### Exception: " + e);
        }
        this.logPad.setCaretPosition(this.logPad.getText().length());
        if (s.length() > 0) {
            this.history.addCommand(s);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.debug) {
            System.out.println("-#- keyPressed: " + e);
        }
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 38: {
                this.prompt.setText(this.history.prev());
                break;
            }
            case 40: {
                this.prompt.setText(this.history.next());
                break;
            }
            case 10: {
                this.enter();
                break;
            }
            case 68: {
                if (!e.isControlDown()) break;
                this.stop();
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
        this.prompt.requestFocus();
    }

    public void windowClosing(WindowEvent e) {
        if (this.debug) {
            System.out.println("windowClosing: " + e);
        }
        this.stop();
    }

    public void stop() {
        this.dispose();
        System.exit(0);
    }

    public PythonInterpreter getInterpreter() {
        return this.interpreter;
    }

    public static void main(String[] argv) {
        JythonConsole jc = new JythonConsole();
        jc.setVisible(true);
    }

    class History
    extends Vector {
        protected int historyIndex = this.size();

        public void addCommand(Object o) {
            this.addElement(o);
            this.historyIndex = this.size();
        }

        public String prev() {
            String s;
            if (this.historyIndex > 0 && !this.isEmpty()) {
                --this.historyIndex;
                s = (String)this.elementAt(this.historyIndex);
            } else {
                s = this.historyIndex == 0 && !this.isEmpty() ? (String)this.firstElement() : "";
            }
            return s;
        }

        public String next() {
            String s;
            if (this.historyIndex < this.size() - 1 && !this.isEmpty()) {
                ++this.historyIndex;
                s = (String)this.elementAt(this.historyIndex);
            } else {
                this.historyIndex = this.size();
                s = "";
            }
            return s;
        }

        public int getIndex() {
            return this.historyIndex;
        }
    }

    class ConsoleStream
    extends OutputStream {
        StringBuffer line = new StringBuffer();

        public void write(int b) {
            this.line.append((char)b);
            if (b == 10) {
                this.writeLine();
            }
        }

        public void write(byte[] b) {
            int i = 0;
            while (i < b.length) {
                this.line.append((char)b[i]);
                if (b[i] == 10) {
                    this.writeLine();
                }
                ++i;
            }
        }

        public void write(byte[] b, int off, int len) {
            int i = off;
            while (i < off + len) {
                this.line.append((char)b[i]);
                if (b[i] == 10) {
                    this.writeLine();
                }
                ++i;
            }
        }

        public void writeLine() {
            JythonConsole.this.logPad.append(this.line.toString());
            this.line = new StringBuffer();
        }
    }

    class PythonRunner
    extends Thread
    implements Runnable {
        private JTextArea inputBuffer = new JTextArea();
        private boolean idle = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCommand(String s) {
            this.inputBuffer.append(s + "\n");
            JTextArea jTextArea = this.inputBuffer;
            synchronized (jTextArea) {
                if (this.idle) {
                    this.inputBuffer.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            System.out.println("-*- run...");
            while (true) {
                block11: {
                    try {
                        this.idle = false;
                        JythonConsole.this.prompt.setForeground(Color.red);
                        if (this.inputBuffer.getText().length() <= 0) break block11;
                        String s = null;
                        JTextArea jTextArea = this.inputBuffer;
                        synchronized (jTextArea) {
                            s = this.inputBuffer.getText();
                        }
                        this.inputBuffer.setText("");
                        JythonConsole.this.interpreter.exec(s);
                    }
                    catch (Throwable t) {
                        System.out.println("-*- exec returned an error: " + t);
                        t.printStackTrace();
                    }
                }
                this.idle = true;
                JythonConsole.this.prompt.setForeground(Color.green.darker());
                try {
                    JTextArea t = this.inputBuffer;
                    synchronized (t) {
                        this.inputBuffer.wait();
                        continue;
                    }
                }
                catch (InterruptedException ie) {
                    System.out.println("-*- sleep interrupted, awakening...");
                    continue;
                }
                break;
            }
        }
    }

    public class PyTxtFileFilter
    extends FileFilter {
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName().trim().toLowerCase();
            if (name.endsWith(".txt")) {
                return true;
            }
            return name.endsWith(".py");
        }

        public String getDescription() {
            return "Python scripts or text (.txt) files";
        }
    }
}

