/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import jfig.utils.SetupManager;

public class JPropertiesViewer
extends jfig.gui.JPropertiesViewer {
    public JPropertiesViewer(Properties _properties) {
        super(_properties);
    }

    public String getDefaultPropertiesFileName() {
        return ".hadesrc";
    }

    public void doSaveUserProperties() {
        System.out.println("-I- Saving working dir properties...");
        String filename = null;
        try {
            filename = System.getProperty("user.home") + File.separatorChar + this.getDefaultPropertiesFileName();
            FileOutputStream fos = new FileOutputStream(filename);
            PrintStream ps = new PrintStream(fos);
            this.writePropertiesFromVisibleText(ps, "Hades user properties");
            fos.close();
        }
        catch (Exception e) {
            System.out.println("-E- Failed to save user properties: " + e);
        }
    }

    public void doSaveWorkingDirProperties() {
        System.out.println("-I- Saving working dir properties...");
        String filename = null;
        try {
            filename = new File(this.getDefaultPropertiesFileName()).getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(filename);
            PrintStream ps = new PrintStream(fos);
            this.writePropertiesFromVisibleText(ps, "Hades user properties");
            fos.close();
        }
        catch (Exception e) {
            System.out.println("-E- Failed to save local properties: " + e);
        }
    }

    public boolean checkShouldWriteProperty(String name) {
        if (name == null) {
            return false;
        }
        if (name.toLowerCase().startsWith("jfig")) {
            return true;
        }
        return name.toLowerCase().startsWith("hades");
    }

    public static void main(String[] argv) {
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadUserProperties(".hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        JPropertiesViewer PV = new JPropertiesViewer(SetupManager.getProperties());
        PV.setTitle("SetupManager properties");
        PV.showProperties();
        PV.setVisible(true);
    }
}

