/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Editor;
import hades.gui.ExportOptionsDialog;
import hades.utils.FigWriter;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import jfig.canvas.FigCanvas;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.commands.UndoStack;
import jfig.gui.JExportOptionsDialog;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;

public class JExportOptionsAdapter
implements FigBasicEditor,
ExportOptionsDialog {
    Editor editor;
    JExportOptionsDialog eoDialog;

    public JExportOptionsAdapter(Editor editor) {
        this.editor = editor;
        this.eoDialog = new JExportOptionsDialog(editor.getFrame());
        this.eoDialog.setEditor(this);
    }

    public FigCanvas getObjectCanvas() {
        return this.editor.getObjectCanvas();
    }

    public Enumeration getObjects() {
        return this.editor.getDrawableObjects();
    }

    public String getFilename() {
        File tmpfile = new File("hades-tmp.fig");
        return tmpfile.getPath();
    }

    public void doAutoSave() {
        String figFilename = this.getFilename();
        this.message("-I- JExportOptionsAdapter: auto save: " + figFilename);
        try {
            FileOutputStream ff = new FileOutputStream(figFilename);
            PrintWriter pw = new PrintWriter(new BufferedOutputStream(ff));
            FigWriter writer = new FigWriter();
            writer.write_fig31_file(pw, true, this.getObjects());
            pw.flush();
            pw.close();
            ff.close();
            this.message("-I- FIG export ok.");
        }
        catch (FileNotFoundException e) {
            this.message("-E- JExportOptionsAdapter: file not found: " + figFilename);
        }
        catch (Throwable t) {
            this.message("-E- JExportOptionsAdapter: Exception: " + t);
            t.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent evt) {
    }

    public UndoStack getUndoStack() {
        return null;
    }

    public Command getCurrentCommand() {
        return null;
    }

    public FigAttribs getCurrentAttribs() {
        return null;
    }

    public void setCurrentAttribs(FigAttribs attr) {
    }

    public void insertIntoObjectList(FigObject t) {
    }

    public void deleteFromObjectList(FigObject t) {
    }

    public boolean isInObjectList(FigObject t) {
        return false;
    }

    public FigObject findObjectAt(Point p) {
        return null;
    }

    public FigObject findNextObjectAt(Point p, FigObject t) {
        return null;
    }

    public FigObject[] findAllObjectsAt(Point pos) {
        return null;
    }

    public void addTmpObject(FigObject tmp) {
    }

    public void deleteTmpObject(FigObject victim) {
    }

    public FigObject[] getTmpObjects() {
        return null;
    }

    public void hideAllObjectCorners() {
    }

    public void showAllObjectCorners() {
    }

    public void showObjectCorners(FigObject t) {
    }

    public void doRedraw() {
        this.editor.doRedraw();
    }

    public void statusMessage(String msg) {
        this.editor.statusMessage(msg);
    }

    public void message(String msg) {
        this.editor.message(msg);
    }

    public void call(String methodname, Object args) {
    }

    public void updateFigObjectsBoundingBox() {
        this.eoDialog.updateFigObjectsBoundingBox();
    }

    public void updateOutFilenameFromFigFilename() {
        this.eoDialog.updateOutFilenameFromFigFilename();
    }

    public void doExportPS() {
        this.eoDialog.doExportPS();
    }

    public void doExportEPS() {
        this.eoDialog.doExportEPS();
    }

    public void doExportNativePPM() {
        this.eoDialog.doExportNativePPM();
    }

    public void doExportNativeGIF() {
        this.eoDialog.doExportNativeGIF();
    }

    public void show() {
        this.eoDialog.setVisible(true);
    }

    public Component getComponent() {
        return this.eoDialog;
    }
}

