/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import jfig.gui.FontCache;
import jfig.gui.StatusMessage;

public class ImageButton
extends Canvas
implements MouseListener {
    Image passive;
    Image active;
    int width;
    int height;
    String label;
    Font font;
    boolean activated;
    boolean state;
    boolean mouseIsDown;
    boolean mouseInside;
    StatusMessage helper;
    String helpMessage;
    ActionListener actionListener = null;
    public static final boolean debug = false;

    public ImageButton(String label, Image passive, Image active) {
        this.passive = passive;
        this.active = active;
        this.label = label;
        this.font = new Font("SansSerif", 0, 8);
        if (passive != null) {
            this.width = passive.getWidth(this) + 4;
            this.height = passive.getHeight(this) + 4;
        } else {
            FontMetrics fm = FontCache.getFontCache().getFontMetrics(this.font);
            this.width = Math.min(50, fm.stringWidth(label) + 6);
            this.height = 20;
        }
        this.activated = false;
        this.mouseIsDown = false;
        this.mouseInside = false;
        this.setSize(new Dimension(this.width, this.height));
        this.addMouseListener(this);
    }

    public ImageButton(String label, StatusMessage helper, String helpMessage, Image passive, Image active) {
        this(label, passive, active);
        this.helpMessage = helpMessage;
        this.helper = helper;
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = l;
    }

    public boolean isDown() {
        return this.state;
    }

    public String getLabel() {
        return this.label;
    }

    public void setStatusMessage(StatusMessage helper) {
        this.helper = helper;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void mouseEntered(MouseEvent evt) {
        if (this.helper != null) {
            String msg = this.activated ? this.helpMessage : "inactive: " + this.helpMessage;
            this.helper.pushStatusMessage(msg);
        }
        this.mouseInside = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent evt) {
        if (this.helper != null) {
            this.helper.popStatusMessage();
        }
        this.mouseInside = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (!this.activated) {
            return;
        }
        this.mouseIsDown = true;
        this.repaint();
        this.createActionEvent();
    }

    public void mouseReleased(MouseEvent evt) {
        this.mouseIsDown = false;
        this.repaint();
    }

    public void createActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
        }
    }

    public void paint(Graphics g) {
        if (this.activated && this.mouseIsDown) {
            g.setColor(this.getBackground());
            g.draw3DRect(0, 0, this.width - 1, this.height - 1, false);
            g.draw3DRect(1, 1, this.width - 3, this.height - 3, false);
            g.setColor(Color.red);
            if (this.activated && this.active != null) {
                this.drawImage(g, this.active, 2, 2, null);
            } else {
                g.drawString(this.label, 3, this.height - 4);
            }
        } else if (this.activated && this.mouseInside) {
            g.setColor(this.getBackground());
            g.draw3DRect(0, 0, this.width - 1, this.height - 1, true);
            g.draw3DRect(1, 1, this.width - 3, this.height - 3, true);
            g.setColor(Color.red);
            if (this.activated && this.active != null) {
                this.drawImage(g, this.active, 2, 2, null);
            } else {
                g.drawString(this.label, 3, this.height - 4);
            }
        } else if (this.activated) {
            g.setColor(this.getBackground());
            g.drawRect(0, 0, this.width - 1, this.height - 1);
            g.drawRect(1, 1, this.width - 3, this.height - 3);
            g.setColor(Color.red);
            if (this.activated && this.active != null) {
                this.drawImage(g, this.active, 2, 2, null);
            } else {
                g.drawString(this.label, 3, this.height - 4);
            }
        } else {
            g.setColor(this.getBackground());
            g.drawRect(0, 0, this.width - 1, this.height - 1);
            g.drawRect(1, 1, this.width - 3, this.height - 3);
            g.setColor(Color.red);
            if (this.passive != null) {
                this.drawImage(g, this.passive, 2, 2, null);
            } else {
                g.drawString(this.label, 3, this.height - 4);
            }
        }
        g.dispose();
    }

    private void drawImage(Graphics g, Image im, int x, int y, ImageObserver observer) {
        int h;
        int w = im.getWidth(observer);
        boolean status = g.drawImage(im, x, y, x + w, y + (h = im.getHeight(observer)), 0, 0, w, h, observer);
        if (!status) {
            System.out.println("-W- ImageButton internal: drawImage not ready : " + this.label);
        }
    }

    public void setActive(boolean b) {
        this.activated = b;
        this.repaint();
    }

    public String toString() {
        String s = "ImageButton" + this.label;
        return s;
    }
}

