/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Console;
import hades.gui.Editor;
import hades.gui.JCanvasScroller;
import hades.gui.ObjectCanvas;
import hades.gui.SimControlPanel;
import hades.manager.DesignManager;
import hades.utils.JavaVersionCheck;
import java.awt.BorderLayout;
import java.awt.Frame;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import jfig.gui.ImageHelper;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class EditorInApplet
extends JApplet {
    boolean javaVersionOK = true;
    boolean useExternalWindow = false;
    boolean debug = false;
    Editor editor;
    String appletServerName;
    String appletBaseDirName;
    JFrame externalFrame;

    public String getAppletInfo() {
        return "HADES digital systems simulator applet (build 20051018) \n(C) 1997-2005 Norman Hendrich, hendrich@informatik.uni-hamburg.de\n\nHades is a framework for fully interactive event-based simulation,\nwith gate-, register-transfer-, and system-level model libraries.\nSee http://tams-www.informatik.uni-hamburg.de/applets/hades/\n";
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"Hades.Applet.ServerName", "String", "the applet server URL"}, {"Hades.Applet.BaseDir", "String", "the base dir on above server"}, {"Hades.Applet.Design", "String", "the initial design"}, {"Hades.Applet.Hadesrc", "String", "additional editor properties"}, {"debug", "boolean", "verbose startup messages, e.g. false"}};
        return info;
    }

    public void init() {
        this.javaVersionOK = JavaVersionCheck.isOK();
        if (!this.javaVersionOK) {
            JavaVersionCheck.printVersionCheckWarning();
            JavaVersionCheck.displayVersionCheckWarning();
            return;
        }
        SetupManager.setProperty("Hades.Applet.EnablePyObjectLookup", "false");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        String hadesrc = this.getParameter("Hades.Applet.Hadesrc");
        if (hadesrc != null) {
            try {
                String urlname = this.getCodeBase() + "/" + hadesrc;
                SetupManager.loadURLProperties(urlname);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ImageHelper.setDebug(false);
        this.appletServerName = this.getParameter("Hades.Applet.ServerName");
        this.appletBaseDirName = this.getParameter("Hades.Applet.BaseDir");
        String useSwing = this.getParameter("Hades.UseSwingGUI");
        String viewMode = this.getParameter("Hades.Editor.ViewMode");
        this.useExternalWindow = "true".equals(this.getParameter("Hades.Editor.ExternalWindow"));
        if ("true".equals(useSwing)) {
            SetupManager.setProperty("Hades.UseSwingGUI", "true");
        }
        if ("true".equals(viewMode)) {
            SetupManager.setProperty("Hades.Editor.ViewMode", "true");
            SetupManager.setProperty("Hades.Editor.PopupMenuResource", "/hades/gui/AppletModePopupMenu.txt");
        }
        try {
            if (this.appletServerName != null || this.appletBaseDirName != null) {
                System.out.println("-I- server/baseDir= " + this.appletServerName + '/' + this.appletBaseDirName);
                DesignManager.setAppletServerName(this.appletServerName);
                DesignManager.setAppletBaseDir(this.appletBaseDirName);
                ImageHelper.setAppletServerName(this.appletServerName);
                ImageHelper.setAppletBaseDir(this.appletBaseDirName);
            }
        }
        catch (Throwable e) {
            System.err.println("-E- Illegal base URL: " + e);
        }
        ExceptionTracer.setEnabled(true);
    }

    public JCanvasScroller getCanvasScrollerWithBorder() {
        ObjectCanvas canvas = this.editor.getObjectCanvas();
        JCanvasScroller scroller = new JCanvasScroller(canvas);
        scroller.setBorder(new EtchedBorder());
        return scroller;
    }

    public JComponent getSimControlPanelWithBorder() {
        SimControlPanel scpanel = this.editor.getSimControlPanel();
        try {
            JPanel panel = (JPanel)scpanel.getComponent();
            panel.setBorder(new EtchedBorder());
            return panel;
        }
        catch (Throwable t) {
            return new JLabel("Internal error: please enable Swing");
        }
    }

    public void start() {
        if (!this.javaVersionOK) {
            return;
        }
        try {
            this.editor = new Editor(this.useExternalWindow);
            this.editor.setParentApplet(this);
            DesignManager.getDesignManager().setDialogWindowsParentFrame(this.editor.getDialogParentFrame());
            if (this.useExternalWindow) {
                this.editor.getFrame().setVisible(true);
            } else {
                Frame f = this.editor.getFrame();
                f.remove(this.editor.getObjectCanvas().getComponent());
                f.remove(this.editor.getSimControlPanel().getComponent());
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().add("Center", this.getCanvasScrollerWithBorder());
                this.getContentPane().add("South", this.getSimControlPanelWithBorder());
                this.validate();
                if (this.debug) {
                    System.out.println("-#- " + this.getContentPane().getSize());
                }
                if (this.debug) {
                    System.out.println("-#- " + this.editor.getObjectCanvas().getSize());
                }
            }
            String designName = this.getParameter("Hades.Applet.Design");
            System.err.println("-I- loading: " + designName);
            if (designName == null) {
                System.err.println("-E- Parameter 'Hades.Applet.Design' not set!");
                designName = "/hades/examples/simple/clocks.hds";
                System.err.println("-W- using demo instead:" + designName);
            }
            this.editor.doOpenDesign(designName, false);
            if ("true".equals(this.getParameter("Hades.Editor.ZoomFit"))) {
                if (this.debug) {
                    System.out.println("-#- doZoomFit...");
                }
                this.editor.doZoomFit();
            }
        }
        catch (Exception e) {
            System.err.println("-E- " + e);
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.debug) {
            System.out.println("-X- EditorInApplet.stop: ignored...");
        }
    }

    public void destroy() {
        if (this.debug) {
            System.out.println("-X- EditorInApplet.destroy...");
        }
        if (this.editor != null) {
            this.editor.doFlushSymbolCache();
            this.editor.getObjectCanvas().flush();
            if (this.debug) {
                System.out.println("-X- flushed symbol cache and object canvas!");
            }
            if (this.editor.getFrame() != null) {
                this.editor.getFrame().setVisible(false);
                this.editor.getFrame().dispose();
            }
            this.editor.doCloseDesign();
            this.editor.tearDown();
            Editor.removeEditor(this.editor);
            Console.getConsole().destroy();
            this.editor = null;
        }
        if (SetupManager.getBoolean("Hades.Applet.DestroyAllFramesOnClose", false)) {
            Frame[] victims = Frame.getFrames();
            if (this.debug) {
                System.out.println("-#- destroy:" + victims.length + " frames.");
            }
            int i = 0;
            while (i < victims.length) {
                if (this.debug) {
                    System.out.println("-#- " + i + "   " + victims[i]);
                }
                victims[i].dispose();
                ++i;
            }
        }
        super.destroy();
    }

    public void doOpenExternalWindow() {
        System.out.println("-#- EditorInApplet.doOpenExternalWindow...");
        if (this.externalFrame != null) {
            this.externalFrame.show();
            return;
        }
        JLabel label = new JLabel("editor showing in external window now");
        label.setHorizontalAlignment(0);
        this.getContentPane().removeAll();
        this.getContentPane().add("Center", label);
        this.getContentPane().validate();
        this.getContentPane().repaint();
        JFrame frame = new JFrame("Hades editor (applet mode)");
        frame.setDefaultCloseOperation(0);
        frame.getContentPane().add("Center", this.getCanvasScrollerWithBorder());
        frame.getContentPane().add("South", this.getSimControlPanelWithBorder());
        frame.setLocation(10, 10);
        frame.pack();
        frame.show();
        this.externalFrame = frame;
    }

    public void doCloseExternalWindow() {
        System.out.println("-#- EditorInApplet.doCloseExternalWindow...");
        if (this.externalFrame == null) {
            return;
        }
        this.externalFrame.setVisible(false);
        this.externalFrame.getContentPane().removeAll();
        this.externalFrame.dispose();
        this.externalFrame = null;
        this.getContentPane().removeAll();
        this.getContentPane().add("Center", this.getCanvasScrollerWithBorder());
        this.getContentPane().add("South", this.getSimControlPanelWithBorder());
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }
}

