/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.ImageCanvas;
import hades.manager.DesignManager;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class DidYouKnowFrame
extends Frame
implements ActionListener,
ItemListener {
    static final String tipsFileName = "/hades/doc/help/TipOfTheDay.txt";
    protected String resourcename;
    protected Vector tips;
    protected int index;
    protected ImageCanvas iconCanvas;
    protected Button nextButton;
    protected Button prevButton;
    protected Button closeButton;
    protected Checkbox againCheckbox;
    protected TextArea textArea;
    protected Font buttonFont;
    protected Font textAreaFont;

    public DidYouKnowFrame() {
        this(tipsFileName);
    }

    public DidYouKnowFrame(String resourcename) {
        super("Tip of the day");
        this.setBackground(Color.lightGray);
        this.getDefaultFonts();
        if (this.buttonFont != null) {
            this.setFont(this.buttonFont);
        }
        Panel buttonPanel = new Panel(new FlowLayout());
        buttonPanel.setBackground(Color.lightGray);
        this.nextButton = new Button("Next");
        this.prevButton = new Button("Previous");
        this.closeButton = new Button("Close");
        this.againCheckbox = new Checkbox("Show again on next start");
        this.againCheckbox.setState(true);
        buttonPanel.add(this.againCheckbox);
        buttonPanel.add(this.prevButton);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.closeButton);
        this.textArea = new TextArea(60, 20);
        this.textArea.setEditable(false);
        if (this.textAreaFont != null) {
            this.textArea.setFont(this.textAreaFont);
        }
        this.nextButton.addActionListener(this);
        this.prevButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.againCheckbox.addItemListener(this);
        this.addWindowListener(new WindowCloser());
        this.iconCanvas = new ImageCanvas(this.getIconName());
        Panel iconPanel = new Panel(new FlowLayout(0));
        iconPanel.setBackground(Color.lightGray);
        iconPanel.add(this.iconCanvas);
        this.tips = this.parse(resourcename);
        this.index = (int)Math.floor(Math.random() * (double)this.tips.size());
        this.textArea.setText((String)this.tips.elementAt(this.index));
        this.add("North", iconPanel);
        this.add("Center", this.textArea);
        this.add("South", buttonPanel);
        this.setSize(new Dimension(400, 300));
    }

    public void getDefaultFonts() {
        String name = SetupManager.getProperty("Hades.TipOfTheDay.TextAreaFontName", "MonoSpaced");
        int size = SetupManager.getInteger("Hades.TipOfTheDay.TextAreaFontSize", 12);
        int style = 0;
        this.textAreaFont = new Font(name, style, size);
        name = SetupManager.getProperty("Hades.TipOfTheDay.ButtonFontName", "SansSerif");
        size = SetupManager.getInteger("Hades.TipOfTheDay.ButtonFontSize", 12);
        style = 0;
        this.buttonFont = new Font(name, style, size);
    }

    public String getIconName() {
        return "/hades/gui/images/didyouknow.gif";
    }

    public Vector parse(String resourcename) {
        Vector<String> tips = new Vector<String>();
        try {
            InputStream IS = DesignManager.getDesignManager().getInputStream(this, resourcename);
            BufferedReader BR = new BufferedReader(new InputStreamReader(IS));
            String line = null;
            StringBuffer oneTip = null;
            int index = 0;
            while ((line = BR.readLine()) != null) {
                if (line.equals("") && oneTip != null) {
                    tips.addElement(oneTip.toString());
                    oneTip = null;
                    ++index;
                    continue;
                }
                if (oneTip == null) {
                    oneTip = new StringBuffer();
                }
                oneTip.append("\n");
                oneTip.append(line);
            }
            if (oneTip != null) {
                tips.addElement(oneTip.toString());
            }
            IS.close();
            ExceptionTracer.message("-I- got " + tips.size() + " tips from file " + resourcename + "!");
        }
        catch (Exception e) {
            ExceptionTracer.message("-E- DidYouKnowPanel: initialization failed due to Exception: " + e);
            ExceptionTracer.trace(e);
            tips = new Vector();
            tips.addElement("I couldn't load the tips from the specified Java reource\n'" + resourcename + "', sorry. Please specify a valid\n" + "Java 1.1 resourcename that points to a plain text file\n" + "with individual tips separated by blank lines");
        }
        return tips;
    }

    public void selectTip(int index) {
        if (index < 0 || index >= this.tips.size()) {
            index = (int)Math.floor(Math.random() * (double)this.tips.size());
        }
        this.index = index;
        if (this.textArea != null) {
            this.textArea.setText((String)this.tips.elementAt(index));
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Button) {
            if (e.getSource() == this.closeButton) {
                this.doClose();
            } else if (e.getSource() == this.nextButton) {
                this.showNextTip();
            } else if (e.getSource() == this.prevButton) {
                this.showPreviousTip();
            }
        } else {
            this.msg("-E- DidYouKnowFrame: unknown action event source: " + e);
        }
    }

    public void doClose() {
        this.setVisible(false);
    }

    public void showNextTip() {
        if (++this.index >= this.tips.size()) {
            this.index = 0;
        }
        this.textArea.setText((String)this.tips.elementAt(this.index));
    }

    public void showPreviousTip() {
        if (--this.index < 0) {
            this.index = this.tips.size() - 1;
        }
        this.textArea.setText((String)this.tips.elementAt(this.index));
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.againCheckbox) {
            this.msg("-W- DidYouKnowFrame: ignoring request: " + e);
        } else {
            this.msg("-E- DidYouKnowFrame: unknown item event source: " + e);
        }
    }

    public void msg(String s) {
        ExceptionTracer.message(s);
    }

    public static void main(String[] argv) {
        ExceptionTracer.setEnabled(true);
        DidYouKnowFrame f = new DidYouKnowFrame();
        f.setVisible(true);
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent e) {
            DidYouKnowFrame.this.doClose();
        }

        public void windowClosed(WindowEvent e) {
            DidYouKnowFrame.this.msg("-F- WC:windowClosed()... ");
        }
    }
}

