/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.utils.ExceptionTracer;

public class DeleteComponentCommand
extends Command {
    SimObject target;
    Signal[] oldSignals;
    ObjectCanvas canvas;

    public DeleteComponentCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = true;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void execute() {
        Symbol symbol;
        if (this.target == null) {
            return;
        }
        try {
            Port[] ports = this.target.getPorts();
            this.oldSignals = new Signal[ports.length];
            int i = 0;
            while (i < ports.length) {
                if (ports[i] != null) {
                    this.oldSignals[i] = ports[i].getSignal();
                } else {
                    this.message("-E- internal in DeleteComponentCommand.execute(): ");
                    this.message("-E- Component port declaration vs. symbol mismatch... at index: " + i + " for component " + this.target);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.message("-E- internal error in DeleteComponentCommand.execute(), ");
            this.message("Component port declaration vs. symbol mismatch...");
            this.message("Trying to continue, undo won't work now.");
        }
        if (this.target.getPropertySheet() != null) {
            this.target.getPropertySheet().setVisible(false);
        }
        this.editor.getDesign().deleteComponent(this.target);
        if (this.editor.getSimulator() != null) {
            this.editor.getSimulator().deleteAllEventsFromSource(this.target);
        }
        if ((symbol = this.target.getSymbol()) != null) {
            this.editor.getObjectList().delete(symbol);
        }
        this.canvas.doFullRedraw();
        this.canvas.setEnablePopup(true);
        this.editor.getUndoStack().push(this);
        this.statusMessage("Please select a command.");
    }

    public void undo() {
        if (this.target == null) {
            return;
        }
        this.message("-W- reconnecting Signals is not reliable yet!");
        this.editor.getDesign().addComponent(this.target);
        Port[] ports = this.target.getPorts();
        int i = 0;
        while (i < this.oldSignals.length) {
            try {
                if (this.oldSignals[i] != null) {
                    this.oldSignals[i].connect(ports[i]);
                }
            }
            catch (Exception e) {
                ExceptionTracer.message("-E- in DeleteComponentCommand.undo: " + e);
                ExceptionTracer.trace(e);
            }
            ++i;
        }
        this.editor.rebuildObjectList(this.editor.getDesign());
        this.canvas.doFullRedraw();
        this.canvas.setEnablePopup(true);
        this.statusMessage("Undo ok. Please select a command.");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        Symbol tmp = this.editor.findSymbol(WP);
        if (tmp == null) {
            this.message("-E- Internal error: No SimObject found to delete by " + this.toString());
            return;
        }
        if (tmp instanceof Symbol) {
            this.target = tmp.getParent();
        }
        this.execute();
    }

    public String toString() {
        return "DeleteComponentCommand object=" + this.target;
    }

    public String getDescription() {
        return "delete object";
    }

    static {
        Command.versionString = "HADES DeleteComponentCommand 0.2 (06.11.97)";
    }
}

