/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.DeleteComponentCommand;
import hades.gui.DeleteSignalCommand;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.symbols.Symbol;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;

public class DeleteCommand
extends Command {
    public DeleteCommand(Editor editor) {
        super(editor);
        this.ready = false;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void execute() {
        System.err.println("-E- DeleteCommand.execute() should not be called!");
    }

    private void cancelWithMessage(String msg) {
        this.editor.setTmpObject(null);
        ObjectCanvas canvas = this.editor.getObjectCanvas();
        canvas.changeRubberbandMode(1);
        canvas.setEnablePopup(true);
        this.editor.doFullRedraw();
        this.statusMessage(msg);
        this.ready = true;
    }

    public void cancel() {
        this.cancelWithMessage("DeleteCommand canceled... Please select a command");
    }

    public void undo() {
        System.err.println("-E- DeleteCommand.undo() should not be called!");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        if (MouseMapper.isMiddleClick(ME)) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else if (MouseMapper.isRightClick(ME)) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else {
            this.setPosition(SP, WP);
        }
    }

    public void setPosition(Point SP, Point WP) {
        this.editor.getObjectCanvas().setEnablePopup(false);
        FigObject tmp = this.editor.findSymbolOrSignal(WP);
        if (tmp == null) {
            tmp = this.editor.findSymbol(WP);
        }
        if (tmp == null) {
            tmp = this.editor.findNearestWireSegment(WP, 600);
        }
        if (tmp == null) {
            this.cancelWithMessage("No object near mouse position. Please select a command.");
            return;
        }
        if (tmp instanceof Symbol) {
            DeleteComponentCommand cmd = new DeleteComponentCommand(this.editor);
            ((Command)cmd).setPosition(SP, WP);
            this.editor.setCommand(cmd);
        } else if (tmp instanceof Signal) {
            DeleteSignalCommand cmd = new DeleteSignalCommand(this.editor);
            ((Command)cmd).setPosition(SP, WP);
            this.editor.setCommand(cmd);
        } else if (tmp instanceof WireSegment) {
            DeleteSignalCommand cmd = new DeleteSignalCommand(this.editor);
            ((Command)cmd).setPosition(SP, WP);
            this.editor.setCommand(cmd);
        }
    }

    public String toString() {
        return "DeleteCommand object";
    }

    public String getDescription() {
        return "delete object";
    }

    static {
        Command.versionString = "HADES DeleteCommand 0.05 (11.01.02)";
    }
}

