/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.AddSegmentToSignalCommand;
import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.utils.ExceptionTracer;
import jfig.utils.MouseMapper;

public class CreateSignalCommand
extends Command {
    Signal signal;
    Signal victim;
    ObjectCanvas canvas;
    int n_points;
    WireSegment ws;
    Point startPoint;
    Port port0;
    Port port1;
    FigCompound tmpCompound;
    boolean rightClick = false;
    boolean shiftDown = false;

    public CreateSignalCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.n_points = 0;
        this.signal = null;
        this.victim = null;
        this.port0 = null;
        this.port1 = null;
        this.tmpCompound = new FigCompound();
        this.tmpCompound.setTrafo(this.canvas.getTrafo());
        this.ready = false;
    }

    public void execute() {
        if (this.port0 != null && !this.signal.isConnected(this.port0)) {
            this.signal.connect(this.port0);
        }
        if (this.port1 != null && !this.signal.isConnected(this.port1)) {
            this.signal.connect(this.port1);
        }
        if (this.ws != null) {
            this.signal.addSegment(this.ws);
        }
        this.editor.getDesign().addSignal(this.signal);
        this.signal.setTrafo(this.canvas.getTrafo());
        this.editor.deleteFromObjectList(this.signal);
        if (this.victim != null && this.victim != this.signal) {
            this.signal.merge(this.victim);
            this.editor.getDesign().deleteSignal(this.victim);
            this.editor.deleteFromObjectList(this.victim);
        }
        this.signal.createVertexTable();
        this.signal.rebuildSolderDots();
        this.editor.insertIntoObjectList(this.signal);
        this.canvas.changeRubberbandMode(1);
        this.canvas.setEnablePopup(true);
        this.editor.setTmpObject(null);
        this.tmpCompound = null;
        this.statusMessage("Create signal ready... select a command");
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        if (this.signal != null) {
            this.editor.getDesign().deleteSignal(this.signal);
            this.signal.disconnectAll();
            this.editor.deleteFromObjectList(this.signal);
        }
        this.editor.rebuildObjectList(this.editor.getDesign());
        this.canvas.doFullRedraw();
    }

    public void cancel() {
        if (this.port0 != null && this.port0.getSignal() != null) {
            this.signal.disconnect(this.port0);
        }
        if (this.port1 != null && this.port1.getSignal() != null) {
            this.signal.disconnect(this.port1);
        }
        this.port0 = null;
        this.port1 = null;
        this.signal = null;
        this.editor.setTmpObject(null);
        this.editor.rebuildObjectList(this.editor.getDesign());
        this.canvas.changeRubberbandMode(1);
        this.canvas.setEnablePopup(true);
        this.canvas.doFullRedraw();
        this.statusMessage("Create signal canceled...");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.rightClick = MouseMapper.isRightClick(ME);
        this.shiftDown = ME.isShiftDown();
        this.setPosition(SP, WP);
    }

    public void setShiftDown(boolean b) {
        this.shiftDown = b;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPosition(Point SP, Point WP) {
        Point[] wcp = null;
        FigObject obj = null;
        Point sc0 = new Point(0, 0);
        sc0 = this.canvas.getTrafo().wc_to_screen(WP, sc0);
        if (this.rightClick) {
            this.cancel();
            this.ready = true;
            return;
        }
        if (this.n_points == 0) {
            if (this.editor.isOnPort(WP)) {
                this.port0 = this.editor.findPort(WP);
                if (this.port0 == null) {
                    this.message("-E- Internal error: no Port found at that position.");
                    this.ready = true;
                    return;
                }
                if (this.port0.getSignal() != null) {
                    this.statusMessage("Adding segment to existing signal...");
                    this.port0 = null;
                    this.editor.doCancel();
                    this.editor.setCommand(new AddSegmentToSignalCommand(this.editor));
                    this.editor.getCommand().setPosition(SP, WP);
                    this.ready = true;
                    return;
                }
                try {
                    this.signal = (Signal)this.port0.getSignalClass().newInstance();
                    this.signal.connect(this.port0);
                    this.signal.setVisible(true);
                }
                catch (Exception e) {
                    this.message("-E- Internal: failed to create a Signal for: " + this.port0);
                    ExceptionTracer.trace(e);
                    this.port0 = null;
                }
                this.startPoint = new Point(WP);
                wcp = new Point[]{WP};
                this.ws = new WireSegment(this.signal);
                this.ws.setPoints(wcp);
                this.ws.setTrafo(this.canvas.getTrafo());
                this.tmpCompound.addMember(this.ws);
                this.editor.setTmpObject(this.tmpCompound);
                this.canvas.setEnablePopup(false);
                this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
                this.canvas.changeRubberbandMode(2);
                this.canvas.doSimpleRedraw();
                this.statusMessage("L: next point, <shift>+L: merge signal (drop signal), R: or <ESC>: cancel");
                this.n_points = 1;
                return;
            }
            if (this.shiftDown) {
                this.port0 = null;
                this.startPoint = new Point(WP);
                wcp = new Point[]{WP};
                this.signal = new SignalStdLogic1164();
                this.signal.setVisible(true);
                this.ws = new WireSegment(this.signal);
                this.ws.setPoints(wcp);
                this.ws.setTrafo(this.canvas.getTrafo());
                this.tmpCompound.addMember(this.ws);
                this.editor.setTmpObject(this.tmpCompound);
                this.canvas.setEnablePopup(false);
                this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
                this.canvas.changeRubberbandMode(2);
                this.canvas.doSimpleRedraw();
                this.statusMessage("L: next point, <shift>+L: merge signal (drop signal), <ESC>: cancel");
                this.n_points = 1;
                return;
            }
            this.ready = true;
            return;
        }
        if (this.startPoint.equals(WP)) {
            this.statusMessage("Wire segment with length 0 ignored.");
            return;
        }
        if (this.editor.isOnPort(WP)) {
            this.port1 = this.editor.findPort(WP);
            if (this.port1 == null) {
                this.message("-E- Internal error: no Port found at that position.");
                return;
            }
            if (this.port1 == this.port0) {
                this.statusMessage("No use to connect twice to the same port!");
                this.port1 = null;
                return;
            }
            if (this.port1.getSignal() != null) {
                if (!this.shiftDown) {
                    this.statusMessage("Use <shift>+click to merge to this Port!");
                    this.port1 = null;
                    return;
                }
                if (!this.signal.canMerge(this.port1.getSignal())) {
                    this.statusMessage("Wrong signal type for merge!");
                    this.port1 = null;
                    this.victim = null;
                    return;
                }
                this.victim = this.port1.getSignal();
                this.ws.appendPoint(WP);
            } else if (!this.signal.canConnect(this.port1)) {
                this.statusMessage("Wrong signal type for that port!");
                this.port1 = null;
                return;
            }
            this.ws.appendPoint(WP);
            this.canvas.changeRubberbandMode(1);
            this.editor.setTmpObject(null);
            this.statusMessage("Create signal ready... select a command");
            this.execute();
            this.ready = true;
            return;
        }
        if (this.shiftDown) {
            Command.dbg("CSC.setPosition: shiftDown:" + WP);
            this.port1 = null;
            obj = this.editor.findSymbolOrSignal(WP);
            if (obj != null) {
                if (!(obj instanceof WireSegment)) {
                    this.statusMessage("Must click on a signal to merge signals!");
                    return;
                }
                this.victim = ((WireSegment)obj).getSignal();
                if (!this.signal.canMerge(this.victim)) {
                    this.statusMessage("Wrong signal type - cannot merge!");
                    this.victim = null;
                    return;
                }
            } else {
                obj = this.editor.findNearestWireSegment(WP, 200);
                if (obj != null) {
                    Command.dbg("CSC.found wire " + obj + " at " + WP);
                    this.victim = ((WireSegment)obj).getSignal();
                    if (!this.signal.canMerge(this.victim)) {
                        this.statusMessage("Wrong signal type - cannot merge!");
                        this.victim = null;
                        return;
                    }
                    this.victim.createVertexTable();
                    if (!this.victim.isVertex(WP)) {
                        this.insertVertexAt(this.victim, (WireSegment)obj, WP);
                    }
                }
            }
            this.ws.appendPoint(WP);
            this.canvas.changeRubberbandMode(1);
            this.editor.setTmpObject(null);
            this.statusMessage("Create signal ready... select a command");
            this.execute();
            this.ready = true;
            return;
        }
        if (WP.equals(this.startPoint)) {
            this.statusMessage("Wire segment with length 0 ignored.");
            return;
        }
        this.ws.appendPoint(WP);
        this.signal.addSegment(this.ws);
        this.startPoint = new Point(WP);
        wcp = new Point[]{WP};
        this.ws = new WireSegment(this.signal);
        this.ws.setPoints(wcp);
        this.ws.setTrafo(this.canvas.getTrafo());
        this.tmpCompound.addMember(this.ws);
        this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
        this.canvas.doSimpleRedraw();
        this.statusMessage("L: next point, <shift>+L: merge signal (drop signal), <ESC>: cancel");
        ++this.n_points;
    }

    void insertVertexAt(Signal signal, WireSegment originalSegment, Point newVertex) {
        Point[] op = originalSegment.getPoints();
        Point[] wp1 = new Point[]{op[0], newVertex};
        WireSegment newSegment1 = new WireSegment(signal);
        newSegment1.setPoints(wp1);
        newSegment1.setTrafo(this.canvas.getTrafo());
        Point[] wp2 = new Point[]{op[1], newVertex};
        WireSegment newSegment2 = new WireSegment(signal);
        newSegment2.setPoints(wp2);
        newSegment2.setTrafo(this.canvas.getTrafo());
        this.editor.deleteFromObjectList(signal);
        signal.deleteSegment(originalSegment);
        signal.addSegment(newSegment1);
        signal.addSegment(newSegment2);
        signal.createVertexTable();
        signal.rebuildSolderDots();
        this.editor.insertIntoObjectList(signal);
    }

    public String toString() {
        return "CreateSignalCommand: " + this.signal;
    }

    public String getDescription() {
        return "create signal";
    }

    static {
        Command.versionString = "HADES CreateSignalCommand 0.06";
    }
}

