/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.ColibriCreateCommand;
import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.manager.DesignManager;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import hades.symbols.SymbolManager;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.utils.ExceptionTracer;

public class CreateCommand
extends Command {
    Point newPos;
    SimObject target;
    ObjectCanvas canvas;

    public CreateCommand(Editor editor, String className) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.canvas.setEnablePopup(false);
        try {
            this.target = DesignManager.getDesignManager().getSimObject(className);
            this.target.setEditor(editor);
            this.target.setVisible(true);
            Symbol tmp = SymbolManager.getSymbolManager().getSymbol(this.target);
            this.target.setSymbol(tmp);
        }
        catch (Exception e) {
            this.message("-E- Couldn't instantiate class " + className);
            ExceptionTracer.trace(e);
            this.ready = true;
            return;
        }
        this.ready = false;
        this.newPos = null;
        this.statusMessage("Left button: position object, middle/right: cancel");
    }

    public void execute() {
        this.editor.getDesign().addComponent(this.target);
        this.target.getSymbol().setTrafo(this.canvas.getTrafo());
        this.target.getSymbol().move(this.newPos.x, this.newPos.y);
        this.editor.insertIntoObjectList(this.target.getSymbol());
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
        this.editor.setCommand(new ColibriCreateCommand(this.editor, this.target.copy()));
    }

    public void undo() {
        this.editor.getDesign().deleteComponent(this.target);
        this.target.getSymbol().move(-this.newPos.x, -this.newPos.y);
        this.editor.rebuildObjectList(this.editor.getDesign());
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.newPos = new Point(WP);
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "CreateCommand at pos: " + this.newPos + " target: " + this.target;
    }

    public String getDescription() {
        return "create instance";
    }

    static {
        Command.versionString = "HADES CreateCommand 0.1 (13.03.01)";
    }
}

