/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.manager.DesignManager;
import hades.simulator.SimObject;
import hades.symbols.SymbolManager;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.utils.MouseMapper;

public class CopyCommand
extends Command {
    Point oldPos;
    Point newPos;
    SimObject source;
    SimObject target;
    ObjectCanvas canvas;

    public CopyCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
        this.oldPos = null;
        this.newPos = null;
    }

    public void execute() {
        this.editor.getDesign().addComponent(this.target);
        this.target.getSymbol().setTrafo(this.canvas.getTrafo());
        this.target.getSymbol().move(this.newPos.x - this.oldPos.x, this.newPos.y - this.oldPos.y);
        this.editor.insertIntoObjectList(this.target.getSymbol());
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void cancel() {
        this.editor.setTmpObject(null);
        this.canvas.changeRubberbandMode(1);
        this.canvas.setEnablePopup(true);
        this.editor.doFullRedraw();
        this.statusMessage("CopyCommand canceled... Please select a command");
        this.ready = true;
    }

    public void undo() {
        this.target.getSymbol().move(this.oldPos.x - this.newPos.x, this.oldPos.y - this.newPos.y);
        this.editor.getDesign().deleteComponent(this.target);
        this.editor.rebuildObjectList(this.editor.getDesign());
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        if (MouseMapper.isMiddleClick(ME)) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else if (MouseMapper.isRightClick(ME)) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else {
            Point WP = ME.getWorldCoordinatePoint();
            Point SP = ME.getScreenCoordinatePoint();
            this.setPosition(SP, WP);
        }
    }

    public void setPosition(Point SP, Point WP) {
        if (this.oldPos == null) {
            this.oldPos = new Point(WP);
            this.canvas.setEnablePopup(false);
            this.source = this.editor.findSimObject(this.oldPos);
            if (this.source == null) {
                this.statusMessage("No object at that position. Please click on the object to copy. L: Select object R: cancel");
                this.oldPos = null;
                return;
            }
            this.target = DesignManager.getDesignManager().getCopy(this.source, this.editor);
            this.target.setSymbol(SymbolManager.getSymbolManager().getSymbol(this.target));
            Point tmp = this.source.getSymbol().getPos();
            this.target.getSymbol().move(tmp.x, tmp.y);
            Point sc0 = new Point(0, 0);
            sc0 = this.canvas.getTrafo().wc_to_screen(WP, sc0);
            this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
            this.canvas.changeRubberbandMode(5, this.canvas.getTrafo(), this.target.getSymbol().getBbox());
            this.canvas.doSimpleRedraw();
            this.statusMessage("Click on the new position for the object! L: place object R: cancel");
        } else {
            this.newPos = new Point(WP);
            this.canvas.changeRubberbandMode(1);
            this.editor.setTmpObject(null);
            this.statusMessage("Copy ready... Please select a command");
            this.execute();
            this.canvas.setEnablePopup(true);
            this.ready = true;
        }
    }

    public String toString() {
        return "CopyCommand from: " + this.oldPos + " to: " + this.newPos + " target: " + this.target;
    }

    public String getDescription() {
        return "copy object";
    }

    static {
        Command.versionString = "HADES CopyCommand 0.02 (03.06.97)";
    }
}

