/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.ChangeSignalNameCommand;
import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.gui.StringDialog;
import hades.simulator.SimObject;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ChangeNameCommand
extends Command
implements ActionListener {
    Point newPos;
    SimObject target;
    ObjectCanvas canvas;
    StringDialog stringDialog;
    boolean hasName;
    String newname;
    String oldname;

    public ChangeNameCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.hasName = false;
        this.newname = null;
        this.oldname = null;
        this.ready = false;
        this.newPos = null;
    }

    public void actionPerformed(ActionEvent evt) {
        if (Command.debug) {
            this.message("-W- CNC: actionPerformed: " + evt);
        }
        if (evt.getActionCommand().equals("Cancel")) {
            this.stringDialog.getDialog().setVisible(false);
            this.stringDialog.getDialog().dispose();
            this.ready = true;
            return;
        }
        if (evt.getActionCommand().equals("OK") || evt.getSource() == this.stringDialog.getTextComponent()) {
            if (Command.debug) {
                this.message("-W- CNC: actionPerformed[OK/TF]: " + evt);
            }
            this.newname = this.stringDialog.getText();
            if (this.newname.indexOf(32) > 0 || this.newname.indexOf(9) > 0) {
                this.newname = this.newname.replace(' ', '_');
                this.newname = this.newname.replace('\t', '_');
                this.message("-W- name contains spaces/tabs, changed to: " + this.newname);
            }
            this.stringDialog.getDialog().setVisible(false);
            this.stringDialog.getDialog().dispose();
            this.editor.getFrame().requestFocus();
            this.ready = true;
            this.execute();
        } else {
            this.message("-E- internal: unknown event source in ChangeNameCommand: " + evt);
        }
    }

    public void execute() {
        if (this.target instanceof SimObject) {
            if (Command.debug) {
                this.message("-I- ChangeNameCommand for " + this.target + " new='" + this.newname + "', old='" + this.oldname + "'");
            }
            this.target.setName(this.newname);
        }
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        this.target.setName(this.oldname);
        this.canvas.doFullRedraw();
    }

    public void setPosition(Point SP, Point WP) {
        this.newPos = new Point(WP);
        this.target = this.editor.findSimObject(WP);
        if (this.target != null) {
            this.stringDialog = StringDialog.createStringDialog(this.editor.getFrame(), "Enter the instance name:", "");
            this.stringDialog.addActionListener(this);
            this.oldname = this.target.getName();
            this.stringDialog.setText(this.oldname);
            Point Q = this.canvas.getComponent().getLocationOnScreen();
            Point P = new Point(Q.x + SP.x + 20, Q.y + SP.y - 40);
            this.stringDialog.selectText(true);
            this.stringDialog.getDialog().pack();
            this.stringDialog.getDialog().setLocation(P);
            this.stringDialog.getDialog().setVisible(true);
        } else if (this.editor.findNearestWireSegment(WP) != null) {
            ChangeSignalNameCommand cmd = new ChangeSignalNameCommand(this.editor);
            this.editor.setCommand(cmd);
            ((Command)cmd).setPosition(SP, WP);
            this.ready = true;
        } else {
            this.message("-E- no Object at that position!");
            this.ready = true;
            return;
        }
    }

    public String toString() {
        return "ChangeNameCommand at pos: " + this.newPos + " target: " + this.target;
    }

    public String getDescription() {
        return "change instance name";
    }

    static {
        Command.versionString = "HADES ChangeNameCommand 0.1 (22.07.97)";
    }
}

