/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.CreateSignalCommand;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.symbols.SolderDot;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.utils.ExceptionTracer;
import jfig.utils.MouseMapper;

public class AddSegmentToSignalCommand
extends Command {
    Signal signal;
    Signal victim;
    ObjectCanvas canvas;
    int n_points;
    WireSegment ws;
    SolderDot sd;
    Port port;
    Point startPoint;
    FigCompound tmpCompound;
    boolean rightClick = false;
    boolean shiftDown = false;

    public AddSegmentToSignalCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
        this.tmpCompound = new FigCompound();
        this.tmpCompound.setTrafo(this.canvas.getTrafo());
        this.n_points = 0;
        this.signal = null;
        this.victim = null;
        this.ws = null;
        this.sd = null;
        this.port = null;
    }

    public void execute() {
        if (Command.debug) {
            this.message("AddSegmentToSignalCommand:execute...");
        }
        this.signal.addSegment(this.ws);
        this.ws.setTrafo(this.canvas.getTrafo());
        this.signal.addSolderDot(this.sd);
        this.sd.setTrafo(this.canvas.getTrafo());
        if (this.port != null) {
            this.signal.connect(this.port);
        }
        this.editor.deleteFromObjectList(this.signal);
        if (this.victim != null && this.victim != this.signal) {
            this.signal.merge(this.victim);
            this.editor.getDesign().deleteSignal(this.victim);
            this.editor.deleteFromObjectList(this.victim);
        }
        this.signal.createVertexTable();
        this.signal.rebuildSolderDots();
        this.editor.insertIntoObjectList(this.signal);
        this.canvas.changeRubberbandMode(1);
        this.canvas.setEnablePopup(true);
        this.editor.setTmpObject(null);
        this.tmpCompound = null;
        this.statusMessage("Add Wire to Signal ready... select a command");
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        this.message("-E- Cannot undo a 'add segment to wire' command yet, sorry!");
        this.canvas.doFullRedraw();
    }

    public void cancel() {
        Command.dbg("-W- ASTSC: canceled!");
        this.canvas.changeRubberbandMode(1);
        this.canvas.setEnablePopup(true);
        this.editor.setTmpObject(null);
        this.canvas.doFullRedraw();
        this.tmpCompound = null;
        this.statusMessage("Add Wire to Signal canceled...");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = new Point(ME.getWorldCoordinatePoint());
        Point SP = new Point(ME.getScreenCoordinatePoint());
        this.rightClick = MouseMapper.isRightClick(ME);
        this.shiftDown = ME.isShiftDown();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        FigObject obj = null;
        Point[] wcp = null;
        Point sc0 = new Point(0, 0);
        sc0 = this.canvas.getTrafo().wc_to_screen(WP, sc0);
        if (this.rightClick) {
            this.cancel();
            this.ready = true;
            return;
        }
        if (this.n_points == 0) {
            if (this.editor.isOnPort(WP)) {
                Port tmpport = this.editor.findPort(WP);
                this.signal = tmpport.getSignal();
                if (this.signal == null) {
                    this.statusMessage("L: next point, <shift>+L: merge signal (drop signal), R: <ESC>: cancel");
                    this.editor.doCancel();
                    this.editor.setCommand(new CreateSignalCommand(this.editor));
                    this.editor.getCommand().setPosition(SP, WP);
                    this.ready = true;
                    return;
                }
                this.sd = new SolderDot(this.signal, WP);
                this.sd.setTrafo(this.canvas.getTrafo());
                this.tmpCompound.addMember(this.sd);
                this.startPoint = new Point(WP);
                wcp = new Point[]{WP};
                this.ws = new WireSegment(this.signal);
                this.ws.setPoints(wcp);
                this.ws.setTrafo(this.canvas.getTrafo());
                this.tmpCompound.addMember(this.ws);
                this.editor.setTmpObject(this.tmpCompound);
                this.canvas.setEnablePopup(false);
                this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
                this.canvas.changeRubberbandMode(2);
                this.canvas.doSimpleRedraw();
                this.statusMessage("L: next point, <shift>+L: merge signal (drop signal), <ESC>: cancel");
                this.n_points = 1;
                return;
            }
            obj = this.editor.findSymbolOrSignal(WP);
            if (obj != null) {
                if (!(obj instanceof WireSegment)) {
                    this.statusMessage("Must click near a Signal wire, not a component!");
                    this.ready = true;
                    return;
                }
                this.signal = ((WireSegment)obj).getSignal();
                this.sd = new SolderDot(this.signal, WP);
                this.sd.setTrafo(this.canvas.getTrafo());
                this.startPoint = new Point(WP);
                wcp = new Point[]{WP};
                this.ws = new WireSegment(this.signal);
                this.ws.setPoints(wcp);
                this.ws.setTrafo(this.canvas.getTrafo());
                this.tmpCompound.addMember(this.ws);
                this.tmpCompound.addMember(this.sd);
                this.editor.setTmpObject(this.tmpCompound);
                this.canvas.setEnablePopup(false);
                this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
                this.canvas.changeRubberbandMode(2);
                this.canvas.doSimpleRedraw();
                this.statusMessage("L: next point, <shift>+L: merge signal (drop signal), <ESC>: cancel");
                this.n_points = 1;
                return;
            }
            obj = this.editor.findNearestWireSegment(WP, 200);
            if (obj != null) {
                ExceptionTracer.message("ASTS: findNearestSignal: found: " + obj);
                WireSegment segment = (WireSegment)obj;
                this.signal = segment.getSignal();
                this.sd = new SolderDot(this.signal, WP);
                wcp = new Point[]{segment.getPoints()[0], WP};
                WireSegment segment1 = new WireSegment(this.signal);
                segment1.setPoints(wcp);
                segment1.setTrafo(this.canvas.getTrafo());
                this.signal.addSegment(segment1);
                wcp[0] = WP;
                wcp[1] = segment.getPoints()[1];
                segment.setPoints(wcp);
                segment.setTrafo(this.canvas.getTrafo());
                this.signal = ((WireSegment)obj).getSignal();
                this.sd = new SolderDot(this.signal, WP);
                this.sd.setTrafo(this.canvas.getTrafo());
                this.startPoint = new Point(WP);
                this.editor.insertIntoObjectList(segment1);
                wcp = new Point[]{WP};
                this.ws = new WireSegment(this.signal);
                this.ws.setPoints(wcp);
                this.ws.setTrafo(this.canvas.getTrafo());
                this.tmpCompound.addMember(segment1);
                this.tmpCompound.addMember(segment);
                this.tmpCompound.addMember(this.ws);
                this.tmpCompound.addMember(this.sd);
                this.editor.setTmpObject(this.tmpCompound);
                this.canvas.setEnablePopup(false);
                this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
                this.canvas.changeRubberbandMode(2);
                this.canvas.doSimpleRedraw();
                this.statusMessage("L: next point, <shift>+L: merge signal (drop signal), <ESC>: cancel");
                this.n_points = 1;
                return;
            }
            this.statusMessage("Must click on or near an existing Signal wire!");
            this.ready = true;
            return;
        }
        if (this.editor.isOnPort(WP)) {
            if (this.editor.findPort(WP).getSignal() != null) {
                this.statusMessage("Already a Signal connected to that Point!");
                return;
            }
            if (!this.signal.canConnect(this.editor.findPort(WP))) {
                this.statusMessage("Signal type mismatch on that port!");
                return;
            }
            this.ws.appendPoint(WP);
            this.port = this.editor.findPort(WP);
            this.execute();
            this.ready = true;
            return;
        }
        if (this.shiftDown) {
            ExceptionTracer.message("ASTSC: final point, but not on Port!");
            if (this.startPoint.equals(WP)) {
                this.statusMessage("Wire segment with length 0 ignored.");
                return;
            }
            if (this.editor.isOnPort(WP)) {
                Port port1 = this.editor.findPort(WP);
                if (port1 == this.port) {
                    this.statusMessage("Already connected to that port!");
                    this.message("-E-  No use to connect twice to the same port!");
                    return;
                }
                if (port1.getSignal() == this.signal) {
                    this.statusMessage("Already connected there!");
                    this.message("-E- No use to connect twice to the same signal!");
                    return;
                }
                if (!this.signal.canMerge(port1.getSignal())) {
                    this.statusMessage("Signal type mismatch!");
                    return;
                }
                this.victim = port1.getSignal();
            } else {
                obj = this.editor.findSymbolOrSignal(WP);
                if (obj != null) {
                    if (!(obj instanceof WireSegment)) {
                        this.statusMessage("Must click on a signal to merge signals!");
                        return;
                    }
                    this.victim = ((WireSegment)obj).getSignal();
                    if (this.victim == null) {
                        this.message("-E- Internal error: victim signal is null!");
                        return;
                    }
                    if (!this.signal.canMerge(this.victim)) {
                        this.statusMessage("Signal type mismatch, cannot merge!");
                        return;
                    }
                } else {
                    obj = this.editor.findNearestWireSegment(WP, 200);
                    if (obj != null) {
                        Command.dbg("ASTSC: " + WP + " nearest segment: " + WP);
                        this.victim = ((WireSegment)obj).getSignal();
                        if (!this.signal.canMerge(this.victim)) {
                            this.statusMessage("Wrong signal type - cannot merge!");
                            this.victim = null;
                            return;
                        }
                        this.victim.createVertexTable();
                        if (!this.victim.isVertex(WP)) {
                            this.insertVertexAt(this.victim, (WireSegment)obj, WP);
                        }
                    }
                }
            }
            this.ws.appendPoint(WP);
            this.execute();
            this.ready = true;
            return;
        }
        if (this.startPoint.equals(WP)) {
            this.statusMessage("Wire segment with length 0 ignored.");
            return;
        }
        this.ws.appendPoint(WP);
        this.signal.addSegment(this.ws);
        this.editor.insertIntoObjectList(this.ws);
        this.startPoint = new Point(WP);
        wcp = new Point[]{WP};
        this.ws = new WireSegment(this.signal);
        this.ws.setPoints(wcp);
        this.ws.setTrafo(this.canvas.getTrafo());
        this.tmpCompound.addMember(this.ws);
        this.editor.setTmpObject(this.tmpCompound);
        this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
        this.canvas.doSimpleRedraw();
        this.statusMessage("L: next point, <shift>+L: merge signal (drop signal), <ESC>: cancel");
        ++this.n_points;
    }

    void insertVertexAt(Signal signal, WireSegment originalSegment, Point newVertex) {
        Point[] op = originalSegment.getPoints();
        Point[] wp1 = new Point[]{op[0], newVertex};
        WireSegment newSegment1 = new WireSegment(signal);
        newSegment1.setPoints(wp1);
        newSegment1.setTrafo(this.canvas.getTrafo());
        Point[] wp2 = new Point[]{op[1], newVertex};
        WireSegment newSegment2 = new WireSegment(signal);
        newSegment2.setPoints(wp2);
        newSegment2.setTrafo(this.canvas.getTrafo());
        this.editor.deleteFromObjectList(signal);
        signal.deleteSegment(originalSegment);
        signal.addSegment(newSegment1);
        signal.addSegment(newSegment2);
        signal.createVertexTable();
        signal.rebuildSolderDots();
        this.editor.insertIntoObjectList(signal);
    }

    public String toString() {
        return "AddSegmentToSignalCommand: " + this.signal;
    }

    public String getDescription() {
        return "add segment";
    }

    static {
        Command.versionString = "HADES AddSegmentToSignalCommand 0.03 (08.04.99)";
    }
}

