/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.styx.Waveform;
import hades.styx.WaveformViewer;
import hades.symbols.ProbeSymbol;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;

public class AddProbeToSignalCommand
extends Command {
    Point pos1;
    Signal signal;
    ObjectCanvas canvas;
    ProbeSymbol probeSymbol;

    public AddProbeToSignalCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
    }

    public void execute() {
        WaveformViewer sw;
        if (Command.debug) {
            this.message("AddProbeToSignalCommand:execute...");
        }
        if ((sw = this.editor.getWaveformViewer()) == null) {
            this.message("-I- ...creating Waveform Viewer, please wait...");
            this.editor.createWaveformViewer();
            sw = this.editor.getWaveformViewer();
        }
        Waveform wf = sw.addSignal(this.signal);
        this.signal.setProbe(wf);
        this.probeSymbol = new ProbeSymbol();
        this.probeSymbol.setSignal(this.signal);
        this.probeSymbol.move(this.pos1.x, this.pos1.y);
        this.signal.setProbeSymbol(this.probeSymbol);
        this.editor.insertIntoObjectList(this.probeSymbol);
        this.editor.doFullRedraw();
        this.editor.getUndoStack().push(this);
        this.ready = true;
    }

    public void undo() {
        this.message("-E- Cannot undo addProbe() yet...");
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        FigObject obj = this.editor.findNearestWireSegment(WP);
        if (obj != null) {
            if (!(obj instanceof WireSegment)) {
                this.statusMessage("Must click on an existing Signal wire!");
                this.ready = true;
                return;
            }
            this.signal = ((WireSegment)obj).getSignal();
            if (this.signal.hasProbe()) {
                this.statusMessage("That Signal already has a probe!");
                this.ready = true;
                return;
            }
        } else {
            this.statusMessage("Must click on an existing Signal!");
            this.ready = true;
            return;
        }
        this.pos1 = WP;
        this.execute();
    }

    public String toString() {
        return "AddProbeToSignalCommand: " + this.signal;
    }

    public String getDescription() {
        return "add probe";
    }

    static {
        Command.versionString = "HADES AddProbeToSignalCommand 0.02 (19.08.97)";
    }
}

