/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.ImageButton;
import hades.gui.SimControlPanel;
import hades.gui.TrafficLight;
import hades.simulator.BatchModeSimKernel;
import hades.simulator.InteractiveSimKernel;
import hades.simulator.RealTimeSimKernel;
import hades.simulator.SimKernel;
import hades.simulator.VhdlBatchSimKernel;
import hades.simulator.VhdlSimKernel;
import hades.styx.TimeFormatter;
import hades.utils.ToolTipManager;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jfig.gui.ImageHelper;
import jfig.gui.InsetsPanel;
import jfig.gui.StatusCanvas;
import jfig.gui.StatusMessage;
import jfig.utils.SetupManager;

public class AWTSimControlPanel
extends Panel
implements SimControlPanel,
ActionListener,
ItemListener {
    private SimKernel simulator;
    private boolean raised;
    private ImageButton pauseButton;
    private ImageButton resetButton;
    private ImageButton singleStepButton;
    private ImageButton runForButton;
    private ImageButton runForeverButton;
    private ImageButton statusButton;
    private TextField deltatTextField;
    private Choice unitsChoice;
    private Choice batchOrInteractiveChoice;
    private TrafficLight trafficLight;
    private SimTimePanel simTimePanel;
    private StatusMessage helper;
    private Frame parent;
    private static boolean debug = false;

    public AWTSimControlPanel(SimKernel sim, Frame parent) {
        this.simulator = sim;
        this.parent = parent;
        this.helper = null;
        this.buildGUI();
        this.simulator.setControlPanel(this);
    }

    public Component getComponent() {
        return this;
    }

    public void setStatusMessage(StatusMessage helper) {
        this.helper = helper;
        this.resetButton.setStatusMessage(helper);
        this.pauseButton.setStatusMessage(helper);
        this.singleStepButton.setStatusMessage(helper);
        this.runForeverButton.setStatusMessage(helper);
        this.runForButton.setStatusMessage(helper);
        this.statusButton.setStatusMessage(helper);
    }

    public void setSimulator(SimKernel simulator) {
        this.simulator = simulator;
        simulator.setControlPanel(this);
        this.updateVisual();
    }

    private void buildGUI() {
        Image icons = null;
        Image[] crop_black = new Image[10];
        Image[] crop_gray = new Image[10];
        try {
            icons = ImageHelper.loadResourceImage("/hades/gui/images/simcontrol.gif");
        }
        catch (Throwable e) {
            System.err.println(e.toString());
        }
        try {
            if (icons != null) {
                int i = 0;
                while (i < 8) {
                    if (this.parent != null) {
                        crop_black[i] = ImageHelper.createImage(20, 20);
                        Graphics cg = crop_black[i].getGraphics();
                        cg.translate(-20 * i, 0);
                        cg.drawImage(icons, 0, 0, this);
                        crop_gray[i] = ImageHelper.createImage(20, 20);
                        cg = crop_gray[i].getGraphics();
                        cg.translate(-20 * i, -20);
                        cg.drawImage(icons, 0, 0, this);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Netscape is broken: " + e);
            e.printStackTrace();
        }
        this.batchOrInteractiveChoice = new Choice();
        this.batchOrInteractiveChoice.add("Batch mode");
        this.batchOrInteractiveChoice.add("Real time");
        this.batchOrInteractiveChoice.add("Interactive");
        this.batchOrInteractiveChoice.add("VHDL");
        this.batchOrInteractiveChoice.add("VHDL (batch)");
        String defaultName = SetupManager.getProperty("Hades.Editor.DefaultSimKernel", "VHDL");
        this.batchOrInteractiveChoice.select(defaultName);
        this.statusButton = new ImageButton("Status", this.helper, "print simulator status", crop_gray[7], crop_black[7]);
        this.statusButton.setActive(true);
        this.resetButton = new ImageButton("Reset", this.helper, "reset to time t=0", crop_gray[1], crop_black[1]);
        this.pauseButton = new ImageButton("Stop", this.helper, "pause the simulator immediately", crop_gray[3], crop_black[3]);
        this.singleStepButton = new ImageButton("Step", this.helper, "single step (next event)", crop_gray[4], crop_black[4]);
        this.runForButton = new ImageButton("Run For:", this.helper, "run for specified time interval", crop_gray[5], crop_black[5]);
        this.runForButton.setEnabled(SetupManager.getBoolean("Hades.Simulator.EnableRunFor", false));
        this.runForeverButton = new ImageButton("Run", this.helper, "run forever (interactive simulation) ", crop_gray[6], crop_black[6]);
        this.deltatTextField = new TextField("100", 5);
        this.unitsChoice = new Choice();
        this.unitsChoice.add("days");
        this.unitsChoice.add("hours");
        this.unitsChoice.add("min");
        this.unitsChoice.add("s");
        this.unitsChoice.add("ms");
        this.unitsChoice.add("us");
        this.unitsChoice.add("ns");
        this.unitsChoice.add("ps");
        this.unitsChoice.add("fs");
        this.unitsChoice.select("ns");
        this.setLayout(new FlowLayout(0, 5, 0));
        this.setBackground(Color.lightGray);
        this.add(this.batchOrInteractiveChoice);
        InsetsPanel buttonPanel = new InsetsPanel(1, 0);
        buttonPanel.add((Component)this.statusButton);
        buttonPanel.add((Component)this.resetButton);
        buttonPanel.add((Component)this.pauseButton);
        buttonPanel.add((Component)this.runForeverButton);
        this.add((Component)buttonPanel);
        InsetsPanel runForPanel = new InsetsPanel(1, 0);
        runForPanel.add((Component)this.runForButton);
        runForPanel.add((Component)this.deltatTextField);
        runForPanel.add((Component)this.unitsChoice);
        this.add((Component)runForPanel);
        InsetsPanel trafficLightPanel = new InsetsPanel(2, 0);
        this.trafficLight = new TrafficLight();
        trafficLightPanel.add((Component)this.trafficLight);
        this.add((Component)trafficLightPanel);
        this.simTimePanel = new SimTimePanel();
        this.add(this.simTimePanel);
        this.statusButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.pauseButton.addActionListener(this);
        this.singleStepButton.addActionListener(this);
        this.runForButton.addActionListener(this);
        this.runForeverButton.addActionListener(this);
        this.runForeverButton.setActive(true);
    }

    public void initToolTip() {
        new ToolTipManager((Component)this.statusButton, this.simulator, 2000L);
    }

    public void updateVisual() {
        if (debug) {
            System.out.println("updateVisual()...");
        }
        if (this.simulator.isRunning()) {
            this.pauseButton.setActive(true);
            this.resetButton.setActive(true);
            this.singleStepButton.setActive(false);
            this.runForButton.setActive(false);
            this.runForeverButton.setActive(false);
            this.trafficLight.setState(2);
        } else if (this.simulator.isPaused()) {
            this.pauseButton.setActive(false);
            this.resetButton.setActive(true);
            this.singleStepButton.setActive(true);
            this.runForButton.setActive(true);
            this.runForeverButton.setActive(true);
            this.trafficLight.setState(1);
        } else if (this.simulator.isSingleStep()) {
            this.pauseButton.setActive(false);
            this.resetButton.setActive(true);
            this.singleStepButton.setActive(true);
            this.runForButton.setActive(true);
            this.runForeverButton.setActive(true);
            this.trafficLight.setState(1);
        } else {
            this.pauseButton.setActive(false);
            this.resetButton.setActive(true);
            this.singleStepButton.setActive(this.simulator.hasEvents());
            this.runForButton.setActive(true);
            this.runForeverButton.setActive(true);
            this.trafficLight.setState(0);
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.resetButton) {
            this.simulator.stopSimulation();
        } else if (source == this.pauseButton) {
            this.simulator.pauseSimulation();
        } else if (source == this.singleStepButton) {
            this.simulator.singleStep();
        } else if (source == this.runForeverButton) {
            this.simulator.runForever();
        } else if (source == this.runForButton) {
            double dt = 0.0;
            try {
                dt = Double.valueOf(this.deltatTextField.getText().trim());
                if (dt < 0.0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                if (this.helper != null) {
                    this.helper.setStatusMessage("Illegal time interval: Must be a positive floating point value");
                }
                return;
            }
            String s = this.unitsChoice.getSelectedItem();
            if (s.equals("fs")) {
                dt *= 1.0E-15;
            } else if (s.equals("ps")) {
                dt *= 1.0E-12;
            } else if (s.equals("ns")) {
                dt *= 1.0E-9;
            } else if (s.equals("us")) {
                dt *= 1.0E-6;
            } else if (s.equals("ms")) {
                dt *= 0.001;
            } else if (s.equals("s")) {
                dt *= 1.0;
            } else if (s.equals("min")) {
                dt *= 60.0;
            } else if (s.equals("hours")) {
                dt *= 3600.0;
            } else if (s.equals("days")) {
                dt *= 86400.0;
            } else {
                System.err.println("-E- internal: unknown time unit: " + s);
                return;
            }
            this.simulator.runFor(dt);
        } else if (source == this.statusButton) {
            this.simulator.printStatus();
        } else {
            System.err.println("AWTSimControlPanel: unknown action event " + evt);
        }
        this.updateVisual();
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.batchOrInteractiveChoice) {
            System.err.println("#### no function defined yet for " + e);
        } else {
            System.err.println("AWTSimControlPanel: unknown Item event: " + e);
        }
    }

    public void addItemListener(ItemListener IL) {
        this.batchOrInteractiveChoice.addItemListener(IL);
    }

    public Choice getSimulatorChoice() {
        return this.batchOrInteractiveChoice;
    }

    public void setShowSimulatorChoice(boolean b) {
        this.batchOrInteractiveChoice.setVisible(b);
        this.doLayout();
    }

    public SimKernel createSelectedSimKernel() {
        String choice = this.batchOrInteractiveChoice.getSelectedItem();
        SimKernel tmp = null;
        if (choice.equals("Real time")) {
            tmp = new RealTimeSimKernel();
        } else if (choice.equals("Interactive")) {
            tmp = new InteractiveSimKernel();
        } else if (choice.equals("Batch mode")) {
            tmp = new BatchModeSimKernel();
        } else if (choice.equals("VHDL")) {
            tmp = new VhdlSimKernel();
        } else if (choice.equals("VHDL (batch)")) {
            tmp = new VhdlBatchSimKernel();
        } else {
            System.err.println("Illegal simulator choice: " + choice);
        }
        if (tmp == null) {
            tmp = new RealTimeSimKernel();
        }
        return tmp;
    }

    public void setRaised(boolean raised) {
        this.raised = raised;
    }

    public boolean isRaised() {
        return this.raised;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void stopSimTimeUpdate() {
        this.simTimePanel.alive = false;
    }

    public static void main(String[] argv) {
        System.out.println("hades.simulator.AWTSimControlPanel self test...");
        Frame f = new Frame("HADES Simulation Control Panel");
        f.setSize(new Dimension(400, 200));
        StatusCanvas statusCanvas = new StatusCanvas();
        f.add("South", (Component)statusCanvas);
        f.setVisible(true);
        SimKernel sim = new SimKernel();
        AWTSimControlPanel scp = new AWTSimControlPanel(sim, f);
        scp.setStatusMessage((StatusMessage)statusCanvas);
        f.add("North", scp);
        f.setVisible(true);
    }

    class SimTimePanel
    extends Panel
    implements Runnable {
        Label timeLabel = new Label("t= " + TimeFormatter.format(0.0) + "  ");
        Thread updater = null;
        boolean alive = true;

        public SimTimePanel() {
            super.setLayout(new FlowLayout(0));
            super.add(this.timeLabel);
            super.doLayout();
            this.updater = new Thread(this);
            this.updater.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (this.alive) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (AWTSimControlPanel.this.simulator != null) {
                        double t = AWTSimControlPanel.this.simulator.getSimTime();
                        this.timeLabel.setText("t= " + TimeFormatter.format(t) + "  ");
                        super.repaint();
                    }
                    Thread.sleep(1000L);
                }
                return;
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

