/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.SelectURLDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AWTSelectURLDialog
extends Dialog
implements SelectURLDialog,
ActionListener {
    private String urlName = null;
    private int status = 11;
    private Button cancelButton;
    private Button openButton;
    private Button chooseFileButton;
    private TextField filenameTF;
    private Panel filenamePanel;
    private Panel buttonPanel;

    public AWTSelectURLDialog(Frame parent, String title, String defaultUrlName) {
        super(parent, title, true);
        this.urlName = defaultUrlName;
        this.buildGUI();
        this.buildCallbacks();
    }

    public String getUrlName() {
        return this.urlName;
    }

    public void setUrlName(String s) {
        this.urlName = s;
    }

    public int getStatus() {
        return this.status;
    }

    public Dialog getDialog() {
        return this;
    }

    public void setSelectFileEnabled(boolean b) {
        this.chooseFileButton.setEnabled(b);
    }

    public void buildGUI() {
        this.filenameTF = new TextField(this.urlName, 40);
        this.chooseFileButton = new Button("Choose File");
        this.filenamePanel = new Panel();
        this.filenamePanel.setLayout(new BorderLayout());
        this.filenamePanel.add("Center", this.filenameTF);
        this.filenamePanel.add("East", this.chooseFileButton);
        this.cancelButton = new Button("Cancel");
        this.openButton = new Button("Open");
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new FlowLayout(0));
        this.buttonPanel.add(this.openButton);
        this.buttonPanel.add(this.cancelButton);
        this.setLayout(new BorderLayout());
        this.add("North", this.filenamePanel);
        this.add("South", this.buttonPanel);
        this.pack();
    }

    public void buildCallbacks() {
        this.cancelButton.addActionListener(this);
        this.openButton.addActionListener(this);
        this.chooseFileButton.addActionListener(this);
        this.filenameTF.addActionListener(this);
        this.addWindowListener(new WindowCloser());
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.cancelButton) {
            this.urlName = null;
            this.status = 11;
            this.setVisible(false);
        } else if (source == this.openButton) {
            this.urlName = this.filenameTF.getText().trim();
            this.status = 13;
            this.setVisible(false);
        } else if (source == this.filenameTF) {
            this.urlName = this.filenameTF.getText().trim();
            this.status = 13;
            this.setVisible(false);
        } else if (source == this.chooseFileButton) {
            this.urlName = null;
            this.status = 15;
            this.setVisible(false);
        } else {
            Thread.dumpStack();
        }
    }

    public static void main(String[] argv) {
        Frame ff = new Frame("dummy");
        ff.setSize(new Dimension(100, 100));
        ff.setVisible(true);
        AWTSelectURLDialog dialog = new AWTSelectURLDialog(ff, "Select an URL:", "http://www.sun.com");
        dialog.setVisible(true);
        System.out.println(dialog.getStatus());
        System.out.println(dialog.getUrlName());
        System.exit(0);
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent we) {
            AWTSelectURLDialog.this.urlName = null;
            AWTSelectURLDialog.this.status = 11;
            AWTSelectURLDialog.this.setVisible(false);
        }
    }
}

