/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.ExportOptionsDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jfig.gui.InsetsPanel;
import jfig.utils.Format;
import jfig.utils.SetupManager;

public class AWTExportOptionsDialog
extends Frame
implements ExportOptionsDialog,
ActionListener,
KeyListener {
    public static final int FULL_COLORS = 2;
    public static final int IO_COLORS = 3;
    public static final int BLACK_WHITE = 4;
    public static final String FULL_COLORS_STRING = "full colors";
    public static final String IO_COLORS_STRING = "black and white, I/O colored";
    public static final String BLACK_WHITE_STRING = "black and white only";
    TextField magnificationTF;
    TextField xoffsetTF;
    TextField yoffsetTF;
    Choice languageChoice;
    Choice orientationChoice;
    Choice centerChoice;
    Choice colorChoice;
    Button filenameButton;
    TextField filenameTF;
    Button fitToPageButton;
    Label sizeLabel;
    Button okButton;
    Button exportNowButton;
    Button cancelButton;
    Font defaultFont;
    boolean debug = false;
    String name;
    Dimension dm;
    String filename = "unnamed.ps";

    public AWTExportOptionsDialog() {
        super("Select Export Options");
        this.buildGUI();
    }

    public void updateFigObjectsBoundingBox() {
    }

    public void updateOutFilenameFromFigFilename() {
    }

    public void doExportPS() {
    }

    public void doExportEPS() {
    }

    public void doExportNativePPM() {
    }

    public void doExportNativeGIF() {
    }

    public Component getComponent() {
        return this;
    }

    public void setActionListener(ActionListener AL) {
        this.cancelButton.addActionListener(AL);
        this.okButton.addActionListener(AL);
        this.exportNowButton.addActionListener(AL);
        this.filenameButton.addActionListener(AL);
        this.fitToPageButton.addActionListener(AL);
        this.magnificationTF.addActionListener(AL);
    }

    protected void buildGUI() {
        Color backgroundColor = new Color(240, 240, 240);
        this.setBackground(backgroundColor);
        this.getDefaultFont();
        if (this.defaultFont != null) {
            this.setFont(this.defaultFont);
        }
        InsetsPanel okPanel = new InsetsPanel(10, 10);
        okPanel.setLayout((LayoutManager)new FlowLayout(1));
        okPanel.setLowered();
        this.cancelButton = new Button("Cancel");
        this.okButton = new Button("OK");
        this.exportNowButton = new Button("Export now");
        okPanel.add((Component)this.cancelButton);
        okPanel.add((Component)new Label("   "));
        okPanel.add((Component)this.okButton);
        okPanel.add((Component)this.exportNowButton);
        Label magnificationLabel = new Label("Magnification [%]: ", 2);
        Panel magPanel = new Panel();
        magPanel.setLayout(new FlowLayout(0));
        this.magnificationTF = new TextField("100", 4);
        this.sizeLabel = new Label("  [47.0 x 11.3 inches]");
        magPanel.add(this.magnificationTF);
        magPanel.add(this.sizeLabel);
        Label orientationLabel = new Label("Orientation: ", 2);
        Panel orientationPanel = new Panel();
        orientationPanel.setLayout(new FlowLayout(0));
        this.orientationChoice = new Choice();
        this.orientationChoice.addItem("landscape");
        this.orientationChoice.addItem("portrait");
        this.orientationChoice.select("portrait");
        this.centerChoice = new Choice();
        this.centerChoice.addItem("center");
        this.centerChoice.addItem("flush left");
        this.centerChoice.select("center");
        orientationPanel.add(this.orientationChoice);
        orientationPanel.add(this.centerChoice);
        Label offsetLabel = new Label("Export offsets [inches]: ", 2);
        Panel offsetPanel = new Panel(new FlowLayout(0));
        offsetPanel.add(new Label("x:"));
        this.xoffsetTF = new TextField("0", 4);
        offsetPanel.add(this.xoffsetTF);
        offsetPanel.add(new Label("  y:"));
        this.yoffsetTF = new TextField("0", 4);
        offsetPanel.add(this.yoffsetTF);
        Label languageLabel = new Label("Output language: ", 2);
        Panel languagePanel = new Panel();
        languagePanel.setLayout(new FlowLayout(0));
        this.languageChoice = new Choice();
        this.languageChoice.addItem("Postscript");
        this.languageChoice.addItem("Encapsulated Postscript");
        this.languageChoice.addItem("IBM GL");
        this.languageChoice.addItem("Latex");
        this.languageChoice.addItem("Pictex");
        this.languageChoice.select("Postscript");
        languagePanel.add(this.languageChoice);
        Label fitLabel = new Label("Fit to page: ", 2);
        Panel fitPanel = new Panel(new FlowLayout(0));
        this.fitToPageButton = new Button("A4, landscape, centered");
        fitPanel.add(this.fitToPageButton);
        Label colorLabel = new Label("Color options: ", 2);
        Panel colorPanel = new Panel(new FlowLayout(0));
        this.colorChoice = new Choice();
        this.colorChoice.addItem(FULL_COLORS_STRING);
        this.colorChoice.addItem(IO_COLORS_STRING);
        this.colorChoice.addItem(BLACK_WHITE_STRING);
        this.colorChoice.select(IO_COLORS_STRING);
        colorPanel.add(this.colorChoice);
        Label filenameLabel = new Label("Select filename:", 2);
        Panel filenamePanel = new Panel(new FlowLayout(0));
        this.filenameButton = new Button("Browse");
        this.filenameTF = new TextField(this.filename, 12);
        this.filenameTF.setEditable(false);
        filenamePanel.add(this.filenameTF);
        filenamePanel.add(this.filenameButton);
        Panel mainPanel = new Panel();
        mainPanel.setLayout(new GridLayout(11, 2));
        mainPanel.add(new Label(""));
        mainPanel.add(new Label(" Fig2dev export options:"));
        mainPanel.add(languageLabel);
        mainPanel.add(languagePanel);
        mainPanel.add(colorLabel);
        mainPanel.add(colorPanel);
        mainPanel.add(new Label(""));
        mainPanel.add(new Label(""));
        mainPanel.add(fitLabel);
        mainPanel.add(fitPanel);
        mainPanel.add(magnificationLabel);
        mainPanel.add(magPanel);
        mainPanel.add(orientationLabel);
        mainPanel.add(orientationPanel);
        mainPanel.add(offsetLabel);
        mainPanel.add(offsetPanel);
        mainPanel.add(new Label(""));
        mainPanel.add(new Label(""));
        mainPanel.add(filenameLabel);
        mainPanel.add(filenamePanel);
        this.setLayout(new BorderLayout());
        this.add("Center", mainPanel);
        this.add("South", (Component)okPanel);
        this.pack();
        this.xoffsetTF.addKeyListener(this);
        this.yoffsetTF.addKeyListener(this);
        this.magnificationTF.addKeyListener(this);
        this.fitToPageButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.exportNowButton.addActionListener(this);
        this.addKeyListener(this);
    }

    private void getDefaultFont() {
        String name = SetupManager.getProperty("Hades.Exporter.FontName", "MonoSpaced");
        int size = SetupManager.getInteger("Hades.Exporter.FontSize", 12);
        int style = 0;
        this.defaultFont = new Font(name, style, size);
    }

    public void keyPressed(KeyEvent evt) {
        char key = evt.getKeyChar();
        if (this.debug) {
            System.out.println("textDialog.keyDown() " + key);
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.debug) {
            System.out.println(this.name + ".action(): " + evt.toString());
            System.out.println(this.getFig2devOptionString());
        }
    }

    public int getColorOption() {
        String s = this.colorChoice.getSelectedItem();
        if (s.equals(FULL_COLORS_STRING)) {
            return 2;
        }
        if (s.equals(IO_COLORS_STRING)) {
            return 3;
        }
        if (s.equals(BLACK_WHITE_STRING)) {
            return 4;
        }
        this.message("-E- unkwown color selection: " + s);
        return 3;
    }

    public void setSizeLabel(double size_x, double size_y) {
        this.sizeLabel.setText("" + new Format("%3.1f").form(size_x) + " x " + new Format("%3.1f").form(size_y) + " " + "inches");
    }

    public void showSize(Dimension d) {
        double mag = this.getMagnification();
        this.setSizeLabel(mag * (double)d.width / 240000.0, mag * (double)d.height / 240000.0);
    }

    public void setMagnification(int i) {
        this.magnificationTF.setText("" + i);
    }

    public int getMagnification() {
        int mag;
        try {
            mag = Integer.parseInt(this.magnificationTF.getText().trim());
        }
        catch (Exception e) {
            this.message("Illegal NumberFormat in getMagnification: " + this.magnificationTF.getText().trim());
            mag = 100;
            this.magnificationTF.setText("100");
        }
        return mag;
    }

    public void setFilename(String filename) {
        this.filenameTF.setText(filename);
    }

    public String getFilenameExtension() {
        String s = null;
        String l = this.languageChoice.getSelectedItem();
        if (l.equals("Postscript")) {
            s = ".ps";
        } else if (l.equals("Encapsulated Postscript")) {
            s = ".eps";
        } else if (l.equals("Pictex")) {
            s = ".tex";
        } else if (l.equals("IBM GL")) {
            s = ".gl";
        } else if (l.equals("Latex")) {
            s = ".tex";
        } else {
            System.err.println("getFilenameExtension: unknown language" + l);
            s = ".ps";
        }
        return s;
    }

    public String getFig2devOptionString() {
        String s = "";
        String language = this.languageChoice.getSelectedItem();
        boolean usePostscript = false;
        if (language.equals("Postscript")) {
            s = s + "-L ps -P";
            usePostscript = true;
        } else if (language.equals("Encapsulated Postscript")) {
            s = s + "-L ps";
            usePostscript = true;
        } else if (language.equals("IBM GL")) {
            s = s + "-L ibmgl";
        } else if (language.equals("Pictex")) {
            s = s + "-L pictex";
        } else if (language.equals("Latex")) {
            s = s + "-L latex";
        } else {
            System.out.println("unknown export language: " + language);
        }
        int mag = 0;
        int xoffset = 0;
        int yoffset = 0;
        try {
            mag = Integer.parseInt(this.magnificationTF.getText().trim());
        }
        catch (NumberFormatException e) {
            this.message("-E- Illegal NumberFormat for magnification: " + this.magnificationTF.getText().trim());
            mag = 100;
            this.magnificationTF.setText("100");
        }
        s = s + " -m " + (double)mag * 0.01;
        if (usePostscript) {
            s = "center".equals(this.centerChoice.getSelectedItem()) ? s + " -c" : s + " -e";
            try {
                xoffset = Integer.parseInt(this.xoffsetTF.getText().trim());
                yoffset = Integer.parseInt(this.yoffsetTF.getText().trim());
            }
            catch (NumberFormatException e) {
                xoffset = 0;
                yoffset = 0;
                this.xoffsetTF.setText("0");
                this.yoffsetTF.setText("0");
            }
            if (xoffset != 0) {
                s = s + " -x " + (double)xoffset / 72.0;
            }
            if (yoffset != 0) {
                s = s + " -y " + (double)yoffset / 72.0;
            }
            if ("landscape".equals(this.orientationChoice.getSelectedItem())) {
                s = s + " -l dummy";
            }
        }
        return s + " ";
    }

    public void message(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] argv) {
        AWTExportOptionsDialog f = new AWTExportOptionsDialog();
        f.setVisible(true);
    }
}

