/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.Vector;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;
import jfig.objects.FigObjectList;
import jfig.objects.FigRectangle;
import jfig.objects.FigText;
import jfig.objects.FigWriter;

public class SimpleLatexParser {
    static final int INVALID = 0;
    static final int TEXT = 1;
    static final int COMMAND = 2;
    static final int MATH = 3;
    static final int BEGINGROUP = 4;
    static final int ENDGROUP = 5;
    static final int CONTROL = 6;
    static final int BEGINMATH = 7;
    static final int ENDMATH = 8;
    static final int SUPERSCRIPT = 9;
    static final int SUBSCRIPT = 10;
    static final int MATHSYMBOL = 11;
    static final String[] _mode_names = new String[]{"invalid", "text", "command", "math", "begingroup", "endgroup", "control", "beginmath", "endmath", "superscript", "subscript", "mathsymbol"};
    static int count = 100;
    boolean debug = false;
    boolean dump_tokens = false;
    boolean display_boxes = false;
    ColorCache colorCache = ColorCache.getColorCache();
    FontCache fontCache = FontCache.getFontCache();
    int mathFontIndex = 44;
    int mathGreekFontIndex = 42;
    int mathSymbolFontIndex = 42;
    StringBuffer token;
    Vector tokens;
    Vector types;
    Stack stack = new Stack();
    Box master;
    Box current;
    int fontIndex;
    int ptSize;
    int colorIndex;
    int italic_correction = 0;
    public final int[][] subscriptPtSizes = new int[][]{{9, 6}, {10, 6}, {11, 7}, {12, 9}, {15, 10}, {17, 12}, {20, 12}, {24, 15}, {30, 20}, {40, 27}};

    void tokenize(String string) {
        this.tokens = new Vector();
        this.types = new Vector();
        this.token = new StringBuffer("");
        char c = '\u0000';
        char c2 = '\u0000';
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        while (n3 < n4) {
            c = string.charAt(n3);
            c2 = this.getShortCommand(n3, string);
            if (c2 != '\u0000') {
                ++n3;
            }
            if (n == 1) {
                if (c2 != '\u0000') {
                    this.token.append(c2);
                } else if (c == '$') {
                    this.checkAddToken(this.token, 1);
                    this.checkAddToken("$", 7);
                    this.token = new StringBuffer("");
                    n = 3;
                } else if (c == '{') {
                    this.checkAddToken(this.token, 1);
                    this.checkAddToken("{", 4);
                    this.token = new StringBuffer("");
                } else if (c == '}') {
                    this.checkAddToken(this.token, 1);
                    this.checkAddToken("}", 5);
                    this.token = new StringBuffer("");
                } else if (c == '\\') {
                    this.checkAddToken(this.token, 1);
                    this.token = new StringBuffer("\\");
                    n2 = 1;
                    n = 2;
                } else {
                    if (c == '%') break;
                    if (this.isTextToken(c)) {
                        this.token.append(c);
                    } else {
                        this.errorInTokenizer(n3, n, string);
                    }
                }
            } else if (n == 3) {
                if (c2 != '\u0000') {
                    this.token.append(c2);
                } else if (this.isDigit(c)) {
                    this.checkAddToken(this.token, 3);
                    this.checkAddToken("" + c, 11);
                    this.token = new StringBuffer("");
                } else if (this.isTextToken(c)) {
                    this.token.append(c);
                } else if (this.isWhitespace(c) || this.isPunctuation(c)) {
                    this.token.append(c);
                } else if (c == '$') {
                    this.checkAddToken(this.token, 3);
                    this.checkAddToken("$", 8);
                    this.token = new StringBuffer("");
                    n = 1;
                } else if (c == '^') {
                    this.checkAddToken(this.token, 3);
                    this.checkAddToken("^", 9);
                    this.token = new StringBuffer("");
                } else if (c == '_') {
                    this.checkAddToken(this.token, 3);
                    this.checkAddToken("_", 10);
                    this.token = new StringBuffer("");
                } else if (c == '{') {
                    this.checkAddToken(this.token, 3);
                    this.checkAddToken("{", 4);
                    this.token = new StringBuffer("");
                } else if (c == '}') {
                    this.checkAddToken(this.token, 3);
                    this.checkAddToken("}", 5);
                    this.token = new StringBuffer("");
                } else if (c == '\\') {
                    this.checkAddToken(this.token, 3);
                    this.token = new StringBuffer("\\");
                    n2 = 3;
                    n = 2;
                } else if (this.isMathSymbol(c)) {
                    this.checkAddToken(this.token, 3);
                    this.checkAddToken("" + c, 11);
                    this.token = new StringBuffer("");
                    n = 3;
                } else {
                    if (c == '%') break;
                    this.errorInTokenizer(n3, n, string);
                }
            } else if (n == 2) {
                if (c2 != '\u0000') {
                    this.checkAddToken(this.token, 2);
                    this.token = new StringBuffer("" + c2);
                    n = n2;
                } else if (this.isAscii(c)) {
                    this.token.append(c);
                } else if (c == '\\') {
                    this.checkAddToken(this.token, 2);
                    this.token = new StringBuffer("\\");
                    n = 2;
                } else if (c == '$') {
                    this.checkAddToken(this.token, 2);
                    if (n2 == 3) {
                        this.checkAddToken("$", 8);
                        n = 1;
                    } else {
                        this.checkAddToken("$", 7);
                        n = 3;
                    }
                    this.token = new StringBuffer("");
                } else {
                    if (c == '%') break;
                    if (c == '^') {
                        if (n2 != 3) {
                            this.errorInTokenizer(n3, n, string);
                        } else {
                            this.checkAddToken(this.token, 2);
                            this.checkAddToken("^", 9);
                            this.token = new StringBuffer("");
                            n = n2;
                        }
                    } else if (c == '_') {
                        if (n2 != 3) {
                            this.errorInTokenizer(n3, n, string);
                        } else {
                            this.checkAddToken(this.token, 2);
                            this.checkAddToken("_", 10);
                            this.token = new StringBuffer("");
                            n = n2;
                        }
                    } else if (c == '{') {
                        this.checkAddToken(this.token, 2);
                        this.checkAddToken("{", 4);
                        this.token = new StringBuffer("");
                        n = n2;
                    } else if (c == '}') {
                        this.checkAddToken(this.token, 2);
                        this.checkAddToken("}", 5);
                        this.token = new StringBuffer("");
                        n = n2;
                    } else if (c == ' ') {
                        this.checkAddToken(this.token, 2);
                        this.token = new StringBuffer("");
                        n = n2;
                    } else if (this.isDigit(c) || this.isPunctuation(c) || this.isWhitespace(c)) {
                        this.checkAddToken(this.token, 2);
                        this.token = new StringBuffer("" + c);
                        n = n2;
                    } else if (n2 == 3 && this.isMathSymbol(c)) {
                        this.checkAddToken(this.token, 2);
                        this.checkAddToken("" + c, 11);
                        this.token = new StringBuffer("");
                        n = n2;
                    } else {
                        this.errorInTokenizer(n3, n, string);
                    }
                }
            }
            ++n3;
        }
        if (this.token != null && this.token.length() > 0) {
            this.checkAddToken(this.token, n);
        }
    }

    private char getShortCommand(int n, String string) {
        try {
            boolean bl;
            char c = string.charAt(n);
            boolean bl2 = bl = c == '\\' || c == '\"';
            if (!bl) {
                return '\u0000';
            }
            char c2 = string.charAt(n + 1);
            if (c == '\\') {
                switch (c2) {
                    case ' ': {
                        return ' ';
                    }
                    case '$': {
                        return '$';
                    }
                    case '%': {
                        return '%';
                    }
                    case '&': {
                        return '&';
                    }
                    case '{': {
                        return '{';
                    }
                    case '}': {
                        return '}';
                    }
                    case '|': {
                        return '|';
                    }
                    case '#': {
                        return '#';
                    }
                    case '_': {
                        return '_';
                    }
                    case '\"': {
                        return '\"';
                    }
                }
                return '\u0000';
            }
            if (c == '\"') {
                switch (c2) {
                    case 'a': {
                        return '\u00e4';
                    }
                    case 'o': {
                        return '\u00f6';
                    }
                    case 'u': {
                        return '\u00fc';
                    }
                    case 'A': {
                        return '\u00c4';
                    }
                    case 'O': {
                        return '\u00d6';
                    }
                    case 'U': {
                        return '\u00dc';
                    }
                    case 's': {
                        return '\u00df';
                    }
                }
                return '\u0000';
            }
            return '\u0000';
        }
        catch (Exception exception) {
            return '\u0000';
        }
    }

    private void checkAddToken(Object object, int n) {
        if (object == null) {
            return;
        }
        String string = object.toString();
        if (string.length() > 0) {
            this.tokens.add(object);
            this.types.add(new Integer(n));
        }
    }

    private void errorInTokenizer(int n, int n2, String string) {
        System.out.println("Error in tokenize, mode= " + _mode_names[n2]);
        System.out.println(string);
        int n3 = 0;
        while (n3 < n) {
            System.out.print(" ");
            ++n3;
        }
        System.out.println("^");
    }

    public boolean isTextToken(char c) {
        return this.isAscii(c) || this.isUmlaut(c) || this.isDigit(c) || this.isWhitespace(c) || this.isPunctuation(c);
    }

    public boolean isAscii(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public boolean isUmlaut(char c) {
        return c == '\u00e4' || c == '\u00c4' || c == '\u00f6' || c == '\u00d6' || c == '\u00fc' || c == '\u00dc' || c == '\u00df';
    }

    public boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    public boolean isPunctuation(char c) {
        return c == '.' || c == ',' || c == ';' || c == ':' || c == '!' || c == '?' || c == '\'' || c == '-' || c == '+' || c == '=' || c == '(' || c == ')' || c == '[' || c == ']';
    }

    public boolean isMathSymbol(char c) {
        return c == '=' || c == '>' || c == '<' || c == '+' || c == '-' || c == '|' || c == '*' || c == '(' || c == ')' || c == '/';
    }

    public void dumpTokens() {
        int n = 0;
        int n2 = 0;
        int n3 = this.tokens.size();
        while (n2 < n3) {
            int n4 = 0;
            while (n4 < n) {
                System.out.print(" ");
                ++n4;
            }
            String string = this.tokens.elementAt(n2).toString();
            int n5 = (Integer)this.types.elementAt(n2);
            System.out.println(string + "   " + _mode_names[n5]);
            n += string.length();
            ++n2;
        }
    }

    public Object getState() {
        return new Object[]{new Integer(this.fontIndex), new Integer(this.ptSize), new Integer(this.colorIndex)};
    }

    public void setState(Object object) {
        try {
            int n = 0;
            Object[] objectArray = (Object[])object;
            this.fontIndex = (Integer)objectArray[n++];
            this.ptSize = (Integer)objectArray[n++];
            this.colorIndex = (Integer)objectArray[n++];
        }
        catch (Throwable throwable) {
            SimpleLatexParser.msg("-E- internal in setState: tmp= " + object);
            throwable.printStackTrace();
        }
    }

    public void append(Box box) {
        this.current.append(box);
        this.current = box;
    }

    public Box buildBox() {
        SimpleLatexParser simpleLatexParser = this;
        if (simpleLatexParser == null) {
            throw null;
        }
        this.current = this.master = simpleLatexParser.new CharBox("", this.fontIndex, this.ptSize, this.colorIndex);
        int n = 0;
        int n2 = this.tokens.size();
        while (n < n2) {
            String string = this.tokens.elementAt(n).toString();
            int n3 = (Integer)this.types.elementAt(n);
            switch (n3) {
                case 0: {
                    SimpleLatexParser.msg("-E-internal: mode=INVALID, token=" + string);
                    break;
                }
                case 1: {
                    Object object;
                    int n4 = 0;
                    while (n4 < string.length()) {
                        object = "" + string.charAt(n4);
                        SimpleLatexParser simpleLatexParser2 = this;
                        if (simpleLatexParser2 == null) {
                            throw null;
                        }
                        this.append(simpleLatexParser2.new CharBox((String)object, this.fontIndex, this.ptSize, this.colorIndex));
                        ++n4;
                    }
                    break;
                }
                case 2: {
                    String string2 = string.substring(1);
                    this.handleCommand(string2);
                    break;
                }
                case 3: {
                    Object object2;
                    int n5 = 0;
                    while (n5 < string.length()) {
                        object2 = "" + string.charAt(n5);
                        SimpleLatexParser simpleLatexParser3 = this;
                        if (simpleLatexParser3 == null) {
                            throw null;
                        }
                        this.append(simpleLatexParser3.new CharBox((String)object2, this.fontIndex, this.ptSize, this.colorIndex));
                        ++n5;
                    }
                    break;
                }
                case 4: {
                    this.stack.push(this.getState());
                    break;
                }
                case 5: {
                    Object object;
                    try {
                        this.setState(this.stack.pop());
                    }
                    catch (Exception exception) {
                        SimpleLatexParser.msg("-E- empty stack: unmatched '}' brace");
                        break;
                    }
                    if (this.stack.isEmpty() || !((object = this.stack.peek()) instanceof SubSuperScriptBox)) break;
                    object = this.stack.pop();
                    this.current = (SubSuperScriptBox)object;
                    this.setState(this.stack.pop());
                    break;
                }
                case 6: {
                    SimpleLatexParser.msg("-W- control character, should not happen: " + string);
                    break;
                }
                case 7: {
                    this.stack.push(this.getState());
                    this.fontIndex = this.mathFontIndex;
                    break;
                }
                case 8: {
                    this.setState(this.stack.pop());
                    break;
                }
                case 9: {
                    Object object;
                    if (this.debug) {
                        System.out.println("\n\n\n");
                    }
                    if (this.current instanceof SubSuperScriptBox) {
                        object = (SubSuperScriptBox)this.current;
                        if (this.debug) {
                            System.out.println("SUPERSCRIPT: '" + string + "' " + object);
                        }
                        if (((SubSuperScriptBox)object).getSuperscriptBox() != null) {
                            SimpleLatexParser simpleLatexParser4 = this;
                            if (simpleLatexParser4 == null) {
                                throw null;
                            }
                            object = simpleLatexParser4.new SubSuperScriptBox(this.fontIndex, this.ptSize);
                            this.append((Box)object);
                        }
                    } else {
                        SimpleLatexParser simpleLatexParser5 = this;
                        if (simpleLatexParser5 == null) {
                            throw null;
                        }
                        object = simpleLatexParser5.new SubSuperScriptBox(this.fontIndex, this.ptSize);
                        this.append((Box)object);
                    }
                    this.stack.push(this.getState());
                    this.stack.push(object);
                    this.ptSize = ((SubSuperScriptBox)object).getSubscriptPtSize();
                    Object object2 = ((SubSuperScriptBox)object).getSuperscriptBasePoint();
                    SimpleLatexParser simpleLatexParser6 = this;
                    if (simpleLatexParser6 == null) {
                        throw null;
                    }
                    CharBox charBox = simpleLatexParser6.new CharBox("", this.fontIndex, this.ptSize, this.colorIndex);
                    charBox.setOrigin((Point)object2);
                    ((SubSuperScriptBox)object).setSuperscriptBox(charBox);
                    if (this.debug) {
                        System.out.println("MASTER: base=" + object2 + "\nbox= " + object);
                    }
                    if (this.debug) {
                        System.out.println("new superscriptbox=" + charBox + " " + this.ptSize);
                    }
                    this.current = charBox;
                    break;
                }
                case 10: {
                    Object object;
                    if (this.debug) {
                        System.out.println("\n\n\n");
                    }
                    if (this.current instanceof SubSuperScriptBox) {
                        object = (SubSuperScriptBox)this.current;
                        if (this.debug) {
                            System.out.println("SUBSCRIPT: '" + string + "' " + object);
                        }
                        if (((SubSuperScriptBox)object).getSubscriptBox() != null) {
                            SimpleLatexParser simpleLatexParser7 = this;
                            if (simpleLatexParser7 == null) {
                                throw null;
                            }
                            object = simpleLatexParser7.new SubSuperScriptBox(this.fontIndex, this.ptSize);
                            this.append((Box)object);
                        }
                    } else {
                        SimpleLatexParser simpleLatexParser8 = this;
                        if (simpleLatexParser8 == null) {
                            throw null;
                        }
                        object = simpleLatexParser8.new SubSuperScriptBox(this.fontIndex, this.ptSize);
                        this.append((Box)object);
                    }
                    this.stack.push(this.getState());
                    this.stack.push(object);
                    this.ptSize = ((SubSuperScriptBox)object).getSubscriptPtSize();
                    Object object2 = ((SubSuperScriptBox)object).getSubscriptBasePoint();
                    SimpleLatexParser simpleLatexParser9 = this;
                    if (simpleLatexParser9 == null) {
                        throw null;
                    }
                    CharBox charBox = simpleLatexParser9.new CharBox("", this.fontIndex, this.ptSize, this.colorIndex);
                    charBox.setOrigin((Point)object2);
                    ((SubSuperScriptBox)object).setSubscriptBox(charBox);
                    if (this.debug) {
                        System.out.println("MASTER: base=" + object2 + "\nbox= " + object);
                    }
                    if (this.debug) {
                        System.out.println("new subscriptbox=" + charBox + " " + this.ptSize);
                    }
                    this.current = charBox;
                    break;
                }
                case 11: {
                    SimpleLatexParser simpleLatexParser10 = this;
                    if (simpleLatexParser10 == null) {
                        throw null;
                    }
                    this.append(simpleLatexParser10.new CharBox(string, this.mathSymbolFontIndex, this.ptSize, this.colorIndex));
                    break;
                }
                default: {
                    System.out.println("UNKNOWN MODE: " + n3 + " " + string);
                }
            }
            ++n;
        }
        return this.master;
    }

    public void handleCommand(String string) {
        String string2 = "_" + string;
        try {
            Class[] classArray = new Class[]{};
            Method method = this.getClass().getMethod(string2, classArray);
            Object[] objectArray = new Object[]{};
            Object object = method.invoke((Object)this, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            SimpleLatexParser.msg("-E- handleCommand: " + throwable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            SimpleLatexParser.msg("-W- Command undefined: " + string + " " + noSuchMethodException);
            noSuchMethodException.printStackTrace();
            SimpleLatexParser simpleLatexParser = this;
            if (simpleLatexParser == null) {
                throw null;
            }
            this.append(simpleLatexParser.new CharBox(string, this.fontIndex, this.ptSize, this.colorIndex));
        }
        catch (Exception exception) {
            SimpleLatexParser.msg("-E- exception: " + exception + " for command: " + string);
            exception.printStackTrace();
        }
    }

    public void FIXME(String string) {
        System.out.println("-W- function not (yet) supported: " + string);
    }

    public void _bf() {
        this.fontIndex |= 2;
    }

    public void _em() {
        this.fontIndex ^= 1;
    }

    public void _rm() {
        this.fontIndex &= 0xFC;
    }

    public void _sl() {
        throw new Error("Not yet implemented: _sl");
    }

    public void _sc() {
        throw new Error("Not yet implemented: _sc");
    }

    public void _mathrm() {
        this.fontIndex &= 0xFC;
    }

    public void _tt() {
        this.fontIndex = 12;
    }

    public void _btt() {
        this.fontIndex = 14;
    }

    public void _itt() {
        this.fontIndex = 13;
    }

    public void _black() {
        this.colorIndex = ColorCache.BLACK;
    }

    public void _red() {
        this.colorIndex = ColorCache.RED;
    }

    public void _green() {
        this.colorIndex = ColorCache.GREEN;
    }

    public void _blue() {
        this.colorIndex = ColorCache.BLUE;
    }

    public void _cyan() {
        this.colorIndex = ColorCache.CYAN;
    }

    public void _magenta() {
        this.colorIndex = ColorCache.MAGENTA;
    }

    public void _yellow() {
        this.colorIndex = ColorCache.YELLOW;
    }

    public void _white() {
        this.colorIndex = ColorCache.WHITE;
    }

    public void _darkblue() {
        this.colorIndex = ColorCache.BLUE4;
    }

    public void _lightblue() {
        this.colorIndex = ColorCache.LTBLUE;
    }

    public void _darkgreen() {
        this.colorIndex = ColorCache.GREEN4;
    }

    public void _darkred() {
        this.colorIndex = ColorCache.RED4;
    }

    public void _darkpink() {
        this.colorIndex = ColorCache.PINK4;
    }

    public void _gold() {
        this.colorIndex = ColorCache.GOLD;
    }

    public void _fivept() {
        this.ptSize = 5;
    }

    public void _sixpt() {
        this.ptSize = 6;
    }

    public void _sevenpt() {
        this.ptSize = 7;
    }

    public void _eightpt() {
        this.ptSize = 8;
    }

    public void _ninept() {
        this.ptSize = 9;
    }

    public void _tenpt() {
        this.ptSize = 10;
    }

    public void _elevenpt() {
        this.ptSize = 11;
    }

    public void _twelvept() {
        this.ptSize = 12;
    }

    public void _thirteenpt() {
        this.ptSize = 13;
    }

    public void _fourteenpt() {
        this.ptSize = 14;
    }

    public void _fifteenpt() {
        this.ptSize = 15;
    }

    public void _sixteenpt() {
        this.ptSize = 16;
    }

    public void _seventeenpt() {
        this.ptSize = 17;
    }

    public void _eightteenpt() {
        this.ptSize = 18;
    }

    public void _nineteenpt() {
        this.ptSize = 19;
    }

    public void _twentypt() {
        this.ptSize = 20;
    }

    public void _twentyonept() {
        this.ptSize = 21;
    }

    public void _twentytwopt() {
        this.ptSize = 22;
    }

    public void _twentythreept() {
        this.ptSize = 23;
    }

    public void _twentyfourpt() {
        this.ptSize = 24;
    }

    public void _twentyfivept() {
        this.ptSize = 25;
    }

    public void _twentysixpt() {
        this.ptSize = 26;
    }

    public void _twentysevenpt() {
        this.ptSize = 27;
    }

    public void _twentyeightpt() {
        this.ptSize = 28;
    }

    public void _twentyninept() {
        this.ptSize = 29;
    }

    public void _thirtypt() {
        this.ptSize = 30;
    }

    public void _thirtyfivept() {
        this.ptSize = 35;
    }

    public void _fourtypt() {
        this.ptSize = 40;
    }

    public void _fourtyfivept() {
        this.ptSize = 45;
    }

    public void _fiftypt() {
        this.ptSize = 50;
    }

    public void _fiftyfivept() {
        this.ptSize = 55;
    }

    public void _sixtypt() {
        this.ptSize = 60;
    }

    public void _seventypt() {
        this.ptSize = 70;
    }

    public void _eightypt() {
        this.ptSize = 80;
    }

    public void _ninetypt() {
        this.ptSize = 90;
    }

    public void _hundredpt() {
        this.ptSize = 100;
    }

    public void _xpt() {
        this.ptSize = 10;
    }

    public void _xipt() {
        this.ptSize = 11;
    }

    public void _xiipt() {
        this.ptSize = 12;
    }

    public void _xiiipt() {
        this.ptSize = 13;
    }

    public void _xivpt() {
        this.ptSize = 14;
    }

    public void _xvpt() {
        this.ptSize = 15;
    }

    public void _xvipt() {
        this.ptSize = 16;
    }

    public void _xviipt() {
        this.ptSize = 17;
    }

    public void _xviiipt() {
        this.ptSize = 18;
    }

    public void _xixpt() {
        this.ptSize = 19;
    }

    public void _xxpt() {
        this.ptSize = 20;
    }

    public void _xxipt() {
        this.ptSize = 21;
    }

    public void _xxiipt() {
        this.ptSize = 22;
    }

    public void _xxiiipt() {
        this.ptSize = 23;
    }

    public void _xxivpt() {
        this.ptSize = 24;
    }

    public void _xxvpt() {
        this.ptSize = 25;
    }

    public void _xxvipt() {
        this.ptSize = 26;
    }

    public void _xxviipt() {
        this.ptSize = 27;
    }

    public void _xxxpt() {
        this.ptSize = 30;
    }

    public void _xxxvpt() {
        this.ptSize = 35;
    }

    public void _xlpt() {
        this.ptSize = 40;
    }

    public void _footnotesize() {
        this.FIXME("footnotesize");
    }

    public void _tiny() {
        this.FIXME("tiny");
    }

    public void _small() {
        this.FIXME("small");
    }

    public void _normalsize() {
        this.FIXME("normalsize");
    }

    public void _large() {
        this.FIXME("large");
    }

    public void _Large() {
        this.FIXME("Large");
    }

    public void _LARGE() {
        this.FIXME("LARGE");
    }

    public void _huge() {
        this.FIXME("huge");
    }

    public void _hashsign() {
        this.unicode("#");
    }

    public void _atsign() {
        this.unicode("@");
    }

    public void _lbracket() {
        this.unicode("[");
    }

    public void _backslash() {
        this.unicode("\\");
    }

    public void _rbracket() {
        this.unicode("]");
    }

    public void _lessthan() {
        this.unicode("<");
    }

    public void _equals() {
        this.unicode("=");
    }

    public void _greaterthan() {
        this.unicode(">");
    }

    public void _proportional() {
        this.unicode("\u2243");
    }

    public void _approxeq() {
        this.unicode("\u2245");
    }

    public void _lbrace() {
        this.unicode("{");
    }

    public void _verticalbar() {
        this.unicode("|");
    }

    public void _rbrace() {
        this.unicode("}");
    }

    public void _tildechar() {
        this.unicode("~");
    }

    public void _not() {
        this.FIXME("\\noti#1");
    }

    public void _pmb() {
        this.FIXME("\\pmb#1");
    }

    public void _frac() {
        this.FIXME("\\frac#1#2");
    }

    public void _hat() {
        this.FIXME("\\hat#1");
    }

    public void _check() {
        this.FIXME("\\check#1");
    }

    public void _acute() {
        this.FIXME("\\acute#1");
    }

    public void _grave() {
        this.FIXME("\\grave#1");
    }

    public void _brave() {
        this.FIXME("\\brave#1");
    }

    public void _bar() {
        this.FIXME("\\bar#1");
    }

    public void _vec() {
        this.FIXME("\\vec#1");
    }

    public void _dot() {
        this.FIXME("\\dot#1");
    }

    public void _ddot() {
        this.FIXME("\\ddot#1");
    }

    public void _tilde() {
        this.FIXME("\\tilde#1");
    }

    public void _alpha() {
        this.greek("\u03b1");
    }

    public void _beta() {
        this.greek("\u03b2");
    }

    public void _gamma() {
        this.greek("\u03b3");
    }

    public void _delta() {
        this.greek("\u03b4");
    }

    public void _epsilon() {
        this.greek("\u03b5");
    }

    public void _varepsilon() {
        this.greek("\u02b5");
    }

    public void _zeta() {
        this.greek("\u03b6");
    }

    public void _eta() {
        this.greek("\u03b7");
    }

    public void _theta() {
        this.greek("\u03b8");
    }

    public void _vartheta() {
        this.greek("\u03d1");
    }

    public void _iota() {
        this.greek("\u03b9");
    }

    public void _kappa() {
        this.greek("\u03ba");
    }

    public void _lambda() {
        this.greek("\u03bb");
    }

    public void _mu() {
        this.greek("\u03bc");
    }

    public void _nu() {
        this.greek("\u03bd");
    }

    public void _xi() {
        this.greek("\u03be");
    }

    public void _greeko() {
        this.greek("\u03bf");
    }

    public void _pi() {
        this.greek("\u03c0");
    }

    public void _varpi() {
        this.greek("\u03d6");
    }

    public void _rho() {
        this.greek("\u03c1");
    }

    public void _varrho() {
        this.greek("\u03f1");
    }

    public void _sigma() {
        this.greek("\u03c3");
    }

    public void _varsigma() {
        this.greek("\u03da");
    }

    public void _tau() {
        this.greek("\u03c4");
    }

    public void _upsilon() {
        this.greek("\u03c5");
    }

    public void _phi() {
        this.greek("\u03d5");
    }

    public void _varphi() {
        this.greek("\u03c6");
    }

    public void _chi() {
        this.greek("\u03c7");
    }

    public void _psi() {
        this.greek("\u03c8");
    }

    public void _omega() {
        this.greek("\u03c9");
    }

    public void _Alpha() {
        this.greek("\u0391");
    }

    public void _Beta() {
        this.greek("\u0392");
    }

    public void _Gamma() {
        this.greek("\u0393");
    }

    public void _Delta() {
        this.greek("\u0394");
    }

    public void _Epsilon() {
        this.greek("\u0395");
    }

    public void _Zeta() {
        this.greek("\u0396");
    }

    public void _Eta() {
        this.greek("\u0397");
    }

    public void _Theta() {
        this.greek("\u0398");
    }

    public void _Iota() {
        this.greek("\u0399");
    }

    public void _Kappa() {
        this.greek("\u039a");
    }

    public void _Lambda() {
        this.greek("\u039b");
    }

    public void _Mu() {
        this.greek("\u039c");
    }

    public void _Nu() {
        this.greek("\u039d");
    }

    public void _Xi() {
        this.greek("\u039e");
    }

    public void _Greeko() {
        this.greek("\u039f");
    }

    public void _Pi() {
        this.greek("\u03a0");
    }

    public void _Rho() {
        this.greek("\u03a1");
    }

    public void _Sigma() {
        this.greek("\u03a3");
    }

    public void _Tau() {
        this.greek("\u03a4");
    }

    public void _Upsilon() {
        this.greek("\u03a5");
    }

    public void _Phi() {
        this.greek("\u03a6");
    }

    public void _Chi() {
        this.greek("\u03a7");
    }

    public void _Psi() {
        this.greek("\u03a8");
    }

    public void _Omega() {
        this.greek("\u03a9");
    }

    public void _pm() {
        this.unicode("\u00b1");
    }

    public void _cap() {
        this.unicode("\u2229");
    }

    public void _diamond() {
        this.unicode("\u22c4");
    }

    public void _oplus() {
        this.unicode("\u2295");
    }

    public void _mp() {
        this.unicode("\u2213");
    }

    public void _cup() {
        this.unicode("\u222a");
    }

    public void _bigtriangleup() {
        this.unicode("\u2206");
    }

    public void _ominus() {
        this.unicode("\u2296");
    }

    public void _times() {
        this.unicode("\u00d7");
    }

    public void _uplus() {
        this.unicode("\u228e");
    }

    public void _bigtriangledown() {
        this.unicode("\u2207");
    }

    public void _otimes() {
        this.unicode("\u2297");
    }

    public void _div() {
        this.unicode("\u00f7");
    }

    public void _sqcap() {
        this.unicode("\u2293");
    }

    public void _triangleleft() {
        this.unicode("\u22b2");
    }

    public void _oslash() {
        this.unicode("\u2298");
    }

    public void _ast() {
        this.unicode("\u2217");
    }

    public void _sqcup() {
        this.unicode("\u2294");
    }

    public void _triangleright() {
        this.unicode("\u22b3");
    }

    public void _odot() {
        this.unicode("\u2299");
    }

    public void _star() {
        this.unicode("\u22c6");
    }

    public void _vee() {
        this.unicode("\u2228");
    }

    public void _lhd() {
        this.unicode("\u22b2");
    }

    public void _bigcirc() {
        this.unicode("\u25cb");
    }

    public void _circ() {
        this.unicode("\u2218");
    }

    public void _wedge() {
        this.unicode("\u2227");
    }

    public void _rhd() {
        this.unicode("\u22b3");
    }

    public void _dagger() {
        this.unicode("\u2020");
    }

    public void _bullet() {
        this.unicode("\u2219");
    }

    public void _setminus() {
        this.unicode("\u2216");
    }

    public void _unlhd() {
        this.unicode("\u22b4");
    }

    public void _ddagger() {
        this.unicode("\u2021");
    }

    public void _cdot() {
        this.unicode("\u22c5");
    }

    public void _wr() {
        this.unicode("\u2240");
    }

    public void _unrhd() {
        this.unicode("\u22b5");
    }

    public void _amalg() {
        this.unicode("\u2210");
    }

    public void _leq() {
        this.unicode("\u2264");
    }

    public void _le() {
        this.unicode("\u2264");
    }

    public void _geq() {
        this.unicode("\u2265");
    }

    public void _equiv() {
        this.unicode("\u2261");
    }

    public void _models() {
        this.unicode("\u22a8");
    }

    public void _prec() {
        this.unicode("\u227a");
    }

    public void _succ() {
        this.unicode("\u227b");
    }

    public void _sim() {
        this.unicode("\u223c");
    }

    public void _perp() {
        this.unicode("\u22a5");
    }

    public void _preceq() {
        this.unicode("\u227c");
    }

    public void _succeq() {
        this.unicode("\u227d");
    }

    public void _simeq() {
        this.unicode("\u22d6");
    }

    public void _mid() {
        this.unicode("\u2223");
    }

    public void _ll() {
        this.unicode("\u00ab");
    }

    public void _gg() {
        this.unicode("\u00bb");
    }

    public void _asymp() {
        this.unicode("\u224d");
    }

    public void _parallel() {
        this.unicode("\u2225");
    }

    public void _subset() {
        this.unicode("\u2282");
    }

    public void _supset() {
        this.unicode("\u2283");
    }

    public void _approx() {
        this.unicode("\u2248");
    }

    public void _bowtie() {
        this.unicode("\u22c8");
    }

    public void _subseteq() {
        this.unicode("\u2286");
    }

    public void _supseteq() {
        this.unicode("\u2287");
    }

    public void _cong() {
        this.unicode("\u2245");
    }

    public void _Join() {
        this.unicode("\u22c8");
    }

    public void _sqsubset() {
        this.unicode("\u228f");
    }

    public void _sqsupset() {
        this.unicode("\u2290");
    }

    public void _neq() {
        this.unicode("\u2260");
    }

    public void _smile() {
        this.unicode("\u203f");
    }

    public void _sqsubseteq() {
        this.unicode("\u2291");
    }

    public void _sqsupseteq() {
        this.unicode("\u2292");
    }

    public void _doteq() {
        this.unicode("\u2250");
    }

    public void _frown() {
        this.unicode("\u2040");
    }

    public void _in() {
        this.unicode("\u2208");
    }

    public void _ni() {
        this.unicode("\u220b");
    }

    public void _propto() {
        this.unicode("\u221d");
    }

    public void _vdash() {
        this.unicode("\u22a2");
    }

    public void _dashv() {
        this.unicode("\u22a3");
    }

    public void _leftarrow() {
        this.unicode("\u2190");
    }

    public void _longleftarrow() {
        this.unicode("\u2190");
    }

    public void _uparrow() {
        this.unicode("\u2191");
    }

    public void _Leftarrow() {
        this.unicode("\u21d0");
    }

    public void _LongLeftarrow() {
        this.unicode("\u21d0");
    }

    public void _Uparrow() {
        this.unicode("\u21d1");
    }

    public void _rightarrow() {
        this.unicode("\u2192");
    }

    public void _longrightarrow() {
        this.unicode("\u2192");
    }

    public void _downarrow() {
        this.unicode("\u2193");
    }

    public void _Rightarrow() {
        this.unicode("\u21d2");
    }

    public void _Longrightarrow() {
        this.unicode("\u21d2");
    }

    public void _Downarrow() {
        this.unicode("\u21d3");
    }

    public void _leftrightarrow() {
        this.unicode("\u2194");
    }

    public void _longleftrightarrow() {
        this.unicode("\u2194");
    }

    public void _updownarrow() {
        this.unicode("\u2195");
    }

    public void _Leftrightarrow() {
        this.unicode("\u21d4");
    }

    public void _Longleftrightarrow() {
        this.unicode("\u21d4");
    }

    public void _Updownarrow() {
        this.unicode("\u21d5");
    }

    public void _mapsto() {
        this.unicode("\u21a6");
    }

    public void _longmapsto() {
        this.unicode("\u21a6");
    }

    public void _nearrow() {
        this.unicode("\u2197");
    }

    public void _hookleftarrow() {
        this.unicode("\u21a9");
    }

    public void _hookrightarrow() {
        this.unicode("\u21aa");
    }

    public void _searrow() {
        this.unicode("\u2198");
    }

    public void _leftharpoonup() {
        this.unicode("\u21bc");
    }

    public void _rightharpoonup() {
        this.unicode("\u21c0");
    }

    public void _swarrow() {
        this.unicode("\u2199");
    }

    public void _leftharpoondown() {
        this.unicode("\u21bd");
    }

    public void _rightharpoondown() {
        this.unicode("\u21c1");
    }

    public void _nwarrow() {
        this.unicode("\u2196");
    }

    public void _ldots() {
        this.unicode("\u2026");
    }

    public void _cdots() {
        this.unicode("\u22ef");
    }

    public void _vdots() {
        this.unicode("\u22ee");
    }

    public void _ddots() {
        this.unicode("\u22f1");
    }

    public void _aleph() {
        this.unicode("\u2135");
    }

    public void _prime() {
        this.unicode("\u2032");
    }

    public void _forall() {
        this.unicode("\u2200");
    }

    public void _infty() {
        this.unicode("\u221e");
    }

    public void _hbar() {
        this.unicode("\u210f");
    }

    public void _emptyset() {
        this.unicode("\u2205");
    }

    public void _exists() {
        this.unicode("\u2204");
    }

    public void _nabla() {
        this.unicode("\u2207");
    }

    public void _surd() {
        this.unicode("\u221a");
    }

    public void _Box() {
        this.unicode("\u25a1");
    }

    public void _triangle() {
        this.unicode("\u2206");
    }

    public void _Diamond() {
        this.unicode("\u25ca");
    }

    public void _imath() {
        this.unicode("i");
    }

    public void _jmath() {
        this.unicode("j");
    }

    public void _ell() {
        this.unicode("\u2113");
    }

    public void _neg() {
        this.unicode("\u00ac");
    }

    public void _top() {
        this.unicode("\u22a4");
    }

    public void _flat() {
        this.unicode("FIXME");
    }

    public void _natural() {
        this.unicode("FIXME");
    }

    public void _sharp() {
        this.unicode("FIXME");
    }

    public void _wp() {
        this.unicode("\u2118");
    }

    public void _bot() {
        this.unicode("\u22a5");
    }

    public void _clubsuit() {
        this.unicode("\u2663");
    }

    public void _diamondsuit() {
        this.unicode("\u2666");
    }

    public void _heartsuit() {
        this.unicode("\u2665");
    }

    public void _spadesuit() {
        this.unicode("\u2660");
    }

    public void _mho() {
        this.unicode("\u2127");
    }

    public void _Re() {
        this.unicode("\u211c");
    }

    public void _Im() {
        this.unicode("\u2111");
    }

    public void _angle() {
        this.unicode("\u2220");
    }

    public void _partial() {
        this.unicode("\u2202");
    }

    public void _sum() {
        this.unicode("\u2211");
    }

    public void _prod() {
        this.unicode("\u220f");
    }

    public void _coprod() {
        this.unicode("\u2210");
    }

    public void _int() {
        this.unicode("\u222b");
    }

    public void _oint() {
        this.unicode("\u222e");
    }

    public void _bigcap() {
        this.unicode("\u2229");
    }

    public void _bigcup() {
        this.unicode("\u222a");
    }

    public void _bigsqcup() {
        this.unicode("\u2294");
    }

    public void _bigvee() {
        this.unicode("\u2228");
    }

    public void _bigwedge() {
        this.unicode("\u2227");
    }

    public void _bigodot() {
        this.unicode("\u2299");
    }

    public void _bigotimes() {
        this.unicode("\u2297");
    }

    public void _bigoplus() {
        this.unicode("\u2295");
    }

    public void _biguplus() {
        this.unicode("\u228e");
    }

    public void _arccos() {
        this.mathfunction("arccos");
    }

    public void _arcsin() {
        this.mathfunction("arcsin");
    }

    public void _arctan() {
        this.mathfunction("arctan");
    }

    public void _arg() {
        this.mathfunction("arg");
    }

    public void _atan() {
        this.mathfunction("atan");
    }

    public void _cos() {
        this.mathfunction("cos");
    }

    public void _cosh() {
        this.mathfunction("cosh");
    }

    public void _cot() {
        this.mathfunction("cot");
    }

    public void _coth() {
        this.mathfunction("coth");
    }

    public void _csc() {
        this.mathfunction("csc");
    }

    public void _deg() {
        this.mathfunction("deg");
    }

    public void _det() {
        this.mathfunction("det");
    }

    public void _dim() {
        this.mathfunction("dim");
    }

    public void _exp() {
        this.mathfunction("exp");
    }

    public void _gcd() {
        this.mathfunction("gcd");
    }

    public void _hom() {
        this.mathfunction("hom");
    }

    public void _inf() {
        this.mathfunction("inf");
    }

    public void _ker() {
        this.mathfunction("ker");
    }

    public void _lg() {
        this.mathfunction("lg");
    }

    public void _lim() {
        this.mathfunction("lim");
    }

    public void _liminf() {
        this.mathfunction("liminf");
    }

    public void _limsup() {
        this.mathfunction("limsup");
    }

    public void _ln() {
        this.mathfunction("ln");
    }

    public void _log() {
        this.mathfunction("log");
    }

    public void _max() {
        this.mathfunction("max");
    }

    public void _min() {
        this.mathfunction("min");
    }

    public void _Pr() {
        this.mathfunction("Pr");
    }

    public void _sec() {
        this.mathfunction("sec");
    }

    public void _sin() {
        this.mathfunction("sin");
    }

    public void _sinh() {
        this.mathfunction("sinh");
    }

    public void _sup() {
        this.mathfunction("sup");
    }

    public void _tan() {
        this.mathfunction("tan");
    }

    public void _tanh() {
        this.mathfunction("tanh");
    }

    public void _lfloor() {
        this.unicode("FIXME");
    }

    public void _rfloor() {
        this.unicode("FIXME");
    }

    public void _lceil() {
        this.unicode("\u02e5");
    }

    public void _rceil() {
        this.unicode("\u02e9");
    }

    public void _langle() {
        this.unicode("FIXME");
    }

    public void _rangle() {
        this.unicode("FIXME");
    }

    public void _slash() {
        this.unicode("/");
    }

    public void _dverticalbar() {
        this.unicode("\u2225");
    }

    public void _rmoustache() {
        this.unicode("FIXME");
    }

    public void _lmoustache() {
        this.unicode("FIXME");
    }

    public void _rgroup() {
        this.unicode("FIXME");
    }

    public void _lgroup() {
        this.unicode("FIXME");
    }

    public void _arrowvert() {
        this.unicode("FIXME");
    }

    public void _Arrowvert() {
        this.unicode("FIXME");
    }

    public void _bracevert() {
        this.unicode("FIXME");
    }

    public void _widetilde() {
        this.FIXME("widetilde#1");
    }

    public void _widehat() {
        this.FIXME("widehat#1");
    }

    public void _overleftarrow() {
        this.FIXME("overleftarrow#1");
    }

    public void _overrightarrow() {
        this.FIXME("overrightarrow#1");
    }

    public void _overline() {
        this.FIXME("overline#1");
    }

    public void _underline() {
        this.FIXME("underline#1");
    }

    public void _overbrace() {
        this.FIXME("overbrace#1");
    }

    public void _underbrace() {
        this.FIXME("underbrace#1");
    }

    public void _sqrt() {
        this.FIXME("sqrt#1");
    }

    public void _sqrtn() {
        this.FIXME("sqrtn#1");
    }

    public void _digamma() {
        this.unicode("F");
    }

    public void _beth() {
        this.unicode("\u2136");
    }

    public void _daleth() {
        this.unicode("\u2138");
    }

    public void _gimel() {
        this.unicode("\u2137");
    }

    public void _looparrowleft() {
        this.unicode("\u21ab");
    }

    public void _looparrowright() {
        this.unicode("\u21ac");
    }

    public void _leftrightsquigarrow() {
        this.unicode("\u21ad");
    }

    public void _circlearrowleft() {
        this.unicode("\u21ba");
    }

    public void _circlearrowright() {
        this.unicode("\u21bb");
    }

    public void _nleftarrow() {
        this.unicode("\u219a");
    }

    public void _nrightarrow() {
        this.unicode("\u219b");
    }

    public void _nleftrightarrow() {
        this.unicode("\u21ae");
    }

    public void _nLeftarrow() {
        this.unicode("\u21cd");
    }

    public void _nLeftrightarrow() {
        this.unicode("\u21ce");
    }

    public void _nRightarrow() {
        this.unicode("\u21cf");
    }

    public void _define() {
        this.unicode("\u225d");
    }

    public void _lll() {
        this.unicode("\u22d8");
    }

    public void _ggg() {
        this.unicode("\u22d9");
    }

    public void _cdotvar() {
        this.unicode("\u00b7");
    }

    public void _minus() {
        this.unicode("\u2212");
    }

    public void _euro() {
        this.unicode("\u20ac");
    }

    public void _pound() {
        this.unicode("\u20a4");
    }

    public void _pts() {
        this.unicode("\u20a7");
    }

    public void _percent() {
        this.unicode("%");
    }

    public void _promille() {
        this.unicode("\u2030");
    }

    public void _copyright() {
        this.unicode("\u00a9");
    }

    public void _paragraph() {
        this.unicode("\u00b6");
    }

    public void _degrees() {
        this.unicode("\u00b0");
    }

    public void _setZ() {
        this.unicode("\u2124");
    }

    public void _setN() {
        this.unicode("\u2115");
    }

    public void _setR() {
        this.unicode("\u211d");
    }

    public void _celsius() {
        this.unicode("\u2103");
    }

    public void _fahrenheit() {
        this.unicode("\u2109");
    }

    public void _complement() {
        this.unicode("\u2201");
    }

    public void _nexists() {
        this.unicode("\u2204");
    }

    public void _varnothing() {
        this.unicode("\u2205");
    }

    public void _notElementIn() {
        this.unicode("\u2209");
    }

    public void _mathEpsilon() {
        this.unicode("\u220a");
    }

    public void _square() {
        this.unicode("\u22a1");
    }

    public void _mathslash() {
        this.unicode("\u2215");
    }

    public void _root() {
        this.unicode("\u221a");
    }

    public void _cubicroot() {
        this.unicode("\u221b");
    }

    public void _fourthroot() {
        this.unicode("\u221c");
    }

    public void _varpropto() {
        this.unicode("\u221d");
    }

    public void _iint() {
        this.unicode("\u222c");
    }

    public void _iiint() {
        this.unicode("\u222d");
    }

    public void _telephone() {
        this.unicode("\u260e");
    }

    public void _smiley() {
        this.unicode("\u263a");
    }

    public void _smileyblack() {
        this.unicode("\u263b");
    }

    public void _male() {
        this.unicode("\u2642");
    }

    public void _female() {
        this.unicode("\u2640");
    }

    public void _thinspace() {
        SimpleLatexParser simpleLatexParser = this;
        if (simpleLatexParser == null) {
            throw null;
        }
        Box box = simpleLatexParser.new Box();
        box.setW(5);
        this.append(box);
    }

    public void _qquad() {
    }

    public void _emspace() {
        SimpleLatexParser simpleLatexParser = this;
        if (simpleLatexParser == null) {
            throw null;
        }
        CharBox charBox = simpleLatexParser.new CharBox("M", this.fontIndex, this.ptSize, this.colorIndex);
        charBox.measure();
        SimpleLatexParser simpleLatexParser2 = this;
        if (simpleLatexParser2 == null) {
            throw null;
        }
        Box box = simpleLatexParser2.new Box();
        box.setW(charBox.getW());
        this.append(box);
    }

    void greek(String string) {
        SimpleLatexParser.msg("XXX: greek: " + string + " " + this.mathSymbolFontIndex);
        SimpleLatexParser simpleLatexParser = this;
        if (simpleLatexParser == null) {
            throw null;
        }
        this.append(simpleLatexParser.new CharBox(string, this.mathGreekFontIndex, this.ptSize, this.colorIndex));
    }

    void unicode(String string) {
        SimpleLatexParser.msg("XXX: unicode: " + string + " " + this.mathSymbolFontIndex);
        SimpleLatexParser simpleLatexParser = this;
        if (simpleLatexParser == null) {
            throw null;
        }
        this.append(simpleLatexParser.new CharBox(string, this.mathSymbolFontIndex, this.ptSize, this.colorIndex));
    }

    void mathfunction(String string) {
        int n = this.fontIndex & 0xFC;
        SimpleLatexParser simpleLatexParser = this;
        if (simpleLatexParser == null) {
            throw null;
        }
        this.append(simpleLatexParser.new CharBox(string, n, this.ptSize, this.colorIndex));
    }

    void space(int n) {
        SimpleLatexParser simpleLatexParser = this;
        if (simpleLatexParser == null) {
            throw null;
        }
        Box box = simpleLatexParser.new Box();
        box.setW(n);
        this.append(box);
    }

    void writeFigHeader(PrintStream printStream) {
        printStream.println("#FIG 3.2");
        printStream.println("Portrait");
        printStream.println("Center");
        printStream.println("Metric");
        printStream.println("A4");
        printStream.println("100.0");
        printStream.println("Single");
        printStream.println("-2");
        printStream.println("1200 2");
    }

    public void setFontIndex(int n) {
        this.fontIndex = n;
    }

    public void setFontPtSize(int n) {
        this.ptSize = n;
    }

    public void setColorIndex(int n) {
        this.colorIndex = n;
    }

    public void parse(String string) {
        this.tokenize(string);
        if (this.dump_tokens) {
            System.out.println("tokens for input:\n" + string);
            this.dumpTokens();
            System.out.println();
            System.out.println();
        }
    }

    public void convertToFig(FigCompound figCompound) {
        Box box = this.buildBox();
        box.convertToFig(figCompound);
    }

    public void selftest(String string) {
        this.parse(string);
        Box box = this.buildBox();
        if (this.debug) {
            box.dump(System.out);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("hugo" + ++count + ".fig");
            FigCompound figCompound = new FigCompound();
            figCompound.setTrafo(new FigTrafo2D());
            box.convertToFig(figCompound);
            figCompound.update_bbox();
            FigWriter figWriter = new FigWriter();
            FigObjectList figObjectList = new FigObjectList();
            figObjectList.insert(figCompound);
            figWriter.write_fig31_file(new DataOutputStream(fileOutputStream), true, figObjectList);
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setEnableDisplayBoxes(boolean bl) {
        this.display_boxes = bl;
    }

    public void setEnableDumpTokens(boolean bl) {
        this.dump_tokens = bl;
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void usage() {
        SimpleLatexParser.msg("java jfig.utils.SimpleLatexParser [options]");
        SimpleLatexParser.msg("where options include: ");
        SimpleLatexParser.msg("-help               - this message ");
        SimpleLatexParser.msg("-debug              - lots of diagnostic output");
        SimpleLatexParser.msg("-tokens             - dump tokens to stdout");
        SimpleLatexParser.msg("-boxes              - display the box outlines");
        SimpleLatexParser.msg("-italic <value>     - add <value> pts after italic chars");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        SimpleLatexParser simpleLatexParser = new SimpleLatexParser();
        int n = 0;
        while (n < stringArray.length) {
            if ("-tokens".equals(stringArray[n])) {
                simpleLatexParser.dump_tokens = true;
            }
            if ("-boxes".equals(stringArray[n])) {
                simpleLatexParser.display_boxes = true;
            }
            if ("-debug".equals(stringArray[n])) {
                simpleLatexParser.debug = true;
            }
            if ("-italic".equals(stringArray[n])) {
                simpleLatexParser.italic_correction = Integer.parseInt(stringArray[n + 1]);
            }
            if ("-help".equals(stringArray[n])) {
                SimpleLatexParser.usage();
            }
            ++n;
        }
        simpleLatexParser.setFontIndex(0);
        simpleLatexParser.setFontPtSize(27);
        simpleLatexParser.selftest("Und es begab sich zu der Zeit, da Cyrhenius Landpfleger...");
        simpleLatexParser.selftest("Black, {\\red red}, {\\gold gold}, {\\green green}, {\\blue blue {\\black black inside} blue}!");
        simpleLatexParser.selftest("Short Commands, \\$ \\% \\\" aou\"a\"o\"uAOU\"A\"O\"Us\"s!");
        simpleLatexParser.selftest("Text und {\\tt Code mit {\\itt kursivem} Argument.}");
        simpleLatexParser.selftest("Das {\\bf Theorem} von {\\em Archimedes}.");
        simpleLatexParser.selftest("{\\em\\red hendrich\\thinspace}{\\black \\atsign informatik.uni-hamburg.de}");
        simpleLatexParser.selftest("Normaler Text, {\\blue $w = \\sin ( \\alpha \\cdot \\pi /4 )$}");
        simpleLatexParser.selftest("{\\twentypt 20pt {\\fifteenpt 15pt }{\\twelvept 12pt }{\\tenpt 10pt }{\\eightpt 8pt }{\\fivept 5pt } and back to 20pt}");
        simpleLatexParser.selftest("Text mit Formel, {\\blue$w = \\sin( \\alpha\\cdot\\pi/4 )$}");
        simpleLatexParser.setFontIndex(16);
        simpleLatexParser.setFontPtSize(20);
        simpleLatexParser.selftest("Boole'sche Algebra: $a = b \\oplus c$ ");
        simpleLatexParser.selftest("\\lessthan X\\greaterthan \\equals\\backslash\\$\\lbrace\\lbracket X\\rbracket\\rbrace X");
        simpleLatexParser.selftest("M\\emspace M $\\black\\clubsuit\\spadesuit {\\red\\heartsuit{}\\diamondsuit}$ \\telephone\\male\\ \\ \\female 42.59\\ \\euro, 15\\thinspace\\pound, 22.000\\thinspace\\pts");
        simpleLatexParser.setFontIndex(0);
        simpleLatexParser.setFontPtSize(30);
        simpleLatexParser.selftest("{\\darkgreen Pythagoras:} $a^{2} + b^{2} = c^{2}$");
        simpleLatexParser.selftest("$\\cos^{2}(x) + \\sin^{2}(x) = 1$");
        simpleLatexParser.selftest("{\\darkblue Euler formula:  $\\exp (i \\pi ) + 1 = 0$}");
        simpleLatexParser.selftest("{\\darkblue Euler formula:  $e^{\\thinspace i \\pi} + 1 = 0$}");
        simpleLatexParser.selftest("AbCdE: \\int $X_{j=3}^{2} \\cdot dx = 42.0$");
        simpleLatexParser.selftest("Formel1: $X_{i} = \\sum_{i=1}^{N_{0}} \\phi  \\xi  \\cdot 3$");
        simpleLatexParser.selftest("$\\prod_{i} \\sum_{j} \\Gamma_{\\Xi_{\\mu}} \\Rightarrow \\setZ \\bullet (TeX \\mp Word)$");
        simpleLatexParser.selftest("Hopfield-Dynamik: $S_{i} (t+1) = (1/N) \\ {\\fourtypt\\sum}_{j}\\  J_{ij}\\cdot S_{j} (t)$");
        simpleLatexParser.selftest("Hopfield-Lernen: $J_{ij} = (1/N) \\sum_{\\mu} \\xi_{i}^{\\mu} \\xi_{j}^{\\mu}$ ");
        simpleLatexParser.selftest("${\\fourtypt\\int}^{5}_{0}\\ (x^{2}) {\\rm d}x = 1/3 x^{3}{\\fourtypt |}_{0}^{5} = (125/3) $");
        simpleLatexParser.selftest("$\\int^{3}_{x=0} a$");
        simpleLatexParser.selftest("IEEE 754: $value = (-1)^{s} \\cdot\\ 2^{exp-127} \\cdot\\ (1 + mantisse^{-23})$ ");
        simpleLatexParser.selftest("Text (in) [Klammern] \\{und\\} mit\\_unterstrich");
        simpleLatexParser.selftest("For all $x: f(x) = g(x+1)$");
        simpleLatexParser.selftest("Preparing an input file: ");
        simpleLatexParser.selftest("abcde fghij klmno pqrst uvwxy z");
        simpleLatexParser.selftest("ABCDE FGHIJ KLMNO PQRST UVWXY Z");
        simpleLatexParser.selftest("01234 56789 .:;,?! '`()[] -/*+=@");
        simpleLatexParser.selftest("The Romans wrote I + I = II. Really!");
        simpleLatexParser.selftest("Beans (lima, etc.)\\ have vitamin B\\@.");
        simpleLatexParser.selftest("\\$ \\& \\% \\# \\_ \\{ \\} are easy to produce.");
        simpleLatexParser.selftest("This page was produced on \\today. (\\backslash today)");
        simpleLatexParser.selftest("The formula \\( x-3y = 7 \\) is easy to type.");
        simpleLatexParser.selftest("Does \\( x + y \\) always equals \\(x+y\\)?");
        simpleLatexParser.selftest("\\( a_{1} > x^{2n} / y^{2n} \\)");
        simpleLatexParser.selftest("This proves that \\( x' < x'' - y'_{3} < 10 x''' z \\).");
        simpleLatexParser.selftest("The formula \\( a<7 \\) is a noun in this sentence.");
        simpleLatexParser.selftest("Let $x$ be a prime such that $y>2x$.");
        simpleLatexParser.selftest("displayed equation: \\[ x' + y^{2} = z_{i}^{2} \\]");
        simpleLatexParser.selftest("{\\bf This is a bold type style.}");
        simpleLatexParser.selftest("{\\sf This is a sans serif type style.}");
        simpleLatexParser.selftest("{\\sl This is a slanted type style.}");
        simpleLatexParser.selftest("{\\sc This is a Small Caps type style.}");
        simpleLatexParser.selftest("{\\tt This is a typewriter type style.}");
        simpleLatexParser.selftest("\\`{o} \\'{o} \\^{o} \\\"{o} \\~{o} \\={o} \\.{o} \\v{o} \\H{o} \\t{oo} \\c{o} \\d{o} \\b{o}");
        simpleLatexParser.selftest("El se\\~{n}or est\\'{a} bien, gar\\c{c}on.");
        simpleLatexParser.selftest("\\'{E}l est\\'{a} aqu\\'{\\i}.");
        simpleLatexParser.selftest("\\dag \\ddag \\S \\P \\copyright \\pounds.");
        simpleLatexParser.selftest("\\oe \\OE \\ae \\AE \\aa \\AA \\o \\O \\l \\L \\ss ?' !'");
        simpleLatexParser.selftest("$x^{2y} x_{2y} x^{y^{2}} x^{y_{1}} x^{y}_{1} x_{1}^{y}$");
        simpleLatexParser.selftest("Multiplyling by $n/2$ gives \\( (m+n)/n \\).");
        simpleLatexParser.selftest("\\[ x = \\frac{y+z/2}{y^{2}+1} \\]");
        simpleLatexParser.selftest("\\[\\frac{x+y}{1 + \\frac{y}{z+1}}\\]");
        simpleLatexParser.selftest("in-text formula to produce a fraction like $\\frac{1}{2}$.");
        simpleLatexParser.selftest("Square root $\\sqrt{x+y}$ and an $n$th root \\sqrt[n]{2}$.");
        simpleLatexParser.selftest("A low ellipsis: $x_{1}, \\ldots ,x_{n}$.");
        simpleLatexParser.selftest("A centered ellipsis: $a + \\cdots + z$.");
        simpleLatexParser.selftest("Making Greek letters is as easy as $\\pi$ (or $\\Pi$).");
        System.exit(0);
    }

    class Box {
        protected int x;
        protected int y;
        protected int w;
        protected int a;
        protected int d;
        protected Box next;

        public void move(int n, int n2) {
            this.x += n;
            this.y += n2;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getW() {
            return this.w;
        }

        public int getA() {
            return this.a;
        }

        public int getD() {
            return this.d;
        }

        public void setX(int n) {
            this.x = n;
        }

        public void setY(int n) {
            this.y = n;
        }

        public void setW(int n) {
            this.w = n;
        }

        public void setA(int n) {
            this.a = n;
        }

        public void setD(int n) {
            this.d = n;
        }

        public Box getNextBox() {
            return this.next;
        }

        public void setNextBox(Box box) {
            this.next = box;
        }

        public void append(Box box) {
            this.measure();
            this.next = box;
            box.setOrigin(this.getAbutmentPoint());
        }

        public void measure() {
        }

        public Rectangle getBounds() {
            int n = Math.min(this.x, this.x + this.w);
            int n2 = Math.max(this.x, this.x + this.w) - n;
            return new Rectangle(n, this.y - this.a, n2, this.d + this.a);
        }

        public Point getAbutmentPoint() {
            return new Point(this.x + this.w, this.y);
        }

        public void setOrigin(Point point) {
            this.x = point.x;
            this.y = point.y;
            this.measure();
        }

        public String toString() {
            return this.getClass().getName() + "[(" + this.x + "," + this.y + ") " + this.w + " (" + this.a + "," + this.d + ")]";
        }

        public void dump(PrintStream printStream) {
            printStream.println(this.toString());
            if (this.getNextBox() != null) {
                this.getNextBox().dump(printStream);
            }
        }

        public void convertToFig(FigCompound figCompound) {
            if (SimpleLatexParser.this.display_boxes) {
                figCompound.fastAddMember(this.getFigRectangle(figCompound, ColorCache.RED, 190));
            }
            if (this.next != null) {
                this.next.convertToFig(figCompound);
            }
        }

        public FigRectangle getFigRectangle(FigCompound figCompound, int n, int n2) {
            Rectangle rectangle = this.getBounds();
            Point point = new Point(32 * rectangle.x, 32 * rectangle.y);
            Point point2 = new Point(32 * (rectangle.x + rectangle.width), 32 * (rectangle.y + rectangle.height));
            FigRectangle figRectangle = new FigRectangle();
            figRectangle.setPoints(new Point[]{point, point2});
            figRectangle.setTrafo(figCompound.getTrafo());
            figRectangle.setAttributes(new FigAttribs());
            figRectangle.setLineColor(SimpleLatexParser.this.colorCache.get(n));
            figRectangle.setFillColor(SimpleLatexParser.this.colorCache.get(n));
            figRectangle.getAttributes().currentLayer = n2;
            return figRectangle;
        }

        Box() {
        }
    }

    class SubSuperScriptBox
    extends Box {
        Box superscriptBox;
        Box subscriptBox;
        int sa;
        int sd;
        int ptSize;
        int fontIndex;

        public void measure() {
            FontMetrics fontMetrics = SimpleLatexParser.this.fontCache.getFontMetrics(this.fontIndex, this.ptSize);
            this.a = fontMetrics.getAscent();
            this.d = fontMetrics.getDescent();
            int n = this.getSubscriptPtSize();
            FontMetrics fontMetrics2 = SimpleLatexParser.this.fontCache.getFontMetrics(this.fontIndex, n);
            this.sa = fontMetrics2.getAscent();
            this.sd = fontMetrics2.getDescent();
            int n2 = 2 * this.sa + 2 * this.sd + this.sd;
            this.w = 0;
        }

        public Point getAbutmentPoint() {
            Box box = null;
            box = this.subscriptBox;
            Point point = new Point(0, 0);
            while (box != null) {
                point = box.getAbutmentPoint();
                box = box.getNextBox();
            }
            box = this.superscriptBox;
            Point point2 = new Point(0, 0);
            while (box != null) {
                point2 = box.getAbutmentPoint();
                box = box.getNextBox();
            }
            return new Point(Math.max(point.x, point2.x), this.y);
        }

        public int getSubscriptPtSize() {
            int n = 0;
            while (n < SimpleLatexParser.this.subscriptPtSizes.length) {
                if (SimpleLatexParser.this.subscriptPtSizes[n][0] >= this.ptSize) {
                    return SimpleLatexParser.this.subscriptPtSizes[n][1];
                }
                ++n;
            }
            return SimpleLatexParser.this.subscriptPtSizes[SimpleLatexParser.this.subscriptPtSizes.length - 1][1];
        }

        public Point getSuperscriptBasePoint() {
            int n = this.y - this.a + (this.a + this.d) / 2;
            int n2 = n - (2 * this.sa + 2 * this.sd + this.sd) / 2;
            return new Point(this.x, n2 + this.sa);
        }

        public Point getSubscriptBasePoint() {
            int n = this.y - this.a + (this.a + this.d) / 2;
            int n2 = n + (2 * this.sa + 2 * this.sd + this.sd) / 2;
            return new Point(this.x, n2 - this.sd);
        }

        public Box getSubscriptBox() {
            return this.subscriptBox;
        }

        public Box getSuperscriptBox() {
            return this.superscriptBox;
        }

        public void setSubscriptBox(Box box) {
            this.subscriptBox = box;
        }

        public void setSuperscriptBox(Box box) {
            this.superscriptBox = box;
        }

        public String toString() {
            String string = this.getClass().getName() + "[(" + this.x + "," + this.y + ") " + this.w + " (" + this.a + "," + this.d + ")]";
            String string2 = this.superscriptBox != null ? this.superscriptBox.toString() : "";
            String string3 = this.subscriptBox != null ? this.subscriptBox.toString() : "";
            return string + "\nsuperscript box:\n" + string2 + "\nsubscript box:" + string3 + "\n";
        }

        public void convertToFig(FigCompound figCompound) {
            if (SimpleLatexParser.this.display_boxes) {
                figCompound.fastAddMember(this.getFigRectangle(figCompound, ColorCache.GREEN, 195));
            }
            if (this.next != null) {
                this.next.convertToFig(figCompound);
            }
            if (this.superscriptBox != null) {
                this.superscriptBox.convertToFig(figCompound);
            }
            if (this.subscriptBox != null) {
                this.subscriptBox.convertToFig(figCompound);
            }
        }

        public SubSuperScriptBox(int n, int n2) {
            this.y = 0;
            this.x = 0;
            this.fontIndex = n;
            this.ptSize = n2;
            this.measure();
        }
    }

    class CharBox
    extends Box {
        protected int fontIndex;
        protected int ptSize;
        protected int colorIndex;
        protected String s;

        public void measure() {
            FontMetrics fontMetrics = SimpleLatexParser.this.fontCache.getFontMetrics(this.fontIndex, this.ptSize);
            this.a = fontMetrics.getAscent();
            this.d = fontMetrics.getDescent();
            this.w = fontMetrics.stringWidth(this.s);
        }

        public void append(Box box) {
            boolean bl;
            this.measure();
            this.next = box;
            Point point = this.getAbutmentPoint();
            boolean bl2 = (this.fontIndex & 1) != 0;
            boolean bl3 = bl = box instanceof CharBox && (((CharBox)box).fontIndex & 1) != 0;
            if (bl2 && !bl) {
                point.x += SimpleLatexParser.this.italic_correction;
            }
            box.setOrigin(point);
        }

        public String toString() {
            return this.getClass().getName() + "[(" + this.x + "," + this.y + ") " + this.w + " (" + this.a + "," + this.d + ")]" + "'" + this.s + "'";
        }

        public void convertToFig(FigCompound figCompound) {
            FigTrafo2D figTrafo2D = figCompound.getTrafo();
            FigAttribs figAttribs = new FigAttribs();
            Point point = new Point(32 * this.x, 32 * this.y);
            FigText figText = new FigText(point, this.s, figAttribs, figTrafo2D);
            figText.setFont(this.fontIndex);
            figText.setFontSize(this.ptSize);
            figText.setColor(SimpleLatexParser.this.colorCache.get(this.colorIndex));
            figCompound.fastAddMember(figText);
            if (SimpleLatexParser.this.display_boxes) {
                figCompound.fastAddMember(this.getFigRectangle(figCompound, ColorCache.BLUE, 200));
            }
            if (this.next != null) {
                this.next.convertToFig(figCompound);
            }
        }

        public CharBox(String string, int n, int n2, int n3) {
            this.y = 0;
            this.x = 0;
            this.s = string;
            this.fontIndex = n;
            this.colorIndex = n3;
            this.ptSize = n2;
            this.measure();
        }
    }
}

