/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class Pathname {
    static boolean debug = false;
    static String sep = File.separator;
    static String doubleDot = "..";

    public static String removeDoubleDots(String string) {
        if (string.indexOf(doubleDot) < 0) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, sep);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (debug) {
            Pathname.dumpTokens(vector);
        }
        int n = 0;
        while (n < vector.size()) {
            if (doubleDot.equals(vector.elementAt(n)) && n >= 1) {
                vector.removeElementAt(n);
                vector.removeElementAt(n - 1);
                n -= 2;
            }
            ++n;
        }
        if (debug) {
            Pathname.dumpTokens(vector);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith(sep)) {
            stringBuffer.append(sep);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            if (n2 > 0) {
                stringBuffer.append(sep);
            }
            stringBuffer.append(vector.elementAt(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String makeRelativePathname(String string, String string2) {
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, sep);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        stringTokenizer = new StringTokenizer(string2, sep);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray2[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        n2 = 0;
        while (n2 < stringArray.length && n2 < stringArray2.length && stringArray[n2].equals(stringArray2[n2])) {
            ++n2;
        }
        int n3 = stringArray2.length - n2;
        System.out.println("n= " + n2 + " p= " + n3);
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append("../");
            ++n4;
        }
        n4 = n2;
        while (n4 < stringArray.length) {
            stringBuffer.append(stringArray[n4]);
            if (n4 < stringArray.length - 1) {
                stringBuffer.append("/");
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    private static void dumpTokens(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            System.out.print(" " + vector.elementAt(n));
            ++n;
        }
        System.out.println();
    }

    private static void test(String string) {
        System.out.println(string);
        System.out.println(Pathname.removeDoubleDots(string));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            Pathname.test(stringArray[0]);
        }
        sep = "/";
        Pathname.test("/home/tech_1/hendrich/java/hades/../../cluj/cluj.jpt");
        sep = "\\";
        Pathname.test("C:\\users\\hendrich\\my documents\\..\\java\\..\\..\\hope.txt");
        sep = File.separator;
        String string = "/users/hugo/tmp/images/editor.gif";
        String string2 = "/users/hugo/presentations";
        System.out.println(string + " " + string2 + " " + Pathname.makeRelativePathname(string, string2));
        string2 = "/users/hugo/presentation/cluj99/final";
        System.out.println(string + " " + string2 + " " + Pathname.makeRelativePathname(string, string2));
        string2 = "/users/hugo/presentation/cluj99/final//";
        System.out.println(string + " " + string2 + " " + Pathname.makeRelativePathname(string, string2));
    }
}

