/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JMenuItem;

public class JRecentFileManager {
    public final int MAXCHARS;
    String[] filenames = null;
    JMenuItem[] menuItems = null;
    ActionListener target = null;

    public void clearAllEntries() {
        int n = 0;
        while (n < this.filenames.length) {
            this.filenames[n] = null;
            ++n;
        }
        if (this.menuItems != null) {
            n = 0;
            while (n < this.filenames.length) {
                this.menuItems[n].setText(this.getMenuItemLabel(n));
                ++n;
            }
        }
    }

    public int getSize() {
        return this.filenames.length;
    }

    public void setActionListener(ActionListener actionListener) {
    }

    public void add(File file) {
        try {
            this.add(file.getCanonicalPath());
        }
        catch (Exception exception) {
            this.add(file.getAbsolutePath());
        }
    }

    public void add(String string) {
        if (string == null) {
            return;
        }
        int n = this.filenames.length - 1;
        int n2 = 0;
        while (n2 < this.filenames.length) {
            if (string.equals(this.filenames[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        n2 = n;
        while (n2 > 0) {
            this.filenames[n2] = this.filenames[n2 - 1];
            --n2;
        }
        this.filenames[0] = string;
        this.updateMenuItems();
    }

    public void print() {
        System.out.println("JRecentFileManager contents: ");
        int n = 0;
        while (n < this.filenames.length) {
            System.out.println("" + this.filenames[n]);
            ++n;
        }
    }

    public String get(String string) {
        this.add(string);
        return this.filenames[0];
    }

    public String get(int n) {
        this.add(this.filenames[n]);
        return this.filenames[0];
    }

    public JMenuItem[] createMenuItems(ActionListener actionListener) {
        this.menuItems = new JMenuItem[this.filenames.length];
        int n = 0;
        while (n < this.filenames.length) {
            this.menuItems[n] = new JMenuItem();
            this.menuItems[n].setActionCommand("RecentFile" + n);
            this.menuItems[n].setText(this.getMenuItemLabel(n));
            if (actionListener != null) {
                this.menuItems[n].addActionListener(actionListener);
            }
            ++n;
        }
        return this.menuItems;
    }

    public void updateMenuItems() {
        if (this.menuItems == null) {
            return;
        }
        int n = 0;
        while (n < this.menuItems.length) {
            try {
                this.menuItems[n].setText(this.getMenuItemLabel(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public String getMenuItemLabel(int n) {
        if (n >= this.filenames.length) {
            return "out of bounds: " + n;
        }
        if (n < 0) {
            return "out of bounds: " + n;
        }
        String string = this.filenames[n];
        if (string == null) {
            return "" + n + ". ---";
        }
        if (string.length() <= 35) {
            return string;
        }
        int n2 = string.lastIndexOf(File.separator);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        if (string.length() <= 35) {
            return string;
        }
        return string.substring(0, 25) + "..." + string.substring(string.length() - 8);
    }

    public String get(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = 0;
        while (n < this.menuItems.length) {
            if (string.equals(this.menuItems[n].getActionCommand())) {
                return this.filenames[n];
            }
            ++n;
        }
        return null;
    }

    public void save(Properties properties) {
        int n = 0;
        while (n < this.filenames.length) {
            if (this.filenames[n] != null) {
                properties.put("RecentFile" + n, this.filenames[n]);
            }
            ++n;
        }
    }

    public void load(Properties properties) {
        int n = 0;
        while (n < this.filenames.length) {
            String string = "RecentFile" + n;
            String string2 = properties.getProperty(string);
            this.filenames[n] = string2 != null ? string2 : null;
            ++n;
        }
        this.updateMenuItems();
    }

    public void saveToFile(String string) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (Exception exception) {
            System.err.println("-I- could not save '" + string + "'");
            return;
        }
        try {
            Properties properties = new Properties();
            this.save(properties);
            properties.store(fileOutputStream, "JRecentFileManager");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("-E- " + exception);
            System.err.println("-E- JRecentFileManager.save '" + string + "'");
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public void loadFromFile(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (Exception exception) {
            System.err.println("-I- could not load '" + string + "'");
            return;
        }
        try {
            Properties properties = new Properties();
            properties.load(fileInputStream);
            this.load(properties);
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("-E- " + exception);
            System.err.println("-E- JRecentFileManager.loadFromFile '" + string + "'");
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("usage: java JRecentFileManager <n_tests>");
        JRecentFileManager jRecentFileManager = new JRecentFileManager(7);
        jRecentFileManager.loadFromFile("/tmp/hugo");
        int n = 0;
        while (n < Integer.parseInt(stringArray[0])) {
            String string;
            double d = Math.random();
            if (d > 0.7) {
                string = "file_" + (int)(100.0 * Math.random());
                System.out.println("...adding new entry: " + string);
                jRecentFileManager.add(string);
            } else if (d > 0.4) {
                int n2 = (int)((double)jRecentFileManager.getSize() * Math.random());
                System.out.println("...accessing index=" + n2);
                System.out.println("-->" + jRecentFileManager.get(n2));
            } else {
                string = "file_" + (int)(100.0 * Math.random());
                System.out.println("...accessing entry: " + string);
                System.out.println("-->" + jRecentFileManager.get(string));
            }
            jRecentFileManager.print();
            ++n;
        }
        jRecentFileManager.saveToFile("/tmp/hugo");
    }

    public JRecentFileManager() {
        this(4);
    }

    public JRecentFileManager(int n) {
        this.MAXCHARS = 35;
        this.filenames = new String[n];
        int n2 = 0;
        while (n2 < this.filenames.length) {
            this.filenames[n2] = null;
            ++n2;
        }
    }
}

