/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.io.File;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import jfig.utils.ShellSort;

public class FileTreeNode
extends DefaultMutableTreeNode {
    public static boolean debug = false;

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return ((File)this.getUserObject()).getName();
    }

    public String getFilePath() {
        return ((File)this.getUserObject()).getPath();
    }

    public void addSORTED(FileTreeNode fileTreeNode) {
        if (fileTreeNode == null) {
            return;
        }
        if (this.children == null) {
            super.add(fileTreeNode);
            return;
        }
        File file = (File)fileTreeNode.getUserObject();
        boolean bl = file.isDirectory();
        String string = file.getName();
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            FileTreeNode fileTreeNode2 = (FileTreeNode)this.getChildAt(n2);
            File file2 = (File)fileTreeNode2.getUserObject();
            String string2 = file2.getName();
            int n3 = string.compareTo(string2);
            if (n3 <= 0) {
                this.children.insertElementAt(fileTreeNode, n2);
                break;
            }
            if (n2 == n - 1) {
                this.children.addElement(fileTreeNode);
            }
            ++n2;
        }
    }

    public static boolean traverseFileSystem(FileTreeNode fileTreeNode) {
        boolean bl;
        block15: {
            File file;
            bl = false;
            if (debug) {
                System.out.println("\ntraverseFileSystem: " + fileTreeNode);
            }
            if ((file = (File)fileTreeNode.getUserObject()).isDirectory()) {
                try {
                    String[] stringArray = file.list();
                    if (stringArray != null) {
                        ShellSort.shellSort(stringArray);
                    }
                    int n = 0;
                    while (n < stringArray.length) {
                        File file2 = new File(file, stringArray[n]);
                        FileTreeNode fileTreeNode2 = new FileTreeNode(file2);
                        if (file2.isDirectory()) {
                            boolean bl2;
                            if (debug) {
                                System.out.println("...traversing: " + file2);
                            }
                            if (bl2 = FileTreeNode.traverseFileSystem(fileTreeNode2)) {
                                fileTreeNode.add(fileTreeNode2);
                                bl = true;
                            }
                        } else if (FileTreeNode.isFigFile(file2)) {
                            if (debug) {
                                System.out.println("...adding: " + file2);
                            }
                            fileTreeNode.add(fileTreeNode2);
                            bl = true;
                        } else if (debug) {
                            System.out.println("...ignoring: " + file2);
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    if (debug) {
                        System.out.println("-E- FileTreeNode.traverseFS:" + exception);
                    }
                    if (!debug) break block15;
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    public static boolean isFigFile(File file) {
        return file.getName().toLowerCase().endsWith(".fig");
    }

    public static void main(String[] stringArray) {
        FileTreeNode fileTreeNode = new FileTreeNode(new File("."));
        FileTreeNode.traverseFileSystem(fileTreeNode);
        System.out.println(fileTreeNode.toString());
        JTree jTree = new JTree(fileTreeNode);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        JFrame jFrame = new JFrame();
        jFrame.setSize(300, 500);
        jFrame.getContentPane().add("Center", jScrollPane);
        jFrame.show();
    }

    public FileTreeNode(File file) {
        super(file);
    }
}

