/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Vector;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;

public class LineWrapper {
    Point[] wcp;
    int[] sx;
    int[] sy;
    Polygon[] polygons;
    Polygon[] fillers;
    FigObject parent;
    FigTrafo2D trafo;
    FigAttribs attribs;
    boolean is_closed;
    Point[][] dashes;
    boolean pen_down = true;
    long timestamp;
    boolean graphicsWasTranslated = false;
    Point anchor;
    Point old_anchor;
    int dx;
    int dy;
    boolean debug = false;
    int visible_linewidth;
    int[] xp;
    int[] yp;
    int np;
    int[] xf;
    int[] yf;
    Point wp;
    Point sp;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void set_debug() {
        this.debug = true;
    }

    public void reset_debug() {
        this.debug = false;
    }

    public int[] getScreenPointsX() {
        if (this.timestamp <= this.trafo.getTimestamp()) {
            this.buildScreenPoints();
            this.timestamp = System.currentTimeMillis();
        }
        return this.sx;
    }

    public int[] getScreenPointsY() {
        if (this.timestamp <= this.trafo.getTimestamp()) {
            this.buildScreenPoints();
            this.timestamp = System.currentTimeMillis();
        }
        return this.sy;
    }

    private void buildPolygons() {
        if (this.debug) {
            System.out.println("LineWrapper.buildPolygons...");
        }
        this.polygons = this.is_closed ? new Polygon[this.wcp.length] : new Polygon[this.wcp.length - 1];
        int n = 0;
        while (n < this.wcp.length - 1) {
            this.build_segment(n, this.wcp[n + 1], this.wcp[n]);
            this.polygons[n] = new Polygon(this.xp, this.yp, this.np);
            ++n;
        }
        if (this.is_closed) {
            this.build_segment(this.wcp.length, this.wcp[0], this.wcp[this.wcp.length - 1]);
            this.polygons[this.wcp.length - 1] = new Polygon(this.xp, this.yp, this.np);
        }
        this.build_fillers();
        if (this.debug) {
            n = 0;
            while (n < this.polygons.length) {
                System.out.println("LineWrapper.buildPolygons() ok: " + this.polygons[n].toString());
                int n2 = 0;
                while (n2 < this.xp.length) {
                    System.out.println(" i,xi,yi: " + n2 + " " + this.polygons[n].xpoints[n2] + " " + this.polygons[n].ypoints[n2]);
                    ++n2;
                }
                ++n;
            }
        }
    }

    private void build_segment(int n, Point point, Point point2) {
        double d = point.x - point2.x;
        double d2 = point.y - point2.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        double d4 = -d2 / d3 * 0.5 * this.attribs.lineWidth;
        double d5 = d / d3 * 0.5 * this.attribs.lineWidth;
        double d6 = (double)point2.x - d4;
        double d7 = (double)point2.y - d5;
        this.sp = this.trafo.wc_to_screen(d6, d7, this.sp);
        this.xp[0] = this.sp.x;
        this.yp[0] = this.sp.y;
        d6 = (double)point.x - d4;
        d7 = (double)point.y - d5;
        this.sp = this.trafo.wc_to_screen(d6, d7, this.sp);
        this.xp[1] = this.sp.x;
        this.yp[1] = this.sp.y;
        d6 = (double)point.x + d4;
        d7 = (double)point.y + d5;
        this.sp = this.trafo.wc_to_screen(d6, d7, this.sp);
        this.xp[2] = this.sp.x;
        this.yp[2] = this.sp.y;
        d6 = (double)point2.x + d4;
        d7 = (double)point2.y + d5;
        this.sp = this.trafo.wc_to_screen(d6, d7, this.sp);
        this.xp[3] = this.sp.x;
        this.yp[3] = this.sp.y;
        this.xp[4] = this.xp[0];
        this.yp[4] = this.yp[0];
    }

    private void build_segment_old(int n, Point point, Point point2) {
        double d = point.x - point2.x;
        double d2 = point.y - point2.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        double d4 = -d2 / d3 * 0.5 * this.attribs.lineWidth;
        double d5 = d / d3 * 0.5 * this.attribs.lineWidth;
        this.wp.x = (int)((double)point2.x - d4 + 0.5);
        this.wp.y = (int)((double)point2.y - d5 + 0.5);
        this.sp = this.trafo.wc_to_screen(this.wp, this.sp);
        this.xp[0] = this.sp.x;
        this.yp[0] = this.sp.y;
        this.wp.x = (int)((double)point.x - d4 + 0.5);
        this.wp.y = (int)((double)point.y - d5 + 0.5);
        this.sp = this.trafo.wc_to_screen(this.wp, this.sp);
        this.xp[1] = this.sp.x;
        this.yp[1] = this.sp.y;
        this.wp.x = (int)((double)point.x + d4 + 0.5);
        this.wp.y = (int)((double)point.y + d5 + 0.5);
        this.sp = this.trafo.wc_to_screen(this.wp, this.sp);
        this.xp[2] = this.sp.x;
        this.yp[2] = this.sp.y;
        this.wp.x = (int)((double)point2.x + d4 + 0.5);
        this.wp.y = (int)((double)point2.y + d5 + 0.5);
        this.sp = this.trafo.wc_to_screen(this.wp, this.sp);
        this.xp[3] = this.sp.x;
        this.yp[3] = this.sp.y;
        this.xp[4] = this.xp[0];
        this.yp[4] = this.yp[0];
    }

    void build_fillers() {
        int[] nArray;
        int[] nArray2;
        if (this.wcp == null) {
            return;
        }
        if (this.is_closed && this.wcp.length >= 3) {
            this.fillers = new Polygon[this.wcp.length];
        } else if (this.wcp.length >= 3) {
            this.fillers = new Polygon[this.wcp.length - 2];
        } else {
            this.fillers = null;
            return;
        }
        int n = this.is_closed ? this.wcp.length - 1 : this.wcp.length - 2;
        int n2 = 0;
        while (n2 < n) {
            nArray2 = this.polygons[n2].xpoints;
            nArray = this.polygons[n2].ypoints;
            this.xf[0] = nArray2[1];
            this.yf[0] = nArray[1];
            this.xf[1] = nArray2[2];
            this.yf[1] = nArray[2];
            nArray2 = this.polygons[n2 + 1].xpoints;
            nArray = this.polygons[n2 + 1].ypoints;
            this.xf[2] = nArray2[3];
            this.yf[2] = nArray[3];
            this.xf[3] = nArray2[4];
            this.yf[3] = nArray[4];
            this.xf[4] = this.xf[0];
            this.yf[4] = this.yf[0];
            this.fillers[n2] = new Polygon(this.xf, this.yf, 5);
            ++n2;
        }
        if (this.is_closed) {
            nArray2 = this.polygons[this.wcp.length - 1].xpoints;
            nArray = this.polygons[this.wcp.length - 1].ypoints;
            this.xf[0] = nArray2[1];
            this.yf[0] = nArray[1];
            this.xf[1] = nArray2[2];
            this.yf[1] = nArray[2];
            nArray2 = this.polygons[0].xpoints;
            nArray = this.polygons[0].ypoints;
            this.xf[2] = nArray2[3];
            this.yf[2] = nArray[3];
            this.xf[3] = nArray2[4];
            this.yf[3] = nArray[4];
            this.xf[4] = this.xf[0];
            this.yf[4] = this.yf[0];
            this.fillers[this.wcp.length - 1] = new Polygon(this.xf, this.yf, 5);
        }
    }

    public void buildScreenPoints() {
        this.visible_linewidth = (int)(60.0 / this.trafo.getZoom());
        int n = 0;
        while (n < this.wcp.length) {
            this.sx[n] = this.trafo.wc_to_screen_x(this.wcp[n].x);
            this.sy[n] = this.trafo.wc_to_screen_y(this.wcp[n].y);
            ++n;
        }
        if (this.is_closed) {
            this.sx[this.wcp.length] = this.trafo.wc_to_screen_x(this.wcp[0].x);
            this.sy[this.wcp.length] = this.trafo.wc_to_screen_y(this.wcp[0].y);
        }
        if (this.debug) {
            n = 0;
            while (n < this.wcp.length) {
                System.out.println("LineWrapper: wcp[" + n + "]: " + this.wcp[n].toString() + " scp[" + this.sx[n] + "," + this.sy[n] + "]");
                ++n;
            }
        }
        if (this.attribs.lineStyle != 0) {
            this.buildDashes();
        }
    }

    void buildDashes() {
        if (this.debug) {
            System.out.println("LineWrapper.buildDashes()...");
        }
        if (this.wcp == null | this.wcp.length < 2) {
            return;
        }
        Vector vector = new Vector();
        double d = 0.0;
        this.pen_down = true;
        int n = 0;
        while (n < this.wcp.length - 1) {
            d = this.build_dashes_segment(vector, this.wcp[n], this.wcp[n + 1], d);
            ++n;
        }
        if (this.is_closed) {
            d = this.build_dashes_segment(vector, this.wcp[this.wcp.length - 1], this.wcp[0], d);
        }
        this.dashes = new Point[vector.size()][];
        Point[] pointArray = new Point[2];
        int n2 = 0;
        while (n2 < vector.size()) {
            pointArray = (Point[])vector.elementAt(n2);
            Point point = new Point(0, 0);
            Point point2 = new Point(0, 0);
            point = this.trafo.wc_to_screen(pointArray[0], point);
            point2 = this.trafo.wc_to_screen(pointArray[1], point2);
            Point[] pointArray2 = new Point[]{point, point2};
            this.dashes[n2] = pointArray2;
            ++n2;
        }
    }

    double build_dashes_segment(Vector vector, Point point, Point point2, double d) {
        double d2;
        double d3;
        double d4;
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        double d5 = d4 = Math.sqrt(n * n + n2 * n2);
        if (this.attribs.lineStyle == 1) {
            d3 = Math.max(0.5 * this.attribs.dashLength, 100.0);
            d2 = Math.max(0.5 * this.attribs.dashLength, 100.0);
        } else {
            d3 = Math.max(this.attribs.lineWidth, 30.0);
            d2 = Math.max(this.attribs.dashLength - d3, 50.0);
        }
        Point point3 = point;
        int n3 = 0;
        while (d5 > 0.0) {
            Point[] pointArray;
            Point point4;
            if (++n3 > 500) {
                System.out.println("-W- internal problem in LineWrapper  watchdog limit reached in build_dashes_segment():  remaining_len=" + d5 + " missingLength=" + d + " dashLength=" + d3 + " gapLength=" + d2);
                break;
            }
            if (d < d5) {
                point4 = new Point(point3.x + (int)((double)n * (d / d4)), point3.y + (int)((double)n2 * (d / d4)));
                if (this.pen_down) {
                    pointArray = new Point[]{point3, point4};
                    vector.addElement(pointArray);
                    d5 -= d;
                    d = d2;
                    this.pen_down = false;
                    point3 = point4;
                    continue;
                }
                point3 = point4;
                d5 -= d;
                d = d3;
                this.pen_down = true;
                continue;
            }
            point4 = point2;
            n = point3.x - point2.x;
            n2 = point3.y - point2.y;
            d4 = Math.max(Math.sqrt(n * n + n2 * n2), 1.0);
            d -= d4;
            d5 = 0.0;
            if (!this.pen_down) continue;
            pointArray = new Point[]{point3, point4};
            vector.addElement(pointArray);
        }
        return d;
    }

    public void paintDashes(Graphics graphics) {
        if (this.dashes != null) {
            int n = 0;
            while (n < this.dashes.length) {
                Point point = this.dashes[n][0];
                Point point2 = this.dashes[n][1];
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                ++n;
            }
        }
    }

    public void paint(Graphics graphics) {
        this.paintAWT11(graphics);
    }

    public void paintAWT11(Graphics graphics) {
        block10: {
            block11: {
                block9: {
                    if (this.wcp.length < 2) {
                        return;
                    }
                    if (this.attribs.lineColor == null) {
                        return;
                    }
                    if (this.timestamp <= this.trafo.getTimestamp()) {
                        this.buildScreenPoints();
                        if (this.attribs.lineWidth > 0.0) {
                            this.buildPolygons();
                        }
                        this.timestamp = System.currentTimeMillis();
                    }
                    graphics.setColor(this.attribs.lineColor);
                    if (this.attribs.lineStyle == 0) break block9;
                    this.paintDashes(graphics);
                    break block10;
                }
                if (this.attribs.lineWidth != 0.0 && !(this.attribs.lineWidth < (double)this.visible_linewidth)) break block11;
                int n = this.sx.length - 1;
                while (n > 0) {
                    graphics.drawLine(this.sx[n], this.sy[n], this.sx[n - 1], this.sy[n - 1]);
                    --n;
                }
                break block10;
            }
            if (this.debug) {
                System.out.println("LineWrapper.paint(), fat line: ");
            }
            int n = this.polygons.length - 1;
            while (n >= 0) {
                if (this.debug) {
                    System.out.println("LineWrapper.polygon: " + this.polygons[n].toString());
                }
                graphics.fillPolygon(this.polygons[n]);
                --n;
            }
            if (this.fillers == null) break block10;
            n = this.fillers.length - 1;
            while (n >= 0) {
                graphics.fillPolygon(this.fillers[n]);
                --n;
            }
        }
    }

    public void message(String string) {
        System.err.println(string);
    }

    public LineWrapper(FigObject figObject, FigTrafo2D figTrafo2D, Point[] pointArray, boolean bl) {
        this.parent = figObject;
        this.attribs = figObject.getAttributes();
        this.trafo = figTrafo2D;
        this.wcp = pointArray;
        this.is_closed = bl;
        this.np = 5;
        this.xp = new int[this.np];
        this.yp = new int[this.np];
        this.xf = new int[5];
        this.yf = new int[5];
        this.wp = new Point(0, 0);
        this.sp = new Point(0, 0);
        if (this.attribs.lineWidth > 0.0) {
            this.buildPolygons();
        }
        if (this.is_closed) {
            this.sx = new int[pointArray.length + 1];
            this.sy = new int[pointArray.length + 1];
        } else {
            this.sx = new int[pointArray.length];
            this.sy = new int[pointArray.length];
        }
        int n = 0;
        while (n < this.sx.length) {
            this.sx[n] = 0;
            this.sy[n] = 0;
            ++n;
        }
        this.buildScreenPoints();
        this.timestamp = System.currentTimeMillis();
    }
}

