/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FillWrapper;
import jfig.objects.LineWrapper;

public class FigTrigger
extends FigBaseobject {
    LineWrapper wline;
    FillWrapper wfill;
    String basename;
    String filename;
    boolean visible = false;

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setLink(String string, String string2) {
        this.basename = string;
        this.filename = string2;
    }

    public String getLink() {
        return this.basename + this.filename;
    }

    public String getBasename() {
        return this.basename;
    }

    public String getFilename() {
        return this.filename;
    }

    void build_wline() {
        Point[] pointArray = new Point[]{new Point(this.bbox.getXl(), this.bbox.getYt()), new Point(this.bbox.getXr(), this.bbox.getYt()), new Point(this.bbox.getXr(), this.bbox.getYb()), new Point(this.bbox.getXl(), this.bbox.getYb())};
        this.wline = new LineWrapper(this, this.trafo, pointArray, true);
    }

    void build_wfill() {
        Point[] pointArray = new Point[]{new Point(this.bbox.getXl(), this.bbox.getYt()), new Point(this.bbox.getXr(), this.bbox.getYb())};
        this.wfill = new FillWrapper(this, this.trafo, pointArray);
    }

    public void setTrafo(FigTrafo2D figTrafo2D) {
        this.trafo = figTrafo2D;
        this.build_wline();
        this.build_wfill();
    }

    public Point[] getPoints() {
        Point[] pointArray = new Point[]{new Point(this.bbox.getXl(), this.bbox.getYt()), new Point(this.bbox.getXr(), this.bbox.getYb())};
        return pointArray;
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.wfill != null && this.attribs.fillColor != null) {
            this.wfill.paint(graphics);
        }
        if (this.wline != null && this.attribs.lineColor != null) {
            this.wline.paint(graphics);
        }
        if (this.filename != null) {
            graphics.setColor(Color.black);
            graphics.setFont(FigAttribs.defaultFont);
            graphics.drawString(this.filename, this.trafo.wc_to_screen_x(this.bbox.getXl()) + 1, this.trafo.wc_to_screen_y(this.bbox.getYb()) - 1);
        }
        super.paint(graphics);
    }

    public void setPoints(Point[] pointArray) {
        if (!this.visible) {
            return;
        }
        if (pointArray == null || pointArray.length < 2 || pointArray.length > 3) {
            System.err.println("-E- a trigger needs 2 Points for setPoints()");
            return;
        }
        this.bbox.set(pointArray[0].x, pointArray[0].y, pointArray[1].x, pointArray[1].y);
        this.build_wline();
        this.build_wfill();
        this.timestamp = 0L;
        super.build_sc_bbox();
    }

    public void update(FigAttribs figAttribs) {
        if (this.debug) {
            System.out.println("FigTrigger.update()...");
        }
        if (!this.visible) {
            return;
        }
        this.attribs.update(figAttribs);
        this.build_wline();
        this.build_wfill();
        this.timestamp = 0L;
        super.build_sc_bbox();
    }

    public FigObject copy() {
        if (this.debug) {
            System.out.println("FigTrigger.copy()...");
        }
        FigTrigger figTrigger = new FigTrigger(this.bbox.getXl(), this.bbox.getYt(), this.bbox.getXr(), this.bbox.getYb(), this.attribs.getClone(), this.trafo, this.basename, this.filename);
        figTrigger.visible = this.visible;
        return figTrigger;
    }

    public void move(int n, int n2) {
        if (this.debug) {
            System.out.println("FigTrigger.move( " + n + ", " + n2 + " ) ");
        }
        this.bbox = new FigBbox(this.bbox.getXl() + n, this.bbox.getYt() + n2, this.bbox.getXr() + n, this.bbox.getYb() + n2);
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        this.build_wline();
        this.build_wfill();
        super.build_sc_bbox();
    }

    public void mirrorX(int n, int n2) {
        block2: {
            block1: {
                if (!this.visible) {
                    return;
                }
                if (n != this.bbox.getXl()) break block1;
                this.move(-(this.bbox.getXr() - this.bbox.getXl()), 0);
                break block2;
            }
            if (n != this.bbox.getXr()) break block2;
            this.move(this.bbox.getXr() - this.bbox.getXl(), 0);
        }
    }

    public void mirrorY(int n, int n2) {
        block2: {
            block1: {
                if (!this.visible) {
                    return;
                }
                if (n2 != this.bbox.getYt()) break block1;
                this.move(0, -(this.bbox.getYb() - this.bbox.getYt()));
                break block2;
            }
            if (n2 != this.bbox.getYb()) break block2;
            this.move(0, this.bbox.getYb() - this.bbox.getYt());
        }
    }

    public boolean supportsPointOps() {
        return true;
    }

    public boolean isClosed() {
        return true;
    }

    public void appendPoint(Point point) {
    }

    public Point deletePoint(Point point) {
        return null;
    }

    public void insertPoint(Point point, Point point2) {
    }

    public Point[] getMovePointNeighbors(Point point) {
        int n = Math.abs(point.x - this.bbox.getXl()) < Math.abs(point.x - this.bbox.getXr()) ? this.bbox.getXr() : this.bbox.getXl();
        int n2 = Math.abs(point.y - this.bbox.getYt()) < Math.abs(point.y - this.bbox.getYb()) ? this.bbox.getYb() : this.bbox.getYt();
        Point point2 = new Point(n, n2);
        Point[] pointArray = new Point[]{point2};
        return pointArray;
    }

    public void movePoint(Point point, Point point2) {
        int n = Math.abs(point.x - this.bbox.getXl());
        int n2 = Math.abs(point.x - this.bbox.getXr());
        int n3 = Math.abs(point.y - this.bbox.getYt());
        int n4 = Math.abs(point.y - this.bbox.getYb());
        int n5 = n < n2 ? this.bbox.getXr() : this.bbox.getXl();
        int n6 = n3 < n4 ? this.bbox.getYb() : this.bbox.getYt();
        Point point3 = new Point(n5, n6);
        this.bbox.set(point2.x, point2.y, point3.x, point3.y);
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        this.build_wline();
        this.build_wfill();
        super.build_sc_bbox();
    }

    public Point getNearestPoint(Point point) {
        int n = Math.abs(point.x - this.bbox.getXl());
        int n2 = Math.abs(point.x - this.bbox.getXr());
        int n3 = Math.abs(point.y - this.bbox.getYt());
        int n4 = Math.abs(point.y - this.bbox.getYb());
        int n5 = n > n2 ? this.bbox.getXr() : this.bbox.getXl();
        int n6 = n3 > n4 ? this.bbox.getYb() : this.bbox.getYt();
        return new Point(n5, n6);
    }

    public Point[] getNeighborPoints(Point point) {
        Point[] pointArray = new Point[]{point, point, point};
        return pointArray;
    }

    public double minDistance(Point point) {
        int n = Math.min(Math.abs(point.x - this.bbox.getXl()), Math.abs(point.x - this.bbox.getXr()));
        int n2 = Math.min(Math.abs(point.y - this.bbox.getYt()), Math.abs(point.y - this.bbox.getYb()));
        return n + n2;
    }

    public String toString() {
        String string = "FigTrigger from (" + this.bbox.getXl() + ", " + this.bbox.getYt() + ") to (" + this.bbox.getXr() + ", " + this.bbox.getYb() + ") on layer (" + this.attribs.currentLayer + ") with colors " + this.attribs.fillColor.toString() + " basename '" + this.basename + "' filename '" + this.filename + "' ";
        return string;
    }

    public FigTrigger(int n, int n2, int n3, int n4) {
        int n5;
        if (n > n3) {
            n5 = n3;
            n3 = n;
            n = n5;
        }
        if (n2 > n4) {
            n5 = n4;
            n4 = n2;
            n2 = n5;
        }
        this.x = n;
        this.y = n2;
        this.attribs.currentLayer = 100;
        this.attribs.lineColor = ColorCache.getColorCache().get(4);
        this.attribs.fillColor = ColorCache.getColorCache().get(31);
        this.attribs.cornerRadius = 0;
        this.wline = null;
        this.wfill = null;
        this.bbox.set(n, n2, n3, n4);
        this.filename = null;
        this.basename = null;
    }

    public FigTrigger(FigBbox figBbox, int n) {
        this(figBbox.getXl(), figBbox.getYt(), figBbox.getXr(), figBbox.getYb());
        this.x = figBbox.getXl();
        this.y = figBbox.getYb();
        this.wline = null;
        this.wfill = null;
        this.filename = null;
        this.basename = null;
    }

    public FigTrigger(int n, int n2, int n3, int n4, FigAttribs figAttribs, FigTrafo2D figTrafo2D, String string, String string2) {
        this(n, n2, n3, n4);
        this.trafo = figTrafo2D;
        this.attribs = figAttribs.getClone();
        this.attribs.lineColor = ColorCache.getColorCache().get(4);
        this.attribs.fillColor = ColorCache.getColorCache().get(31);
        this.attribs.lineStyle = 0;
        this.attribs.lineWidth = 1.0;
        this.attribs.currentLayer = 100;
        this.attribs.cornerRadius = 0;
        this.attribs.cornerRadius = 0;
        this.basename = string;
        this.filename = string2;
        this.debug = false;
        this.build_wline();
        this.build_wfill();
    }
}

