/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.ObjectPainter;
import jfig.gui.ColorCache;
import jfig.gui.Console;
import jfig.gui.ConsoleMessage;
import jfig.gui.StatusMessage;
import jfig.objects.FigArc;
import jfig.objects.FigArrowParams;
import jfig.objects.FigAttribs;
import jfig.objects.FigBezier;
import jfig.objects.FigBezierXSpline;
import jfig.objects.FigCompound;
import jfig.objects.FigEllipse;
import jfig.objects.FigGeneralXSpline;
import jfig.objects.FigImage;
import jfig.objects.FigNormalXSpline;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.FigPolyline;
import jfig.objects.FigRectangle;
import jfig.objects.FigSpline;
import jfig.objects.FigText;
import jfig.objects.FigTrigger;
import jfig.objects.FigXSpline;
import jfig.utils.SetupManager;

public class FigParser
implements Runnable {
    boolean debug;
    boolean fastMessages = false;
    int n_errors = 0;
    int line_number = 0;
    ColorCache colorCache;
    int input_resolution = 2;
    int fig_version = 31;
    StatusMessage helper = null;
    ConsoleMessage printer = null;
    ObjectPainter painter = null;
    Vector actionListeners;
    String gl_filename = null;
    String gl_filetype = null;
    StringBuffer comment = null;
    boolean enableNonASCII = false;
    boolean enableMessages = false;
    String[] paperSizes = new String[]{"Letter", "Legal", "Ledger", "Tabloid", "A", "B", "C", "D", "E", "A4", "A3", "A2", "A1", "A0", "B5"};
    private int[] gl_xp;
    private int[] gl_yp;
    public boolean solaris_is_broken = false;
    int t_errors = 0;
    boolean t_top_level = false;
    boolean t_inside_compound = false;
    boolean t_merge = false;
    FigAttribs t_attribs = null;
    FigTrafo2D t_trafo = null;
    FigObjectList t_OL = null;
    Thread reader = null;
    InputStream t_f = null;
    private int n_messages = 0;

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.addElement(actionListener);
    }

    public void setFilenameAndType(String string, String string2) {
        this.gl_filename = string;
        this.gl_filetype = string2;
    }

    public void setObjectPainter(ObjectPainter objectPainter) {
        this.painter = objectPainter;
    }

    public void setStatusMessage(StatusMessage statusMessage) {
        this.helper = statusMessage;
    }

    public void setConsole(ConsoleMessage consoleMessage) {
        this.printer = consoleMessage;
    }

    public void set_debug() {
        this.debug = true;
    }

    public void reset_debug() {
        this.debug = false;
    }

    public void parse_jfig_trigger(BufferedReader bufferedReader, String string, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        if (this.debug) {
            this.message("FigParser: FigTrigger: " + string);
        }
        String string2 = null;
        int n = 0;
        int n2 = 0;
        String string3 = null;
        String string4 = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\t ");
            string2 = stringTokenizer.nextToken();
            n2 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            n = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n3 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n4 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n5 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n6 = this.fig_scale(Integer.parseInt(string2));
            string3 = stringTokenizer.nextToken();
            string4 = stringTokenizer.nextToken();
            if (string3.equals("\"\"")) {
                string3 = null;
            }
            if (string4.equals("\"\"")) {
                string4 = null;
            }
            FigTrigger figTrigger = new FigTrigger(n3, n4, n5, n6, figAttribs, figTrafo2D, string3, string4);
            figObjectList.insert(figTrigger);
            this.check_add_object_comment(figTrigger);
        }
        catch (NumberFormatException numberFormatException) {
            this.message("-E- Not a valid jfig trigger.");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
    }

    final int fig_scale(int n) {
        if (this.fig_version >= 30) {
            return n * this.input_resolution;
        }
        return (n + 1) * this.input_resolution;
    }

    final double fig_scale(double d) {
        return d * (double)this.input_resolution;
    }

    final double fig_arrow_scale(double d) {
        return d * (double)this.input_resolution;
    }

    final int fig_thickness(int n) {
        if (n <= 0) {
            return 0;
        }
        return n * 30;
    }

    final Color old_fig_color(int n) {
        Color color = null;
        switch (n) {
            case -1: {
                color = Color.black;
                break;
            }
            case 0: {
                color = Color.black;
                break;
            }
            case 1: {
                color = Color.blue;
                break;
            }
            case 2: {
                color = Color.green;
                break;
            }
            case 3: {
                color = Color.cyan;
                break;
            }
            case 4: {
                color = Color.red;
                break;
            }
            case 5: {
                color = Color.magenta;
                break;
            }
            case 6: {
                color = Color.yellow;
                break;
            }
            case 7: {
                color = Color.white;
                break;
            }
            default: {
                color = Color.orange;
                break;
            }
        }
        if (color == null) {
            this.message("FigParser: fig_color broken...");
        }
        return color;
    }

    final Color fig_color(int n) {
        Color color = null;
        color = this.colorCache.get(n);
        if (color != null) {
            return color;
        }
        this.message("-E- Internal error (unknown color, index=" + n + "), substituting Orange...");
        return Color.orange;
    }

    final void handleLineStyle(FigAttribs figAttribs, int n, double d) {
        switch (n) {
            case -1: 
            case 0: {
                figAttribs.lineStyle = 0;
                figAttribs.dashLength = 0.0;
                break;
            }
            case 1: {
                figAttribs.lineStyle = 1;
                figAttribs.dashLength = 30.0 * d;
                break;
            }
            case 2: {
                figAttribs.lineStyle = 2;
                figAttribs.dashLength = 30.0 * d;
                break;
            }
            case 3: {
                figAttribs.lineStyle = 3;
                figAttribs.dashLength = 30.0 * d;
                break;
            }
            case 4: {
                figAttribs.lineStyle = 4;
                figAttribs.dashLength = 30.0 * d;
                break;
            }
            case 5: {
                figAttribs.lineStyle = 5;
                figAttribs.dashLength = 30.0 * d;
                break;
            }
            default: {
                this.message("-E- Illegal line style " + n + " Using SOLID_LINE instead!");
                figAttribs.lineStyle = 0;
            }
        }
        if (this.debug && n > 0) {
            this.message("Line-style dashed/dotted...");
            this.message("dashLength is " + figAttribs.dashLength);
        }
    }

    final void handleFillStyle(int n, FigAttribs figAttribs) {
        int n2;
        figAttribs.fillStyle = 1;
        if ((n2 = figAttribs.fig_area_fill--) >= 0 && n2 <= 40) {
            if (this.fig_version >= 30) {
                figAttribs.fillStyle = 2;
                figAttribs.fillColor = this.colorCache.get(n, n2);
                if (figAttribs.fillColor == null) {
                    this.message("-E- No color found for " + n + " and area_fill " + n2);
                }
            } else {
                figAttribs.fig_fill_color = 0;
                figAttribs.fillStyle = 2;
                figAttribs.fillColor = this.colorCache.getFIG21Gray(n2);
                if (figAttribs.fillColor == null) {
                    figAttribs.fillStyle = 1;
                    figAttribs.fillColor = Color.black;
                }
            }
        } else if (n2 >= 41) {
            figAttribs.fillStyle = 3;
            if (!figAttribs.getEnableJava2D()) {
                this.message("Area fill style (pattern fill)" + n2 + " not supported without Java2D. Using solid fill instead.");
            }
        } else {
            figAttribs.fillColor = Color.black;
            figAttribs.fillStyle = 1;
        }
        if (figAttribs.fillColor == null) {
            this.message("-E- Internal error in 'handleFillStyle()': fillColor is null, using orange instead!");
            figAttribs.fillColor = Color.orange;
        }
    }

    final void old_handleFillStyle(FigAttribs figAttribs) {
        figAttribs.fillStyle = 1;
        int n = figAttribs.fig_area_fill;
        if (n > 0 && n <= 20) {
            if (figAttribs.fillColor == Color.black && n <= 20) {
                if (this.debug) {
                    this.message("handleFillStyle for black[" + n + "] ");
                }
                figAttribs.fillStyle = 2;
                double d = 0.05 * (double)n;
                figAttribs.fillColor = new Color((float)(1.0 - d), (float)(1.0 - d), (float)(1.0 - d));
            } else if (figAttribs.fillColor == Color.white && n <= 20) {
                figAttribs.fillStyle = 2;
                double d = 0.05 * (double)n;
                figAttribs.fillColor = new Color((float)d, (float)d, (float)d);
            } else {
                if (this.debug) {
                    this.message("-W- filled colored object:  Color may be wrong (tint=" + n + ") ");
                }
                figAttribs.fillStyle = 2;
            }
        } else if (n > 41) {
            figAttribs.fillStyle = 2;
            figAttribs.fillColor = Color.orange;
            this.message("Area fill style (pattern fill)" + n + " not yet supported. Using solid fill instead.");
        }
    }

    final void handle_forward_arrow(FigAttribs figAttribs, FigArrowParams figArrowParams) {
        ++figAttribs.arrowMode;
        figAttribs.arrow_f_Width = figArrowParams.width;
        figAttribs.arrow_f_Length = figArrowParams.height;
        figAttribs.arrow_f_Thickness = figArrowParams.thickness;
        figAttribs.arrow_f_Style = 2 * figArrowParams.type + 2;
        if (figArrowParams.style == 1) {
            ++figAttribs.arrow_f_Style;
        }
    }

    final void handle_backward_arrow(FigAttribs figAttribs, FigArrowParams figArrowParams) {
        figAttribs.arrowMode += 2;
        figAttribs.arrow_b_Width = figArrowParams.width;
        figAttribs.arrow_b_Length = figArrowParams.height;
        figAttribs.arrow_b_Thickness = figArrowParams.thickness;
        figAttribs.arrow_b_Style = 2 * figArrowParams.type + 2;
        if (figArrowParams.style == 1) {
            ++figAttribs.arrow_b_Style;
        }
    }

    void collect_object_comment(String string) {
        if (this.comment == null) {
            this.comment = new StringBuffer();
            this.comment.append(string.substring(1).trim());
        } else {
            this.comment.append('\n');
            this.comment.append(string.substring(1).trim());
        }
    }

    void check_add_object_comment(FigObject figObject) {
        if (this.comment != null) {
            figObject.setComment(this.comment.toString());
        }
        this.comment = null;
    }

    void parse_fig_pseudocolor(BufferedReader bufferedReader, String string, FigAttribs figAttribs, FigObjectList figObjectList) {
        if (this.debug) {
            this.message("parse_fig_pseudocolor()...");
        }
        this.statusMessage("parsing pseudocolor (" + this.line_number + ")");
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\t ");
            String string2 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            String string3 = string2.substring(1, string2.length());
            int n3 = Integer.parseInt(string3, 16);
            ColorCache.getColorCache().putUserColor(n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            this.message("-E- Not a valid FIG3.1 file (pseudocolor)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
    }

    void parse_fig_ellipse(BufferedReader bufferedReader, String string, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        String string2 = null;
        if (this.debug) {
            this.message("parse_fig_ellipse()...");
        }
        this.statusMessage("parsing ellipse (" + this.line_number + ")");
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\t ");
            string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n5 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n6 = Integer.parseInt(string2);
            if (this.fig_version >= 30) {
                string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2);
            } else {
                n = n6;
            }
            string2 = stringTokenizer.nextToken();
            int n7 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n8 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n9 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            Double d = Double.valueOf(string2);
            double d2 = d;
            string2 = stringTokenizer.nextToken();
            int n10 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            d = Double.valueOf(string2);
            double d3 = d;
            string2 = stringTokenizer.nextToken();
            int n11 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n12 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n13 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n14 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n15 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n16 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n17 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n18 = this.fig_scale(Integer.parseInt(string2));
            figAttribs.lineWidth = this.fig_thickness(n5);
            figAttribs.lineColor = this.fig_color(n6);
            figAttribs.fillColor = this.fig_color(n);
            figAttribs.fig_line_color = n6;
            figAttribs.fig_fill_color = n;
            figAttribs.currentLayer = n7;
            figAttribs.fig_pen_style = n8;
            figAttribs.fig_area_fill = n9;
            figAttribs.fig_style_val = d2;
            this.handleLineStyle(figAttribs, n4, d2);
            this.handleFillStyle(n, figAttribs);
            figAttribs.fig_ellipse_direction = n10;
            figAttribs.fig_angle = d3;
            figAttribs.fig_ellipse_angle = d3;
            Point point = new Point(0, 0);
            point.x = n11;
            point.y = n12;
            Point point2 = new Point(0, 0);
            point2.x = n11 + n13;
            point2.y = n12 + n14;
            FigEllipse figEllipse = new FigEllipse(point, point2, figAttribs, figTrafo2D);
            figObjectList.insert(figEllipse);
            this.check_add_object_comment(figEllipse);
        }
        catch (NumberFormatException numberFormatException) {
            this.message("-E- Not a valid FIG3.1 file (ellipse)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
    }

    void parse_fig_spline(BufferedReader bufferedReader, String string, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        FigPolyline figPolyline = null;
        Object var9_7 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        double[] dArray = null;
        boolean bl = SetupManager.getBoolean("jfig.enableXSplines", true);
        if (this.debug) {
            this.message("parse_fig_spline()...");
        }
        this.statusMessage("parsing spline (" + this.line_number + ")");
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\t ");
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n5 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n6 = Integer.parseInt(string2);
            if (this.fig_version >= 30) {
                string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2);
            } else {
                n = n6;
            }
            string2 = stringTokenizer.nextToken();
            int n7 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n8 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n9 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            Double d = Double.valueOf(string2);
            double d2 = d;
            string2 = stringTokenizer.nextToken();
            int n10 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n11 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n12 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n13 = Integer.parseInt(string2);
            FigArrowParams figArrowParams = new FigArrowParams();
            FigArrowParams figArrowParams2 = new FigArrowParams();
            if (n11 == 1) {
                this.parse_fig_arrow(bufferedReader, figArrowParams);
            }
            if (n12 == 1) {
                this.parse_fig_arrow(bufferedReader, figArrowParams2);
            }
            if (n13 > 0) {
                nArray = new int[n13];
                nArray2 = new int[n13];
                this.parse_fig_pointline(bufferedReader, n13, nArray, nArray2);
            } else {
                n13 = this.parse_fig21_pointline(bufferedReader);
                nArray = this.gl_xp;
                nArray2 = this.gl_yp;
            }
            if (figAttribs.figVersion == 31) {
                if (n3 == 2 || n3 == 3) {
                    double[] dArray2 = new double[2 * n13];
                    double[] dArray3 = new double[2 * n13];
                    this.parse_fig31_cpointline(bufferedReader, 2 * n13, dArray2, dArray3);
                }
            } else if (figAttribs.figVersion == 32) {
                dArray = new double[n13];
                this.parse_fig32_cpointline(bufferedReader, n13, dArray);
            }
            figAttribs.lineWidth = this.fig_thickness(n5);
            figAttribs.lineColor = this.fig_color(n6);
            figAttribs.fillColor = this.fig_color(n);
            figAttribs.fig_line_color = n6;
            figAttribs.fig_fill_color = n;
            figAttribs.currentLayer = n7;
            figAttribs.fig_pen_style = n8;
            figAttribs.fig_area_fill = n9;
            figAttribs.fig_style_val = d2;
            figAttribs.fig_cap_style = n10;
            this.handleLineStyle(figAttribs, n4, d2);
            this.handleFillStyle(n, figAttribs);
            figAttribs.arrowMode = 0;
            if (n11 == 1) {
                this.handle_forward_arrow(figAttribs, figArrowParams);
            }
            if (n12 == 1) {
                this.handle_backward_arrow(figAttribs, figArrowParams2);
            }
            switch (n3) {
                case 4: {
                    Point[] pointArray = new Point[n13];
                    int n14 = 0;
                    while (n14 < n13) {
                        pointArray[n14] = new Point(nArray[n14], nArray2[n14]);
                        ++n14;
                    }
                    if (bl) {
                        figPolyline = new FigGeneralXSpline(nArray[0], nArray2[0], figAttribs, figTrafo2D);
                        figPolyline.setPoints(pointArray);
                        ((FigXSpline)figPolyline).setSFactors(dArray);
                    } else {
                        this.message("-W- FIG 3.2 X-splines disabled, using approximated spline instead!");
                        figPolyline = new FigSpline(nArray[0], nArray2[0], false, figAttribs, figTrafo2D);
                        figPolyline.setPoints(pointArray);
                    }
                    figObjectList.insert(figPolyline);
                    this.check_add_object_comment(figPolyline);
                    break;
                }
                case 0: {
                    figPolyline = bl ? new FigNormalXSpline(nArray[0], nArray2[0], figAttribs, figTrafo2D) : new FigSpline(nArray[0], nArray2[0], false, figAttribs, figTrafo2D);
                    Point[] pointArray = new Point[n13];
                    int n15 = 0;
                    while (n15 < n13) {
                        pointArray[n15] = new Point(nArray[n15], nArray2[n15]);
                        ++n15;
                    }
                    figPolyline.setPoints(pointArray);
                    figObjectList.insert(figPolyline);
                    this.check_add_object_comment(figPolyline);
                    break;
                }
                case 5: {
                    Point[] pointArray;
                    if (figAttribs.figVersion == 32) {
                        pointArray = new Point[n13];
                        int n16 = 0;
                        while (n16 < n13) {
                            pointArray[n16] = new Point(nArray[n16], nArray2[n16]);
                            ++n16;
                        }
                    } else {
                        pointArray = new Point[n13 - 1];
                        int n17 = 0;
                        while (n17 < n13 - 1) {
                            pointArray[n17] = new Point(nArray[n17], nArray2[n17]);
                            ++n17;
                        }
                    }
                    if (bl) {
                        figPolyline = new FigGeneralXSpline(nArray[0], nArray2[0], true, figAttribs, figTrafo2D);
                        figPolyline.setPoints(pointArray);
                        ((FigXSpline)figPolyline).setSFactors(dArray);
                    } else {
                        this.message("-W- FIG 3.2 X-splines disabled, using approximated spline instead!");
                        figPolyline = new FigSpline(nArray[0], nArray2[0], true, figAttribs, figTrafo2D);
                        figPolyline.setPoints(pointArray);
                    }
                    figObjectList.insert(figPolyline);
                    this.check_add_object_comment(figPolyline);
                    break;
                }
                case 1: {
                    Point[] pointArray;
                    figPolyline = bl ? new FigNormalXSpline(nArray[0], nArray2[0], true, figAttribs, figTrafo2D) : new FigSpline(nArray[0], nArray2[0], true, figAttribs, figTrafo2D);
                    if (figAttribs.figVersion == 32) {
                        pointArray = new Point[n13];
                        int n18 = 0;
                        while (n18 < n13) {
                            pointArray[n18] = new Point(nArray[n18], nArray2[n18]);
                            ++n18;
                        }
                    } else {
                        pointArray = new Point[n13 - 1];
                        int n19 = 0;
                        while (n19 < n13 - 1) {
                            pointArray[n19] = new Point(nArray[n19], nArray2[n19]);
                            ++n19;
                        }
                    }
                    figPolyline.setPoints(pointArray);
                    figObjectList.insert(figPolyline);
                    this.check_add_object_comment(figPolyline);
                    break;
                }
                case 2: {
                    figPolyline = bl ? new FigBezierXSpline(nArray[0], nArray2[0], false, figAttribs, figTrafo2D) : new FigBezier(nArray[0], nArray2[0], false, figAttribs, figTrafo2D);
                    Point[] pointArray = new Point[n13];
                    int n20 = 0;
                    while (n20 < n13) {
                        pointArray[n20] = new Point(nArray[n20], nArray2[n20]);
                        ++n20;
                    }
                    figPolyline.setPoints(pointArray);
                    figObjectList.insert(figPolyline);
                    this.check_add_object_comment(figPolyline);
                    break;
                }
                case 3: {
                    Point[] pointArray;
                    figPolyline = bl ? new FigBezierXSpline(nArray[0], nArray2[0], true, figAttribs, figTrafo2D) : new FigBezier(nArray[0], nArray2[0], true, figAttribs, figTrafo2D);
                    if (figAttribs.figVersion == 32) {
                        pointArray = new Point[n13];
                        int n21 = 0;
                        while (n21 < n13) {
                            pointArray[n21] = new Point(nArray[n21], nArray2[n21]);
                            ++n21;
                        }
                    } else {
                        pointArray = new Point[n13 - 1];
                        int n22 = 0;
                        while (n22 < n13 - 1) {
                            pointArray[n22] = new Point(nArray[n22], nArray2[n22]);
                            ++n22;
                        }
                    }
                    figPolyline.setPoints(pointArray);
                    figObjectList.insert(figPolyline);
                    this.check_add_object_comment(figPolyline);
                    break;
                }
                default: {
                    this.message("parse_fig_spline: Internal error (unknown sub_type).");
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.message("-E- Not a valid FIG file (spline, number format)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
            exception.printStackTrace();
        }
    }

    String buildString(String string) {
        String string2 = "";
        try {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c != '\u0013') {
                    if (c < ' ' || c > '\u007f' || !this.enableNonASCII) {
                        this.message("-W- Parser found non ASCII char '" + c + "' in input: " + string);
                    }
                    if (c == '\\') {
                        String string3;
                        if ((c = string.charAt(++n)) == '\\') {
                            string2 = string2 + "\\";
                        } else if (c == 'n') {
                            string2 = string2 + "\n";
                        } else if (c <= '7' && c >= '0') {
                            string3 = string.substring(n, n + 3);
                            n += 2;
                            c = (char)Integer.parseInt(string3, 8);
                            if (this.debug) {
                                this.message("buildString(): octal escape: '" + string3 + "' result char is '" + c + "' (value)" + c);
                            }
                            string2 = string2 + c;
                        } else if (c == 'u') {
                            string3 = string.substring(n + 1, n + 5);
                            n += 4;
                            c = (char)Integer.parseInt(string3, 16);
                            string2 = string2 + c;
                        } else {
                            string2 = string2 + "\\" + c;
                        }
                    } else {
                        string2 = string2 + c;
                    }
                }
                ++n;
            }
            return string2;
        }
        catch (Exception exception) {
            this.message("FIG 3.1 parser internal error in buildString():  while trying to convert input '" + string + "' dest='" + string2 + "' ");
            ++this.n_errors;
            return string2;
        }
    }

    private void printString(String string) {
        System.out.println("printString: " + string);
        int n = 0;
        while (n < string.length()) {
            System.out.print("" + string.charAt(n) + " ");
            ++n;
        }
        System.out.println();
    }

    void parse_fig_text(BufferedReader bufferedReader, String string, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        String string2 = null;
        int n = 4;
        int n2 = 0;
        int n3 = 0;
        int n4 = 5;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n7 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n8 = 0;
        int n9 = 0;
        if (this.debug) {
            this.message("parse_fig_text()...");
        }
        this.statusMessage("parsing text (" + this.line_number + ")");
        try {
            String string3;
            int n10;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\t ");
            if (this.fig_version >= 30) {
                string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                n3 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                n4 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                n5 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                n6 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                d = Double.valueOf(string2);
                string2 = stringTokenizer.nextToken();
                d2 = Double.valueOf(string2);
                string2 = stringTokenizer.nextToken();
                n7 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                d3 = Double.valueOf(string2);
                string2 = stringTokenizer.nextToken();
                d4 = Double.valueOf(string2);
                string2 = stringTokenizer.nextToken();
                n8 = this.fig_scale(Integer.parseInt(string2));
                string2 = stringTokenizer.nextToken();
                n9 = this.fig_scale(Integer.parseInt(string2));
            } else if (this.fig_version == 21) {
                string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                n6 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                d = Double.valueOf(string2);
                string2 = stringTokenizer.nextToken();
                n10 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                n3 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                n4 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                d2 = Double.valueOf(string2);
                string2 = stringTokenizer.nextToken();
                n7 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                d3 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                d4 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                n8 = this.fig_scale(Integer.parseInt(string2));
                string2 = stringTokenizer.nextToken();
                n9 = this.fig_scale(Integer.parseInt(string2));
            }
            figAttribs.lineColor = this.fig_color(n3);
            figAttribs.fig_line_color = n3;
            figAttribs.currentLayer = n4;
            figAttribs.fig_pen_style = n5;
            figAttribs.fig_font = n6;
            figAttribs.fig_font_flags = n7;
            figAttribs.fig_angle = d2;
            figAttribs.fig_text_height = d3;
            figAttribs.fig_text_width = d4;
            string2 = stringTokenizer.nextToken("\n");
            if (this.fig_version >= 30) {
                int n11;
                n10 = string.indexOf(string2);
                if (n10 < 0) {
                    n10 = 0;
                }
                if ((n11 = string.indexOf("\\001")) < 0) {
                    n11 = string.length() - 4;
                }
                string3 = this.buildString(string.substring(n10 + 1, n11));
            } else {
                n10 = string.indexOf(string2);
                int n12 = string.length() - 1;
                string3 = this.buildString(string.substring(n10 + 1, n12));
            }
            if (this.debug) {
                this.message("...text: token='" + string2 + "' string='" + string3 + "' ");
            }
            figAttribs.textAlign = n2 == 0 ? 1 : (n2 == 1 ? 2 : 3);
            figAttribs.fontSize = (int)d;
            if ((n7 & 4) == 0 && !FigAttribs.enableJava2D) {
                this.message("-I- Computer Modern fonts not supported, using Postscript/TrueType font instead.");
            }
            FigText figText = new FigText(new Point(n8, n9), string3, figAttribs, figTrafo2D);
            figObjectList.insert(figText);
            this.check_add_object_comment(figText);
            if (d2 != 0.0 && !FigAttribs.enableJava2D) {
                if (this.n_errors < 30) {
                    this.message("-W- cannot display text rotation " + d2 + ", " + "for string '" + string3 + "'");
                } else if (this.n_errors == 30) {
                    this.message("-W- too many errors, suppressing future messages!");
                } else if (this.n_errors > 30) {
                    // empty if block
                }
                ++this.n_errors;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.message("Error (text, number format): Not a valid FIG3.1 file");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
    }

    void parse_fig_arc(BufferedReader bufferedReader, String string, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        String string2 = null;
        if (this.debug) {
            this.message("parse_fig_arc()...");
        }
        this.statusMessage("parsing arc (" + this.line_number + ")");
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\t ");
            string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n5 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n6 = Integer.parseInt(string2);
            if (this.fig_version >= 30) {
                string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2);
            } else {
                n = n6;
            }
            string2 = stringTokenizer.nextToken();
            int n7 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n8 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n9 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            Double d = Double.valueOf(string2);
            double d2 = d;
            if (this.fig_version >= 30) {
                string2 = stringTokenizer.nextToken();
                int n10 = Integer.parseInt(string2);
            } else {
                boolean bl = false;
            }
            string2 = stringTokenizer.nextToken();
            int n11 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n12 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            int n13 = Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            d = Double.valueOf(string2);
            double d3 = d;
            string2 = stringTokenizer.nextToken();
            d = Double.valueOf(string2);
            double d4 = d;
            string2 = stringTokenizer.nextToken();
            int n14 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n15 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n16 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n17 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n18 = this.fig_scale(Integer.parseInt(string2));
            string2 = stringTokenizer.nextToken();
            int n19 = this.fig_scale(Integer.parseInt(string2));
            FigArrowParams figArrowParams = new FigArrowParams();
            FigArrowParams figArrowParams2 = new FigArrowParams();
            if (n12 == 1) {
                this.parse_fig_arrow(bufferedReader, figArrowParams);
            }
            if (n13 == 1) {
                this.parse_fig_arrow(bufferedReader, figArrowParams2);
            }
            figAttribs.lineWidth = this.fig_thickness(n5);
            figAttribs.lineColor = this.fig_color(n6);
            figAttribs.fillColor = this.fig_color(n);
            figAttribs.fig_line_color = n6;
            figAttribs.fig_fill_color = n;
            figAttribs.currentLayer = n7;
            figAttribs.fig_pen_style = n8;
            figAttribs.fig_area_fill = n9;
            figAttribs.fig_style_val = d2;
            this.handleLineStyle(figAttribs, n4, d2);
            this.handleFillStyle(n, figAttribs);
            figAttribs.arrowMode = 0;
            if (n12 == 1) {
                this.handle_forward_arrow(figAttribs, figArrowParams);
            }
            if (n13 == 1) {
                this.handle_backward_arrow(figAttribs, figArrowParams2);
            }
            FigArc figArc = new FigArc(new Point(n14, n15), new Point(n16, n17), new Point(n18, n19), figAttribs, figTrafo2D);
            figObjectList.insert(figArc);
            this.check_add_object_comment(figArc);
        }
        catch (NumberFormatException numberFormatException) {
            this.message("-E- Not a valid FIG3.1 file (arc)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
    }

    void parse_fig_pointline(BufferedReader bufferedReader, int n, int[] nArray, int[] nArray2) {
        if (this.debug) {
            this.message("parse_fig_pointline: npoints= " + n);
        }
        String string = null;
        int n2 = 0;
        int n3 = 0;
        try {
            while (n3 < n) {
                string = bufferedReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t");
                n2 = stringTokenizer.countTokens();
                int n4 = 0;
                while (n4 < n2) {
                    nArray[n3] = this.fig_scale(Integer.parseInt(stringTokenizer.nextToken()));
                    nArray2[n3] = this.fig_scale(Integer.parseInt(stringTokenizer.nextToken()));
                    ++n3;
                    n4 += 2;
                }
                ++this.line_number;
            }
        }
        catch (Exception exception) {
            this.message("-E- Not a valid FIG file (pointline)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
            exception.printStackTrace();
        }
    }

    int parse_fig21_pointline(BufferedReader bufferedReader) {
        if (this.debug) {
            this.message("parse_fig21_pointline...");
        }
        String string = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        try {
            string = bufferedReader.readLine();
            if (this.debug) {
                this.message("parse_fig_pointline: " + string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t");
            n = stringTokenizer.countTokens();
            n2 = (n - 2) / 2;
            this.gl_xp = new int[n2];
            this.gl_yp = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.gl_xp[n3] = this.fig_scale(Integer.parseInt(stringTokenizer.nextToken()));
                this.gl_yp[n3] = this.fig_scale(Integer.parseInt(stringTokenizer.nextToken()));
                ++n3;
            }
            ++this.line_number;
        }
        catch (Exception exception) {
            this.message("-E- Not a valid FIG3.1 file (pointline)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
        return n2;
    }

    void parse_fig32_cpointline(BufferedReader bufferedReader, int n, double[] dArray) {
        if (this.debug) {
            this.message("parse_fig32_cpointline: npoints= " + n);
        }
        String string = null;
        int n2 = 0;
        int n3 = 0;
        try {
            while (n3 < n) {
                string = bufferedReader.readLine();
                if (this.debug) {
                    this.message("parse_fig32_cpointline: " + string);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t");
                n2 = stringTokenizer.countTokens();
                int n4 = 0;
                while (n4 < n2) {
                    Double d = Double.valueOf(stringTokenizer.nextToken());
                    dArray[n3] = d;
                    ++n3;
                    ++n4;
                }
                ++this.line_number;
            }
        }
        catch (Exception exception) {
            this.message("-E- Not a valid FIG3.2 file (cpointline) ");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
    }

    void parse_fig31_cpointline(BufferedReader bufferedReader, int n, double[] dArray, double[] dArray2) {
        if (this.debug) {
            this.message("parse_fig31_cpointline: npoints= " + n);
        }
        String string = null;
        int n2 = 0;
        int n3 = 0;
        try {
            while (n3 < n) {
                string = bufferedReader.readLine();
                if (this.debug) {
                    this.message("parse_fig31_cpointline: " + string);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t");
                n2 = stringTokenizer.countTokens();
                int n4 = 0;
                while (n4 < n2) {
                    Double d = Double.valueOf(stringTokenizer.nextToken());
                    Double d2 = Double.valueOf(stringTokenizer.nextToken());
                    dArray[n3] = this.fig_scale(d);
                    dArray2[n3] = this.fig_scale(d2);
                    ++n3;
                    if (this.debug) {
                        this.message("xx " + d + ", yy " + d2);
                    }
                    n4 += 2;
                }
                ++this.line_number;
            }
        }
        catch (IOException iOException) {
            this.message("-E- Not a valid FIG3.1 file (cpointline)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
        catch (NumberFormatException numberFormatException) {
            this.message("-E- Not a valid FIG3.1 file (number format, cpointline)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
        catch (Exception exception) {
            this.message("-E- Not a valid FIG3.1 file (number format, cpointline)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
    }

    void parse_fig_arrow(BufferedReader bufferedReader, FigArrowParams figArrowParams) {
        String string = null;
        try {
            string = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t\r");
            figArrowParams.type = Integer.parseInt(stringTokenizer.nextToken());
            figArrowParams.style = Integer.parseInt(stringTokenizer.nextToken());
            Double d = Double.valueOf(stringTokenizer.nextToken());
            figArrowParams.thickness = this.fig_arrow_scale(d);
            d = Double.valueOf(stringTokenizer.nextToken());
            figArrowParams.width = this.fig_arrow_scale(d);
            d = Double.valueOf(stringTokenizer.nextToken());
            figArrowParams.height = this.fig_arrow_scale(d);
            ++this.line_number;
        }
        catch (Exception exception) {
            this.message("-E- Not a valid FIG3.1 file (arrow)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
    }

    void parse_fig_polyline(BufferedReader bufferedReader, String string, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        String string2 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (this.debug) {
            this.message("parse_fig_polyline()...");
        }
        this.statusMessage("parsing polyline (" + this.line_number + ")");
        try {
            int n;
            int n2;
            int n3;
            int n4;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\t ");
            String string3 = stringTokenizer.nextToken();
            int n5 = Integer.parseInt(string3);
            string3 = stringTokenizer.nextToken();
            int n6 = Integer.parseInt(string3);
            string3 = stringTokenizer.nextToken();
            int n7 = Integer.parseInt(string3);
            string3 = stringTokenizer.nextToken();
            int n8 = Integer.parseInt(string3);
            string3 = stringTokenizer.nextToken();
            int n9 = Integer.parseInt(string3);
            if (this.fig_version >= 30) {
                string3 = stringTokenizer.nextToken();
                n4 = Integer.parseInt(string3);
            } else {
                n4 = n9;
            }
            string3 = stringTokenizer.nextToken();
            int n10 = Integer.parseInt(string3);
            string3 = stringTokenizer.nextToken();
            int n11 = Integer.parseInt(string3);
            string3 = stringTokenizer.nextToken();
            int n12 = Integer.parseInt(string3);
            string3 = stringTokenizer.nextToken();
            Double d = Double.valueOf(string3);
            double d2 = d;
            if (this.fig_version >= 30) {
                string3 = stringTokenizer.nextToken();
                n3 = Integer.parseInt(string3);
                string3 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(string3);
            } else {
                n3 = 0;
                n2 = 0;
            }
            string3 = stringTokenizer.nextToken();
            int n13 = Integer.parseInt(string3);
            string3 = stringTokenizer.nextToken();
            int n14 = Integer.parseInt(string3);
            string3 = stringTokenizer.nextToken();
            int n15 = Integer.parseInt(string3);
            if (this.fig_version >= 30) {
                string3 = stringTokenizer.nextToken();
                n = Integer.parseInt(string3);
            } else {
                n = -1;
            }
            FigArrowParams figArrowParams = new FigArrowParams();
            FigArrowParams figArrowParams2 = new FigArrowParams();
            if (n14 == 1) {
                this.parse_fig_arrow(bufferedReader, figArrowParams);
            }
            if (n15 == 1) {
                this.parse_fig_arrow(bufferedReader, figArrowParams2);
            }
            if (n6 == 5) {
                string = bufferedReader.readLine();
                stringTokenizer = new StringTokenizer(string, " \n\r\t");
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                int n16 = string.indexOf(string2);
                string2 = string.substring(n16).trim();
                if (this.debug) {
                    this.message("Image source is '" + string2 + "' ");
                }
            }
            if (n > 0) {
                nArray = new int[n];
                nArray2 = new int[n];
                this.parse_fig_pointline(bufferedReader, n, nArray, nArray2);
            } else {
                n = this.parse_fig21_pointline(bufferedReader);
                nArray = this.gl_xp;
                nArray2 = this.gl_yp;
            }
            figAttribs.lineWidth = this.fig_thickness(n8);
            figAttribs.lineColor = this.fig_color(n9);
            figAttribs.fillColor = this.fig_color(n4);
            figAttribs.fig_line_color = n9;
            figAttribs.fig_fill_color = n4;
            figAttribs.currentLayer = n10;
            figAttribs.fig_pen_style = n11;
            figAttribs.fig_area_fill = n12;
            figAttribs.fig_style_val = d2;
            figAttribs.fig_join_style = n3;
            figAttribs.fig_cap_style = n2;
            figAttribs.cornerRadius = this.fig_thickness(n13);
            this.handleLineStyle(figAttribs, n7, d2);
            this.handleFillStyle(n4, figAttribs);
            figAttribs.arrowMode = 0;
            if (n14 == 1) {
                this.handle_forward_arrow(figAttribs, figArrowParams);
            }
            if (n15 == 1) {
                this.handle_backward_arrow(figAttribs, figArrowParams2);
            }
            switch (n6) {
                case 1: {
                    FigPolyline figPolyline = new FigPolyline(nArray[0], nArray2[0], false, figAttribs, figTrafo2D);
                    Point[] pointArray = new Point[n];
                    int n17 = 0;
                    while (n17 < n) {
                        pointArray[n17] = new Point(nArray[n17], nArray2[n17]);
                        ++n17;
                    }
                    figPolyline.setPoints(pointArray);
                    figObjectList.insert(figPolyline);
                    this.check_add_object_comment(figPolyline);
                    break;
                }
                case 2: {
                    figAttribs.cornerRadius = 0;
                    int n18 = Integer.MAX_VALUE;
                    int n19 = Integer.MAX_VALUE;
                    int n20 = Integer.MIN_VALUE;
                    int n21 = Integer.MIN_VALUE;
                    int n22 = 0;
                    while (n22 < n) {
                        if (nArray[n22] < n18) {
                            n18 = nArray[n22];
                        }
                        if (nArray2[n22] < n19) {
                            n19 = nArray2[n22];
                        }
                        if (nArray[n22] > n20) {
                            n20 = nArray[n22];
                        }
                        if (nArray2[n22] > n21) {
                            n21 = nArray2[n22];
                        }
                        ++n22;
                    }
                    FigRectangle figRectangle = new FigRectangle(n18, n19, n20, n21, false, figAttribs, figTrafo2D);
                    figObjectList.insert(figRectangle);
                    this.check_add_object_comment(figRectangle);
                    break;
                }
                case 3: {
                    FigPolyline figPolyline = new FigPolyline(nArray[0], nArray2[0], true, figAttribs, figTrafo2D);
                    Point[] pointArray = new Point[n - 1];
                    int n23 = 0;
                    while (n23 < n - 1) {
                        pointArray[n23] = new Point(nArray[n23], nArray2[n23]);
                        ++n23;
                    }
                    figPolyline.setPoints(pointArray);
                    figObjectList.insert(figPolyline);
                    this.check_add_object_comment(figPolyline);
                    break;
                }
                case 4: {
                    int n24 = Integer.MAX_VALUE;
                    int n25 = Integer.MAX_VALUE;
                    int n26 = Integer.MIN_VALUE;
                    int n27 = Integer.MIN_VALUE;
                    int n28 = 0;
                    while (n28 < n) {
                        if (nArray[n28] < n24) {
                            n24 = nArray[n28];
                        }
                        if (nArray2[n28] < n25) {
                            n25 = nArray2[n28];
                        }
                        if (nArray[n28] > n26) {
                            n26 = nArray[n28];
                        }
                        if (nArray2[n28] > n27) {
                            n27 = nArray2[n28];
                        }
                        ++n28;
                    }
                    FigRectangle figRectangle = new FigRectangle(n24, n25, n26, n27, true, figAttribs, figTrafo2D);
                    figObjectList.insert(figRectangle);
                    this.check_add_object_comment(figRectangle);
                    break;
                }
                case 5: {
                    int n29 = Integer.MAX_VALUE;
                    int n30 = Integer.MAX_VALUE;
                    int n31 = Integer.MIN_VALUE;
                    int n32 = Integer.MIN_VALUE;
                    int n33 = 0;
                    while (n33 < n) {
                        if (nArray[n33] < n29) {
                            n29 = nArray[n33];
                        }
                        if (nArray2[n33] < n30) {
                            n30 = nArray2[n33];
                        }
                        if (nArray[n33] > n31) {
                            n31 = nArray[n33];
                        }
                        if (nArray2[n33] > n32) {
                            n32 = nArray2[n33];
                        }
                        ++n33;
                    }
                    FigImage figImage = new FigImage(n29, n30, n31, n32, figAttribs, figTrafo2D, null);
                    figImage.setImageAndFilename(string2, this.gl_filename, this.gl_filetype, true);
                    if (this.painter != null) {
                        figImage.setObjectPainter(this.painter);
                    }
                    figObjectList.insert(figImage);
                    this.check_add_object_comment(figImage);
                    break;
                }
                default: {
                    this.message("Illegal polyline sub_type: " + n6);
                    throw new IOException();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.message("-E- Not a valid FIG3.1 file (polyline)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
        catch (Exception exception) {
            this.message("-E- Not a valid FIG3.1 file (polyline)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
        }
    }

    void parse_text_plain(String string, BufferedReader bufferedReader, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        this.message("reading input as plain/text file...");
        try {
            String string2;
            FigText figText;
            FigAttribs figAttribs2 = new FigAttribs();
            figAttribs2.fig_font = 12;
            figAttribs2.fontSize = 14;
            int n = 480;
            int n2 = 1200;
            int n3 = n;
            if (string != null) {
                figText = new FigText(new Point(n2, n3), string, figAttribs2, figTrafo2D);
                figObjectList.append(figText);
                n3 += n;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                figText = new FigText(new Point(n2, n3), string2, figAttribs2, figTrafo2D);
                figObjectList.append(figText);
                n3 += 480;
            }
        }
        catch (Exception exception) {
            this.message("parse_text_plain.: " + exception.toString());
        }
    }

    String skip_fig_comments(BufferedReader bufferedReader) throws IOException {
        String string = null;
        do {
            string = bufferedReader.readLine();
            ++this.line_number;
            if (string != null) continue;
            throw new IOException();
        } while (string.length() <= 0 || string.charAt(0) == '#');
        return string;
    }

    void parse_fig32_header(BufferedReader bufferedReader, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        String string = null;
        try {
            string = this.skip_fig_comments(bufferedReader);
            if (string.indexOf("Landscape") >= 0) {
                figAttribs.setFigOrientation(0);
                figAttribs.setPageOrientation("Landscape");
            } else if (string.indexOf("Portrait") >= 0) {
                figAttribs.setFigOrientation(1);
                figAttribs.setPageOrientation("Portrait");
            } else {
                throw new IOException("Wrong orientation: " + string);
            }
            string = this.skip_fig_comments(bufferedReader);
            if (string.indexOf("Center") >= 0) {
                figAttribs.setFigJustification(0);
                figAttribs.setPageJustification("Center");
            } else if (string.toLowerCase().indexOf("flush left") >= 0) {
                figAttribs.setFigJustification(1);
                figAttribs.setPageJustification("Flush Left");
            } else {
                throw new IOException("Wrong alignment: " + string);
            }
            string = this.skip_fig_comments(bufferedReader);
            if (string.indexOf("Metric") >= 0) {
                figAttribs.setFigUnits(0);
                figAttribs.setPageUnits("Metric");
            } else if (string.indexOf("Inches") >= 0) {
                figAttribs.setFigUnits(1);
                figAttribs.setPageUnits("Inches");
            } else {
                throw new IOException("Wrong units: " + string);
            }
            string = this.skip_fig_comments(bufferedReader);
            boolean bl = false;
            int n = 0;
            while (n < this.paperSizes.length) {
                if (string.indexOf(this.paperSizes[n]) >= 0) {
                    bl = true;
                    figAttribs.setPaperSize(this.paperSizes[n]);
                }
                ++n;
            }
            if (!bl) {
                throw new IOException("Wrong paper size: " + string);
            }
            string = this.skip_fig_comments(bufferedReader);
            figAttribs.setExportMagnification(Double.valueOf(string));
            string = this.skip_fig_comments(bufferedReader);
            if (string.indexOf("Single") >= 0) {
                figAttribs.setSingleOrMultipleSheets("Single");
            } else if (string.indexOf("Multiple") >= 0) {
                figAttribs.setSingleOrMultipleSheets("Multiple");
            } else {
                throw new IOException("Must use either Single or Multiple: " + string);
            }
            string = this.skip_fig_comments(bufferedReader);
            figAttribs.setTransparentColorIndex(Integer.parseInt(string));
            string = this.skip_fig_comments(bufferedReader);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\t\r ");
            String string2 = stringTokenizer.nextToken();
            figAttribs.setFigResolution(Integer.parseInt(string2));
            this.input_resolution = (int)(2400.0 / (double)FigAttribs.fig_resolution);
            string2 = stringTokenizer.nextToken();
            figAttribs.setFigOrigin(Integer.parseInt(string2));
            if (figAttribs.getFigOrigin() != 2) {
                throw new IOException();
            }
        }
        catch (Exception exception) {
            this.message("-W- Not a valid FIG 3.2 file (header)" + exception);
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
            this.parse_text_plain(string, bufferedReader, figAttribs, figTrafo2D, figObjectList);
        }
    }

    void parse_fig_header(BufferedReader bufferedReader, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        String string = null;
        this.statusMessage("parsing header...");
        try {
            string = bufferedReader.readLine();
            ++this.line_number;
            if (string.indexOf("#FIG 3.2") > -1) {
                this.fig_version = 32;
                figAttribs.setFigVersion(32);
                this.parse_fig32_header(bufferedReader, figAttribs, figTrafo2D, figObjectList);
            } else if (string.indexOf("#FIG 3.1") > -1) {
                this.fig_version = 31;
                figAttribs.setFigVersion(31);
                string = this.skip_fig_comments(bufferedReader);
                if (string.indexOf("Landscape") >= 0) {
                    figAttribs.setFigOrientation(0);
                    figAttribs.setPageOrientation("Landscape");
                } else if (string.indexOf("Portrait") >= 0) {
                    figAttribs.setFigOrientation(1);
                    figAttribs.setPageOrientation("Portrait");
                } else {
                    throw new IOException();
                }
                string = this.skip_fig_comments(bufferedReader);
                if (string.indexOf("Center") >= 0) {
                    figAttribs.setFigJustification(0);
                    figAttribs.setPageJustification("Center");
                } else if (string.toLowerCase().indexOf("flush left") >= 0) {
                    figAttribs.setFigJustification(1);
                    figAttribs.setPageJustification("Flush Left");
                } else {
                    throw new IOException();
                }
                string = this.skip_fig_comments(bufferedReader);
                if (string.indexOf("Metric") >= 0) {
                    figAttribs.setFigUnits(0);
                    figAttribs.setPageUnits("Metric");
                } else if (string.indexOf("Inches") >= 0) {
                    figAttribs.setFigUnits(1);
                    figAttribs.setPageUnits("Inches");
                } else {
                    throw new IOException();
                }
                string = this.skip_fig_comments(bufferedReader);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\t\r ");
                String string2 = stringTokenizer.nextToken();
                figAttribs.setFigResolution(Integer.parseInt(string2));
                this.input_resolution = (int)(2400.0 / (double)figAttribs.getFigResolution());
                string2 = stringTokenizer.nextToken();
                figAttribs.setFigOrigin(Integer.parseInt(string2));
                if (figAttribs.getFigOrigin() != 2) {
                    throw new IOException();
                }
            } else if (string.indexOf("FIG 2.1") > -1) {
                this.fig_version = 21;
                string = this.skip_fig_comments(bufferedReader);
                figAttribs.setFigJustification(1);
                figAttribs.setFigUnits(1);
                figAttribs.setFigOrigin(2);
                figAttribs.setFigResolution(80);
                this.input_resolution = (int)(2400.0 / (double)figAttribs.getFigResolution());
            } else {
                throw new IOException();
            }
            if (this.debug) {
                this.message("FIG 3.1 header variables: ");
                this.message(" units " + figAttribs.getFigUnits() + " justification " + figAttribs.getFigJustification() + " resolution " + figAttribs.getFigResolution() + " origin " + figAttribs.getFigOrigin());
            }
        }
        catch (IOException iOException) {
            this.message("-E- Not a valid FIG3.1 file (header)");
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
            this.parse_text_plain(string, bufferedReader, figAttribs, figTrafo2D, figObjectList);
        }
    }

    public int parse_fig_file(InputStream inputStream, boolean bl, boolean bl2, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this.parse_fig_file_private(bufferedReader, bl, bl2, figAttribs, figTrafo2D, figObjectList);
    }

    private int parse_fig_file_private(BufferedReader bufferedReader, boolean bl, boolean bl2, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        String string = null;
        if (bl) {
            this.statusMessage("parsing file...");
        } else {
            this.statusMessage("parsing compound... " + this.line_number);
        }
        if (bl) {
            this.n_messages = 0;
        }
        long l = System.currentTimeMillis();
        if (bufferedReader == null) {
            this.statusMessage("file not found or empty!");
            return 1;
        }
        try {
            if (bl) {
                this.n_errors = 0;
                this.line_number = 0;
                this.parse_fig_header(bufferedReader, figAttribs, figTrafo2D, figObjectList);
            }
            while ((string = bufferedReader.readLine()) != null) {
                if (this.debug) {
                    this.message("..." + string);
                }
                if (string.length() < 1) continue;
                char c = string.charAt(0);
                if (c == '#') {
                    this.collect_object_comment(string);
                } else if (c == '0') {
                    this.parse_fig_pseudocolor(bufferedReader, string, figAttribs, figObjectList);
                } else if (c == '1') {
                    this.parse_fig_ellipse(bufferedReader, string, figAttribs, figTrafo2D, figObjectList);
                } else if (c == '2') {
                    this.parse_fig_polyline(bufferedReader, string, figAttribs, figTrafo2D, figObjectList);
                } else if (c == '3') {
                    this.parse_fig_spline(bufferedReader, string, figAttribs, figTrafo2D, figObjectList);
                } else if (c == '4') {
                    this.parse_fig_text(bufferedReader, string, figAttribs, figTrafo2D, figObjectList);
                } else if (c == '5') {
                    this.parse_fig_arc(bufferedReader, string, figAttribs, figTrafo2D, figObjectList);
                } else if (c == '6') {
                    bl2 = true;
                    FigCompound figCompound = new FigCompound();
                    this.check_add_object_comment(figCompound);
                    figCompound.setTrafo(figTrafo2D);
                    FigObjectList figObjectList2 = figCompound.getMembers();
                    this.parse_fig_file_private(bufferedReader, false, bl2, figAttribs, figTrafo2D, figObjectList2);
                    figCompound.update_bbox();
                    figObjectList.insert(figCompound);
                } else if (c == '-') {
                    if (bl2 && string.charAt(1) == '6') {
                        return this.n_errors;
                    }
                    this.message("-E- Not a valid FIG3.1 file, a compound may not be closed here: ");
                    if (string != null) {
                        this.message(string);
                    }
                } else if (c == '9') {
                    this.parse_jfig_trigger(bufferedReader, string, figAttribs, figTrafo2D, figObjectList);
                } else {
                    throw new IOException();
                }
                ++this.line_number;
            }
            figAttribs.restoreDefaults();
            if (this.debug) {
                this.message("Parsing FIG3.1 file ok, " + this.n_errors + " possible error(s) on " + this.line_number + " lines.");
            }
            return this.n_errors;
        }
        catch (IOException iOException) {
            this.message("-E- Not a valid FIG3.1 file (main parser)" + iOException);
            if (string != null) {
                this.message("on line " + this.line_number + ": " + string);
            }
            ++this.n_errors;
            return this.n_errors;
        }
    }

    public int parse_fig_file_not_threaded(InputStream inputStream, boolean bl, boolean bl2, boolean bl3, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        this.statusMessage("parsing...");
        FigObjectList figObjectList2 = figObjectList;
        int n = this.parse_fig_file(inputStream, bl, bl2, figAttribs, figTrafo2D, figObjectList2);
        if (this.actionListeners.size() > 0) {
            this.notifyOurActionListeners(bl3);
        }
        return n;
    }

    public void notifyOurActionListeners(boolean bl) {
        String string = bl ? "ParserCallback:merge" : "ParserCallback:load";
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        Enumeration enumeration = this.actionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
        }
    }

    public int parse_fig_file_threaded(InputStream inputStream, boolean bl, boolean bl2, boolean bl3, FigAttribs figAttribs, FigTrafo2D figTrafo2D, FigObjectList figObjectList) {
        if (this.solaris_is_broken) {
            return this.parse_fig_file_not_threaded(inputStream, bl, bl2, bl3, figAttribs, figTrafo2D, figObjectList);
        }
        if (this.reader != null && this.reader.isAlive()) {
            return 12345;
        }
        if (bl) {
            this.n_messages = 0;
        }
        this.t_errors = 0;
        this.t_f = inputStream;
        this.t_top_level = bl;
        this.t_inside_compound = bl2;
        this.t_merge = bl3;
        this.t_attribs = figAttribs;
        this.t_trafo = figTrafo2D;
        this.t_OL = figObjectList;
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
        return 0;
    }

    public void run() {
        if (this.debug) {
            this.message("FigParser.run(): parsing started...");
        }
        this.t_errors = this.parse_fig_file(this.t_f, this.t_top_level, this.t_inside_compound, this.t_attribs, this.t_trafo, this.t_OL);
        if (this.debug) {
            this.message("FigParser.run(): parsing ok, " + this.t_errors + " errors");
        }
        if (this.actionListeners.size() > 0) {
            this.notifyOurActionListeners(this.t_merge);
        }
    }

    public void message(String string) {
        if (this.printer != null) {
            this.printer.consoleMessage(string);
        } else {
            try {
                Console.getConsole().message(string);
            }
            catch (Throwable throwable) {
                System.err.println(string);
            }
        }
    }

    public void statusMessage(String string) {
        ++this.n_messages;
        if (!this.enableMessages) {
            return;
        }
        if (this.helper != null) {
            if (this.fastMessages && this.n_messages < 10 || this.n_messages % 50 == 0) {
                this.helper.setStatusMessage(string);
            }
        } else {
            this.message(string);
        }
    }

    public FigParser(Object object) {
        this.actionListeners = new Vector();
        this.colorCache = ColorCache.getColorCache();
        this.debug = SetupManager.getBoolean("jfig.objects.FigParser.debug", false);
        this.enableNonASCII = SetupManager.getBoolean("jfig.objects.FigParser.enableNonASCII", true);
        this.enableMessages = SetupManager.getBoolean("jfig.objects.FigParser.enableMessages", false);
        this.fastMessages = SetupManager.getBoolean("jfig.objects.FigParser.UseFastMessages", false);
    }

    public FigParser(Object object, StatusMessage statusMessage) {
        this(object);
        this.helper = statusMessage;
    }

    public FigParser() {
        this(null);
    }
}

