/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.io.PrintWriter;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.ObjectPainter;
import jfig.gui.ConsoleMessage;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigWriter;

public class FigBaseobject
implements FigObject {
    protected static ConsoleMessage printer = null;
    protected FigAttribs attribs = new FigAttribs();
    protected FigTrafo2D trafo;
    protected int x = 0;
    protected int y = 0;
    protected FigBbox bbox;
    protected FigBbox sc_bbox;
    protected long sc_bbox_timestamp = -1L;
    protected boolean debug = false;
    protected boolean selected;
    protected boolean showPoints;
    protected boolean syncRedrawFlag = false;
    protected long timestamp = 0L;
    protected String comment;
    protected boolean visible;
    public ObjectPainter painter = null;

    public boolean initialize(String string) {
        this.message("shouldn't call initialize() on a FigBaseobject!");
        return true;
    }

    public void setObjectPainter(ObjectPainter objectPainter) {
        this.painter = objectPainter;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public FigAttribs getAttributes() {
        return this.attribs;
    }

    public void setAttributes(FigAttribs figAttribs) {
        this.attribs = figAttribs;
    }

    public void updateAttributes(String string) {
        this.getAttributes().parse(string);
        this.rebuild();
    }

    public void setTrafo(FigTrafo2D figTrafo2D) {
        if (figTrafo2D != this.trafo) {
            this.trafo = figTrafo2D;
            this.rebuild();
        }
    }

    public FigTrafo2D getTrafo() {
        return this.trafo;
    }

    public int getLayer() {
        return this.attribs.currentLayer;
    }

    public Point getPosition() {
        return new Point(this.x, this.y);
    }

    public FigBbox getBbox() {
        return this.bbox;
    }

    public void set_debug() {
        this.debug = true;
    }

    public void reset_debug() {
        this.debug = false;
    }

    public void move(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public void mirrorX(int n, int n2) {
        this.message("mirrorX() not supported by " + this.toString());
    }

    public void mirrorY(int n, int n2) {
        this.message("mirrorY() not supported by " + this.toString());
    }

    public void scale(Point point, double d, double d2) {
        Point[] pointArray = this.getPoints();
        if (pointArray != null) {
            Point[] pointArray2 = new Point[pointArray.length];
            int n = 0;
            while (n < pointArray2.length) {
                int n2 = point.x + (int)((double)(pointArray[n].x - point.x) * d);
                int n3 = point.y + (int)((double)(pointArray[n].y - point.y) * d2);
                pointArray2[n] = new Point(n2, n3);
                ++n;
            }
            this.setPoints(pointArray2);
        }
        d = Math.abs(d);
        this.attribs.lineWidth *= d;
        this.attribs.dashLength *= d;
        this.attribs.arrow_f_Width *= d;
        this.attribs.arrow_f_Length *= d;
        this.attribs.arrow_f_Thickness *= d;
        this.attribs.arrow_b_Width *= d;
        this.attribs.arrow_b_Length *= d;
        this.attribs.arrow_b_Thickness *= d;
    }

    public void rotate(Point point, double d) throws Exception {
        Point[] pointArray;
        if (this.canRotate(d)) {
            Point[] pointArray2 = this.getPoints();
            pointArray = new Point[pointArray2.length];
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            int n = 0;
            while (n < pointArray2.length) {
                double d4 = pointArray2[n].x - point.x;
                double d5 = pointArray2[n].y - point.y;
                double d6 = d4 * d2 - d5 * d3;
                double d7 = d4 * d3 + d5 * d2;
                pointArray[n] = new Point((int)(d6 += (double)point.x), (int)(d7 += (double)point.y));
                ++n;
            }
        } else {
            throw new Exception("Rotation not supported on FigBaseObject!");
        }
        this.setPoints(pointArray);
    }

    public boolean canRotate(double d) {
        return false;
    }

    public void update(FigAttribs figAttribs) {
        this.message("update() not supported by " + this.toString());
    }

    public void rebuild() {
        this.message("-W- rebuild() not implemented by " + this.toString());
    }

    public FigObject copy() {
        return null;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void showPoints() {
        this.showPoints = true;
        this.selected = false;
    }

    public boolean isShowPoints() {
        return this.showPoints;
    }

    public void select() {
        this.showPoints = false;
        this.selected = true;
    }

    public void deselect() {
        this.showPoints = false;
        this.selected = false;
    }

    public boolean getSyncRedrawFlag() {
        return this.syncRedrawFlag;
    }

    public void setSyncRedrawFlag(boolean bl) {
        this.syncRedrawFlag = bl;
    }

    public boolean supportsPointOps() {
        return false;
    }

    public int numPoints() {
        if (this.getPoints() != null) {
            return this.getPoints().length;
        }
        return 0;
    }

    public boolean isClosed() {
        return false;
    }

    public Point[] getPoints() {
        return null;
    }

    public void setPoints(Point[] pointArray) {
        if (this.debug) {
            this.message("FigBaseobject.setPoints(): You should not call this!");
        }
    }

    public static Point[] clonePoints(Point[] pointArray) {
        int n = pointArray.length;
        Point[] pointArray2 = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            pointArray2[n2] = new Point(point.x, point.y);
            ++n2;
        }
        return pointArray2;
    }

    public void appendPoint(Point point) {
        if (this.debug) {
            this.message("FigBaseobject.appendPoint(): You should not call this!");
        }
    }

    public void movePoint(Point point, Point point2) {
        if (this.debug) {
            this.message("FigBaseobject.movePoint(): You should not call this!");
        }
    }

    public void insertPoint(Point point, Point point2) {
        if (this.debug) {
            this.message("FigBaseobject.insertPoint(): You should not call this!");
        }
    }

    public Point deletePoint(Point point) {
        if (this.debug) {
            this.message("FigBaseobject.deletePoint(): You should not call this!");
        }
        return null;
    }

    public Point getNearestPoint(Point point) {
        Point[] pointArray = this.getPoints();
        if (pointArray == null) {
            return null;
        }
        Point point2 = null;
        double d = 1.0E10;
        int n = 0;
        while (n < pointArray.length) {
            double d2 = FigBaseobject.manhattan(pointArray[n], point);
            if (d2 < d) {
                d = d2;
                point2 = pointArray[n];
            }
            ++n;
        }
        return new Point(point2);
    }

    public static int manhattan(Point point, Point point2) {
        return Math.abs(point.x - point2.x) + Math.abs(point.y - point2.y);
    }

    public Point[] getNeighborPoints(Point point) {
        if (this.debug) {
            this.message("FigBaseobject.getNeighborPoints(): You should not call this!");
        }
        return null;
    }

    public Point[] getMovePointNeighbors(Point point) {
        if (this.debug) {
            this.message("FigBaseobject.getMovePointNeighbors(): You should not call this!");
        }
        return null;
    }

    public double minDistance(Point point) {
        return this.bbox.minDistanceInside(point);
    }

    public double minDistanceEuclid(Point point) {
        return this.minDistance(point);
    }

    public String getText() {
        return "";
    }

    public void setText(String string) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.message(this.toString() + ".keyPressed( " + keyEvent + ") ");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void build_sc_bbox() {
        Point point = new Point(this.bbox.getXl(), this.bbox.getYt());
        Point point2 = new Point(this.bbox.getXr(), this.bbox.getYb());
        Point point3 = new Point(0, 0);
        Point point4 = new Point(0, 0);
        point3 = this.trafo.wc_to_screen(point, point3);
        point4 = this.trafo.wc_to_screen(point2, point4);
        this.sc_bbox = new FigBbox(point3, point4);
        this.sc_bbox_timestamp = System.currentTimeMillis();
    }

    public FigBbox get_sc_bbox() {
        return this.sc_bbox;
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (!this.showPoints && !this.selected) {
            return;
        }
        if (this.sc_bbox_timestamp <= this.trafo.getTimestamp()) {
            this.build_sc_bbox();
        }
        int n = this.sc_bbox.getXl();
        int n2 = this.sc_bbox.getXr();
        int n3 = this.sc_bbox.getYt();
        int n4 = this.sc_bbox.getYb();
        if (this.debug) {
            this.message("sc_bbox coords: " + n + " " + n3 + ", " + n2 + " " + n4);
        }
        if (this.showPoints) {
            graphics.setColor(Color.black);
            graphics.drawRect(n - 2, n3 - 2, 4, 4);
            graphics.drawRect(n2 - 2, n3 - 2, 4, 4);
            graphics.drawRect(n - 2, n4 - 2, 4, 4);
            graphics.drawRect(n2 - 2, n4 - 2, 4, 4);
            graphics.setColor(Color.white);
            graphics.fillRect(n - 1, n3 - 1, 3, 3);
            graphics.fillRect(n2 - 1, n3 - 1, 3, 3);
            graphics.fillRect(n - 1, n4 - 1, 3, 3);
            graphics.fillRect(n2 - 1, n4 - 1, 3, 3);
            graphics.setColor(Color.black);
        } else if (this.selected) {
            graphics.setColor(Color.black);
            graphics.fillRect(n - 1, n3 - 1, 3, 3);
            graphics.fillRect(n2 - 1, n3 - 1, 3, 3);
            graphics.fillRect(n - 1, n4 - 1, 3, 3);
            graphics.fillRect(n2 - 1, n4 - 1, 3, 3);
            graphics.setColor(Color.white);
            graphics.drawRect(n - 2, n3 - 2, 4, 4);
            graphics.drawRect(n2 - 2, n3 - 2, 4, 4);
            graphics.drawRect(n - 2, n4 - 2, 4, 4);
            graphics.drawRect(n2 - 2, n4 - 2, 4, 4);
        }
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (figTrafo2D != this.getTrafo()) {
            this.setTrafo(figTrafo2D);
        }
        this.paint(graphics);
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        Graphics graphics2 = graphics.create();
        this.setTrafo(figTrafo2D);
        this.rebuild();
        this.paint(graphics2, figTrafo2D);
        graphics2.dispose();
    }

    public boolean isVisible(FigBbox figBbox) {
        return this.bbox.isVisible(figBbox);
    }

    public void message(String string) {
        if (printer != null) {
            printer.consoleMessage(string);
        } else {
            System.err.println(string);
        }
    }

    public void setConsole(ConsoleMessage consoleMessage) {
        printer = consoleMessage;
    }

    public void writeAsResource(PrintWriter printWriter) {
        new FigWriter().writeAsResource(printWriter, this);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String toString() {
        String string = "FigBaseobject at (" + this.x + ", " + this.y + ") on layer " + this.attribs.currentLayer;
        return string;
    }

    public FigBaseobject() {
        this.trafo = new FigTrafo2D();
        this.bbox = new FigBbox(this.x, this.y, this.x, this.y);
        this.build_sc_bbox();
        this.sc_bbox_timestamp = 0L;
        this.debug = false;
        this.selected = false;
        this.showPoints = false;
        this.visible = true;
        this.timestamp = 0L;
    }

    public FigBaseobject(FigTrafo2D figTrafo2D) {
        this.trafo = figTrafo2D;
        this.bbox = new FigBbox(this.x, this.y, this.x, this.y);
        this.build_sc_bbox();
        this.sc_bbox_timestamp = 0L;
        this.debug = false;
        this.selected = false;
        this.showPoints = false;
        this.visible = true;
        this.timestamp = 0L;
    }
}

