/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigArrow;
import jfig.objects.FigAttribs;
import jfig.objects.FigRenderer;
import jfig.objects.FigSpline;
import jfig.objects.FillWrapper;
import jfig.objects.LineWrapper;

public class AWTSplineRenderer
implements FigRenderer {
    FigSpline spline;
    Point[] wcp_spline;
    Point[] wcp;
    LineWrapper wspline;
    FillWrapper wfill;
    FigArrow f_arrow;
    FigArrow b_arrow;
    long timestamp;

    public void rebuild() {
        this.wcp = this.spline.getPoints();
        this.wcp_spline = this.spline.getSplinePoints();
        FigAttribs figAttribs = this.spline.getAttributes();
        FigTrafo2D figTrafo2D = this.spline.getTrafo();
        boolean bl = this.spline.isClosed();
        if (this.wcp.length >= 3) {
            this.wspline = new LineWrapper(this.spline, figTrafo2D, this.wcp_spline, bl);
            this.wfill = figAttribs.fillStyle != 1 ? new FillWrapper(this.spline, figTrafo2D, this.wcp_spline) : null;
        } else if (this.wcp.length == 2) {
            this.wcp_spline = new Point[2];
            this.wcp_spline[0] = this.wcp[0];
            this.wcp_spline[1] = this.wcp[1];
            this.wspline = new LineWrapper(this.spline, figTrafo2D, this.wcp_spline, false);
            this.wfill = null;
        }
        this.b_arrow = null;
        this.f_arrow = null;
        if (this.wcp.length >= 2) {
            if ((figAttribs.arrowMode & 2) > 0) {
                this.b_arrow = FigArrow.create(this.spline, this.wcp_spline[1], this.wcp_spline[0], false);
            }
            if ((figAttribs.arrowMode & 1) > 0) {
                this.f_arrow = FigArrow.create(this.spline, this.wcp_spline[this.wcp_spline.length - 2], this.wcp_spline[this.wcp_spline.length - 1], true);
            }
        }
        this.timestamp = System.currentTimeMillis();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.spline.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        int n;
        int n2;
        int n3;
        if (!this.spline.isVisible()) {
            return;
        }
        if (this.timestamp < figTrafo2D.getTimestamp()) {
            this.rebuild();
        }
        if (this.wfill != null) {
            this.wfill.paint(graphics);
        }
        if (this.wspline != null) {
            this.wspline.paint(graphics);
        }
        if (this.b_arrow != null) {
            this.b_arrow.paint(graphics);
        }
        if (this.f_arrow != null) {
            this.f_arrow.paint(graphics);
        }
        Point[] pointArray = this.spline.getPoints();
        if (this.spline.isShowPoints()) {
            n3 = 0;
            while (n3 < pointArray.length) {
                n2 = figTrafo2D.wc_to_screen_x(pointArray[n3].x);
                n = figTrafo2D.wc_to_screen_y(pointArray[n3].y);
                graphics.setColor(Color.black);
                graphics.drawRect(n2 - 2, n - 2, 4, 4);
                graphics.setColor(Color.white);
                graphics.fillRect(n2 - 1, n - 1, 3, 3);
                ++n3;
            }
        }
        if (this.spline.isSelected()) {
            n3 = 0;
            while (n3 < pointArray.length) {
                n2 = figTrafo2D.wc_to_screen_x(pointArray[n3].x);
                n = figTrafo2D.wc_to_screen_y(pointArray[n3].y);
                graphics.setColor(Color.black);
                graphics.fillRect(n2 - 2, n - 2, 5, 5);
                graphics.setColor(Color.white);
                graphics.drawRect(n2 - 3, n - 3, 6, 6);
                ++n3;
            }
        }
    }

    public AWTSplineRenderer(FigSpline figSpline) {
        this.spline = figSpline;
    }
}

