/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigRectangle;
import jfig.objects.FigRenderer;
import jfig.objects.FillWrapper;
import jfig.objects.LineWrapper;

public class AWTRectangleRenderer
implements FigRenderer {
    protected FigRectangle rectangle;
    protected LineWrapper wline;
    protected FillWrapper wfill;
    protected int pixel_width;
    protected int radius;
    protected long timestamp;

    public void rebuild() {
        FigBbox figBbox = this.rectangle.getBbox();
        FigTrafo2D figTrafo2D = this.rectangle.getTrafo();
        Point[] pointArray = new Point[]{new Point(figBbox.getXl(), figBbox.getYt()), new Point(figBbox.getXr(), figBbox.getYt()), new Point(figBbox.getXr(), figBbox.getYb()), new Point(figBbox.getXl(), figBbox.getYb())};
        this.wline = new LineWrapper(this.rectangle, figTrafo2D, pointArray, true);
        pointArray = new Point[]{new Point(figBbox.getXl(), figBbox.getYt()), new Point(figBbox.getXr(), figBbox.getYb())};
        this.wfill = new FillWrapper(this.rectangle, figTrafo2D, pointArray);
        this.timestamp = System.currentTimeMillis();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.rectangle.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        Object object;
        int n;
        Object object2;
        Object object3;
        if (!this.rectangle.isVisible()) {
            return;
        }
        if (this.timestamp < figTrafo2D.getTimestamp()) {
            this.rebuild();
        }
        FigAttribs figAttribs = this.rectangle.getAttributes();
        if (figAttribs.fillStyle == 2) {
            graphics.setColor(figAttribs.fillColor);
            if (this.wfill != null) {
                this.wfill.paint(graphics);
            }
        } else if (figAttribs.fillStyle == 3) {
            graphics.setColor(figAttribs.fillColor);
            if (this.wfill != null) {
                this.wfill.paint(graphics);
            }
        }
        if (this.wline != null && figAttribs.lineColor != null) {
            if (figAttribs.cornerRadius > 0) {
                object3 = this.wline.getScreenPointsX();
                int[] nArray = this.wline.getScreenPointsY();
                this.radius = 2 * figTrafo2D.wc_to_screen(figAttribs.cornerRadius);
                this.pixel_width = (int)figTrafo2D.wc_to_screen(figAttribs.lineWidth);
                if (this.pixel_width <= 1) {
                    graphics.setColor(figAttribs.lineColor);
                    graphics.drawRoundRect((int)object3[0], nArray[0], (int)(object3[2] - object3[0]), nArray[2] - nArray[0], this.radius, this.radius);
                } else {
                    object2 = object3[0] + this.pixel_width / 2;
                    n = nArray[0] + this.pixel_width / 2;
                    object = object3[2] - object3[0] - this.pixel_width;
                    int n2 = nArray[2] - nArray[0] - this.pixel_width;
                    graphics.setColor(figAttribs.lineColor);
                    int n3 = 0;
                    while (n3 < this.pixel_width) {
                        graphics.drawRoundRect((int)object2, n, (int)object, n2, this.radius, this.radius);
                        --object2;
                        --n;
                        object += 2;
                        n2 += 2;
                        ++n3;
                    }
                }
            } else {
                graphics.setColor(figAttribs.lineColor);
                this.wline.paint(graphics);
            }
        }
        if (this.rectangle.isShowPoints()) {
            object3 = this.rectangle.getBbox();
            int n4 = figTrafo2D.wc_to_screen_x(((FigBbox)object3).getXl());
            object2 = figTrafo2D.wc_to_screen_y(((FigBbox)object3).getYt());
            n = figTrafo2D.wc_to_screen_x(((FigBbox)object3).getXr());
            object = figTrafo2D.wc_to_screen_y(((FigBbox)object3).getYb());
            graphics.setColor(Color.black);
            graphics.drawRect(n4 - 2, object2 - 2, 4, 4);
            graphics.drawRect(n - 2, object2 - 2, 4, 4);
            graphics.drawRect(n4 - 2, object - 2, 4, 4);
            graphics.drawRect(n - 2, object - 2, 4, 4);
            graphics.setColor(Color.white);
            graphics.fillRect(n4 - 1, object2 - 1, 3, 3);
            graphics.fillRect(n - 1, object2 - 1, 3, 3);
            graphics.fillRect(n4 - 1, object - 1, 3, 3);
            graphics.fillRect(n - 1, object - 1, 3, 3);
            graphics.setColor(Color.black);
        }
        if (this.rectangle.isSelected()) {
            object3 = this.rectangle.getBbox();
            int n5 = figTrafo2D.wc_to_screen_x(((FigBbox)object3).getXl());
            object2 = figTrafo2D.wc_to_screen_y(((FigBbox)object3).getYt());
            n = figTrafo2D.wc_to_screen_x(((FigBbox)object3).getXr());
            object = figTrafo2D.wc_to_screen_y(((FigBbox)object3).getYb());
            graphics.setColor(Color.black);
            graphics.fillRect(n5 - 1, object2 - 1, 3, 3);
            graphics.fillRect(n - 1, object2 - 1, 3, 3);
            graphics.fillRect(n5 - 1, object - 1, 3, 3);
            graphics.fillRect(n - 1, object - 1, 3, 3);
            graphics.setColor(Color.white);
            graphics.drawRect(n5 - 2, object2 - 2, 4, 4);
            graphics.drawRect(n - 2, object2 - 2, 4, 4);
            graphics.drawRect(n5 - 2, object - 2, 4, 4);
            graphics.drawRect(n - 2, object - 2, 4, 4);
        }
    }

    public AWTRectangleRenderer(FigRectangle figRectangle) {
        this.rectangle = figRectangle;
    }
}

