/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigArrow;
import jfig.objects.FigAttribs;
import jfig.objects.FigPolyline;
import jfig.objects.FigRenderer;
import jfig.objects.FillWrapper;
import jfig.objects.LineWrapper;

public class AWTPolylineRenderer
implements FigRenderer {
    FigPolyline polyline;
    LineWrapper wline;
    FillWrapper wfill;
    FigArrow b_arrow;
    FigArrow f_arrow;
    long timestamp;

    public void rebuild() {
        FigTrafo2D figTrafo2D = this.polyline.getTrafo();
        FigAttribs figAttribs = this.polyline.getAttributes();
        Point[] pointArray = this.polyline.getPoints();
        boolean bl = this.polyline.isClosed();
        this.wline = new LineWrapper(this.polyline, figTrafo2D, pointArray, bl);
        this.wfill = figAttribs.fillStyle == 2 && pointArray.length >= 3 ? new FillWrapper(this.polyline, figTrafo2D, pointArray) : null;
        this.b_arrow = null;
        this.f_arrow = null;
        if (pointArray.length < 2) {
            return;
        }
        if ((figAttribs.arrowMode & 2) > 0) {
            this.b_arrow = FigArrow.create(this.polyline, pointArray[1], pointArray[0], false);
        }
        if ((figAttribs.arrowMode & 1) > 0) {
            this.f_arrow = bl ? FigArrow.create(this.polyline, pointArray[pointArray.length - 1], pointArray[0], true) : FigArrow.create(this.polyline, pointArray[pointArray.length - 2], pointArray[pointArray.length - 1], true);
        }
        this.timestamp = System.currentTimeMillis();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.polyline.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        int n;
        int[] nArray;
        int[] nArray2;
        if (!this.polyline.isVisible()) {
            return;
        }
        if (this.timestamp < figTrafo2D.getTimestamp()) {
            this.rebuild();
        }
        if (this.wfill != null) {
            this.wfill.paint(graphics);
        }
        if (this.wline != null) {
            this.wline.paint(graphics);
        }
        if (this.b_arrow != null) {
            this.b_arrow.paint(graphics);
        }
        if (this.f_arrow != null) {
            this.f_arrow.paint(graphics);
        }
        if (this.polyline.isShowPoints()) {
            nArray2 = this.wline.getScreenPointsX();
            nArray = this.wline.getScreenPointsY();
            n = 0;
            while (n < nArray2.length) {
                graphics.setColor(Color.black);
                graphics.drawRect(nArray2[n] - 2, nArray[n] - 2, 4, 4);
                graphics.setColor(Color.white);
                graphics.fillRect(nArray2[n] - 1, nArray[n] - 1, 3, 3);
                ++n;
            }
        }
        if (this.polyline.isSelected()) {
            nArray2 = this.wline.getScreenPointsX();
            nArray = this.wline.getScreenPointsY();
            n = 0;
            while (n < nArray2.length) {
                graphics.setColor(Color.black);
                graphics.fillRect(nArray2[n] - 2, nArray[n] - 2, 5, 5);
                graphics.setColor(Color.white);
                graphics.drawRect(nArray2[n] - 3, nArray[n] - 3, 6, 6);
                ++n;
            }
        }
    }

    public AWTPolylineRenderer(FigPolyline figPolyline) {
        this.polyline = figPolyline;
        this.rebuild();
    }
}

