/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigArc;
import jfig.objects.FigArrow;
import jfig.objects.FigAttribs;
import jfig.objects.FigRenderer;
import jfig.objects.FillWrapper;
import jfig.objects.LineWrapper;

public class AWTArcRenderer
implements FigRenderer {
    FigArc arc;
    Point[] wcp_arc;
    Point[] wcp;
    LineWrapper warc;
    FillWrapper wfill;
    FigArrow f_arrow;
    FigArrow b_arrow;
    long timestamp;

    public void rebuild() {
        boolean bl;
        this.wcp = this.arc.getPoints();
        this.wcp_arc = this.arc.getInterpolatedArcPoints();
        FigAttribs figAttribs = this.arc.getAttributes();
        FigTrafo2D figTrafo2D = this.arc.getTrafo();
        boolean bl2 = bl = figAttribs.fillStyle != 1;
        if (this.wcp.length == 3) {
            this.warc = new LineWrapper(this.arc, figTrafo2D, this.wcp_arc, bl);
            this.wfill = figAttribs.fillStyle != 1 ? new FillWrapper(this.arc, figTrafo2D, this.wcp_arc) : null;
        } else if (this.wcp.length == 2) {
            this.wcp_arc = new Point[2];
            this.wcp_arc[0] = this.wcp[0];
            this.wcp_arc[1] = this.wcp[1];
            this.warc = new LineWrapper(this.arc, figTrafo2D, this.wcp_arc, false);
            this.wfill = null;
        }
        this.b_arrow = null;
        this.f_arrow = null;
        if (this.wcp.length >= 2 && figAttribs.fillStyle == 1) {
            int n;
            if ((figAttribs.arrowMode & 2) > 0) {
                n = Math.min(4, this.wcp_arc.length - 1);
                this.b_arrow = FigArrow.create(this.arc, this.wcp_arc[n], this.wcp_arc[0], false);
            }
            if ((figAttribs.arrowMode & 1) > 0) {
                n = Math.max(this.wcp_arc.length - 4, 0);
                this.f_arrow = FigArrow.create(this.arc, this.wcp_arc[n], this.wcp_arc[this.wcp_arc.length - 1], true);
            }
        }
        this.timestamp = System.currentTimeMillis();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.arc.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        int n;
        int n2;
        int n3;
        if (!this.arc.isVisible()) {
            return;
        }
        if (this.timestamp < figTrafo2D.getTimestamp()) {
            this.rebuild();
        }
        if (this.wfill != null) {
            this.wfill.paint(graphics);
        }
        if (this.warc != null) {
            this.warc.paint(graphics);
        }
        if (this.b_arrow != null) {
            this.b_arrow.paint(graphics);
        }
        if (this.f_arrow != null) {
            this.f_arrow.paint(graphics);
        }
        Point[] pointArray = this.arc.getPoints();
        if (this.arc.isShowPoints()) {
            n3 = 0;
            while (n3 < pointArray.length) {
                n2 = figTrafo2D.wc_to_screen_x(pointArray[n3].x);
                n = figTrafo2D.wc_to_screen_y(pointArray[n3].y);
                graphics.setColor(Color.black);
                graphics.drawRect(n2 - 2, n - 2, 4, 4);
                graphics.setColor(Color.white);
                graphics.fillRect(n2 - 1, n - 1, 3, 3);
                ++n3;
            }
        }
        if (this.arc.isSelected()) {
            n3 = 0;
            while (n3 < pointArray.length) {
                n2 = figTrafo2D.wc_to_screen_x(pointArray[n3].x);
                n = figTrafo2D.wc_to_screen_y(pointArray[n3].y);
                graphics.setColor(Color.black);
                graphics.fillRect(n2 - 2, n - 2, 5, 5);
                graphics.setColor(Color.white);
                graphics.drawRect(n2 - 3, n - 3, 6, 6);
                ++n3;
            }
        }
    }

    public AWTArcRenderer(FigArc figArc) {
        this.arc = figArc;
    }
}

