/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FillPatterns;

public class FigTools2D {
    static boolean thinLinesHack = true;

    public static Point2D.Float[] convertToFloatPoints(Point[] pointArray) {
        int n = pointArray.length;
        Point2D.Float[] floatArray = new Point2D.Float[n];
        int n2 = 0;
        while (n2 < n) {
            floatArray[n2] = new Point2D.Float(pointArray[n2].x, pointArray[n2].y);
            ++n2;
        }
        return floatArray;
    }

    public static Point[] convertToIntegerPoints(Point2D.Float[] floatArray) {
        int n = floatArray.length;
        Point[] pointArray = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            pointArray[n2] = new Point((int)((double)floatArray[n2].x + 0.5), (int)((double)floatArray[n2].y + 0.5));
            ++n2;
        }
        return pointArray;
    }

    public static GeneralPath createPath(Point[] pointArray, boolean bl) {
        GeneralPath generalPath = new GeneralPath(0);
        if (pointArray != null && pointArray.length > 1) {
            generalPath.moveTo(pointArray[0].x, pointArray[0].y);
            int n = 1;
            while (n < pointArray.length) {
                generalPath.lineTo(pointArray[n].x, pointArray[n].y);
                ++n;
            }
            if (bl) {
                generalPath.closePath();
            }
        }
        return generalPath;
    }

    public static void checkRestoreDashLength(FigAttribs figAttribs) {
        if (figAttribs.lineStyle != 0 && figAttribs.dashLength <= 0.0) {
            FigTools2D.msg("-W- found zero dash/dot length, restoring default 4");
            figAttribs.dashLength = 120.0;
        }
    }

    public static BasicStroke createStroke(FigAttribs figAttribs) {
        float f;
        BasicStroke basicStroke = null;
        float f2 = f = FigTools2D.getLineWidth(figAttribs.lineWidth);
        int n = 0;
        int n2 = 2;
        float f3 = 1.0f;
        float[] fArray = null;
        float f4 = 0.0f;
        switch (figAttribs.fig_join_style) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        switch (figAttribs.fig_cap_style) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        FigTools2D.checkRestoreDashLength(figAttribs);
        switch (figAttribs.lineStyle) {
            case 0: {
                fArray = null;
                break;
            }
            case 1: {
                fArray = new float[]{(float)figAttribs.dashLength, (float)figAttribs.dashLength};
                break;
            }
            case 2: {
                fArray = new float[]{f, (float)figAttribs.dashLength};
                break;
            }
            case 3: {
                fArray = new float[]{(float)figAttribs.dashLength, f2, f2, f2};
                break;
            }
            case 4: {
                fArray = new float[]{(float)figAttribs.dashLength, f2, f2, f2, f2, f2};
                break;
            }
            case 5: {
                fArray = new float[]{(float)figAttribs.dashLength, f2, f2, f2, f2, f2, f2, f2};
                break;
            }
            default: {
                FigTools2D.msg("-W- unsupported line style: " + figAttribs.lineStyle);
                fArray = null;
            }
        }
        if (fArray != null) {
            try {
                basicStroke = new BasicStroke(f, n, n2, f3, fArray, f4);
            }
            catch (Throwable throwable) {
                FigTools2D.msg("-E- could not create dash/dot pattern stroke: " + throwable);
                FigTools2D.msg("-E- using solid line instead...");
                basicStroke = new BasicStroke(f, n, n2);
            }
        } else {
            basicStroke = new BasicStroke(f, n, n2);
        }
        return basicStroke;
    }

    public static float getLineWidth(double d) {
        if (thinLinesHack) {
            if (d > 30.0) {
                return (float)(d - 30.0);
            }
            if (d > 0.0) {
                return 15.0f;
            }
            return 0.0f;
        }
        return (float)d;
    }

    public static AffineTransform createCompoundTransform(AffineTransform affineTransform, FigTrafo2D figTrafo2D) {
        AffineTransform affineTransform2 = FigTools2D.createTransform(figTrafo2D);
        affineTransform2.preConcatenate(affineTransform);
        return affineTransform2;
    }

    public static AffineTransform createTransform(FigTrafo2D figTrafo2D) {
        double d;
        double d2 = d = figTrafo2D.getZoomFactor() / 32.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = d;
        double d6 = -1.0 * d * (double)figTrafo2D.getAnchor().x;
        double d7 = -1.0 * d * (double)figTrafo2D.getAnchor().y;
        return new AffineTransform(d2, d3, d4, d5, d6, d7);
    }

    public static Paint getTexture(FigAttribs figAttribs) {
        return FillPatterns.getTexturePaint(figAttribs.fig_area_fill - 40 + 20, 32, figAttribs.lineColor, figAttribs.fillColor);
    }

    public static void showPoints(Graphics graphics, FigTrafo2D figTrafo2D, Point[] pointArray) {
        if (pointArray == null) {
            return;
        }
        int n = 0;
        while (n < pointArray.length) {
            int n2 = figTrafo2D.wc_to_screen_x(pointArray[n].x);
            int n3 = figTrafo2D.wc_to_screen_y(pointArray[n].y);
            graphics.setColor(Color.black);
            graphics.drawRect(n2 - 2, n3 - 2, 4, 4);
            graphics.setColor(Color.white);
            graphics.fillRect(n2 - 1, n3 - 1, 3, 3);
            ++n;
        }
    }

    public static void showPoints(Graphics graphics, FigTrafo2D figTrafo2D, FigBbox figBbox) {
        FigTools2D.showPoints(graphics, figTrafo2D, FigTools2D.convertToPoints(figBbox));
    }

    public static void showSelected(Graphics graphics, FigTrafo2D figTrafo2D, Point[] pointArray) {
        if (pointArray == null) {
            return;
        }
        int n = 0;
        while (n < pointArray.length) {
            int n2 = figTrafo2D.wc_to_screen_x(pointArray[n].x);
            int n3 = figTrafo2D.wc_to_screen_y(pointArray[n].y);
            graphics.setColor(Color.white);
            graphics.drawRect(n2 - 2, n3 - 2, 4, 4);
            graphics.setColor(Color.black);
            graphics.fillRect(n2 - 1, n3 - 1, 3, 3);
            ++n;
        }
    }

    public static void showSelected(Graphics graphics, FigTrafo2D figTrafo2D, FigBbox figBbox) {
        FigTools2D.showSelected(graphics, figTrafo2D, FigTools2D.convertToPoints(figBbox));
    }

    public static Point[] convertToPoints(FigBbox figBbox) {
        if (figBbox == null) {
            return null;
        }
        int n = figBbox.getXl();
        int n2 = figBbox.getYt();
        int n3 = figBbox.getXr();
        int n4 = figBbox.getYb();
        return new Point[]{new Point(n, n2), new Point(n3, n2), new Point(n3, n4), new Point(n, n4)};
    }

    public static void msg(String string) {
        System.err.println(string);
    }
}

