/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import jfig.canvas.FigTrafo2D;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;
import jfig.objects.FigRenderer;
import jfig.objects.FigText;
import jfig.utils.LP2;
import jfig.utils.SetupManager;

public class FigTextRenderer
implements FigRenderer {
    FigText textObject;
    boolean showBoundingBoxes;
    Shape rect2D;
    BasicStroke stroke;
    AffineTransform cachedAffineTransform;
    FontCache fontCache;
    FontMetrics fm;

    public void rebuild() {
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.textObject.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.textObject.isVisible()) {
            return;
        }
        try {
            Point point = this.textObject.getPosition();
            FigAttribs figAttribs = this.textObject.getAttributes();
            String string = this.textObject.getText();
            if (string == null) {
                return;
            }
            if (figAttribs.fig_font == 32) {
                string = FigText.symbol_recode(string);
            }
            int n = (int)((double)figAttribs.fontSize * figTrafo2D.getZoom());
            Font font = this.fontCache.getFont(figAttribs.fig_font, n);
            FontMetrics fontMetrics = this.fontCache.getFontMetrics(figAttribs.fig_font, n);
            if ((figAttribs.fig_font_flags & 2) != 0 && SetupManager.getBoolean("jfig.showTeXStrings", false)) {
                LP2 lP2 = new LP2();
                lP2.setFontIndex(figAttribs.fig_font);
                lP2.setFontPtSize(figAttribs.fontSize);
                lP2.setColorIndex(figAttribs.fig_line_color);
                lP2.setEnableDisplayBoxes(SetupManager.getBoolean("jfig.utils.SimpleLatexParser.displayBoxes", false));
                lP2.setEnableDumpTokens(SetupManager.getBoolean("jfig.utils.SimpleLatexParser.dumpTokens", false));
                lP2.setUseWords(SetupManager.getBoolean("jfig.utils.SimpleLatexParser.useWords", true));
                lP2.parse(string);
                FigCompound figCompound = new FigCompound();
                figCompound.setTrafo(this.textObject.getTrafo());
                lP2.convertToFig(figCompound);
                figCompound.update_bbox();
                figCompound.move(this.textObject.getPosition().x, this.textObject.getPosition().y);
                int n2 = figCompound.getBbox().getXr() - figCompound.getBbox().getXl();
                int n3 = 0;
                if (figAttribs.textAlign == 3) {
                    n3 = -n2;
                    figCompound.move(-n2, 0);
                } else if (figAttribs.textAlign == 2) {
                    n3 = -n2 / 2;
                    figCompound.move(-n2 / 2, 0);
                }
                Point point2 = new Point(this.textObject.getPosition().x, this.textObject.getPosition().y);
                figCompound.rotate(point2, -figAttribs.fig_angle);
                figCompound.paint(graphics, figTrafo2D);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                Stroke stroke = graphics2D.getStroke();
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                int n4 = 0;
                if (figAttribs.textAlign == 3) {
                    n4 = (int)rectangle2D.getWidth();
                } else if (figAttribs.textAlign == 2) {
                    n4 = (int)(rectangle2D.getWidth() / 2.0);
                }
                AffineTransform affineTransform2 = new AffineTransform();
                affineTransform2.translate(figTrafo2D.wc_to_screen_x(point.x), figTrafo2D.wc_to_screen_y(point.y));
                affineTransform2.rotate(-figAttribs.fig_angle);
                affineTransform2.translate(-n4, 0.0);
                affineTransform2.preConcatenate(affineTransform);
                graphics2D.setTransform(affineTransform2);
                if (this.showBoundingBoxes) {
                    graphics2D.setColor(Color.yellow);
                    graphics2D.draw(rectangle2D);
                    graphics2D.drawLine(0, 0, (int)rectangle2D.getWidth(), 0);
                }
                graphics2D.setColor(figAttribs.lineColor);
                graphics2D.setFont(font);
                if (string.length() > 0) {
                    graphics2D.drawString(string, 0, 0);
                }
                if (string != null && this.textObject.isShowCursor()) {
                    String string2 = string.substring(0, this.textObject.getTextCursorIndex());
                    int n5 = fontMetrics.stringWidth(string2);
                    int n6 = fontMetrics.getAscent();
                    if (this.showBoundingBoxes) {
                        rectangle2D = fontMetrics.getStringBounds(string2, graphics2D);
                        graphics2D.setColor(Color.red);
                        graphics2D.draw(rectangle2D);
                    }
                    graphics2D.setColor(Color.blue);
                    graphics2D.drawLine(n5, 0, n5, -n6);
                }
                if (this.textObject.isShowPoints()) {
                    int n7 = fontMetrics.getAscent();
                    this.showOnePoint(graphics, n4, 0, false);
                    this.showOnePoint(graphics, n4, -n7, false);
                }
                if (this.textObject.isSelected()) {
                    int n8 = fontMetrics.getAscent();
                    this.showOnePoint(graphics, n4, 0, true);
                    this.showOnePoint(graphics, n4, -n8, true);
                }
                graphics2D.setTransform(affineTransform);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void showOnePoint(Graphics graphics, int n, int n2, boolean bl) {
        Color color = bl ? Color.white : Color.black;
        Color color2 = bl ? Color.black : Color.white;
        graphics.setColor(color);
        graphics.drawRect(n - 2, n2 - 2, 4, 4);
        graphics.setColor(color2);
        graphics.fillRect(n - 1, n2 - 1, 3, 3);
    }

    public FigTextRenderer(FigText figText) {
        this.textObject = figText;
        this.fontCache = FontCache.getFontCache();
        this.showBoundingBoxes = SetupManager.getBoolean("jfig.objects.FigText.showBoundingBoxes", false);
        this.rebuild();
    }
}

