/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import jfig.canvas.FigTrafo2D;
import jfig.java2d.FigTools2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigImage;
import jfig.objects.FigRenderer;

public class FigImageRenderer
implements FigRenderer {
    FigImage imageObject;
    Shape rect2D;
    BasicStroke stroke;
    AffineTransform cachedAffineTransform;

    public void rebuild() {
        this.createRectangle();
        this.stroke = FigTools2D.createStroke(this.imageObject.getAttributes());
    }

    public void createRectangle() {
        FigAttribs figAttribs = this.imageObject.getAttributes();
        FigBbox figBbox = this.imageObject.getBbox();
        this.rect2D = new Rectangle2D.Float(figBbox.getXl(), figBbox.getYt(), figBbox.getXr() - figBbox.getXl(), figBbox.getYb() - figBbox.getYt());
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.imageObject.getTrafo());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.imageObject.isVisible()) {
            return;
        }
        try {
            boolean bl = false;
            Graphics2D graphics2D = (Graphics2D)graphics;
            FigAttribs figAttribs = this.imageObject.getAttributes();
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            if (this.cachedAffineTransform != affineTransform) {
                this.cachedAffineTransform = FigTools2D.createCompoundTransform(affineTransform, figTrafo2D);
                graphics2D.setTransform(this.cachedAffineTransform);
                bl = true;
            }
            FigBbox figBbox = this.imageObject.getBbox();
            Image image = this.imageObject.getImage();
            FigImage figImage = this.imageObject;
            if (image != null) {
                try {
                    boolean bl2 = graphics2D.drawImage(image, figBbox.getXl(), figBbox.getYt(), figBbox.getXr() + 1, figBbox.getYb() + 1, 0, 0, image.getWidth(figImage), image.getHeight(figImage), figImage);
                    if (bl2) {
                        // empty if block
                    }
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("-E- internal in FigImageRenderer: " + runtimeException);
                }
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.setFont(FigAttribs.defaultFont);
                graphics2D.drawString("image not found", figBbox.getXl() + 10, figBbox.getYt() + (figBbox.getYt() + figBbox.getYb()) / 2);
            }
            graphics2D.setColor(figAttribs.lineColor);
            if (this.stroke != null) {
                graphics2D.setStroke(this.stroke);
            }
            if ((double)this.stroke.getLineWidth() > 0.0) {
                graphics2D.draw(this.rect2D);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
            if (this.imageObject.isShowPoints()) {
                FigTools2D.showPoints(graphics, figTrafo2D, figBbox);
            }
            if (!this.imageObject.isSelected()) return;
            FigTools2D.showSelected(graphics, figTrafo2D, figBbox);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public FigImageRenderer(FigImage figImage) {
        this.imageObject = figImage;
        this.rebuild();
    }
}

