/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import jfig.canvas.FigTrafo2D;
import jfig.java2d.FigArrow2D;
import jfig.java2d.FigTools2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigBezier;
import jfig.objects.FigRenderer;

public class FigBezierSplineRenderer
implements FigRenderer {
    FigBezier bezier;
    GeneralPath path2D;
    BasicStroke stroke;
    AffineTransform cachedAffineTransform;

    public void rebuild() {
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.bezier.getTrafo());
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.bezier.isVisible()) {
            return;
        }
        try {
            boolean bl = false;
            Graphics2D graphics2D = (Graphics2D)graphics;
            FigAttribs figAttribs = this.bezier.getAttributes();
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            Point[] pointArray = this.bezier.getPoints();
            if (this.cachedAffineTransform != affineTransform) {
                this.cachedAffineTransform = FigTools2D.createCompoundTransform(affineTransform, figTrafo2D);
                graphics2D.setTransform(this.cachedAffineTransform);
                bl = true;
            }
            this.path2D = FigTools2D.createPath(this.bezier.getSplinePoints(), this.bezier.isClosed());
            this.stroke = FigTools2D.createStroke(this.bezier.getAttributes());
            if (figAttribs.fig_area_fill > 40) {
                graphics2D.setPaint(FigTools2D.getTexture(figAttribs));
                graphics2D.fill(this.path2D);
            } else if (figAttribs.fillStyle == 2) {
                graphics2D.setColor(figAttribs.fillColor);
                graphics2D.fill(this.path2D);
            }
            graphics2D.setColor(figAttribs.lineColor);
            graphics2D.setStroke(this.stroke);
            if ((double)this.stroke.getLineWidth() > 0.0) {
                graphics2D.draw(this.path2D);
            }
            if (pointArray.length >= 2) {
                int n;
                Point[] pointArray2 = this.bezier.getSplinePoints();
                if ((figAttribs.arrowMode & 2) != 0) {
                    n = Math.min(4, pointArray2.length);
                    FigArrow2D.renderBackArrow(graphics2D, figAttribs, pointArray2[n], pointArray2[0]);
                }
                if ((figAttribs.arrowMode & 1) > 0) {
                    n = Math.max(pointArray2.length - 4, 0);
                    FigArrow2D.renderFrontArrow(graphics2D, figAttribs, pointArray2[n], pointArray2[pointArray2.length - 1]);
                }
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
            if (this.bezier.isShowPoints()) {
                FigTools2D.showPoints(graphics, figTrafo2D, pointArray);
            }
            if (this.bezier.isSelected()) {
                FigTools2D.showSelected(graphics, figTrafo2D, pointArray);
            }
        }
        catch (Throwable throwable) {
            System.err.println("-E- FigBezierSplineRenderer(2D).paint: " + throwable);
            throwable.printStackTrace();
        }
        this.path2D = null;
        this.stroke = null;
    }

    public FigBezierSplineRenderer(FigBezier figBezier) {
        this.bezier = figBezier;
        this.rebuild();
    }
}

