/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigDrawable;
import jfig.canvas.FigDrawableEnumerator;
import jfig.canvas.FigSwingCanvas;
import jfig.canvas.FigTrafo2D;
import jfig.commands.SelectLibraryObjectDialog;
import jfig.gui.JConsole;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.FigParser;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.FileTreeNode;
import jfig.utils.SetupManager;

public class JSelectFromLibraryDialog
extends JDialog
implements SelectLibraryObjectDialog,
ActionListener,
TreeSelectionListener {
    FigAttribs attribs = new FigAttribs();
    FigObjectList objectList = new FigObjectList();
    FigParser parser;
    ObjectEnumerator objectEnumerator;
    JButton cancelButton;
    JButton selectButton;
    JButton reloadButton;
    JTextField libraryBasePathTF;
    JTree libraryTree;
    JScrollPane libraryTreeScroller;
    JPanel topPanel;
    JPanel treePanel;
    JPanel previewPanel;
    JPanel buttonPanel;
    FigCanvas previewCanvas;
    ActionListener selectionListener;
    String libraryBasePath = null;
    String selectedFigName = null;
    boolean debug = false;

    public Dialog getDialog() {
        return this;
    }

    public void buildGUI() {
        this.buildTopPanel();
        this.buildTreePanel();
        this.buildPreviewPanel();
        this.buildButtonPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", this.topPanel);
        this.getContentPane().add("West", this.treePanel);
        this.getContentPane().add("Center", this.previewPanel);
        this.getContentPane().add("South", this.buttonPanel);
        this.pack();
    }

    public void buildTopPanel() {
        this.reloadButton = new JButton("reload");
        this.reloadButton.setToolTipText("search directory for FIG files");
        this.libraryBasePathTF = new JTextField(this.libraryBasePath, 40);
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.add("East", this.reloadButton);
        this.topPanel.add("Center", this.libraryBasePathTF);
    }

    public void buildTreePanel() {
        this.libraryTree = new JTree();
        this.libraryTree.setMinimumSize(new Dimension(300, 400));
        this.libraryTreeScroller = new JScrollPane(this.libraryTree);
        this.libraryTreeScroller.setMinimumSize(new Dimension(200, 400));
        this.libraryTreeScroller.setPreferredSize(new Dimension(200, 400));
        this.treePanel = new JPanel(new BorderLayout());
        this.treePanel.add("Center", this.libraryTreeScroller);
    }

    public void buildPreviewPanel() {
        this.previewCanvas = new FigSwingCanvas();
        this.previewCanvas.showRulers(false);
        this.previewCanvas.getTrafo().setGridMode(0);
        this.previewCanvas.getTrafo().setSnapRelative(1);
        this.previewCanvas.setBackground(Color.white);
        this.previewCanvas.setObjectEnumerator(this.objectEnumerator);
        this.previewPanel = new JPanel();
        this.previewPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.previewPanel.setLayout(new GridLayout(1, 1));
        this.previewPanel.add(this.previewCanvas.getComponent());
    }

    public void buildButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.cancelButton = new JButton("Cancel");
        this.selectButton = new JButton("Select object");
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.selectButton);
    }

    public void buildCallbacks() {
        this.cancelButton.addActionListener(this);
        this.selectButton.addActionListener(this);
        this.reloadButton.addActionListener(this);
        this.libraryBasePathTF.addActionListener(this);
        this.libraryTree.addTreeSelectionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.libraryBasePathTF) {
            this.libraryBasePath = this.libraryBasePathTF.getText();
            this.searchLibraries();
        } else if (object == this.cancelButton) {
            ((Component)this).setVisible(false);
        } else if (object == this.selectButton) {
            this.selectObject();
        } else if (object == this.reloadButton) {
            this.searchLibraries();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        FileTreeNode fileTreeNode = (FileTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        File file = (File)fileTreeNode.getUserObject();
        String string = file.getPath();
        if (string.endsWith(".fig")) {
            this.selectedFigName = string;
            this.parseSelectedSymbol();
            this.previewSelectedSymbol();
        }
    }

    public void searchLibraries() {
        if (this.debug) {
            this.msg("-#- searchLibraries..." + this.libraryBasePath);
        }
        try {
            File file = new File(this.libraryBasePathTF.getText().trim());
            FileTreeNode fileTreeNode = new FileTreeNode(file);
            FileTreeNode.traverseFileSystem(fileTreeNode);
            this.libraryTree.setModel(new DefaultTreeModel(fileTreeNode));
        }
        catch (Exception exception) {
            this.msg("-E- in searchLibraries: " + exception);
            exception.printStackTrace();
        }
    }

    public void parseSelectedSymbol() {
        if (this.debug) {
            this.msg("-#- parseSelectedSymbol: ");
        }
        if (this.debug) {
            this.msg("... selected: " + this.selectedFigName);
        }
        try {
            FigObjectList figObjectList = new FigObjectList();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.selectedFigName));
            this.parser.parse_fig_file(bufferedInputStream, true, false, this.attribs, this.previewCanvas.getTrafo(), figObjectList);
            bufferedInputStream.close();
            this.objectList = figObjectList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.debug) {
            this.msg("-#- previewSelectedSymbol ok.");
        }
    }

    public void previewSelectedSymbol() {
        FigBbox figBbox = BoundingBoxCalculator.getBoundingBox(this.objectEnumerator.getDrawableObjects());
        this.doZoomFit(figBbox);
    }

    void doZoomFit(FigBbox figBbox) {
        int n;
        if (this.debug) {
            this.msg("-#- doZoomFit: " + figBbox);
        }
        int n2 = figBbox.getXl();
        int n3 = figBbox.getXr();
        int n4 = figBbox.getYt();
        int n5 = figBbox.getYb();
        n4 -= 1000;
        n5 += 1000;
        Rectangle rectangle = this.previewCanvas.getComponent().getBounds();
        if ((n2 -= 1000) > (n3 += 1000)) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        if (n4 > n5) {
            n = n4;
            n4 = n5;
            n5 = n;
        }
        if (n3 == n2) {
            n3 = n2 + 1;
        }
        if (n5 == n4) {
            n5 = n4 + 1;
        }
        FigTrafo2D figTrafo2D = this.previewCanvas.getTrafo();
        figTrafo2D.setAnchor(new Point(n2, n4));
        double d = 32.0 * (double)rectangle.width / (double)(n3 - n2);
        double d2 = 32.0 * (double)rectangle.height / (double)(n5 - n4);
        double d3 = Math.min(d, d2);
        if (this.debug) {
            System.out.println("New factor: " + d3);
        }
        d3 = Math.max(0.013333333333333334, d3);
        if (this.debug) {
            System.out.println("New factor: " + d3);
        }
        figTrafo2D.set_zoom(d3);
        Enumeration enumeration = this.objectEnumerator.getDrawableObjects();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            figObject.setTrafo(figTrafo2D);
        }
        this.previewCanvas.doFullRedraw();
    }

    public void setSelectionListener(ActionListener actionListener) {
        this.selectionListener = actionListener;
    }

    public void selectObject() {
        if (this.debug) {
            this.msg("-#- selectObject: ");
        }
        if (this.selectionListener != null) {
            this.selectionListener.actionPerformed(new ActionEvent(this, 0, this.selectedFigName));
        }
    }

    public String getSelectedObjectFilename() {
        return this.selectedFigName;
    }

    public FigDrawableEnumerator getObjectEnumerator() {
        return this.objectEnumerator;
    }

    public void printTimestamps() {
        long l = this.previewCanvas.getTrafo().getTimestamp();
        System.out.println("trafo: " + l);
        Enumeration enumeration = this.objectEnumerator.getDrawableObjects();
        while (enumeration.hasMoreElements()) {
            FigBaseobject figBaseobject = (FigBaseobject)enumeration.nextElement();
            long l2 = figBaseobject.getTimestamp();
            System.out.println("object " + figBaseobject.getTimestamp() + " " + (l2 - l));
        }
    }

    public void msg(String string) {
        System.out.println(string);
    }

    public void dbg(String string) {
        if (this.debug) {
            this.msg(string);
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("dummy");
        frame.setSize(new Dimension(100, 100));
        frame.show();
        SetupManager.loadLocalProperties("jfig.cnf");
        JSelectFromLibraryDialog jSelectFromLibraryDialog = new JSelectFromLibraryDialog(frame);
        jSelectFromLibraryDialog.pack();
        jSelectFromLibraryDialog.show();
    }

    public JSelectFromLibraryDialog(Frame frame) {
        super(frame, "jfig: Select object from library", false);
        JSelectFromLibraryDialog jSelectFromLibraryDialog = this;
        if (jSelectFromLibraryDialog == null) {
            throw null;
        }
        this.objectEnumerator = jSelectFromLibraryDialog.new ObjectEnumerator();
        this.libraryBasePath = SetupManager.getProperty("jfig.gui.SelectFromLibraryDialog.BaseDir", "/usr/X11R6/lib/X11/xfig/Libraries");
        try {
            File file = new File(this.libraryBasePath);
            if (file != null && file.exists()) {
                this.libraryBasePath = file.getCanonicalPath();
            } else {
                JConsole.getConsole().message("-W- JSelectFromLibraryDialog: Could not find \n    the base directory '" + this.libraryBasePath + "'," + "    using the current working directory, instead.");
                this.libraryBasePath = new File(".").getCanonicalPath();
            }
        }
        catch (Throwable throwable) {
            JConsole.getConsole().message("-E- internal error in JSelectFromLibraryDialog<init>" + throwable);
        }
        this.buildGUI();
        this.buildCallbacks();
        this.parser = new FigParser();
        this.parser.setObjectPainter(this.previewCanvas);
        this.searchLibraries();
    }

    class ObjectEnumerator
    implements FigDrawableEnumerator {
        public Enumeration getDrawableObjects() {
            return JSelectFromLibraryDialog.this.objectList.elements();
        }

        public FigDrawable getTmpObject() {
            return null;
        }

        ObjectEnumerator() {
        }
    }
}

