/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.canvas.FigTrafo2D;
import jfig.commands.FigBasicEditor;
import jfig.gui.JConsole;
import jfig.gui.JWindowCloser;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.Format;
import jfig.utils.ItextFontMapper;
import jfig.utils.ItextPDFWriter;
import jfig.utils.RegistrationKeyManager;
import jfig.utils.SetupManager;

public class JPdfExportOptionsDialog
extends JDialog
implements ActionListener,
ItemListener {
    public static final int A4_WIDTH = 26173;
    public static final int A4_HEIGHT = 17952;
    public static final double _72_DPI = 72.0;
    public static final double _75_DPI = 75.0;
    static boolean debug = false;
    boolean centered = true;
    boolean portrait = true;
    double magnification = 1.0;
    private Frame parent;
    private JTextField magnificationTF;
    private JTextField xoffsetTF;
    private JTextField yoffsetTF;
    private JComboBox languageChoice;
    private JComboBox orientationChoice;
    private JComboBox centerChoice;
    private JComboBox colorChoice;
    private JCheckBox extraBorderCB;
    private JButton exportNowButton;
    private JButton cancelButton;
    private JButton filenameButton;
    private JButton updateNameButton;
    private JButton fitToPageButton;
    private JTextField filenameTF;
    private JLabel sizeLabel;
    private JFileChooser fileChooser;
    private JConsole console;
    private FigBasicEditor editor = null;
    private FigBbox bbox = null;
    private static /* synthetic */ Class class$Ljava$lang$Object;

    public void setEditor(FigBasicEditor figBasicEditor) {
        this.editor = figBasicEditor;
    }

    public void setConsole(JConsole jConsole) {
        this.console = jConsole;
    }

    public void buildGUI() {
        this.cancelButton = new JButton("Cancel");
        this.exportNowButton = new JButton("Export now");
        this.updateNameButton = new JButton("Update PDF filename from FIG filename");
        this.cancelButton.setToolTipText("Cancel: close dialog without exporting");
        this.exportNowButton.setToolTipText("Export to PDF and close dialog");
        this.updateNameButton.setToolTipText("Set PDF filename from FIG filename");
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 5));
        jPanel.add(new JLabel("output format:", 4));
        jPanel.add(new JLabel("magnification:", 4));
        jPanel.add(new JLabel("orientation:", 4));
        jPanel.add(new JLabel("offsets x,y:", 4));
        jPanel.add(new JLabel(" "));
        jPanel.add(new JLabel("output filename:", 4));
        jPanel.add(new JLabel(" "));
        jPanel.add(new JLabel(" "));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.cancelButton);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        jPanel3.setBorder(new EmptyBorder(10, 5, 10, 10));
        jPanel3.add(new JLabel("PDF  (via Itext library)"));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel("100% (bounding box)  ");
        this.extraBorderCB = new JCheckBox("add extra border (2mm)");
        this.extraBorderCB.setSelected(SetupManager.getBoolean("jfig.gui.ExportOptionsDialog.PDFExtraBorder", true));
        jPanel4.add(jLabel);
        jPanel4.add(this.extraBorderCB);
        jPanel3.add(jPanel4);
        jPanel3.add(new JLabel("portrait"));
        jPanel3.add(new JLabel("none"));
        jPanel3.add(new JLabel(""));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        this.filenameTF = new JTextField("", 40);
        this.filenameButton = new JButton("Browse");
        jPanel5.add(this.filenameTF);
        jPanel5.add(this.filenameButton);
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.add(this.updateNameButton);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel6);
        jPanel3.add(new JLabel(""));
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.add(this.exportNowButton);
        jPanel7.add(new JLabel("to selected output file"));
        jPanel3.add(jPanel7);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("West", jPanel);
        this.getContentPane().add("East", jPanel3);
        this.pack();
    }

    public void buildCallbacks() {
        JPdfExportOptionsDialog jPdfExportOptionsDialog = this;
        if (jPdfExportOptionsDialog == null) {
            throw null;
        }
        KeyMultiplexer keyMultiplexer = jPdfExportOptionsDialog.new KeyMultiplexer();
        this.filenameTF.addKeyListener(keyMultiplexer);
        this.cancelButton.addActionListener(this);
        this.exportNowButton.addActionListener(this);
        this.filenameButton.addActionListener(this);
        this.updateNameButton.addActionListener(this);
        this.addWindowListener(new JWindowCloser(this, false));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fitToPageButton) {
            JPdfExportOptionsDialog.dbg("-#- fitToPageButton: " + actionEvent);
            this.fitToLandscapeA4();
        } else if (object == this.cancelButton) {
            JPdfExportOptionsDialog.dbg("-#- cancelButton: " + actionEvent);
            this.setVisible(false);
        } else if (object == this.exportNowButton) {
            JPdfExportOptionsDialog.dbg("-#- exportNowButton: " + actionEvent);
            this.doExportNow();
        } else if (object == this.filenameButton) {
            JPdfExportOptionsDialog.dbg("-#- filenameButton: " + actionEvent);
            this.doBrowseFilename();
        } else if (object == this.updateNameButton) {
            JPdfExportOptionsDialog.dbg("-#- updateNameButton: " + actionEvent);
            this.doUpdateFilename();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JPdfExportOptionsDialog.dbg("-#- optionChangeHandler: " + itemEvent);
    }

    public void showSize() {
        if (this.bbox == null) {
            this.updateFigObjectsBoundingBox();
        }
        Dimension dimension = new Dimension(this.bbox.getXr() - this.bbox.getXl(), this.bbox.getYb() - this.bbox.getYt());
        double d = this.getMagnification();
        double d2 = d * (double)dimension.width / 2400.0;
        double d3 = d * (double)dimension.height / 2400.0;
    }

    public void setMagnification(double d) {
        this.magnification = d;
    }

    public double getMagnification() {
        return 1.0;
    }

    public int getOrientation() {
        return "landscape".equals(this.orientationChoice.getSelectedItem()) ? 0 : 1;
    }

    public int getJustification() {
        return "center".equals(this.centerChoice.getSelectedItem()) ? 0 : 1;
    }

    public void setFilename(String string) {
        this.filenameTF.setText(string);
    }

    public String getFigFilename() {
        String string = null;
        try {
            string = this.editor.getFilename();
        }
        catch (Exception exception) {
            string = "unnamed.fig";
        }
        if (string == null) {
            return "unnamed.fig";
        }
        return string;
    }

    public String getPdfFilename() {
        String string = this.filenameTF.getText();
        if (string == null || string.length() == 0) {
            return "unnamed.pdf";
        }
        return string;
    }

    public void doUpdateFilename() {
        this.updateOutFilenameFromFigFilename();
    }

    public void updateOutFilenameFromFigFilename() {
        JPdfExportOptionsDialog.dbg("-#- updateOutFilenameFromFigFilename...");
        String string = null;
        String string2 = null;
        try {
            string = this.getFigFilename();
            string2 = string.toLowerCase().endsWith(".fig") ? string.substring(0, string.length() - 4) + ".pdf" : string + ".pdf";
            this.filenameTF.setText(string2);
        }
        catch (Exception exception) {
            this.msg("-E- filenames: " + string + " " + string2);
            exception.printStackTrace();
        }
    }

    public String getRoundedValue(double d) {
        return new Format("%3.2f").form(d);
    }

    private void call(String string) {
        try {
            Class[] classArray = new Class[]{class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = JPdfExportOptionsDialog.class$("java.lang.Object"))};
            Method method = this.getClass().getMethod(string, classArray);
            Object[] objectArray = new Object[]{};
            method.invoke((Object)this, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            this.msg("-E- call: " + string + " " + throwable);
            throwable.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.msg("-E- call: " + noSuchMethodException + ":" + string);
        }
        catch (Exception exception) {
            this.msg("-E- call: " + exception + " for command: " + string);
            exception.printStackTrace();
        }
    }

    public void fitToLandscapeA4() {
        this.updateFigObjectsBoundingBox();
        Dimension dimension = new Dimension(this.bbox.getXr() - this.bbox.getXl(), this.bbox.getYb() - this.bbox.getYt());
        double d = 26173.0 / (double)dimension.width;
        double d2 = 17952.0 / (double)dimension.height;
        double d3 = Math.min(d, d2);
        d3 = Math.max(0.01, d3);
        double d4 = d3 * (double)dimension.width;
        double d5 = d3 * (double)dimension.height;
        this.setMagnification(d3);
        this.showSize();
    }

    public void updateFigObjectsBoundingBox() {
        try {
            this.bbox = BoundingBoxCalculator.getBoundingBox(this.editor.getObjects());
        }
        catch (Throwable throwable) {
            this.bbox = new FigBbox(0, 0, 26173, 17952);
        }
        if (debug) {
            this.msg("-#- updateFigObjectBoundingBox: " + this.bbox);
        }
        this.showSize();
    }

    public void doExportNow() {
        JPdfExportOptionsDialog.dbg("-#- doExportNow: output file '" + this.getPdfFilename() + "'");
        FileOutputStream fileOutputStream = null;
        FigTrafo2D figTrafo2D = null;
        FigTrafo2D figTrafo2D2 = null;
        Document document = null;
        PdfContentByte pdfContentByte = null;
        PdfWriter pdfWriter = null;
        PdfTemplate pdfTemplate = null;
        Graphics2D graphics2D = null;
        Rectangle rectangle = null;
        ItextFontMapper itextFontMapper = null;
        if (!RegistrationKeyManager.getRegistrationKeyManager().isValid()) {
            JOptionPane.showMessageDialog(this, "PDF export disabled in the evaluation version. See help->registration...", "Error", 0);
            return;
        }
        try {
            fileOutputStream = new FileOutputStream(this.getPdfFilename());
            this.bbox = BoundingBoxCalculator.getBoundingBox(this.editor.getObjects());
            float f = 0.03f;
            float f2 = f * (float)(this.bbox.getXr() - this.bbox.getXl());
            float f3 = f * (float)(this.bbox.getYb() - this.bbox.getYt());
            if (this.extraBorderCB.isSelected()) {
                float f4 = 11.338583f;
                f2 += f4;
                f3 += f4;
            }
            int n = (int)f2;
            int n2 = (int)f3;
            rectangle = new Rectangle(0.0f, 0.0f, f2, f3);
            JPdfExportOptionsDialog.dbg("bbox= " + this.bbox + " w,h=" + n + "," + n2);
            document = new Document(rectangle, 0.0f, 0.0f, 0.0f, 0.0f);
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)fileOutputStream);
            document.open();
            itextFontMapper = new ItextFontMapper();
            pdfContentByte = pdfWriter.getDirectContent();
            pdfTemplate = pdfContentByte.createTemplate((float)n, (float)n2);
            graphics2D = pdfTemplate.createGraphics((float)n, (float)n2, (FontMapper)itextFontMapper);
            pdfTemplate.setWidth((float)n);
            pdfTemplate.setHeight((float)n2);
            document.newPage();
            figTrafo2D = new FigTrafo2D();
            if (this.extraBorderCB.isSelected()) {
                int n3 = (int)Math.round(188.9763779527559);
                figTrafo2D.setAnchor(new Point(this.bbox.getXl() - n3, this.bbox.getYt() - n3));
            } else {
                figTrafo2D.setAnchor(new Point(this.bbox.getXl(), this.bbox.getYt()));
            }
            figTrafo2D.set_zoom(0.96);
            figTrafo2D2 = this.editor.getObjectCanvas().getTrafo();
            pdfContentByte.saveState();
            ItextPDFWriter itextPDFWriter = new ItextPDFWriter(document, itextFontMapper, graphics2D);
            itextPDFWriter.setTrafo(figTrafo2D);
            itextPDFWriter.setOrigTrafo(figTrafo2D2);
            Enumeration enumeration = this.editor.getObjects();
            while (enumeration.hasMoreElements()) {
                FigObject figObject = (FigObject)enumeration.nextElement();
                itextPDFWriter.paintOneObject(figObject);
            }
            graphics2D.dispose();
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
            pdfContentByte.restoreState();
            document.close();
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Throwable throwable) {
            this.msg("-E- JPdfExportOptionsDialog: internal error: " + throwable);
            throwable.printStackTrace();
        }
    }

    public void doBrowseFilename() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setDialogTitle("Select output filename:");
        }
        try {
            String string = SetupManager.getProperty("jfig.gui.CurrentFigFileDirectory", null);
            if (string != null) {
                this.fileChooser.setCurrentDirectory(new File(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = this.fileChooser.showSaveDialog(this.parent);
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.filenameTF.setText(file.getName());
        }
    }

    public void msg(String string) {
        if (this.console != null) {
            this.console.println(string);
        } else {
            System.out.println(string);
        }
    }

    public static void dbg(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        SetupManager.loadLocalProperties("jfig.cnf");
        JFrame jFrame = new JFrame("JPdfExportOptionsDialog test.");
        JPdfExportOptionsDialog jPdfExportOptionsDialog = new JPdfExportOptionsDialog(jFrame);
        jPdfExportOptionsDialog.updateFigObjectsBoundingBox();
        jPdfExportOptionsDialog.setEditor(null);
        jPdfExportOptionsDialog.show();
        jPdfExportOptionsDialog.updateOutFilenameFromFigFilename();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JPdfExportOptionsDialog(Frame frame) {
        super(frame, "jfig PDF Export Options");
        this.parent = frame;
        this.buildGUI();
        this.buildCallbacks();
    }

    class KeyMultiplexer
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            JPdfExportOptionsDialog.dbg("-*- " + keyEvent);
            this.mux();
        }

        public void keyReleased(KeyEvent keyEvent) {
            JPdfExportOptionsDialog.dbg("-*- " + keyEvent);
            this.mux();
        }

        public void keyTyped(KeyEvent keyEvent) {
            JPdfExportOptionsDialog.dbg("-*- " + keyEvent);
            this.mux();
        }

        public void mux() {
            JPdfExportOptionsDialog.this.showSize();
        }

        KeyMultiplexer() {
        }
    }
}

